/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.PageManagerFactory;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.designimporter.CanvasBuildOptions;
import com.day.cq.wcm.designimporter.DesignImportException;
import com.day.cq.wcm.designimporter.DesignImportResult;
import com.day.cq.wcm.designimporter.DesignImporterContext;
import com.day.cq.wcm.designimporter.MalformedArchiveException;
import com.day.cq.wcm.designimporter.MissingHTMLException;
import com.day.cq.wcm.designimporter.api.CanvasBuilder;
import com.day.cq.wcm.designimporter.api.EntryPreprocessor;
import com.day.cq.wcm.designimporter.util.ImporterUtil;
import com.day.cq.wcm.designimporter.util.StreamUtil;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="%design.importer.name", description="%design.importer.description", metatype=true)
@Service(value={DesignPackageImporter.class})
public class DesignPackageImporter {
    private static final String DEFAULT_EXTRACT_FILTER_GITIGNORE = "[^.]*\\.gitignore";
    private static final String DEFAULT_EXTRACT_FILTER_DS_STORE = "[^.]*\\.DS_Store";
    private static final String DEFAULT_EXTRACT_FILTER_MACOSX = "__MACOSX.*";
    @Property(value={"__MACOSX.*", "[^.]*\\.DS_Store", "[^.]*\\.gitignore"})
    private static final String PN_EXTRACT_FILTER = "extract.filter";
    private Logger logger = LoggerFactory.getLogger(DesignPackageImporter.class);
    @Reference
    protected MimeTypeService mimeTypeService;
    @Reference
    protected EntryPreprocessor entryPreprocessor;
    @Reference
    protected PageManagerFactory pageManagerFactory;
    private ArrayList<Node> extractedHtmlNodes = new ArrayList();
    private ArrayList<String> extractedResources = new ArrayList();
    private BundleContext bundleContext;
    private String[] extractFilters;
    private AssetManager assetManager;

    public DesignImportResult importDesignPackage(SlingHttpServletRequest slingHttpServletRequest) throws DesignImportException {
        return this.importDesignPackage(slingHttpServletRequest, null);
    }

    public DesignImportResult importDesignPackage(SlingHttpServletRequest slingHttpServletRequest, CanvasBuildOptions buildOptions) throws DesignImportException {
        try {
            if (buildOptions == null) {
                buildOptions = new CanvasBuildOptions();
                buildOptions.setBuildPageNodes(true);
                buildOptions.setBuildClientLibs(true);
                buildOptions.setBuildCanvasComponent(true);
            }
            Resource importer = slingHttpServletRequest.getResource();
            InputStream designPackage = this.getArchiveStreamFromRequest(slingHttpServletRequest);
            return this.importDesignPackageInternal(importer, designPackage, buildOptions);
        }
        catch (ZipException e) {
            throw new MalformedArchiveException();
        }
        catch (IOException e) {
            throw new DesignImportException(e);
        }
        catch (RepositoryException e) {
            throw new DesignImportException(e);
        }
    }

    public DesignImportResult importDesignPackage(Page importerPage, String designPackagePath, CanvasBuildOptions buildOptions) throws DesignImportException {
        try {
            if (buildOptions == null) {
                buildOptions = new CanvasBuildOptions();
                buildOptions.setBuildPageNodes(true);
                buildOptions.setBuildClientLibs(true);
                buildOptions.setBuildCanvasComponent(true);
            }
            String importerPath = "jcr:content/importer";
            Resource importer = importerPage.adaptTo(Resource.class).getChild(importerPath);
            Node importerPageNode = importerPage.adaptTo(Node.class);
            Node dst = importerPageNode.getNode(importerPath).addNode("designpackage", "nt:unstructured");
            Node src = importerPageNode.getSession().getNode(designPackagePath);
            JcrUtil.copy(src, dst, "file");
            Resource jcrContent = importer.getChild("designpackage/file/jcr:content");
            InputStream designPackage = (InputStream)jcrContent.adaptTo(ValueMap.class).get("jcr:data");
            return this.importDesignPackageInternal(importer, designPackage, buildOptions);
        }
        catch (ZipException e) {
            throw new MalformedArchiveException();
        }
        catch (IOException e) {
            throw new DesignImportException(e);
        }
        catch (RepositoryException e) {
            throw new DesignImportException(e);
        }
    }

    protected Node extractEntry(ZipEntry entry, Node parent, ZipInputStream zipInputStream, DesignImporterContext designImporterContext) throws RepositoryException, IOException {
        if (!entry.isDirectory()) {
            String destPath = this.mapPath(entry.getName());
            int lastIndexOfSlash = destPath.lastIndexOf(47);
            String fileName = destPath.substring(lastIndexOfSlash + 1);
            Node fileParent = parent;
            if (lastIndexOfSlash > 0) {
                String folder = destPath.substring(0, lastIndexOfSlash);
                fileParent = JcrUtil.createPath(parent, folder, false, "{http://www.jcp.org/jcr/nt/1.0}folder", "{http://www.jcp.org/jcr/nt/1.0}folder", parent.getSession(), true);
            }
            String encoding = "utf-8";
            FilterInputStream stream = zipInputStream;
            if (entry.getName().matches("(?i)[^.]*\\.html")) {
                if (!((InputStream)stream).markSupported()) {
                    stream = new BufferedInputStream(zipInputStream);
                }
                encoding = StreamUtil.getEncoding(stream);
            }
            String mimeType = this.getMimeType(fileName);
            InputStream entryStream = stream;
            if (this.entryPreprocessor != null) {
                entryStream = this.entryPreprocessor.getProcessedStream(entry.getName(), stream, designImporterContext);
            }
            if (this.assetManager != null && mimeType.startsWith("image/")) {
                this.assetManager.createAsset(fileParent.getPath() + "/" + fileName, entryStream, mimeType, true);
            } else {
                mimeType = mimeType + ";charset=" + encoding;
                return JcrUtils.putFile(fileParent, fileName, mimeType, entryStream);
            }
        }
        return null;
    }

    protected Node getOrCreateDesignPath(Resource importer) throws RepositoryException {
        ResourceResolver resourceResolver = importer.getResourceResolver();
        PageManager pageManager = this.pageManagerFactory.getPageManager(resourceResolver);
        Page page = pageManager.getContainingPage(importer);
        Session session = page.adaptTo(Node.class).getSession();
        String pagePath = page.getPath();
        String path = null;
        if (ImporterUtil.isImporter(importer)) {
            Designer designer = resourceResolver.adaptTo(Designer.class);
            String pageDesignPath = designer.getDesign(page).getPath();
            path = pageDesignPath + "/canvas" + importer.getPath();
        } else {
            path = "/etc/designs/canvaspage" + pagePath;
        }
        Node designNode = JcrUtil.createPath(path, "{http://www.jcp.org/jcr/nt/1.0}folder", "cq:Page", session, true);
        Node jcrContent = JcrUtils.getOrAddNode(designNode, "jcr:content", "{http://www.jcp.org/jcr/nt/1.0}unstructured");
        JcrUtil.setProperty(jcrContent, "cq:doctype", "html_5");
        JcrUtil.setProperty(jcrContent, "sling:resourceType", "wcm/core/components/designer");
        session.save();
        return designNode;
    }

    protected Node getOrCreateDesignPath(Page page) throws RepositoryException {
        Session session = page.adaptTo(Node.class).getSession();
        String pagePath = page.getPath();
        String path = "/etc/designs/canvaspage" + pagePath;
        Node designNode = JcrUtil.createPath(path, "{http://www.jcp.org/jcr/nt/1.0}folder", "cq:Page", session, true);
        Node jcrContent = JcrUtils.getOrAddNode(designNode, "jcr:content", "{http://www.jcp.org/jcr/nt/1.0}unstructured");
        JcrUtil.setProperty(jcrContent, "cq:doctype", "html_5");
        JcrUtil.setProperty(jcrContent, "sling:resourceType", "wcm/core/components/designer");
        session.save();
        return designNode;
    }

    protected String mapPath(String zipEntry) {
        return zipEntry;
    }

    protected String mapPath(ZipEntry entry) {
        return this.mapPath(entry.getName());
    }

    protected boolean shouldExtractEntry(ZipEntry entry) {
        for (String extractFilter : this.extractFilters) {
            if (!entry.getName().matches(extractFilter)) continue;
            return false;
        }
        return true;
    }

    private void cleanup(Node designNode, Set<String> resourcesToCleanup) {
        try {
            for (Node node : this.extractedHtmlNodes) {
                node.remove();
            }
        }
        catch (RepositoryException e) {
            this.logger.error("A repository exception occured while cleaning up the temporary HTML file nodes from the design path", e);
        }
        try {
            for (String resource : resourcesToCleanup) {
                Node source = designNode.getNode(resource);
                Node parent = source.getParent();
                source.remove();
                while (!parent.getNodes().hasNext()) {
                    Node p = parent;
                    parent = parent.getParent();
                    p.remove();
                }
            }
            designNode.getSession().save();
        }
        catch (RepositoryException e) {
            this.logger.warn("Caught exception while cleaning up resources", e);
        }
    }

    private void extractArchive(Node designNode, InputStream archiveStream, DesignImporterContext designImporterContext) throws IOException, RepositoryException {
        try {
            ZipInputStream zipInputStream = new ZipInputStream(archiveStream);
            ZipEntry entry = zipInputStream.getNextEntry();
            if (entry == null) {
                throw new ZipException();
            }
            while (entry != null) {
                if (this.shouldExtractEntry(entry)) {
                    Node node = this.extractEntry(entry, designNode, zipInputStream, designImporterContext);
                    if (this.isHtmlEntry(entry)) {
                        this.extractedHtmlNodes.add(node);
                    } else if (!entry.isDirectory()) {
                        this.extractedResources.add(entry.getName());
                    }
                }
                entry = zipInputStream.getNextEntry();
            }
        }
        catch (IllegalArgumentException ex) {
            throw new IOException("Archived file is not in a valid format");
        }
    }

    private String getMimeType(String name) {
        String mimeType = this.mimeTypeService.getMimeType(name);
        return mimeType != null ? mimeType : "";
    }

    private DesignImportResult importDesignPackageInternal(Resource importer, InputStream designPackage, CanvasBuildOptions buildOptions) throws DesignImportException, RepositoryException, IOException {
        this.initialize();
        this.assetManager = importer.getResourceResolver().adaptTo(AssetManager.class);
        PageManager pageManager = this.pageManagerFactory.getPageManager(importer.getResourceResolver());
        Page page = pageManager.getContainingPage(importer);
        Node designNode = this.getOrCreateDesignPath(importer);
        DesignImporterContext importerContext = new DesignImporterContext(page, designNode, null);
        importerContext.setImporter(importer);
        this.extractArchive(designNode, designPackage, importerContext);
        if (this.extractedHtmlNodes.size() == 0) {
            throw new MissingHTMLException();
        }
        Comparator<Node> comparator = new Comparator<Node>(){

            @Override
            public int compare(Node n1, Node n2) {
                String n1Name = "";
                String n2Name = "";
                try {
                    n1Name = n1.getName();
                    n2Name = n2.getName();
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
                return n2Name.compareTo(n1Name);
            }
        };
        HashSet<String> resourcesToRemove = new HashSet<String>();
        Collections.sort(this.extractedHtmlNodes, comparator);
        ArrayList<String> warnings = new ArrayList<String>();
        boolean built = false;
        for (int i = this.extractedHtmlNodes.size() - 1; i >= 0; --i) {
            Node htmlNode = this.extractedHtmlNodes.get(i);
            String htmlName = htmlNode.getName();
            InputStream htmlStream = htmlNode.getNode("jcr:content").getProperty("jcr:data").getBinary().getStream();
            CanvasBuilder canvasBuilder = this.getCanvasBuilder(htmlNode, importer);
            if (canvasBuilder != null) {
                DesignImporterContext designImporterContext = new DesignImporterContext(page, designNode, htmlName, canvasBuilder, this.bundleContext, this.extractedResources);
                designImporterContext.setImporter(importer);
                canvasBuilder.build(htmlStream, designImporterContext, buildOptions);
                warnings.addAll(designImporterContext.importWarnings);
                resourcesToRemove.addAll(designImporterContext.getResourcesToRemove());
                built = true;
                continue;
            }
            this.extractedHtmlNodes.remove(i);
        }
        if (!built) {
            throw new MissingHTMLException();
        }
        this.cleanup(designNode, resourcesToRemove);
        designNode.getSession().save();
        return new DesignImportResult(warnings);
    }

    private InputStream getArchiveStreamFromRequest(SlingHttpServletRequest request) throws IOException, DesignImportException {
        RequestParameter designfile = request.getRequestParameter("designfile");
        InputStream archiveStream = null;
        if (designfile != null) {
            archiveStream = designfile.getInputStream();
        } else {
            Resource importer = request.getResource();
            if (ImporterUtil.isImporter(importer)) {
                Resource jcrContent = importer.getChild("designpackage/file/jcr:content");
                if (jcrContent == null) {
                    throw new DesignImportException("Design Package not found");
                }
                archiveStream = (InputStream)jcrContent.adaptTo(ValueMap.class).get("jcr:data");
            }
        }
        return archiveStream;
    }

    private void initialize() {
        this.extractedHtmlNodes = new ArrayList();
        this.extractedResources = new ArrayList();
    }

    private boolean isHtmlEntry(ZipEntry entry) {
        return entry.getName().matches("(?i)[^/\\\\]*\\.html?");
    }

    protected CanvasBuilder getCanvasBuilder(Node htmlNode, Resource importer) throws RepositoryException {
        try {
            ServiceReference[] references = this.bundleContext.getServiceReferences(CanvasBuilder.class.getName(), null);
            Arrays.sort(references, new Comparator<ServiceReference>(){

                @Override
                public int compare(ServiceReference o1, ServiceReference o2) {
                    int o1Priority = OsgiUtil.toInteger(o1.getProperty("service.ranking"), 0);
                    int o2Priority = OsgiUtil.toInteger(o2.getProperty("service.ranking"), 0);
                    return o2Priority - o1Priority;
                }
            });
            for (ServiceReference reference : references) {
                String filepattern = (String)reference.getProperty("filepattern");
                if (!htmlNode.getName().matches(filepattern)) continue;
                return (CanvasBuilder)this.bundleContext.getService(reference);
            }
        }
        catch (InvalidSyntaxException e) {
            this.logger.error("An error occurred while obtaining CanvasPageBuilder ServiceReference", e);
        }
        return null;
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.extractFilters = OsgiUtil.toStringArray(context.getProperties().get(PN_EXTRACT_FILTER));
        this.bundleContext = context.getBundleContext();
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }

    protected void bindEntryPreprocessor(EntryPreprocessor entryPreprocessor) {
        this.entryPreprocessor = entryPreprocessor;
    }

    protected void unbindEntryPreprocessor(EntryPreprocessor entryPreprocessor) {
        if (this.entryPreprocessor == entryPreprocessor) {
            this.entryPreprocessor = null;
        }
    }

    protected void bindPageManagerFactory(PageManagerFactory pageManagerFactory) {
        this.pageManagerFactory = pageManagerFactory;
    }

    protected void unbindPageManagerFactory(PageManagerFactory pageManagerFactory) {
        if (this.pageManagerFactory == pageManagerFactory) {
            this.pageManagerFactory = null;
        }
    }
}

