/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.model.responsivegrid;

import aQute.bnd.annotation.ProviderType;
import com.adobe.cq.export.json.ComponentExporter;
import com.day.cq.wcm.api.TemplatedResource;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.foundation.model.export.AllowedComponentsExporter;
import com.day.cq.wcm.foundation.model.responsivegrid.Breakpoint;
import com.day.cq.wcm.foundation.model.responsivegrid.ResponsiveColumn;
import com.day.cq.wcm.foundation.model.responsivegrid.ResponsiveGridUtils;
import com.day.cq.wcm.foundation.model.responsivegrid.export.ResponsiveGridExporter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.factory.ModelFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={ResponsiveGrid.class, ComponentExporter.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL, resourceType={"wcm/foundation/components/responsivegrid"})
@Exporter(name="jackson", selector="model", extensions={"json"})
@JsonSerialize(as=ResponsiveGridExporter.class)
@ProviderType
public class ResponsiveGrid
extends AbstractResource
implements ResponsiveGridExporter {
    protected static final String RESOURCE_TYPE = "wcm/foundation/components/responsivegrid";
    static final String COLUMNS = "columns";
    static final String OFFSET = "offset";
    static final String WIDTH = "width";
    @Self
    private SlingHttpServletRequest slingRequest;
    @SlingObject
    volatile Resource resource;
    @ScriptVariable
    private ValueMap properties;
    @ScriptVariable
    private Style currentStyle;
    @Inject
    private ModelFactory modelFactory;
    private String classNames;
    private final Map<String, String> columnClassNames = new HashMap<String, String>();
    private final Map<String, ResponsiveColumn> childColumns = new LinkedHashMap<String, ResponsiveColumn>();
    private int columns;
    private String classNamesPrefix;

    @PostConstruct
    protected void initModel() {
        HashMap<String, Breakpoint> breakpoints = new HashMap<String, Breakpoint>();
        this.classNamesPrefix = this.currentStyle.get("cssPrefix", "aem-Grid");
        Resource columnConfig = this.resource.getChild("cq:responsive");
        Resource parent = this.resource.getParent();
        Resource responsiveParentCfg = null;
        if (parent != null) {
            responsiveParentCfg = parent.getChild("cq:responsive");
        }
        this.columns = this.currentStyle.get(COLUMNS, 12);
        int width = this.currentStyle.get(COLUMNS, 0);
        int offset = this.currentStyle.get(OFFSET, 0);
        boolean hasDesignValues = width > 0 || this.currentStyle.containsKey(OFFSET);
        int initialDefaultWidth = 12;
        Object effectiveResource = this.getEffectiveResource();
        Resource effectiveResponsiveConfig = effectiveResource.getChild("cq:responsive/default");
        if (effectiveResponsiveConfig != null && effectiveResponsiveConfig.getValueMap().containsKey(WIDTH)) {
            initialDefaultWidth = effectiveResponsiveConfig.getValueMap().get(WIDTH, 12);
        }
        if (columnConfig != null) {
            Iterator<Resource> resCfgIt = columnConfig.listChildren();
            while (resCfgIt.hasNext()) {
                ValueMap parentCfg;
                int parentWidth;
                Resource parentBreakpoint;
                Resource resCfg = resCfgIt.next();
                String breakpointName = resCfg.getName();
                ValueMap cfg = resCfg.adaptTo(ValueMap.class);
                Breakpoint.ResponsiveBehavior behavior = Breakpoint.ResponsiveBehavior.valueOf(cfg.get("behavior", Breakpoint.ResponsiveBehavior.none.toString()));
                if (!hasDesignValues) {
                    int resWidth = cfg.get(WIDTH, 0);
                    int resOffset = cfg.get(OFFSET, 0);
                    width = resWidth > 0 ? resWidth : width;
                    int n = offset = resOffset > 0 ? resOffset : offset;
                }
                if (width > 0 && responsiveParentCfg != null && (parentBreakpoint = responsiveParentCfg.getChild(breakpointName)) != null && width + offset > (parentWidth = (parentCfg = parentBreakpoint.adaptTo(ValueMap.class)).get(WIDTH, width).intValue())) {
                    width = parentWidth;
                    offset = 0;
                }
                breakpoints.put(breakpointName, new Breakpoint(breakpointName, width, offset, behavior));
            }
        }
        this.createDefaultBreakpoint(breakpoints, offset, initialDefaultWidth);
        Set<String> columnBreakpointNames = this.createResponsiveColumns(breakpoints);
        Map<String, Breakpoint> missingBreakpoints = ResponsiveGridUtils.getMissingBreakpoints(breakpoints, columnBreakpointNames);
        breakpoints.putAll(missingBreakpoints);
        int effectiveColumns = this.currentStyle.get(COLUMNS, initialDefaultWidth);
        String initial = String.join((CharSequence)" ", List.of(this.classNamesPrefix, ResponsiveGridUtils.createClassname(List.of(this.classNamesPrefix, Integer.toString(effectiveColumns))), this.properties.get("cq:cssClass", "")));
        this.classNames = ResponsiveGridUtils.createClassNames(initial, breakpoints, this::generateBreakpointCssClasses);
    }

    private void createDefaultBreakpoint(Map<String, Breakpoint> breakpoints, int offset, int initialDefaultWidth) {
        if (!breakpoints.containsKey("default")) {
            int columns = this.currentStyle.get(COLUMNS, initialDefaultWidth);
            breakpoints.put("default", new Breakpoint("default", columns, offset, Breakpoint.ResponsiveBehavior.none));
        }
    }

    Set<String> createResponsiveColumns(Map<String, Breakpoint> breakpoints) {
        HashSet<String> columnBreakpointNames = new HashSet<String>();
        Iterator<Resource> paragraphsIt = this.getEffectiveResource().listChildren();
        while (paragraphsIt.hasNext()) {
            Resource child = paragraphsIt.next();
            if ("cq:responsive".equals(child.getName())) continue;
            ResponsiveColumn column = new ResponsiveColumn(child, breakpoints, this.classNamesPrefix, this.slingRequest, this.modelFactory);
            this.childColumns.put(column.getResource().getName(), column);
            Map<String, Breakpoint> columnBreakpoints = column.getBreakpoints();
            this.columnClassNames.put(column.getResource().getName(), column.getColumnClassNames());
            if (columnBreakpoints == null) continue;
            columnBreakpointNames.addAll(columnBreakpoints.keySet());
        }
        return columnBreakpointNames;
    }

    List<String> generateBreakpointCssClasses(Breakpoint breakpoint) {
        String breakpointName = breakpoint.getName();
        int width = breakpoint.getWidth();
        ArrayList<String> breakpointClasses = new ArrayList<String>();
        if (width > 0) {
            String widthBreakpointClassname = ResponsiveGridUtils.createClassname(List.of(this.classNamesPrefix, breakpointName, Integer.toString(width)));
            breakpointClasses.add(widthBreakpointClassname);
        }
        return breakpointClasses;
    }

    @Override
    public String getGridClassNames() {
        return this.classNames;
    }

    @Override
    @Nonnull
    public Map<String, String> getColumnClassNames() {
        return this.columnClassNames;
    }

    @Override
    public int getColumnCount() {
        return this.columns;
    }

    @Nonnull
    public Collection<? extends ResponsiveColumn> getColumns() {
        return this.childColumns.values();
    }

    @Nonnull
    public <T extends Resource> T getEffectiveResource() {
        Resource wrappedResource;
        if (this.resource instanceof TemplatedResource) {
            return (T)this.resource;
        }
        if (this.resource instanceof ResourceWrapper && (wrappedResource = ((ResourceWrapper)this.resource).getResource()) instanceof TemplatedResource) {
            return (T)this.resource;
        }
        Resource templatedResource = this.slingRequest.adaptTo(TemplatedResource.class);
        if (templatedResource == null) {
            return (T)this.resource;
        }
        return (T)templatedResource;
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.resource.getPath();
    }

    @Override
    @JsonProperty(value="allowedComponents")
    public AllowedComponentsExporter getExportedAllowedComponents() {
        return this.slingRequest.adaptTo(AllowedComponentsExporter.class);
    }

    @Override
    @Nonnull
    public Map<String, ? extends ComponentExporter> getExportedItems() {
        return this.childColumns;
    }

    @Override
    @Nonnull
    public String[] getExportedItemsOrder() {
        return this.childColumns.isEmpty() ? new String[]{} : this.childColumns.keySet().toArray(new String[0]);
    }

    @Override
    @Nonnull
    public String getExportedType() {
        return this.resource.getResourceType();
    }

    @Deprecated
    public List<ResponsiveColumn> getParagraphs() {
        return new ArrayList<ResponsiveColumn>(this.getColumns());
    }

    @Deprecated
    public String getCssClass() {
        return this.classNames;
    }

    @Override
    @Nonnull
    @Deprecated
    public String getResourceType() {
        return this.resource.getResourceType();
    }

    @Override
    @Deprecated
    public String getResourceSuperType() {
        return this.resource.getResourceSuperType();
    }

    @Override
    @Nonnull
    @Deprecated
    public ResourceMetadata getResourceMetadata() {
        return this.resource.getResourceMetadata();
    }

    @Override
    @Nonnull
    @Deprecated
    public ResourceResolver getResourceResolver() {
        return this.resource.getResourceResolver();
    }
}

