/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.workflow.process;

import com.adobe.granite.workflow.collection.ResourceCollection;
import com.adobe.granite.workflow.collection.ResourceCollectionManager;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Revision;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.workflow.process.ResourceCollectionHelper;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Property(name="process.label", value={"Create Version"})
public class CreateVersionProcess
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(CreateVersionProcess.class);
    private static final String WORKFLOW_COLLECTION_PAGE_RESOURCE_TYPE = "cq/workflow/components/collection/page";
    public static final String TYPE_JCR_PATH = "JCR_PATH";
    public static final String TYPE_JCR_UUID = "JCR_UUID";
    @Reference
    private ResourceResolverFactory resolverFactory = null;
    @Reference
    private SlingRepository repository;
    @Reference
    private ResourceCollectionManager rcManager;

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        try {
            Session session = workflowSession.getSession();
            WorkflowData data = workItem.getWorkflowData();
            String path = null;
            String type = data.getPayloadType();
            if (type.equals(TYPE_JCR_PATH) && data.getPayload() != null) {
                String payloadData = (String)data.getPayload();
                if (session.itemExists(payloadData)) {
                    path = payloadData;
                }
            } else if (data.getPayload() != null && type.equals(TYPE_JCR_UUID)) {
                Node node = session.getNodeByIdentifier((String)data.getPayload());
                path = node.getPath();
            }
            if (path != null) {
                ResourceResolver resolver = this.resolverFactory.getResourceResolver(Collections.singletonMap("user.jcr.session", session));
                Resource res = resolver.getResource(path);
                HashMap<String, String> revisionMap = new HashMap<String, String>();
                if (res.adaptTo(Page.class) != null) {
                    Page page = res.adaptTo(Page.class);
                    PageManager pageManager = page.getPageManager();
                    this.createPageVersion(page, workItem, pageManager, revisionMap);
                    if (page.getContentResource().isResourceType(WORKFLOW_COLLECTION_PAGE_RESOURCE_TYPE)) {
                        List<ResourceCollection> rcCollections = this.rcManager.getCollectionsForNode((Node)session.getItem(path));
                        List<String> paths = ResourceCollectionHelper.getPaths(path, rcCollections);
                        for (String collectionPath : paths) {
                            Resource collectionResource = resolver.getResource(collectionPath);
                            if (collectionResource.adaptTo(Page.class) != null) {
                                this.createPageVersion(collectionResource.adaptTo(Page.class), workItem, pageManager, revisionMap);
                                continue;
                            }
                            if (collectionResource.adaptTo(Asset.class) == null) continue;
                            this.createAssetVersion(collectionResource.adaptTo(Asset.class), workItem, revisionMap);
                        }
                    }
                } else if (res.adaptTo(Asset.class) != null) {
                    this.createAssetVersion(res.adaptTo(Asset.class), workItem, revisionMap);
                } else {
                    log.warn("Cannot create version of " + path);
                }
                if (!revisionMap.isEmpty()) {
                    JSONObject revisionJs = new JSONObject();
                    for (String key : revisionMap.keySet()) {
                        revisionJs.put(key, revisionMap.get(key));
                    }
                    data.getMetaDataMap().put("versions", revisionJs.toString());
                    if (workItem.getWorkflowData().getMetaDataMap().get("absoluteTime", String.class) != null) {
                        Calendar cal = this.getTime(workItem);
                        data.getMetaDataMap().put("comment", "Activate version " + revisionMap + " on " + cal.getTime().toString());
                    }
                    workflowSession.updateWorkflowData(workItem.getWorkflow(), data);
                }
            } else {
                log.warn("Cannot process payload. Path is null");
            }
        }
        catch (RepositoryException e) {
            throw new WorkflowException(e);
        }
        catch (WCMException e) {
            throw new WorkflowException(e);
        }
        catch (Exception e) {
            throw new WorkflowException(e);
        }
    }

    private void createPageVersion(Page page, WorkItem workItem, PageManager pageManager, Map<String, String> revisionMap) throws WCMException, RepositoryException {
        if (page == null) {
            return;
        }
        String versionLabel = this.createUniqueVersionLabel(pageManager.getRevisions(page.getPath(), null), this.getAbsTime(workItem));
        com.day.cq.wcm.api.Revision rev = pageManager.createRevision(page, versionLabel, null);
        revisionMap.put(page.getContentResource().getPath(), rev.getVersion().getName());
    }

    private void createAssetVersion(Asset asset, WorkItem workItem, Map<String, String> revisionMap) throws Exception {
        if (asset == null) {
            return;
        }
        String versionLabel = this.createUniqueVersionLabel(asset.getRevisions(null), this.getAbsTime(workItem));
        Revision rev = asset.createRevision(versionLabel, null);
        revisionMap.put(asset.getPath(), rev.getVersion().getName());
    }

    private String createUniqueVersionLabel(Collection<?> revisions, String versionLabelHint) throws RepositoryException {
        boolean unique;
        if (versionLabelHint == null) {
            return null;
        }
        LinkedList<Version> versions = new LinkedList<Version>();
        for (Object o : revisions) {
            Version v = o instanceof com.day.cq.wcm.api.Revision ? ((com.day.cq.wcm.api.Revision)o).getVersion() : (o instanceof Revision ? ((Revision)o).getVersion() : null);
            if (null == v) continue;
            versions.add(v);
        }
        String versionLabel = versionLabelHint;
        int count = 1;
        block1: do {
            unique = true;
            for (Version v : versions) {
                if (!v.getContainingHistory().hasVersionLabel(versionLabel)) continue;
                versionLabel = versionLabelHint + " (" + ++count + ")";
                unique = false;
                continue block1;
            }
        } while (!unique);
        return versionLabel;
    }

    private String getAbsTime(WorkItem workItem) {
        if (workItem.getWorkflowData().getMetaDataMap().get("absoluteTime", String.class) != null) {
            Calendar cal = this.getTime(workItem);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd HH.mm.ss");
            return "Scheduled Activation Time is " + formatter.format(cal.getTime());
        }
        return null;
    }

    private Calendar getTime(WorkItem workItem) {
        Long time = (Long)((Object)workItem.getWorkflowData().getMetaDataMap().get("absoluteTime", Long.class));
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        return cal;
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindRcManager(ResourceCollectionManager resourceCollectionManager) {
        this.rcManager = resourceCollectionManager;
    }

    protected void unbindRcManager(ResourceCollectionManager resourceCollectionManager) {
        if (this.rcManager == resourceCollectionManager) {
            this.rcManager = null;
        }
    }
}

