/*
 * Decompiled with CFR 0.152.
 */
package com.day.image;

import com.day.image.AbstractBufferedImageOp;
import com.day.image.ResizeOp;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class StampOp
extends AbstractBufferedImageOp {
    private BufferedImage stamp;
    private volatile BufferedImage stampCache;
    private Rectangle2D stampPosition = new Rectangle2D.Double(0.0, 0.0, 15.0, 15.0);
    private Composite stampComposite = AlphaComposite.Src;

    public StampOp(RenderingHints hints) {
        super(hints);
    }

    public StampOp() {
        super(null);
    }

    public void setStamp(BufferedImage stamp) {
        this.stamp = stamp;
        this.stampCache = null;
    }

    public BufferedImage getStamp() {
        return this.stamp;
    }

    public void setStampLocation(int x, int y) {
        this.stampPosition.setRect(x, y, this.stampPosition.getWidth(), this.stampPosition.getHeight());
    }

    public void setStampSize(int width, int height) {
        this.stampPosition.setRect(this.stampPosition.getX(), this.stampPosition.getY(), width, height);
        this.stampCache = null;
    }

    public Rectangle2D getStampPosition() {
        return this.stampPosition;
    }

    public void setStampComposite(Composite stampComposite) {
        if (stampComposite != null) {
            this.stampComposite = stampComposite;
        }
    }

    public Composite getStampComposite() {
        return this.stampComposite;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (src == dst && src != null) {
            this.doFilter(src, dst);
            return dst;
        }
        return super.filter(src, dst);
    }

    protected void doFilter(BufferedImage src, BufferedImage dst) {
        Graphics2D gDst = dst.createGraphics();
        if (src.getHeight() != dst.getHeight() || src.getWidth() != dst.getWidth()) {
            ResizeOp sizer = new ResizeOp(dst.getWidth() / src.getWidth(), dst.getHeight() / src.getHeight(), this.getRenderingHints());
            sizer.filter(src, dst);
        } else if (src != dst) {
            gDst.drawRenderedImage(src, new AffineTransform());
        }
        BufferedImage stamp = this.getSizedStamp();
        if (stamp != null) {
            Composite oldComposite = gDst.getComposite();
            gDst.setComposite(this.getStampComposite());
            gDst.drawImage((Image)stamp, (int)this.getStampPosition().getX(), (int)this.getStampPosition().getY(), null);
            gDst.setComposite(oldComposite);
        }
    }

    private BufferedImage getSizedStamp() {
        BufferedImage stamp;
        if (this.stampCache == null && (stamp = this.getStamp()) != null) {
            Rectangle2D stampPosition = this.getStampPosition();
            double stampWidth = stamp.getWidth();
            double stampHeight = stamp.getHeight();
            if (stampPosition.getWidth() == stampWidth && stampPosition.getHeight() == stampHeight) {
                this.stampCache = stamp;
            } else {
                double scaleX = stampPosition.getWidth() / stampWidth;
                double scaleY = stampPosition.getHeight() / stampHeight;
                ResizeOp stampSizer = new ResizeOp(scaleX, scaleY, this.getRenderingHints());
                this.stampCache = stampSizer.filter(stamp, null);
            }
        }
        return this.stampCache;
    }
}

