/*
 * Decompiled with CFR 0.152.
 */
package com.day.util;

import com.day.text.GlobPattern;
import com.day.util.HandleExpander;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

public class FileExpander
implements HandleExpander {
    public static final BaseFilter RETURN_ALL = new BaseFilter("*");
    public static final BaseFilter RETURN_FILES = new FileFileFilter("*");
    public static final BaseFilter RETURN_DIRECTORIES = new DirectoryFileFilter("*");
    private final File rootDirectory;
    private final BaseFilter expandType;

    public FileExpander() {
        this.rootDirectory = null;
        this.expandType = RETURN_FILES;
    }

    public FileExpander(String root, BaseFilter type) {
        this(new File(root), type);
    }

    public FileExpander(File root, BaseFilter type) {
        if (root.isFile()) {
            root = root.getParentFile();
        }
        if (!root.isAbsolute()) {
            root = root.getAbsoluteFile();
        }
        this.rootDirectory = root;
        this.expandType = type != null ? type : RETURN_FILES;
    }

    @Override
    public String[] expand(String pattern) {
        File root = new File(pattern = pattern.replace('/', File.separatorChar)).isAbsolute() ? null : this.rootDirectory;
        List result = this.traverse(new ArrayList(), root, pattern);
        return result.toArray(new String[result.size()]);
    }

    private List traverse(List result, File directory, String rest) {
        int end = rest.length();
        for (int i = 0; i < end; ++i) {
            int nextSlash;
            char c = rest.charAt(i);
            if ("*?[]".indexOf(c) < 0) continue;
            int lastSlash = rest.lastIndexOf(File.separatorChar, i);
            if (lastSlash >= 0) {
                String part = lastSlash == 2 && rest.charAt(1) == ':' ? rest.substring(0, 3) : (lastSlash == 0 ? rest.substring(0, 1) : rest.substring(0, lastSlash));
                directory = new File(directory, part);
            }
            if ((nextSlash = rest.indexOf(File.separatorChar, i)) < 0) {
                String pat = rest.substring(lastSlash + 1);
                rest = null;
                File[] files = directory.listFiles(this.expandType.getInstance(pat));
                if (files != null) {
                    for (int j = 0; j < files.length; ++j) {
                        result.add(files[j].getAbsolutePath());
                    }
                }
            } else {
                String pat = rest.substring(lastSlash + 1, nextSlash);
                rest = rest.substring(nextSlash + 1);
                File[] dirs = directory.listFiles(new DirectoryFileFilter(pat));
                if (dirs != null) {
                    for (int j = 0; j < dirs.length; ++j) {
                        this.traverse(result, dirs[j], rest);
                    }
                }
            }
            return result;
        }
        if ((directory = new File(directory, rest)).exists() && this.expandType.accept(directory)) {
            result.add(directory.getAbsolutePath());
        }
        return result;
    }

    private static class FileFileFilter
    extends BaseFilter {
        FileFileFilter(String pattern) {
            super(pattern);
        }

        @Override
        BaseFilter getInstance(String glob) {
            return new FileFileFilter(glob);
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile() && super.accept(pathname);
        }
    }

    private static class DirectoryFileFilter
    extends BaseFilter {
        DirectoryFileFilter(String pattern) {
            super(pattern);
        }

        @Override
        BaseFilter getInstance(String glob) {
            return new DirectoryFileFilter(glob);
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() && super.accept(pathname);
        }
    }

    public static class BaseFilter
    implements FileFilter {
        private final GlobPattern glob;

        BaseFilter(String pattern) {
            this.glob = new GlobPattern(pattern.toLowerCase());
        }

        BaseFilter getInstance(String glob) {
            return new BaseFilter(glob);
        }

        @Override
        public boolean accept(File pathname) {
            return this.glob.matches(pathname.getName().toLowerCase());
        }
    }
}

