/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.composite.CompositeNodeStoreMonitor;
import org.apache.jackrabbit.oak.composite.CompositeNodeStoreStatsMBean;
import org.apache.jackrabbit.oak.spi.mount.Mount;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.HistogramStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.stats.TimeSeriesStatsUtil;

public class CompositeNodeStoreStats
implements CompositeNodeStoreStatsMBean,
CompositeNodeStoreMonitor {
    public static final String STRING_CACHE_SIZE = "STRING_CACHE_SIZE";
    public static final String NODE_PATH_DEPTH = "_PATH_DEPTH";
    public static final String NODE_SWITCH_TO_DEFAULT_MOUNT = "_SWITCH_TO_DEFAULT_MOUNT";
    public static final String NODE_SWITCH_TO_NON_DEFAULT_MOUNT = "_SWITCH_TO_NON_DEFAULT_MOUNT";
    private final StatisticsProvider statisticsProvider;
    private final CounterStats stringCacheSize;
    private final HistogramStats nodePathDepths;
    private final CounterStats nodeSwitchToDefaultMount;
    private final CounterStats nodeSwitchToNonDefaultMount;
    private final Map<String, Long> nodePathCounts;
    private long maxNodePathCount;
    private final long nodePathCountSizeLimit;
    private final long nodePathCountValueLimit;
    private final boolean countPaths;
    private final String prefix;

    public CompositeNodeStoreStats(StatisticsProvider statisticsProvider, String prefix, boolean countPaths) {
        this(statisticsProvider, prefix, countPaths, 100L, 0x3FFFFFFFFFFFFFFFL);
    }

    public CompositeNodeStoreStats(StatisticsProvider statisticsProvider, String prefix, boolean countPaths, long nodePathCountSizeLimit, long nodePathCountValueLimit) {
        this.statisticsProvider = statisticsProvider;
        this.stringCacheSize = statisticsProvider.getCounterStats(prefix + STRING_CACHE_SIZE, StatsOptions.DEFAULT);
        this.nodePathDepths = statisticsProvider.getHistogram(prefix + NODE_PATH_DEPTH, StatsOptions.METRICS_ONLY);
        this.nodeSwitchToDefaultMount = statisticsProvider.getCounterStats(prefix + NODE_SWITCH_TO_DEFAULT_MOUNT, StatsOptions.DEFAULT);
        this.nodeSwitchToNonDefaultMount = statisticsProvider.getCounterStats(prefix + NODE_SWITCH_TO_NON_DEFAULT_MOUNT, StatsOptions.DEFAULT);
        this.nodePathCounts = Maps.newHashMap();
        this.maxNodePathCount = 0L;
        this.countPaths = countPaths;
        this.nodePathCountSizeLimit = nodePathCountSizeLimit;
        this.nodePathCountValueLimit = nodePathCountValueLimit;
        this.prefix = prefix;
    }

    @Override
    public void onCreateNodeObject(String path) {
        this.nodePathDepths.update(PathUtils.getDepth(path));
        if (this.countPaths) {
            this.updatePathCount(path);
        }
    }

    @Override
    public void onSwitchNodeToNative(Mount mount) {
        if (mount.isDefault()) {
            this.nodeSwitchToDefaultMount.inc();
        } else {
            this.nodeSwitchToNonDefaultMount.inc();
        }
    }

    @Override
    public void onAddStringCacheEntry() {
        this.stringCacheSize.inc();
    }

    @Override
    public CompositeData getStringCacheSize() {
        return this.getCompositeData(STRING_CACHE_SIZE);
    }

    @Override
    public CompositeData getNodeSwitchToDefaultMount() {
        return this.getCompositeData(NODE_SWITCH_TO_DEFAULT_MOUNT);
    }

    @Override
    public CompositeData getNodeSwitchToNonDefaultMount() {
        return this.getCompositeData(NODE_SWITCH_TO_NON_DEFAULT_MOUNT);
    }

    private CompositeData getCompositeData(String name) {
        return TimeSeriesStatsUtil.asCompositeData(this.getTimeSeries(this.prefix + name), this.prefix + name);
    }

    @Override
    public TabularData getNodePathCounts() throws OpenDataException {
        return this.pathsTable(this.nodePathCounts, "popularNodeStatePaths", "Popular node state paths");
    }

    private TimeSeries getTimeSeries(String name) {
        return this.statisticsProvider.getStats().getTimeSeries(name, true);
    }

    private synchronized void updatePathCount(String path) {
        long newValue = this.nodePathCounts.compute(path, (p, v) -> v == null ? 1L : v + 1L);
        boolean removeZeros = false;
        if (newValue == 1L && (long)this.nodePathCounts.size() >= this.nodePathCountSizeLimit) {
            this.nodePathCounts.entrySet().stream().forEach(e -> this.nodePathCounts.put((String)e.getKey(), (Long)e.getValue() - 1L));
            --this.maxNodePathCount;
            removeZeros = true;
        }
        if (this.maxNodePathCount < newValue) {
            this.maxNodePathCount = newValue;
            if (this.maxNodePathCount >= this.nodePathCountValueLimit) {
                this.nodePathCounts.entrySet().stream().forEach(e -> this.nodePathCounts.put((String)e.getKey(), (Long)e.getValue() / 2L));
                this.maxNodePathCount /= 2L;
                removeZeros = true;
            }
        }
        if (removeZeros) {
            Iterator<Long> it = this.nodePathCounts.values().iterator();
            while (it.hasNext()) {
                if (it.next() > 0L) continue;
                it.remove();
            }
        }
    }

    private TabularData pathsTable(Map<String, Long> paths, String name, String description) throws OpenDataException {
        CompositeType pathRowType = new CompositeType("compositePath", "Path", new String[]{"count", "path"}, new String[]{"count", "path"}, new OpenType[]{SimpleType.LONG, SimpleType.STRING});
        TabularDataSupport tabularData = new TabularDataSupport(new TabularType(name, description, pathRowType, new String[]{"path"}));
        paths.entrySet().stream().sorted(Comparator.comparingLong(Map.Entry::getValue).reversed()).map(e -> {
            HashMap<String, Object> m = Maps.newHashMap();
            m.put("count", e.getValue());
            m.put("path", e.getKey());
            return m;
        }).map(d -> CompositeNodeStoreStats.mapToCompositeData(pathRowType, d)).forEach(tabularData::put);
        return tabularData;
    }

    private static CompositeData mapToCompositeData(CompositeType compositeType, Map<String, Object> data) {
        try {
            return new CompositeDataSupport(compositeType, data);
        }
        catch (OpenDataException e) {
            throw new IllegalArgumentException(e);
        }
    }

    Map<String, Long> getNodePathCountsMap() {
        return this.nodePathCounts;
    }

    long getMaxNodePathCount() {
        return this.maxNodePathCount;
    }
}

