/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FilenameUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.apache.jackrabbit.oak.api.jmx.CheckpointMBean;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.document.spi.JournalPropertyService;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexInfoService;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexInfoProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexPathService;
import org.apache.jackrabbit.oak.plugins.index.fulltext.PreExtractedTextProvider;
import org.apache.jackrabbit.oak.plugins.index.importer.IndexImporterProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.ActiveDeletedBlobCollectorMBean;
import org.apache.jackrabbit.oak.plugins.index.lucene.ActiveDeletedBlobCollectorMBeanImpl;
import org.apache.jackrabbit.oak.plugins.index.lucene.AsyncIndexesSizeStatsUpdate;
import org.apache.jackrabbit.oak.plugins.index.lucene.AsyncIndexesSizeStatsUpdateImpl;
import org.apache.jackrabbit.oak.plugins.index.lucene.CopyOnReadStatsMBean;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexAugmentorFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexCopier;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexTracker;
import org.apache.jackrabbit.oak.plugins.index.lucene.LoggingInfoStream;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexInfoProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexMBean;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexMBeanImpl;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.OakCodec;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.ActiveDeletedBlobCollectorFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.BufferedOakDirectory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.LuceneIndexFileSystemStatistics;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.LuceneIndexImporter;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.DocumentQueue;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.ExternalObserverBuilder;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.IndexingQueue;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.LocalIndexObserver;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.LuceneJournalPropertyService;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.NRTIndexFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.property.PropertyIndexCleaner;
import org.apache.jackrabbit.oak.plugins.index.lucene.reader.DefaultIndexReaderFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.reader.LuceneIndexReaderFactory;
import org.apache.jackrabbit.oak.plugins.index.search.ExtractedTextCache;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.TextExtractionStatsMBean;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.commit.BackgroundObserver;
import org.apache.jackrabbit.oak.spi.commit.BackgroundObserverMBean;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.state.Clusterable;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.util.InfoStream;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Apache Jackrabbit Oak LuceneIndexProvider")
public class LuceneIndexProviderService {
    public static final String REPOSITORY_HOME = "repository.home";
    private LuceneIndexProvider indexProvider;
    private final List<ServiceRegistration> regs = Lists.newArrayList();
    private final List<Registration> oakRegs = Lists.newArrayList();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policyOption=ReferencePolicyOption.GREEDY, policy=ReferencePolicy.DYNAMIC)
    private QueryIndex.NodeAggregator nodeAggregator;
    private static final boolean PROP_DISABLED_DEFAULT = false;
    @Property(boolValue={false}, label="Disable this component", description="If true, this component is disabled.")
    private static final String PROP_DISABLED = "disabled";
    @Property(boolValue={false}, label="Enable Debug Logging", description="Enables debug logging in Lucene. After enabling this actual logging can be controlled via changing log level for category 'oak.lucene' to debug")
    private static final String PROP_DEBUG = "debug";
    @Property(boolValue={true}, label="Enable CopyOnRead", description="Enable copying of Lucene index to local file system to improve query performance", propertyPrivate=true)
    private static final String PROP_COPY_ON_READ = "enableCopyOnReadSupport";
    @Property(label="Local index storage path", description="Local file system path where Lucene indexes would be copied when CopyOnRead is enabled. If not specified then indexes would be stored under 'index' dir under Repository Home")
    private static final String PROP_LOCAL_INDEX_DIR = "localIndexDir";
    private static final boolean PROP_COPY_ON_WRITE_DEFAULT = true;
    @Property(boolValue={true}, label="Enable CopyOnWrite", description="Enable copying of Lucene index to local file system to improve index writer performance", propertyPrivate=true)
    private static final String PROP_COPY_ON_WRITE = "enableCopyOnWriteSupport";
    @Property(boolValue={true}, label="Open index asynchronously", description="Enable opening of indexes in asynchronous mode")
    private static final String PROP_ASYNC_INDEX_OPEN = "enableOpenIndexAsync";
    private static final int PROP_THREAD_POOL_SIZE_DEFAULT = 5;
    @Property(intValue={5}, label="Thread pool size", description="Thread pool size used to perform various asynchronous task in Oak Lucene")
    private static final String PROP_THREAD_POOL_SIZE = "threadPoolSize";
    private static final boolean PROP_PREFETCH_INDEX_FILES_DEFAULT = true;
    @Property(boolValue={true}, label="Prefetch Index Files", description="Prefetch the index files when CopyOnRead is enabled. When enabled all new Lucene index files would be copied locally before the index is made available to QueryEngine")
    private static final String PROP_PREFETCH_INDEX_FILES = "prefetchIndexFiles";
    private static final int PROP_EXTRACTED_TEXT_CACHE_SIZE_DEFAULT = 20;
    @Property(intValue={20}, label="Extracted text cache size (MB)", description="Cache size in MB for caching extracted text for some time. When set to 0 then cache would be disabled")
    private static final String PROP_EXTRACTED_TEXT_CACHE_SIZE = "extractedTextCacheSizeInMB";
    private static final int PROP_EXTRACTED_TEXT_CACHE_EXPIRY_DEFAULT = 300;
    @Property(intValue={300}, label="Extracted text cache expiry (secs)", description="Time in seconds for which the extracted text would be cached in memory")
    private static final String PROP_EXTRACTED_TEXT_CACHE_EXPIRY = "extractedTextCacheExpiryInSecs";
    private static final boolean PROP_PRE_EXTRACTED_TEXT_ALWAYS_USE_DEFAULT = false;
    @Property(boolValue={false}, label="Always use pre-extracted text cache", description="By default pre extracted text cache would only be used for reindex case. If this setting is enabled then it would also be used in normal incremental indexing")
    private static final String PROP_PRE_EXTRACTED_TEXT_ALWAYS_USE = "alwaysUsePreExtractedCache";
    private static final int PROP_BOOLEAN_CLAUSE_LIMIT_DEFAULT = 1024;
    @Property(intValue={1024}, label="Boolean Clause Limit", description="Limit for number of boolean clauses generated for handling of OR query")
    private static final String PROP_BOOLEAN_CLAUSE_LIMIT = "booleanClauseLimit";
    private static final boolean PROP_HYBRID_INDEXING_DEFAULT = true;
    @Property(boolValue={true}, label="Hybrid Indexing", description="When enabled Lucene NRT Indexing mode would be enabled")
    private static final String PROP_HYBRID_INDEXING = "enableHybridIndexing";
    private static final int PROP_HYBRID_QUEUE_SIZE_DEFAULT = 10000;
    @Property(intValue={10000}, label="Queue size", description="Size of in memory queue used for storing Lucene Documents which need to be added to local index")
    private static final String PROP_HYBRID_QUEUE_SIZE = "hybridQueueSize";
    public static final long PROP_HYBRID_QUEUE_TIMEOUT_DEFAULT = 100L;
    @Property(longValue={100L}, label="Queue timeout", description="Maximum time to wait for adding entries to the queue used for storing Lucene Documents which need to be added to local index")
    private static final String PROP_HYBRID_QUEUE_TIMEOUT = "hybridQueueTimeout";
    private static final boolean PROP_DISABLE_DEFN_STORAGE_DEFAULT = false;
    @Property(boolValue={false}, label="Disable index definition storage", description="By default index definitions would be stored at time of reindexing to ensure that future modifications to it are not effective untill index is reindex. Set this to true would disable this feature")
    private static final String PROP_DISABLE_STORED_INDEX_DEFINITION = "disableStoredIndexDefinition";
    private static final boolean PROP_DELETED_BLOB_COLLECTION_DEFAULT_ENABLED = true;
    @Property(boolValue={true}, label="Enable actively removing deleted index blobs from blob store", description="Index blobs are explicitly unique and don't require mark-sweep type collection.This is used to enable the feature. Cleanup implies purging index blobs marked as deleted earlier during some indexing cycle.")
    private static final String PROP_NAME_DELETED_BLOB_COLLECTION_DEFAULT_ENABLED = "deletedBlobsCollectionEnabled";
    private static final int LUCENE_INDEX_STATS_UPDATE_INTERVAL_DEFAULT = 300;
    @Property(intValue={300}, label="Lucene index stats update interval (seconds)", description="Delay in seconds after which Lucene stats are updated in async index update cycle.")
    private static final String LUCENE_INDEX_STATS_UPDATE_INTERVAL = "luceneIndexStatsUpdateInterval";
    private static final int PROP_INDEX_CLEANER_INTERVAL_DEFAULT = 600;
    @Property(intValue={600}, label="Property Index Cleaner Interval (seconds)", description="Cleaner interval time (in seconds) for synchronous property indexes configured as part of lucene indexes")
    private static final String PROP_INDEX_CLEANER_INTERVAL = "propIndexCleanerIntervalInSecs";
    private static final boolean PROP_ENABLE_SINGLE_BLOB_PER_INDEX_FILE_DEFAULT = true;
    @Property(boolValue={true}, label="With CoW enabled, should index files by written as single blobs", description="Index files can be written as single blobs as chunked into smaller blobs. Enable this to write single blob per index file. This would reduce number of blobs in the data store.")
    private static final String PROP_NAME_ENABLE_SINGLE_BLOB_PER_INDEX_FILE = "enableSingleBlobIndexFiles";
    private static final long PROP_INDEX_FILESYSTEM_STATS_INTERVAL_DEFAULT = 300L;
    @Property(longValue={300L}, label="Lucene Index File System Stats Interval (seconds)", description="Interval (in seconds) for calculation of File System metrics for Lucene Index such as Local Index Directory Size")
    private static final String PROP_INDEX_FILESYSTEM_STATS_INTERVAL = "propIndexFSStatsIntervalInSecs";
    private final Clock clock = Clock.SIMPLE;
    private Whiteboard whiteboard;
    private BackgroundObserver backgroundObserver;
    private BackgroundObserver externalIndexObserver;
    @Reference
    private IndexAugmentorFactory augmentorFactory;
    @Reference
    private StatisticsProvider statisticsProvider;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY, policyOption=ReferencePolicyOption.GREEDY)
    private volatile PreExtractedTextProvider extractedTextProvider;
    @Reference
    private MountInfoProvider mountInfoProvider;
    @Reference
    private NodeStore nodeStore;
    @Reference
    private IndexPathService indexPathService;
    @Reference
    private AsyncIndexInfoService asyncIndexInfoService;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY, target="(&(!(split.blobstore=old))(!(split.blobstore=new)))")
    private GarbageCollectableBlobStore blobStore;
    @Reference
    private CheckpointMBean checkpointMBean;
    private IndexCopier indexCopier;
    private ActiveDeletedBlobCollectorFactory.ActiveDeletedBlobCollector activeDeletedBlobCollector;
    private File indexDir;
    private ExecutorService executorService;
    private int threadPoolSize;
    private ExtractedTextCache extractedTextCache;
    private boolean hybridIndex;
    private NRTIndexFactory nrtIndexFactory;
    private DocumentQueue documentQueue;
    private LuceneIndexEditorProvider editorProvider;
    private IndexTracker tracker;
    private PropertyIndexCleaner cleaner;
    private AsyncIndexesSizeStatsUpdate asyncIndexesSizeStatsUpdate;

    @Activate
    private void activate(BundleContext bundleContext, Map<String, ?> config) throws IOException {
        this.asyncIndexesSizeStatsUpdate = new AsyncIndexesSizeStatsUpdateImpl(PropertiesUtil.toLong(config.get(LUCENE_INDEX_STATS_UPDATE_INTERVAL), 300L) * 1000L);
        boolean disabled = PropertiesUtil.toBoolean(config.get(PROP_DISABLED), false);
        this.hybridIndex = PropertiesUtil.toBoolean(config.get(PROP_HYBRID_INDEXING), false);
        if (disabled) {
            this.log.info("Component disabled by configuration");
            return;
        }
        this.configureIndexDefinitionStorage(config);
        this.configureBooleanClauseLimit(config);
        this.initializeFactoryClassLoaders(this.getClass().getClassLoader());
        if (System.getProperty("oak.lucene.enableSingleBlobIndexFiles") == null) {
            BufferedOakDirectory.setEnableWritingSingleBlobIndexFile((boolean)PropertiesUtil.toBoolean(config.get(PROP_NAME_ENABLE_SINGLE_BLOB_PER_INDEX_FILE), true));
        } else {
            this.log.info("Not setting config for single blob for an index file as it's set by command line!");
        }
        this.whiteboard = new OsgiWhiteboard(bundleContext);
        this.threadPoolSize = PropertiesUtil.toInteger(config.get(PROP_THREAD_POOL_SIZE), 5);
        this.initializeIndexDir(bundleContext, config);
        this.initializeExtractedTextCache(bundleContext, config, this.statisticsProvider);
        this.tracker = this.createTracker(bundleContext, config);
        this.indexProvider = new LuceneIndexProvider(this.tracker, this.augmentorFactory);
        this.initializeActiveBlobCollector(this.whiteboard, config);
        this.initializeLogging(config);
        this.initialize();
        this.regs.add(bundleContext.registerService(QueryIndexProvider.class.getName(), (Object)this.indexProvider, null));
        this.registerObserver(bundleContext, config);
        this.registerLocalIndexObserver(bundleContext, this.tracker, config);
        this.registerIndexInfoProvider(bundleContext);
        this.registerIndexImporterProvider(bundleContext);
        this.registerPropertyIndexCleaner(config, bundleContext);
        LuceneIndexMBeanImpl mBean = new LuceneIndexMBeanImpl(this.tracker, this.nodeStore, this.indexPathService, this.getIndexCheckDir(), this.cleaner);
        this.oakRegs.add(WhiteboardUtils.registerMBean(this.whiteboard, LuceneIndexMBean.class, mBean, "LuceneIndex", "Lucene Index statistics"));
        this.registerGCMonitor(this.whiteboard, this.tracker);
        this.registerIndexEditor(bundleContext, this.tracker, mBean, config);
        LuceneIndexFileSystemStatistics luceneIndexFSStats = new LuceneIndexFileSystemStatistics(this.statisticsProvider, this.indexCopier);
        this.registerLuceneFileSystemStats(luceneIndexFSStats, PropertiesUtil.toLong(config.get(PROP_INDEX_FILESYSTEM_STATS_INTERVAL), 300L));
    }

    private File getIndexCheckDir() {
        return new File(Preconditions.checkNotNull(this.indexDir), "indexCheckDir");
    }

    @Deactivate
    private void deactivate() throws InterruptedException, IOException {
        for (ServiceRegistration serviceRegistration : this.regs) {
            serviceRegistration.unregister();
        }
        for (Registration registration : this.oakRegs) {
            registration.unregister();
        }
        if (this.backgroundObserver != null) {
            this.backgroundObserver.close();
        }
        if (this.externalIndexObserver != null) {
            this.externalIndexObserver.close();
        }
        if (this.indexProvider != null) {
            this.indexProvider.close();
            this.indexProvider = null;
        }
        if (this.documentQueue != null) {
            this.documentQueue.close();
        }
        if (this.nrtIndexFactory != null) {
            this.nrtIndexFactory.close();
        }
        if (this.indexCopier != null) {
            this.indexCopier.close();
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService.awaitTermination(1L, TimeUnit.MINUTES);
        }
        if (this.extractedTextCache != null) {
            this.extractedTextCache.close();
        }
        InfoStream.setDefault(InfoStream.NO_OUTPUT);
    }

    void initializeIndexDir(BundleContext bundleContext, Map<String, ?> config) {
        String repoHome;
        String indexDirPath = PropertiesUtil.toString(config.get(PROP_LOCAL_INDEX_DIR), null);
        if (Strings.isNullOrEmpty(indexDirPath) && (repoHome = bundleContext.getProperty(REPOSITORY_HOME)) != null) {
            indexDirPath = FilenameUtils.concat(repoHome, "index");
        }
        Preconditions.checkNotNull(indexDirPath, "Index directory cannot be determined as neither index directory path [%s] nor repository home [%s] defined", PROP_LOCAL_INDEX_DIR, REPOSITORY_HOME);
        this.indexDir = new File(indexDirPath);
    }

    IndexCopier getIndexCopier() {
        return this.indexCopier;
    }

    ExtractedTextCache getExtractedTextCache() {
        return this.extractedTextCache;
    }

    private void initialize() {
        if (this.indexProvider == null) {
            return;
        }
        if (this.nodeAggregator != null) {
            this.log.debug("Using NodeAggregator {}", (Object)this.nodeAggregator.getClass());
        }
        this.indexProvider.setAggregator(this.nodeAggregator);
    }

    private void initializeLogging(Map<String, ?> config) {
        boolean debug = PropertiesUtil.toBoolean(config.get(PROP_DEBUG), false);
        if (debug) {
            InfoStream.setDefault(LoggingInfoStream.INSTANCE);
            this.log.info("Registered LoggingInfoStream with Lucene. Lucene logs can be enabled now via category [{}]", (Object)"oak.lucene");
        }
    }

    private void registerIndexEditor(BundleContext bundleContext, IndexTracker tracker, LuceneIndexMBean mBean, Map<String, ?> config) throws IOException {
        boolean enableCopyOnWrite = PropertiesUtil.toBoolean(config.get(PROP_COPY_ON_WRITE), true);
        if (enableCopyOnWrite) {
            this.initializeIndexCopier(bundleContext, config);
            this.editorProvider = new LuceneIndexEditorProvider(this.indexCopier, tracker, this.extractedTextCache, this.augmentorFactory, this.mountInfoProvider, this.activeDeletedBlobCollector, mBean, this.statisticsProvider);
            this.log.info("Enabling CopyOnWrite support. Index files would be copied under {}", (Object)this.indexDir.getAbsolutePath());
        } else {
            this.editorProvider = new LuceneIndexEditorProvider(null, tracker, this.extractedTextCache, this.augmentorFactory, this.mountInfoProvider, this.activeDeletedBlobCollector, mBean, this.statisticsProvider);
        }
        this.editorProvider.setBlobStore(this.blobStore);
        this.editorProvider.withAsyncIndexesSizeStatsUpdate(this.asyncIndexesSizeStatsUpdate);
        if (this.hybridIndex) {
            this.editorProvider.setIndexingQueue((IndexingQueue)Preconditions.checkNotNull(this.documentQueue));
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("type", "lucene");
        this.regs.add(bundleContext.registerService(IndexEditorProvider.class.getName(), (Object)this.editorProvider, props));
        this.oakRegs.add(WhiteboardUtils.registerMBean(this.whiteboard, TextExtractionStatsMBean.class, this.editorProvider.getExtractedTextCache().getStatsMBean(), "TextExtractionStats", "TextExtraction statistics"));
    }

    private IndexTracker createTracker(BundleContext bundleContext, Map<String, ?> config) throws IOException {
        IndexTracker tracker;
        boolean enableCopyOnRead = PropertiesUtil.toBoolean(config.get(PROP_COPY_ON_READ), true);
        if (enableCopyOnRead) {
            this.initializeIndexCopier(bundleContext, config);
            this.log.info("Enabling CopyOnRead support. Index files would be copied under {}", (Object)this.indexDir.getAbsolutePath());
            if (this.hybridIndex) {
                this.nrtIndexFactory = new NRTIndexFactory(this.indexCopier, this.statisticsProvider);
            }
            tracker = new IndexTracker((LuceneIndexReaderFactory)new DefaultIndexReaderFactory(this.mountInfoProvider, this.indexCopier), this.nrtIndexFactory);
        } else {
            tracker = new IndexTracker((LuceneIndexReaderFactory)new DefaultIndexReaderFactory(this.mountInfoProvider, null));
        }
        tracker.setAsyncIndexInfoService(this.asyncIndexInfoService);
        return tracker;
    }

    private void initializeIndexCopier(BundleContext bundleContext, Map<String, ?> config) throws IOException {
        if (this.indexCopier != null) {
            return;
        }
        boolean prefetchEnabled = PropertiesUtil.toBoolean(config.get(PROP_PREFETCH_INDEX_FILES), true);
        if (prefetchEnabled) {
            this.log.info("Prefetching of index files enabled. Index would be opened after copying all new files locally");
        }
        this.indexCopier = new IndexCopier(this.getExecutorService(), this.indexDir, prefetchEnabled);
        this.oakRegs.add(WhiteboardUtils.registerMBean(this.whiteboard, CopyOnReadStatsMBean.class, this.indexCopier, "IndexCopierStats", "IndexCopier support statistics"));
    }

    ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = this.createExecutor();
        }
        return this.executorService;
    }

    private ExecutorService createExecutor() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(5, 5, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();
            private final Thread.UncaughtExceptionHandler handler = (t, e) -> LuceneIndexProviderService.this.log.warn("Error occurred in asynchronous processing ", e);

            @Override
            public Thread newThread(@NotNull Runnable r) {
                Thread thread = new Thread(r, this.createName());
                thread.setDaemon(true);
                thread.setPriority(1);
                thread.setUncaughtExceptionHandler(this.handler);
                return thread;
            }

            private String createName() {
                return "oak-lucene-" + this.counter.getAndIncrement();
            }
        });
        executor.setKeepAliveTime(1L, TimeUnit.MINUTES);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    private void registerObserver(BundleContext bundleContext, Map<String, ?> config) {
        boolean enableAsyncIndexOpen = PropertiesUtil.toBoolean(config.get(PROP_ASYNC_INDEX_OPEN), true);
        Closeable observer = this.indexProvider;
        if (enableAsyncIndexOpen) {
            this.backgroundObserver = new BackgroundObserver(this.indexProvider, this.getExecutorService(), 5);
            observer = this.backgroundObserver;
            this.oakRegs.add(WhiteboardUtils.registerMBean(this.whiteboard, BackgroundObserverMBean.class, this.backgroundObserver.getMBean(), "BackgroundObserverStats", "LuceneIndexConfigObserver queue stats"));
            this.log.info("Registering the LuceneIndexProvider as a BackgroundObserver");
        }
        this.regs.add(bundleContext.registerService(Observer.class.getName(), (Object)observer, null));
    }

    private void registerLocalIndexObserver(BundleContext bundleContext, IndexTracker tracker, Map<String, ?> config) {
        if (!this.hybridIndex) {
            this.log.info("Hybrid indexing feature disabled");
            return;
        }
        int queueSize = PropertiesUtil.toInteger(config.get(PROP_HYBRID_QUEUE_SIZE), 10000);
        long queueOfferTimeoutMillis = PropertiesUtil.toLong(config.get(PROP_HYBRID_QUEUE_TIMEOUT), 100L);
        this.documentQueue = new DocumentQueue(queueSize, queueOfferTimeoutMillis, tracker, (Executor)this.getExecutorService(), this.statisticsProvider);
        LocalIndexObserver localIndexObserver = new LocalIndexObserver(this.documentQueue, this.statisticsProvider);
        this.regs.add(bundleContext.registerService(Observer.class.getName(), (Object)localIndexObserver, null));
        int observerQueueSize = 1000;
        int builderMaxSize = 5000;
        this.regs.add(bundleContext.registerService(JournalPropertyService.class.getName(), (Object)new LuceneJournalPropertyService(builderMaxSize), null));
        ExternalObserverBuilder builder = new ExternalObserverBuilder((IndexingQueue)this.documentQueue, tracker, this.statisticsProvider, (Executor)this.getExecutorService(), observerQueueSize);
        this.log.info("Configured JournalPropertyBuilder with max size {} and backed by BackgroundObserver with queue size {}", (Object)builderMaxSize, (Object)observerQueueSize);
        Observer observer = builder.build();
        this.externalIndexObserver = builder.getBackgroundObserver();
        this.regs.add(bundleContext.registerService(Observer.class.getName(), (Object)observer, null));
        this.oakRegs.add(WhiteboardUtils.registerMBean(this.whiteboard, BackgroundObserverMBean.class, this.externalIndexObserver.getMBean(), "BackgroundObserverStats", "LuceneExternalIndexObserver queue stats"));
        this.log.info("Hybrid indexing enabled for configured indexes with queue size of {}", (Object)queueSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFactoryClassLoaders(ClassLoader classLoader) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            this.initializeFactoryClassLoaders0(classLoader);
            this.initializeClasses();
        }
        catch (Throwable t) {
            this.log.warn("Error occurred while initializing the Lucene Factories", t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private void initializeFactoryClassLoaders0(ClassLoader classLoader) {
        TokenizerFactory.reloadTokenizers(classLoader);
        CharFilterFactory.reloadCharFilters(classLoader);
        TokenFilterFactory.reloadTokenFilters(classLoader);
    }

    private void initializeClasses() {
        OakCodec ensureLucene46CodecLoaded = new OakCodec();
        this.log.debug("Lucene46Codec is loaded: {}", (Object)ensureLucene46CodecLoaded);
    }

    private void initializeExtractedTextCache(BundleContext bundleContext, Map<String, ?> config, StatisticsProvider statisticsProvider) {
        CacheStats stats;
        int cacheSizeInMB = PropertiesUtil.toInteger(config.get(PROP_EXTRACTED_TEXT_CACHE_SIZE), 20);
        int cacheExpiryInSecs = PropertiesUtil.toInteger(config.get(PROP_EXTRACTED_TEXT_CACHE_EXPIRY), 300);
        boolean alwaysUsePreExtractedCache = PropertiesUtil.toBoolean(config.get(PROP_PRE_EXTRACTED_TEXT_ALWAYS_USE), false);
        this.extractedTextCache = new ExtractedTextCache((long)cacheSizeInMB * 0x100000L, (long)cacheExpiryInSecs, alwaysUsePreExtractedCache, this.indexDir, statisticsProvider);
        if (this.extractedTextProvider != null) {
            this.registerExtractedTextProvider(this.extractedTextProvider);
        }
        if ((stats = this.extractedTextCache.getCacheStats()) != null) {
            this.oakRegs.add(WhiteboardUtils.registerMBean(this.whiteboard, CacheStatsMBean.class, stats, "CacheStats", stats.getName()));
            this.log.info("Extracted text caching enabled with maxSize {} MB, expiry time {} secs", (Object)cacheSizeInMB, (Object)cacheExpiryInSecs);
        }
    }

    private void registerExtractedTextProvider(PreExtractedTextProvider provider) {
        if (this.extractedTextCache != null) {
            if (provider != null) {
                String usage = this.extractedTextCache.isAlwaysUsePreExtractedCache() ? "always" : "only during reindexing phase";
                this.log.info("Registering PreExtractedTextProvider {} with extracted text cache. It would be used {}", (Object)provider, (Object)usage);
            } else {
                this.log.info("Unregistering PreExtractedTextProvider with extracted text cache");
            }
            this.extractedTextCache.setExtractedTextProvider(provider);
        }
    }

    private void configureBooleanClauseLimit(Map<String, ?> config) {
        int booleanClauseLimit = PropertiesUtil.toInteger(config.get(PROP_BOOLEAN_CLAUSE_LIMIT), 1024);
        if (booleanClauseLimit != BooleanQuery.getMaxClauseCount()) {
            BooleanQuery.setMaxClauseCount(booleanClauseLimit);
            this.log.info("Changed the Max boolean clause limit to {}", (Object)booleanClauseLimit);
        }
    }

    private void configureIndexDefinitionStorage(Map<String, ?> config) {
        boolean disableStorage = PropertiesUtil.toBoolean(config.get(PROP_DISABLE_STORED_INDEX_DEFINITION), false);
        if (disableStorage) {
            this.log.info("Feature to ensure that index definition matches the index state is disabled. Change in index definition would now affect query plans and might lead to inconsistent results.");
            IndexDefinition.setDisableStoredIndexDefinition((boolean)disableStorage);
        }
    }

    private void registerGCMonitor(Whiteboard whiteboard, final IndexTracker tracker) {
        GCMonitor.Empty gcMonitor = new GCMonitor.Empty(){

            @Override
            public void compacted() {
                tracker.refresh();
            }
        };
        this.oakRegs.add(whiteboard.register(GCMonitor.class, gcMonitor, Collections.emptyMap()));
    }

    private void registerIndexInfoProvider(BundleContext bundleContext) {
        LuceneIndexInfoProvider infoProvider = new LuceneIndexInfoProvider(this.nodeStore, this.asyncIndexInfoService, this.getIndexCheckDir());
        this.regs.add(bundleContext.registerService(IndexInfoProvider.class.getName(), (Object)infoProvider, null));
    }

    private void registerIndexImporterProvider(BundleContext bundleContext) {
        LuceneIndexImporter importer = new LuceneIndexImporter(this.blobStore);
        this.regs.add(bundleContext.registerService(IndexImporterProvider.class.getName(), (Object)importer, null));
    }

    private void initializeActiveBlobCollector(Whiteboard whiteboard, Map<String, ?> config) {
        boolean activeDeletionEnabled = PropertiesUtil.toBoolean(config.get(PROP_NAME_DELETED_BLOB_COLLECTION_DEFAULT_ENABLED), true);
        if (activeDeletionEnabled && this.blobStore != null) {
            File blobCollectorWorkingDir = new File(this.indexDir, "deleted-blobs");
            this.activeDeletedBlobCollector = ActiveDeletedBlobCollectorFactory.newInstance((File)blobCollectorWorkingDir, (ExecutorService)this.getExecutorService());
            ActiveDeletedBlobCollectorMBeanImpl bean = new ActiveDeletedBlobCollectorMBeanImpl(this.activeDeletedBlobCollector, whiteboard, this.nodeStore, this.indexPathService, this.asyncIndexInfoService, this.blobStore, this.getExecutorService());
            this.oakRegs.add(WhiteboardUtils.registerMBean(whiteboard, ActiveDeletedBlobCollectorMBean.class, bean, "ActiveDeletedBlobCollector", "Active lucene files collection"));
            this.log.info("Active blob collector initialized at working dir: {}", (Object)blobCollectorWorkingDir);
        } else {
            this.activeDeletedBlobCollector = ActiveDeletedBlobCollectorFactory.NOOP;
            this.log.info("Active blob collector set to NOOP. enabled: {} seconds; blobStore: {}", (Object)activeDeletionEnabled, (Object)this.blobStore);
        }
    }

    private void registerPropertyIndexCleaner(Map<String, ?> config, BundleContext bundleContext) {
        int cleanerInterval = PropertiesUtil.toInteger(config.get(PROP_INDEX_CLEANER_INTERVAL), 600);
        if (cleanerInterval <= 0) {
            this.log.info("Property index cleaner would not be registered");
            return;
        }
        this.cleaner = new PropertyIndexCleaner(this.nodeStore, this.indexPathService, this.asyncIndexInfoService, this.statisticsProvider);
        if (this.nodeStore instanceof Clusterable) {
            this.cleaner.setRecursiveDelete(true);
            this.log.info("PropertyIndexCleaner configured to perform recursive delete");
        }
        this.oakRegs.add(WhiteboardUtils.scheduleWithFixedDelay(this.whiteboard, (Runnable)this.cleaner, ImmutableMap.of("scheduler.name", PropertyIndexCleaner.class.getName()), (long)cleanerInterval, true, true));
        this.log.info("Property index cleaner configured to run every [{}] seconds", (Object)cleanerInterval);
    }

    private void registerLuceneFileSystemStats(LuceneIndexFileSystemStatistics luceneIndexFSStats, long delayInSeconds) {
        ImmutableMap<String, Object> config = ImmutableMap.of("scheduler.name", LuceneIndexFileSystemStatistics.class.getName());
        this.oakRegs.add(WhiteboardUtils.scheduleWithFixedDelay(this.whiteboard, (Runnable)luceneIndexFSStats, config, delayInSeconds, false, true));
        this.log.info("Lucene FileSystem Statistics calculator configured to run every [{}] seconds", (Object)delayInSeconds);
    }

    protected void bindNodeAggregator(QueryIndex.NodeAggregator aggregator) {
        this.nodeAggregator = aggregator;
        this.initialize();
    }

    protected void unbindNodeAggregator(QueryIndex.NodeAggregator aggregator) {
        this.nodeAggregator = null;
        this.initialize();
    }

    protected void bindExtractedTextProvider(PreExtractedTextProvider preExtractedTextProvider) {
        this.extractedTextProvider = preExtractedTextProvider;
        this.registerExtractedTextProvider(preExtractedTextProvider);
    }

    protected void unbindExtractedTextProvider(PreExtractedTextProvider preExtractedTextProvider) {
        this.extractedTextProvider = null;
        this.registerExtractedTextProvider(null);
    }

    protected void bindAugmentorFactory(IndexAugmentorFactory indexAugmentorFactory) {
        this.augmentorFactory = indexAugmentorFactory;
    }

    protected void unbindAugmentorFactory(IndexAugmentorFactory indexAugmentorFactory) {
        if (this.augmentorFactory == indexAugmentorFactory) {
            this.augmentorFactory = null;
        }
    }

    protected void bindStatisticsProvider(StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
    }

    protected void unbindStatisticsProvider(StatisticsProvider statisticsProvider) {
        if (this.statisticsProvider == statisticsProvider) {
            this.statisticsProvider = null;
        }
    }

    protected void bindMountInfoProvider(MountInfoProvider mountInfoProvider) {
        this.mountInfoProvider = mountInfoProvider;
    }

    protected void unbindMountInfoProvider(MountInfoProvider mountInfoProvider) {
        if (this.mountInfoProvider == mountInfoProvider) {
            this.mountInfoProvider = null;
        }
    }

    protected void bindNodeStore(NodeStore nodeStore) {
        this.nodeStore = nodeStore;
    }

    protected void unbindNodeStore(NodeStore nodeStore) {
        if (this.nodeStore == nodeStore) {
            this.nodeStore = null;
        }
    }

    protected void bindIndexPathService(IndexPathService indexPathService) {
        this.indexPathService = indexPathService;
    }

    protected void unbindIndexPathService(IndexPathService indexPathService) {
        if (this.indexPathService == indexPathService) {
            this.indexPathService = null;
        }
    }

    protected void bindAsyncIndexInfoService(AsyncIndexInfoService asyncIndexInfoService) {
        this.asyncIndexInfoService = asyncIndexInfoService;
    }

    protected void unbindAsyncIndexInfoService(AsyncIndexInfoService asyncIndexInfoService) {
        if (this.asyncIndexInfoService == asyncIndexInfoService) {
            this.asyncIndexInfoService = null;
        }
    }

    protected void bindBlobStore(GarbageCollectableBlobStore garbageCollectableBlobStore) {
        this.blobStore = garbageCollectableBlobStore;
    }

    protected void unbindBlobStore(GarbageCollectableBlobStore garbageCollectableBlobStore) {
        if (this.blobStore == garbageCollectableBlobStore) {
            this.blobStore = null;
        }
    }

    protected void bindCheckpointMBean(CheckpointMBean checkpointMBean) {
        this.checkpointMBean = checkpointMBean;
    }

    protected void unbindCheckpointMBean(CheckpointMBean checkpointMBean) {
        if (this.checkpointMBean == checkpointMBean) {
            this.checkpointMBean = null;
        }
    }
}

