/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype;

import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;

final class RootNodeDefinition
implements NodeDefinition {
    private static final String REP_ROOT = "rep:root";
    private final NodeTypeManager ntManager;

    RootNodeDefinition(NodeTypeManager ntManager) {
        this.ntManager = ntManager;
    }

    @Override
    public NodeType[] getRequiredPrimaryTypes() {
        try {
            return new NodeType[]{this.ntManager.getNodeType(REP_ROOT)};
        }
        catch (RepositoryException e) {
            return new NodeType[0];
        }
    }

    @Override
    public String[] getRequiredPrimaryTypeNames() {
        return new String[]{REP_ROOT};
    }

    @Override
    public NodeType getDefaultPrimaryType() {
        try {
            return this.ntManager.getNodeType(REP_ROOT);
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    @Override
    public String getDefaultPrimaryTypeName() {
        return REP_ROOT;
    }

    @Override
    public boolean allowsSameNameSiblings() {
        return false;
    }

    @Override
    public NodeType getDeclaringNodeType() {
        try {
            return this.ntManager.getNodeType(REP_ROOT);
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    @Override
    public String getName() {
        return REP_ROOT;
    }

    @Override
    public boolean isAutoCreated() {
        return true;
    }

    @Override
    public boolean isMandatory() {
        return true;
    }

    @Override
    public int getOnParentVersion() {
        return 2;
    }

    @Override
    public boolean isProtected() {
        return false;
    }
}

