/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation.filter;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.observation.filter.ChangeSetFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.GlobbingPathHelper;
import org.apache.jackrabbit.oak.spi.observation.ChangeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeSetFilterImpl
implements ChangeSetFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeSetFilterImpl.class);
    private static final int MAX_EXCLUDED_PATHS = 11;
    private static final int MAX_EXCLUDE_PATH_CUTOFF_LEVEL = 6;
    private final Set<String> rootIncludePaths = new HashSet<String>();
    private final Set<String> firstLevelIncludeNames;
    private final Set<Pattern> includePathPatterns = new HashSet<Pattern>();
    private final Set<Pattern> excludePathPatterns;
    private final Set<Pattern> unpreciseExcludePathPatterns;
    private final Set<String> parentNodeNames;
    private final Set<String> parentNodeTypes;
    private final Set<String> propertyNames;

    public String toString() {
        return "ChangeSetFilterImpl[rootIncludePaths=" + this.rootIncludePaths + ", includePathPatterns=" + this.includePathPatterns + ", excludePathPatterns=" + this.excludePathPatterns + ", parentNodeNames=" + this.parentNodeNames + ", parentNodeTypes=" + this.parentNodeTypes + ", propertyNames=" + this.propertyNames + "]";
    }

    public ChangeSetFilterImpl(@NotNull Set<String> includedParentPaths, boolean isDeep, @Nullable Set<String> additionalIncludedParentPaths, Set<String> excludedParentPaths, Set<String> parentNodeNames, Set<String> parentNodeTypes, Set<String> propertyNames) {
        this(includedParentPaths, isDeep, additionalIncludedParentPaths, excludedParentPaths, parentNodeNames, parentNodeTypes, propertyNames, 11);
    }

    public ChangeSetFilterImpl(@NotNull Set<String> includedParentPaths, boolean isDeep, @Nullable Set<String> additionalIncludedParentPaths, Set<String> excludedParentPaths, Set<String> parentNodeNames, Set<String> parentNodeTypes, Set<String> propertyNames, int maxExcludedPaths) {
        HashSet<String> firstLevelIncludePaths = new HashSet<String>();
        for (String aRawIncludePath : includedParentPaths) {
            String aGlobbingIncludePath = aRawIncludePath.contains("*") ? aRawIncludePath : (!isDeep ? aRawIncludePath : PathUtils.concat(aRawIncludePath, "**"));
            this.rootIncludePaths.add(aRawIncludePath);
            this.includePathPatterns.add(this.asPattern(aGlobbingIncludePath));
            if (firstLevelIncludePaths == null) continue;
            String firstLevelName = this.firstLevelName(aRawIncludePath);
            if (firstLevelName != null && !firstLevelName.contains("*")) {
                firstLevelIncludePaths.add(firstLevelName);
                continue;
            }
            firstLevelIncludePaths = null;
        }
        if (additionalIncludedParentPaths != null) {
            for (String path : additionalIncludedParentPaths) {
                this.rootIncludePaths.add(path);
                this.includePathPatterns.add(this.asPattern(path));
                if (firstLevelIncludePaths == null) continue;
                String firstLevelName = this.firstLevelName(path);
                if (firstLevelName != null && !firstLevelName.contains("*")) {
                    firstLevelIncludePaths.add(firstLevelName);
                    continue;
                }
                firstLevelIncludePaths = null;
            }
        }
        this.firstLevelIncludeNames = firstLevelIncludePaths;
        this.excludePathPatterns = new HashSet<Pattern>();
        this.unpreciseExcludePathPatterns = new HashSet<Pattern>();
        if (excludedParentPaths.size() < maxExcludedPaths) {
            for (String aRawExcludePath : excludedParentPaths) {
                this.excludePathPatterns.add(this.asPattern(PathUtils.concat(aRawExcludePath, "**")));
            }
        } else {
            Set<String> unprecisePaths = this.unprecisePaths(excludedParentPaths, maxExcludedPaths, 6);
            for (String anUnprecisePath : unprecisePaths) {
                this.unpreciseExcludePathPatterns.add(this.asPattern(PathUtils.concat(anUnprecisePath, "**")));
            }
        }
        this.propertyNames = propertyNames == null ? null : new HashSet<String>(propertyNames);
        this.parentNodeTypes = parentNodeTypes == null ? null : new HashSet<String>(parentNodeTypes);
        this.parentNodeNames = parentNodeNames == null ? null : new HashSet<String>(parentNodeNames);
    }

    private String firstLevelName(String path) {
        if (path.isEmpty() || path.equals("/")) {
            return null;
        }
        int secondSlash = path.indexOf("/", 1);
        if (secondSlash != -1) {
            return path.substring(1, secondSlash);
        }
        return path.substring(1);
    }

    private Set<String> unprecisePaths(Set<String> paths, int maxExcludedPaths, int maxExcludePathCutOffLevel) {
        for (int level = maxExcludePathCutOffLevel; level > 1; --level) {
            Set<String> unprecise = this.unprecisePaths(paths, level);
            if (unprecise.size() >= maxExcludedPaths) continue;
            return unprecise;
        }
        HashSet<String> result = new HashSet<String>();
        result.add("/");
        return result;
    }

    private Set<String> unprecisePaths(Set<String> paths, int level) {
        HashSet<String> result = new HashSet<String>();
        Iterator<String> iterator = paths.iterator();
        while (iterator.hasNext()) {
            String path;
            String unprecise = path = iterator.next();
            while (PathUtils.getDepth(unprecise) > level) {
                unprecise = PathUtils.getParentPath(unprecise);
            }
            result.add(unprecise);
        }
        return result;
    }

    public Set<String> getRootIncludePaths() {
        return this.rootIncludePaths;
    }

    private Pattern asPattern(String patternWithGlobs) {
        return Pattern.compile(GlobbingPathHelper.globPathAsRegex(patternWithGlobs));
    }

    @Override
    public boolean excludes(ChangeSet changeSet) {
        try {
            return this.doExcludes(changeSet);
        }
        catch (Exception e) {
            LOG.warn("excludes: got an Exception while evaluating excludes: " + e.getMessage() + ", changeSet=" + changeSet, e);
            return false;
        }
    }

    private boolean doExcludes(ChangeSet changeSet) {
        if (changeSet.anyOverflow()) {
            return false;
        }
        if (changeSet.doesHitMaxPathDepth()) {
            if (this.firstLevelIncludeNames == null) {
                return false;
            }
            for (String parentPath : changeSet.getParentPaths()) {
                String firstLevelName = this.firstLevelName(parentPath);
                if (firstLevelName == null || !this.firstLevelIncludeNames.contains(firstLevelName)) continue;
                return false;
            }
            return true;
        }
        HashSet<String> parentPaths = new HashSet<String>(changeSet.getParentPaths());
        boolean unpreciseExclude = false;
        if (this.unpreciseExcludePathPatterns.size() != 0) {
            for (String aParentPath : parentPaths) {
                if (!ChangeSetFilterImpl.patternsMatch(this.unpreciseExcludePathPatterns, aParentPath)) continue;
                unpreciseExclude = true;
                break;
            }
        }
        if (this.excludePathPatterns.size() != 0) {
            Iterator it = parentPaths.iterator();
            while (it.hasNext()) {
                String aParentPath;
                aParentPath = (String)it.next();
                if (!ChangeSetFilterImpl.patternsMatch(this.excludePathPatterns, aParentPath)) continue;
                it.remove();
            }
        }
        boolean included = false;
        for (String aPath : parentPaths) {
            String firstLevelName;
            if (this.rootIncludePaths.contains(aPath)) {
                included = true;
                break;
            }
            if (this.firstLevelIncludeNames != null && (firstLevelName = this.firstLevelName(aPath)) != null && !this.firstLevelIncludeNames.contains(firstLevelName) || !ChangeSetFilterImpl.patternsMatch(this.includePathPatterns, aPath)) continue;
            included = true;
            break;
        }
        if (!included) {
            return true;
        }
        if (unpreciseExclude) {
            return false;
        }
        if (this.propertyNames != null && this.propertyNames.size() != 0 && Collections.disjoint(changeSet.getPropertyNames(), this.propertyNames)) {
            return true;
        }
        if (this.parentNodeTypes != null && this.parentNodeTypes.size() != 0 && Collections.disjoint(changeSet.getParentNodeTypes(), this.parentNodeTypes)) {
            return true;
        }
        return this.parentNodeNames != null && this.parentNodeNames.size() != 0 && Collections.disjoint(changeSet.getParentNodeNames(), this.parentNodeNames);
    }

    private static boolean patternsMatch(Set<Pattern> pathPatterns, String path) {
        if (path == null) {
            return false;
        }
        for (Pattern pathPattern : pathPatterns) {
            if (!pathPattern.matcher(path).matches()) continue;
            return true;
        }
        return false;
    }
}

