/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation.filter;

import com.google.common.base.Preconditions;
import java.util.function.Predicate;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.core.GuavaDeprecation;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

public class UuidPredicate
implements Predicate<NodeState>,
com.google.common.base.Predicate<NodeState> {
    private final String[] uuids;

    public UuidPredicate(@NotNull String[] uuids) {
        this.uuids = Preconditions.checkNotNull(uuids);
    }

    @Override
    public boolean test(NodeState node) {
        if (this.uuids.length == 0) {
            return false;
        }
        PropertyState uuidProperty = node.getProperty("jcr:uuid");
        if (uuidProperty == null) {
            return false;
        }
        String parentUuid = uuidProperty.getValue(Type.STRING);
        for (String uuid : this.uuids) {
            if (!parentUuid.equals(uuid)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean apply(NodeState node) {
        GuavaDeprecation.handleCall((String)"OAK-8874");
        return this.test(node);
    }
}

