/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.facet;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Value;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetResult {
    private final Map<String, List<Facet>> perDimFacets = new HashMap<String, List<Facet>>();

    public FacetResult(QueryResult queryResult) {
        try {
            RowIterator rows = queryResult.getRows();
            if (rows.hasNext()) {
                Row row = rows.nextRow();
                this.parseJson(queryResult.getColumnNames(), (String columnName) -> {
                    Value value = row.getValue(columnName);
                    return value == null ? null : value.getString();
                });
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public FacetResult(String[] columnNames, FacetResultRow ... rows) {
        try {
            for (FacetResultRow row : rows) {
                this.parseJson(columnNames, row);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> asColumnToFacetJsonMap() {
        HashMap<String, String> json = Maps.newHashMap();
        for (Map.Entry<String, List<Facet>> entry : this.perDimFacets.entrySet()) {
            JsopBuilder builder = new JsopBuilder();
            builder.object();
            for (Facet f : entry.getValue()) {
                builder.key(f.getLabel());
                builder.value(f.getCount());
            }
            builder.endObject();
            json.put("rep:facet(" + entry.getKey() + ")", builder.toString());
        }
        return json;
    }

    private void parseJson(String[] columnNames, FacetResultRow row) throws Exception {
        for (String column : columnNames) {
            if (!column.startsWith("rep:facet")) continue;
            String dimension = column.substring("rep:facet".length() + 1, column.length() - 1);
            String value = row.getValue(column);
            if (value == null) continue;
            String jsonFacetString = value;
            this.parseJson(dimension, jsonFacetString);
        }
    }

    private void parseJson(String dimension, String jsonFacetString) {
        int c;
        JsopTokenizer jsopTokenizer = new JsopTokenizer(jsonFacetString);
        List<Facet> facets = this.perDimFacets.get(dimension);
        LinkedHashMap<String, Facet> facetsMap = Maps.newLinkedHashMap();
        if (facets != null) {
            for (Facet facet : facets) {
                if (facetsMap.containsKey(facet.getLabel())) continue;
                facetsMap.put(facet.getLabel(), facet);
            }
        }
        String label = null;
        while ((c = jsopTokenizer.read()) != 0) {
            if (1 == c) {
                label = jsopTokenizer.getEscapedToken();
                continue;
            }
            if (2 != c) continue;
            int count = Integer.parseInt(jsopTokenizer.getEscapedToken());
            if (label != null) {
                if (facetsMap.containsKey(label)) {
                    count += ((Facet)facetsMap.get(label)).getCount();
                }
                facetsMap.put(label, new Facet(label, count));
            }
            label = null;
        }
        facets = Lists.newArrayList(facetsMap.values());
        Collections.sort(facets, Collections.reverseOrder(Comparator.comparingInt(Facet::getCount)));
        this.perDimFacets.put(dimension, facets);
    }

    @NotNull
    public Set<String> getDimensions() {
        return this.perDimFacets.keySet();
    }

    @Nullable
    public List<Facet> getFacets(@NotNull String dimension) {
        return this.perDimFacets.get(dimension);
    }

    public static interface FacetResultRow {
        public String getValue(String var1) throws Exception;
    }

    public static class Facet {
        private final String label;
        private final int count;

        Facet(String label, int count) {
            this.label = label;
            this.count = count;
        }

        @NotNull
        public String getLabel() {
            return this.label;
        }

        public int getCount() {
            return this.count;
        }
    }
}

