/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.wrappers.SlingRequestPaths;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostOperation;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class AbstractPostOperation
implements PostOperation {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(SlingHttpServletRequest request, PostResponse response, SlingPostProcessor[] processors) {
        Session session = request.getResourceResolver().adaptTo(Session.class);
        VersioningConfiguration versionableConfiguration = this.getVersioningConfiguration(request);
        try {
            String path = this.getItemPath(request);
            path = this.removeAndValidateWorkspace(path, session);
            response.setPath(path);
            response.setLocation(this.externalizePath(request, path));
            path = ResourceUtil.getParent(path);
            if (path != null) {
                response.setParentLocation(this.externalizePath(request, path));
            }
            ArrayList<Modification> changes = new ArrayList<Modification>();
            this.doRun(request, response, changes);
            if (processors != null) {
                for (SlingPostProcessor slingPostProcessor : processors) {
                    slingPostProcessor.process(request, changes);
                }
            }
            HashMap<String, String> modificationSourcesContainingPostfix = new HashMap<String, String>();
            HashSet<String> allModificationSources = new HashSet<String>(changes.size());
            for (Modification modification : changes) {
                String source = modification.getSource();
                if (source == null) continue;
                allModificationSources.add(source);
                int atIndex = source.indexOf(64);
                if (atIndex <= 0) continue;
                modificationSourcesContainingPostfix.put(source.substring(0, atIndex), source);
            }
            if (modificationSourcesContainingPostfix.size() > 0) {
                for (Map.Entry entry : modificationSourcesContainingPostfix.entrySet()) {
                    if (!allModificationSources.contains(entry.getKey())) continue;
                    response.setStatus(500, "Postfix-containing path " + (String)entry.getValue() + " contained in the modification list. Check configuration.");
                    return;
                }
            }
            LinkedHashSet<String> nodesToCheckin = new LinkedHashSet<String>();
            for (Modification change : changes) {
                switch (change.getType()) {
                    case MODIFY: {
                        response.onModified(change.getSource());
                        break;
                    }
                    case DELETE: {
                        response.onDeleted(change.getSource());
                        break;
                    }
                    case MOVE: {
                        response.onMoved(change.getSource(), change.getDestination());
                        break;
                    }
                    case COPY: {
                        response.onCopied(change.getSource(), change.getDestination());
                        break;
                    }
                    case CREATE: {
                        response.onCreated(change.getSource());
                        if (!versionableConfiguration.isCheckinOnNewVersionableNode()) break;
                        nodesToCheckin.add(change.getSource());
                        break;
                    }
                    case ORDER: {
                        response.onChange("ordered", change.getSource(), change.getDestination());
                        break;
                    }
                    case CHECKOUT: {
                        response.onChange("checkout", change.getSource());
                        nodesToCheckin.add(change.getSource());
                        break;
                    }
                    case CHECKIN: {
                        response.onChange("checkin", change.getSource());
                        nodesToCheckin.remove(change.getSource());
                    }
                }
            }
            if (this.isSessionSaveRequired(session, request)) {
                request.getResourceResolver().commit();
            }
            if (!this.isSkipCheckin(request)) {
                for (String checkinPath : nodesToCheckin) {
                    if (!this.checkin(request.getResourceResolver(), checkinPath)) continue;
                    response.onChange("checkin", checkinPath);
                }
            }
        }
        catch (Exception e) {
            this.log.error("Exception during response processing.", e);
            response.setError(e);
        }
        finally {
            try {
                if (this.isSessionSaveRequired(session, request)) {
                    request.getResourceResolver().revert();
                }
            }
            catch (RepositoryException e) {
                this.log.warn("RepositoryException in finally block: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    protected abstract void doRun(SlingHttpServletRequest var1, PostResponse var2, List<Modification> var3) throws RepositoryException;

    protected VersioningConfiguration getVersioningConfiguration(SlingHttpServletRequest request) {
        VersioningConfiguration versionableConfiguration = (VersioningConfiguration)request.getAttribute(VersioningConfiguration.class.getName());
        return versionableConfiguration != null ? versionableConfiguration : new VersioningConfiguration();
    }

    protected boolean isSkipCheckin(SlingHttpServletRequest request) {
        return !this.getVersioningConfiguration(request).isAutoCheckin();
    }

    protected boolean isSkipSessionHandling(SlingHttpServletRequest request) {
        return Boolean.parseBoolean((String)request.getAttribute("skip-session-handling"));
    }

    protected boolean isSessionSaveRequired(Session session, SlingHttpServletRequest request) throws RepositoryException {
        return !this.isSkipSessionHandling(request) && request.getResourceResolver().hasChanges();
    }

    protected String removeAndValidateWorkspace(String path, Session session) throws RepositoryException {
        int wsSepPos = path.indexOf(":/");
        if (wsSepPos != -1) {
            String workspaceName = path.substring(0, wsSepPos);
            if (!workspaceName.equals(session.getWorkspace().getName())) {
                throw new RepositoryException("Incorrect workspace. Expecting " + workspaceName + ". Received " + session.getWorkspace().getName());
            }
            return path.substring(wsSepPos + 1);
        }
        return path;
    }

    protected String getItemPath(SlingHttpServletRequest request) {
        return request.getResource().getPath();
    }

    protected Iterator<Resource> getApplyToResources(SlingHttpServletRequest request) {
        String[] applyTo = request.getParameterValues(":applyTo");
        if (applyTo == null) {
            return null;
        }
        return new ApplyToIterator(request, applyTo);
    }

    protected final String externalizePath(SlingHttpServletRequest request, String path) {
        StringBuilder ret = new StringBuilder();
        ret.append(SlingRequestPaths.getContextPath(request));
        ret.append(request.getResourceResolver().map(path));
        String ext = request.getParameter(":displayExtension");
        if (ext != null && ext.length() > 0) {
            if (ext.charAt(0) != '.') {
                ret.append('.');
            }
            ret.append(ext);
        }
        return ret.toString();
    }

    protected final String resolvePath(String absPath, String relPath) {
        if (relPath.startsWith("/")) {
            return relPath;
        }
        return absPath + "/" + relPath;
    }

    protected final boolean requireItemPathPrefix(SlingHttpServletRequest request) {
        boolean requirePrefix = false;
        Enumeration<String> names = request.getParameterNames();
        while (names.hasMoreElements() && !requirePrefix) {
            String name = names.nextElement();
            requirePrefix = name.startsWith("./");
        }
        return requirePrefix;
    }

    protected boolean hasItemPathPrefix(String name) {
        return name.startsWith("/") || name.startsWith("./") || name.startsWith("../");
    }

    protected void orderNode(SlingHttpServletRequest request, Item item, List<Modification> changes) throws RepositoryException {
        String command = request.getParameter(":order");
        if (command == null || command.length() == 0) {
            return;
        }
        if (!item.isNode()) {
            return;
        }
        Node parent = item.getParent();
        String next = null;
        if (command.equals("first")) {
            next = parent.getNodes().nextNode().getName();
        } else if (command.equals("last")) {
            next = "";
        } else if (command.startsWith("before ")) {
            next = command.substring("before ".length());
        } else if (command.startsWith("after ")) {
            String name = command.substring("after ".length());
            NodeIterator iter = parent.getNodes();
            while (iter.hasNext()) {
                Node n = iter.nextNode();
                if (!n.getName().equals(name)) continue;
                if (iter.hasNext()) {
                    next = iter.nextNode().getName();
                    continue;
                }
                next = "";
            }
        } else {
            try {
                next = "";
                NodeIterator iter = parent.getNodes();
                for (int newPos = Integer.parseInt(command); iter.hasNext() && newPos >= 0; --newPos) {
                    Node n = iter.nextNode();
                    if (n.getName().equals(item.getName())) {
                        ++newPos;
                    }
                    if (newPos != 0) continue;
                    next = n.getName();
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("provided node ordering command is invalid: " + command);
            }
        }
        if (next != null) {
            if (next.equals("")) {
                next = null;
            }
            parent.orderBefore(item.getName(), next);
            changes.add(Modification.onOrder(item.getPath(), next));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Node {} moved '{}'", (Object)item.getPath(), (Object)command);
            }
        } else {
            throw new IllegalArgumentException("provided node ordering command is invalid: " + command);
        }
    }

    protected Node findVersionableAncestor(Node node) throws RepositoryException {
        if (this.isVersionable(node)) {
            return node;
        }
        try {
            node = node.getParent();
            return this.findVersionableAncestor(node);
        }
        catch (ItemNotFoundException e) {
            return null;
        }
    }

    protected boolean isVersionable(Node node) throws RepositoryException {
        return node.isNodeType("mix:versionable");
    }

    protected void checkoutIfNecessary(Node node, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws RepositoryException {
        Node versionableNode;
        if (versioningConfiguration.isAutoCheckout() && (versionableNode = this.findVersionableAncestor(node)) != null && !versionableNode.isCheckedOut()) {
            versionableNode.checkout();
            changes.add(Modification.onCheckout(versionableNode.getPath()));
        }
    }

    private boolean checkin(ResourceResolver resolver, String path) throws RepositoryException {
        Node node;
        Resource rsrc = resolver.getResource(path);
        Node node2 = node = rsrc == null ? null : rsrc.adaptTo(Node.class);
        if (node != null && node.isCheckedOut() && this.isVersionable(node)) {
            node.checkin();
            return true;
        }
        return false;
    }

    private static class ApplyToIterator
    implements Iterator<Resource> {
        private final ResourceResolver resolver;
        private final Resource baseResource;
        private final String[] paths;
        private int pathIndex;
        private Resource nextResource;
        private Iterator<Resource> resourceIterator = null;

        ApplyToIterator(SlingHttpServletRequest request, String[] paths) {
            this.resolver = request.getResourceResolver();
            this.baseResource = request.getResource();
            this.paths = paths;
            this.pathIndex = 0;
            this.nextResource = this.seek();
        }

        @Override
        public boolean hasNext() {
            return this.nextResource != null;
        }

        @Override
        public Resource next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Resource result = this.nextResource;
            this.nextResource = this.seek();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Resource seek() {
            if (this.resourceIterator != null) {
                if (this.resourceIterator.hasNext()) {
                    Resource res = this.resourceIterator.next();
                    return res;
                }
                this.resourceIterator = null;
            }
            while (this.pathIndex < this.paths.length) {
                Resource res;
                String path = this.paths[this.pathIndex];
                ++this.pathIndex;
                if (path.endsWith("*")) {
                    if (path.length() == 1) {
                        this.resourceIterator = this.baseResource.listChildren();
                    } else if (path.endsWith("/*")) {
                        if ((path = path.substring(0, path.length() - 2)).length() == 0) {
                            this.resourceIterator = this.baseResource.listChildren();
                        } else {
                            res = this.resolver.getResource(this.baseResource, path);
                            if (res != null) {
                                this.resourceIterator = res.listChildren();
                            }
                        }
                    }
                    if (this.resourceIterator == null) continue;
                    if (this.resourceIterator.hasNext()) {
                        res = this.resourceIterator.next();
                        return res;
                    }
                    this.resourceIterator = null;
                    continue;
                }
                res = this.resolver.getResource(this.baseResource, path);
                if (res == null) continue;
                return res;
            }
            return null;
        }
    }
}

