/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.functions;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.jsp.JspTagException;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.util.EscapeXML;

public class Functions {
    public static String toUpperCase(String input) {
        return input.toUpperCase();
    }

    public static String toLowerCase(String input) {
        return input.toLowerCase();
    }

    public static int indexOf(String input, String substring) {
        return input.indexOf(substring);
    }

    public static boolean contains(String input, String substring) {
        return input.contains(substring);
    }

    public static boolean containsIgnoreCase(String input, String substring) {
        return Functions.contains(input.toUpperCase(), substring.toUpperCase());
    }

    public static boolean startsWith(String input, String prefix) {
        return input.startsWith(prefix);
    }

    public static boolean endsWith(String input, String suffix) {
        return input.endsWith(suffix);
    }

    public static String substring(String input, int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (endIndex < 0 || endIndex > input.length()) {
            endIndex = input.length();
        }
        if (endIndex < beginIndex) {
            return "";
        }
        return input.substring(beginIndex, endIndex);
    }

    public static String substringAfter(String input, String substring) {
        int index = input.indexOf(substring);
        if (index == -1) {
            return "";
        }
        return input.substring(index + substring.length());
    }

    public static String substringBefore(String input, String substring) {
        int index = input.indexOf(substring);
        if (index == -1) {
            return "";
        }
        return input.substring(0, index);
    }

    public static String escapeXml(String input) {
        return EscapeXML.escape((String)input);
    }

    public static String trim(String input) {
        return input.trim();
    }

    public static String replace(String input, String before, String after) {
        if (before.length() == 0) {
            return input;
        }
        return input.replace(before, after);
    }

    public static String[] split(String input, String delimiters) {
        if (input.length() == 0 || delimiters.length() == 0) {
            return new String[]{input};
        }
        StringTokenizer tok = new StringTokenizer(input, delimiters);
        String[] array = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            array[i++] = tok.nextToken();
        }
        return array;
    }

    public static String join(String[] array, String separator) {
        if (array == null || array.length == 0) {
            return "";
        }
        if (array.length == 1) {
            return array[0] == null ? "null" : array[0];
        }
        StringBuilder buf = new StringBuilder();
        buf.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            buf.append(separator).append(array[i]);
        }
        return buf.toString();
    }

    public static int length(Object obj) throws JspTagException {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return ((String)obj).length();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        if (obj instanceof Iterator) {
            int count = 0;
            Iterator iter = (Iterator)obj;
            while (iter.hasNext()) {
                ++count;
                iter.next();
            }
            return count;
        }
        if (obj instanceof Enumeration) {
            Enumeration enum_ = (Enumeration)obj;
            int count = 0;
            while (enum_.hasMoreElements()) {
                ++count;
                enum_.nextElement();
            }
            return count;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj);
        }
        throw new JspTagException(Resources.getMessage("PARAM_BAD_VALUE"));
    }
}

