/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.captioning.tf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.tika.config.Field;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.IOUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.captioning.CaptionObject;
import org.apache.tika.parser.recognition.ObjectRecogniser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TensorflowRESTCaptioner
implements ObjectRecogniser {
    private static final Logger LOG = LoggerFactory.getLogger(TensorflowRESTCaptioner.class);
    private static final Set<MediaType> SUPPORTED_MIMES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.image("jpeg"), MediaType.image("png"), MediaType.image("gif"))));
    private static final String LABEL_LANG = "eng";
    @Field
    private URI apiBaseUri = URI.create("http://localhost:8764/inception/v3");
    @Field
    private int captions = 5;
    @Field
    private int maxCaptionLength = 15;
    private URI apiUri;
    private URI healthUri;
    private boolean available;

    protected URI getApiUri(Metadata metadata) {
        return this.apiUri;
    }

    @Override
    public Set<MediaType> getSupportedMimes() {
        return SUPPORTED_MIMES;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public void initialize(Map<String, Param> params) throws TikaConfigException {
        try {
            this.healthUri = URI.create(this.apiBaseUri + "/ping");
            this.apiUri = URI.create(this.apiBaseUri + String.format(Locale.getDefault(), "/caption/image?beam_size=%1$d&max_caption_length=%2$d", this.captions, this.maxCaptionLength));
            DefaultHttpClient client = new DefaultHttpClient();
            CloseableHttpResponse response = client.execute(new HttpGet(this.healthUri));
            this.available = response.getStatusLine().getStatusCode() == 200;
            LOG.info("Available = {}, API Status = {}", (Object)this.available, (Object)response.getStatusLine());
            LOG.info("Captions = {}, MaxCaptionLength = {}", (Object)this.captions, (Object)this.maxCaptionLength);
        }
        catch (Exception e) {
            this.available = false;
            throw new TikaConfigException(e.getMessage(), e);
        }
    }

    @Override
    public void checkInitialization(InitializableProblemHandler handler) throws TikaConfigException {
    }

    public List<CaptionObject> recognise(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        ArrayList<CaptionObject> capObjs = new ArrayList<CaptionObject>();
        try {
            DefaultHttpClient client = new DefaultHttpClient();
            HttpPost request = new HttpPost(this.getApiUri(metadata));
            try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();){
                IOUtils.copy(stream, (OutputStream)byteStream);
                request.setEntity(new ByteArrayEntity(byteStream.toByteArray()));
            }
            CloseableHttpResponse response = client.execute(request);
            try (InputStream reply = response.getEntity().getContent();){
                String replyMessage = IOUtils.toString(reply);
                if (response.getStatusLine().getStatusCode() == 200) {
                    JSONObject jReply = (JSONObject)new JSONParser().parse(replyMessage);
                    JSONArray jCaptions = (JSONArray)jReply.get((Object)"captions");
                    for (int i = 0; i < jCaptions.size(); ++i) {
                        JSONObject jCaption = (JSONObject)jCaptions.get(i);
                        String sentence = (String)jCaption.get((Object)"sentence");
                        Double confidence = (Double)jCaption.get((Object)"confidence");
                        capObjs.add(new CaptionObject(sentence, LABEL_LANG, confidence));
                    }
                } else {
                    LOG.warn("Status = {}", (Object)response.getStatusLine());
                    LOG.warn("Response = {}", (Object)replyMessage);
                }
            }
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
        }
        return capObjs;
    }
}

