/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import org.apache.pdfbox.util.Matrix;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pdf.AbstractPDF2XHTML;
import org.apache.tika.parser.pdf.ImageGraphicsEngine;
import org.apache.tika.parser.pdf.PDFParserConfig;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

class PDF2XHTML
extends AbstractPDF2XHTML {
    private Map<COSStream, Integer> processedInlineImages = new HashMap<COSStream, Integer>();
    private AtomicInteger inlineImageCounter = new AtomicInteger(0);

    PDF2XHTML(PDDocument document, ContentHandler handler, ParseContext context, Metadata metadata, PDFParserConfig config) throws IOException {
        super(document, handler, context, metadata, config);
    }

    public static void process(PDDocument document, ContentHandler handler, ParseContext context, Metadata metadata, PDFParserConfig config) throws SAXException, TikaException {
        PDF2XHTML pdf2XHTML = null;
        try {
            pdf2XHTML = config.getDetectAngles() ? new AngleDetectingPDF2XHTML(document, handler, context, metadata, config) : new PDF2XHTML(document, handler, context, metadata, config);
            config.configure(pdf2XHTML);
            pdf2XHTML.writeText(document, new Writer(){

                @Override
                public void write(char[] cbuf, int off, int len) {
                }

                @Override
                public void flush() {
                }

                @Override
                public void close() {
                }
            });
        }
        catch (IOException e) {
            if (e.getCause() instanceof SAXException) {
                throw (SAXException)e.getCause();
            }
            throw new TikaException("Unable to extract PDF content", e);
        }
        if (pdf2XHTML.exceptions.size() > 0) {
            throw new TikaException("Unable to extract PDF content", (Throwable)pdf2XHTML.exceptions.get(0));
        }
    }

    public void processPage(PDPage page) throws IOException {
        try {
            super.processPage(page);
        }
        catch (IOException e) {
            this.handleCatchableIOE(e);
            this.endPage(page);
        }
    }

    @Override
    protected void endPage(PDPage page) throws IOException {
        try {
            this.writeParagraphEnd();
            try {
                this.extractImages(page);
            }
            catch (IOException e) {
                this.handleCatchableIOE(e);
            }
            super.endPage(page);
        }
        catch (SAXException e) {
            throw new IOException("Unable to end a page", e);
        }
        catch (IOException e) {
            this.handleCatchableIOE(e);
        }
    }

    void extractImages(PDPage page) throws SAXException, IOException {
        if (!this.config.getExtractInlineImages()) {
            return;
        }
        ImageGraphicsEngine engine = new ImageGraphicsEngine(page, this.embeddedDocumentExtractor, this.config, this.processedInlineImages, this.inlineImageCounter, this.xhtml, this.metadata, this.context);
        engine.run();
        List<IOException> engineExceptions = engine.getExceptions();
        if (engineExceptions.size() > 0) {
            IOException first = engineExceptions.remove(0);
            if (this.config.getCatchIntermediateIOExceptions()) {
                this.exceptions.addAll(engineExceptions);
            }
            throw first;
        }
    }

    protected void writeParagraphStart() throws IOException {
        super.writeParagraphStart();
        try {
            this.xhtml.startElement("p");
        }
        catch (SAXException e) {
            throw new IOException("Unable to start a paragraph", e);
        }
    }

    protected void writeParagraphEnd() throws IOException {
        super.writeParagraphEnd();
        try {
            this.xhtml.endElement("p");
        }
        catch (SAXException e) {
            throw new IOException("Unable to end a paragraph", e);
        }
    }

    protected void writeString(String text) throws IOException {
        try {
            this.xhtml.characters(text);
        }
        catch (SAXException e) {
            throw new IOException("Unable to write a string: " + text, e);
        }
    }

    protected void writeCharacters(TextPosition text) throws IOException {
        try {
            this.xhtml.characters(text.getUnicode());
        }
        catch (SAXException e) {
            throw new IOException("Unable to write a character: " + text.getUnicode(), e);
        }
    }

    protected void writeWordSeparator() throws IOException {
        try {
            this.xhtml.characters(this.getWordSeparator());
        }
        catch (SAXException e) {
            throw new IOException("Unable to write a space character", e);
        }
    }

    protected void writeLineSeparator() throws IOException {
        try {
            this.xhtml.newline();
        }
        catch (SAXException e) {
            throw new IOException("Unable to write a newline character", e);
        }
    }

    private static class AngleDetectingPDF2XHTML
    extends PDF2XHTML {
        private AngleDetectingPDF2XHTML(PDDocument document, ContentHandler handler, ParseContext context, Metadata metadata, PDFParserConfig config) throws IOException {
            super(document, handler, context, metadata, config);
        }

        @Override
        protected void startPage(PDPage page) throws IOException {
        }

        @Override
        protected void endPage(PDPage page) throws IOException {
        }

        @Override
        public void processPage(PDPage page) throws IOException {
            try {
                super.startPage(page);
                this.detectAnglesAndProcessPage(page);
            }
            catch (IOException e) {
                this.handleCatchableIOE(e);
            }
            finally {
                super.endPage(page);
            }
        }

        private void detectAnglesAndProcessPage(PDPage page) throws IOException {
            AngleCollector angleCollector = new AngleCollector();
            angleCollector.setStartPage(this.getCurrentPageNo());
            angleCollector.setEndPage(this.getCurrentPageNo());
            angleCollector.getText(this.document);
            int rotation = page.getRotation();
            page.setRotation(0);
            for (Integer angle : angleCollector.getAngles()) {
                if (angle == 0) {
                    try {
                        super.processPage(page);
                    }
                    catch (IOException e) {
                        this.handleCatchableIOE(e);
                    }
                    continue;
                }
                try (PDPageContentStream cs = new PDPageContentStream(this.document, page, PDPageContentStream.AppendMode.PREPEND, false);){
                    cs.transform(Matrix.getRotateInstance((double)(-Math.toRadians(angle.intValue())), (float)0.0f, (float)0.0f));
                }
                try {
                    super.processPage(page);
                }
                catch (IOException e) {
                    this.handleCatchableIOE(e);
                }
                COSArray contents = (COSArray)page.getCOSObject().getItem(COSName.CONTENTS);
                contents.remove(0);
            }
            page.setRotation(rotation);
        }

        protected void processTextPosition(TextPosition text) {
            Matrix m = text.getTextMatrix();
            m.concatenate(text.getFont().getFontMatrix());
            int angle = (int)Math.round(Math.toDegrees(Math.atan2(m.getShearY(), m.getScaleY())));
            if (angle == 0) {
                super.processTextPosition(text);
            }
        }
    }

    class AngleCollector
    extends PDFTextStripper {
        Set<Integer> angles = new HashSet<Integer>();

        public Set<Integer> getAngles() {
            return this.angles;
        }

        AngleCollector() throws IOException {
        }

        protected void processTextPosition(TextPosition text) {
            Matrix m = text.getTextMatrix();
            m.concatenate(text.getFont().getFontMatrix());
            int angle = (int)Math.round(Math.toDegrees(Math.atan2(m.getShearY(), m.getScaleY())));
            angle = (angle + 360) % 360;
            this.angles.add(angle);
        }
    }
}

