/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.apache.jempbox.xmp.XMPMetadata;
import org.apache.jempbox.xmp.XMPSchema;
import org.apache.jempbox.xmp.XMPSchemaDublinCore;
import org.apache.jempbox.xmp.pdfa.XMPSchemaPDFAId;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.poi.util.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.PDF;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.image.xmp.JempboxExtractor;
import org.apache.tika.parser.pdf.PDFEncodedStringDecoder;
import org.apache.tika.utils.XMLReaderUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

class PDMetadataExtractor {
    private static final MediaType MEDIA_TYPE = MediaType.application("pdf");

    PDMetadataExtractor() {
    }

    static void extract(PDMetadata pdMetadata, Metadata metadata, ParseContext context) {
        if (pdMetadata == null) {
            metadata.set(PDF.HAS_XMP, "false");
            return;
        }
        metadata.set(PDF.HAS_XMP, "true");
        Document dom = PDMetadataExtractor.loadDOM(pdMetadata, metadata, context);
        XMPMetadata xmp = null;
        if (dom != null) {
            xmp = new XMPMetadata(dom);
        }
        XMPSchemaDublinCore dcSchema = null;
        if (xmp != null) {
            try {
                dcSchema = xmp.getDublinCoreSchema();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            JempboxExtractor.extractXMPMM(xmp, metadata);
        }
        PDMetadataExtractor.extractMultilingualItems(metadata, TikaCoreProperties.DESCRIPTION, null, (XMPSchema)dcSchema);
        PDMetadataExtractor.extractDublinCoreListItems(metadata, TikaCoreProperties.CONTRIBUTOR, dcSchema);
        PDMetadataExtractor.extractDublinCoreListItems(metadata, TikaCoreProperties.CREATOR, dcSchema);
        PDMetadataExtractor.extractMultilingualItems(metadata, TikaCoreProperties.TITLE, null, (XMPSchema)dcSchema);
        try {
            if (xmp != null) {
                xmp.addXMLNSMapping("http://www.aiim.org/pdfa/ns/id/", XMPSchemaPDFAId.class);
                XMPSchemaPDFAId pdfaxmp = (XMPSchemaPDFAId)xmp.getSchemaByClass(XMPSchemaPDFAId.class);
                if (pdfaxmp != null) {
                    if (pdfaxmp.getPart() != null) {
                        metadata.set(PDF.PDFAID_PART, Integer.toString(pdfaxmp.getPart()));
                    }
                    if (pdfaxmp.getConformance() != null) {
                        metadata.set(PDF.PDFAID_CONFORMANCE, pdfaxmp.getConformance());
                        String version = "A-" + pdfaxmp.getPart() + pdfaxmp.getConformance().toLowerCase(Locale.ROOT);
                        metadata.set(PDF.PDFA_VERSION, version);
                        metadata.add(TikaCoreProperties.FORMAT.getName(), MEDIA_TYPE.toString() + "; version=\"" + version + "\"");
                    }
                }
            }
        }
        catch (IOException e) {
            metadata.set("X-TIKA:pdf:metadata-xmp-parse-failed", "" + e);
        }
    }

    static List<String> getXMPBagOrSeqList(XMPSchema schema, String name) {
        List ret = schema.getBagList(name);
        if (ret == null) {
            ret = schema.getSequenceList(name);
        }
        return ret;
    }

    private static void extractMultilingualItems(Metadata metadata, Property property, String pdfBoxBaseline, XMPSchema schema) {
        if (schema == null) {
            if (pdfBoxBaseline != null && pdfBoxBaseline.length() > 0) {
                PDMetadataExtractor.addMetadata(metadata, property, pdfBoxBaseline);
            }
            return;
        }
        for (String lang : schema.getLanguagePropertyLanguages(property.getName())) {
            String value = schema.getLanguageProperty(property.getName(), lang);
            if (value == null || value.length() <= 0 || pdfBoxBaseline != null && value.equals(pdfBoxBaseline)) continue;
            PDMetadataExtractor.addMetadata(metadata, property, value);
            if (property.isMultiValuePermitted()) continue;
            return;
        }
        if (pdfBoxBaseline != null && pdfBoxBaseline.length() > 0) {
            if (!property.isMultiValuePermitted() && metadata.get(property) != null) {
                return;
            }
            PDMetadataExtractor.addMetadata(metadata, property, pdfBoxBaseline);
        }
    }

    private static void extractDublinCoreListItems(Metadata metadata, Property property, XMPSchemaDublinCore dc) {
        if (dc == null) {
            return;
        }
        List<String> items = PDMetadataExtractor.getXMPBagOrSeqList((XMPSchema)dc, property.getName());
        if (items == null) {
            return;
        }
        for (String item : items) {
            PDMetadataExtractor.addMetadata(metadata, property, item);
        }
    }

    static void addMetadata(Metadata metadata, Property property, String value) {
        if (value != null) {
            String decoded = PDMetadataExtractor.decode(value);
            if (property.isMultiValuePermitted() || metadata.get(property) == null) {
                metadata.add(property, decoded);
            }
        }
    }

    static void addMetadata(Metadata metadata, String name, String value) {
        if (value != null) {
            metadata.add(name, PDMetadataExtractor.decode(value));
        }
    }

    static String decode(String value) {
        if (PDFEncodedStringDecoder.shouldDecode(value)) {
            PDFEncodedStringDecoder d = new PDFEncodedStringDecoder();
            return d.decode(value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document loadDOM(PDMetadata pdMetadata, Metadata metadata, ParseContext context) {
        if (pdMetadata == null) {
            return null;
        }
        InputStream is = null;
        try {
            try {
                is = pdMetadata.exportXMPMetadata();
            }
            catch (IOException e) {
                EmbeddedDocumentUtil.recordEmbeddedStreamException(e, metadata);
                Document document = null;
                IOUtils.closeQuietly(is);
                return document;
            }
            Document e = XMLReaderUtils.buildDOM(is, context);
            return e;
        }
        catch (IOException | TikaException | SAXException e) {
            EmbeddedDocumentUtil.recordException(e, metadata);
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        return null;
    }

    static void addMetadata(Metadata metadata, Property property, Calendar value) {
        if (value != null) {
            metadata.set(property, value);
        }
    }

    static void addMetadata(Metadata metadata, String name, COSBase value) {
        if (value instanceof COSArray) {
            for (Object v : ((COSArray)value).toList()) {
                PDMetadataExtractor.addMetadata(metadata, name, (COSBase)v);
            }
        } else if (value instanceof COSString) {
            PDMetadataExtractor.addMetadata(metadata, name, ((COSString)value).getString());
        } else if (value != null && !(value instanceof COSDictionary)) {
            PDMetadataExtractor.addMetadata(metadata, name, value.toString());
        }
    }
}

