/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.InvalidFontException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FontInputStream {
    private MessageDigest digest;
    private PushbackInputStream pbis;
    private long curOffset = 0L;
    private static int constructions;

    public FontInputStream(FontInputStream in) {
        this.pbis = in.pbis;
        this.curOffset = in.curOffset;
        this.digest = in.digest;
    }

    public FontInputStream(InputStream in) {
        MessageDigest d;
        InputStream dis = null;
        try {
            d = MessageDigest.getInstance("SHA");
            dis = new DigestInputStream(in, d);
        }
        catch (NoSuchAlgorithmException e) {
            d = null;
            dis = in;
        }
        this.digest = d;
        this.pbis = new PushbackInputStream(dis, 400);
        ++constructions;
    }

    public static int numFis() {
        return constructions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.pbis.close();
        }
        finally {
            this.pbis = null;
            this.digest = null;
        }
    }

    public long getCurrentOffset() {
        return this.curOffset;
    }

    public long skipTo(long offset) throws IOException, InvalidFontException {
        if (this.curOffset > offset) {
            throw new InvalidFontException("trying to read the same byte twice (read up to " + Long.toHexString(this.curOffset) + ", want to go back to " + Long.toHexString(offset) + ")");
        }
        long initialOffset = this.curOffset;
        while (this.curOffset < offset) {
            long bytesSkipped = this.pbis.skip(offset - this.curOffset);
            this.curOffset += bytesSkipped;
        }
        return this.curOffset - initialOffset;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.pbis.read(b, off, len);
        if (n > 0) {
            this.curOffset += (long)n;
        }
        return n;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read() throws IOException {
        int retVal = this.pbis.read();
        if (retVal != -1) {
            ++this.curOffset;
        }
        return retVal;
    }

    public void unread(int b) throws IOException {
        this.pbis.unread(b);
        --this.curOffset;
    }

    public void unread(byte[] b, int off, int len) throws IOException {
        this.pbis.unread(b, off, len);
        this.curOffset -= (long)len;
    }

    public void unread(byte[] b) throws IOException {
        this.unread(b, 0, b.length);
    }

    public byte[] getDigest() throws IOException {
        if (this.digest == null) {
            return new byte[0];
        }
        byte[] b = new byte[1024];
        int n = 0;
        while (n != -1) {
            n = this.pbis.read(b);
        }
        return this.digest.digest();
    }
}

