/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.LookupTableHarvester;
import java.util.Map;

class ChainingFormat2Harvester
implements LookupTableHarvester.CoverageLookupHarvester,
LayoutTable.ClassConsumer {
    private Map lookups;
    private Subset gids;
    private boolean classCoveredBySet;
    private final LookupTableHarvester harvester;

    ChainingFormat2Harvester(LookupTableHarvester harvester, Map lookups) {
        this.lookups = lookups;
        this.harvester = harvester;
    }

    public boolean glyph(int glyphID, int classID) throws UnsupportedFontException, InvalidFontException {
        if (this.gids.getExistingSubsetGid(glyphID) != -1) {
            this.classCoveredBySet = true;
            return false;
        }
        return true;
    }

    private boolean classesApply(int numGlyphs, int classDefOffset, int chainSubruleOffset, int delta) throws InvalidFontException, UnsupportedFontException {
        for (int i = 0; i < numGlyphs; ++i) {
            int thisClass = this.harvester.lookupTable.data.getuint16(chainSubruleOffset + delta + 2 * i);
            this.classCoveredBySet = false;
            this.harvester.lookupTable.iterateClass(classDefOffset, this.harvester.numGlyphs, this, thisClass);
            if (this.classCoveredBySet) continue;
            return false;
        }
        return true;
    }

    public boolean lookupApplies(int coverageGlyph, int stOffset, int coverageIndex, Subset gids) throws InvalidFontException, UnsupportedFontException {
        this.gids = gids;
        int classDefOffset = this.harvester.lookupTable.data.getOffset(stOffset, 6);
        int classIndex = this.harvester.lookupTable.getClassIndex(coverageGlyph, classDefOffset);
        int chainSubClassSetOffset = this.harvester.lookupTable.data.getOffset(stOffset, 12 + 2 * classIndex);
        if (chainSubClassSetOffset == 0) {
            return false;
        }
        int backtrackClassDefOffset = this.harvester.lookupTable.data.getOffset(stOffset, 4);
        int lookaheadClassDefOffset = this.harvester.lookupTable.data.getOffset(stOffset, 8);
        boolean applies = false;
        int chainSubclassRuleCount = this.harvester.lookupTable.data.getuint16(chainSubClassSetOffset);
        for (int i = 0; i < chainSubclassRuleCount; ++i) {
            int lookAheadGlyphCount;
            int inputGlyphCount;
            int chainSubclassRuleOffset = this.harvester.lookupTable.data.getOffset(chainSubClassSetOffset, 2 + 2 * i);
            int backtrackGlyphCount = this.harvester.lookupTable.data.getuint16(chainSubclassRuleOffset);
            int delta = 0;
            if (!this.classesApply(backtrackGlyphCount, backtrackClassDefOffset, chainSubclassRuleOffset, 2) || !this.classesApply(inputGlyphCount = this.harvester.lookupTable.data.getuint16(chainSubclassRuleOffset + (delta += 2 + 2 * backtrackGlyphCount)) - 1, classDefOffset, chainSubclassRuleOffset, delta + 2) || !this.classesApply(lookAheadGlyphCount = this.harvester.lookupTable.data.getuint16(chainSubclassRuleOffset + (delta += 2 + 2 * inputGlyphCount)), lookaheadClassDefOffset, chainSubclassRuleOffset, delta + 2)) continue;
            int lookupCount = this.harvester.lookupTable.data.getuint16(chainSubclassRuleOffset + (delta += 2 + 2 * lookAheadGlyphCount));
            for (int j = 0; j < lookupCount; ++j) {
                int lookupIndex = this.harvester.lookupTable.data.getuint16(chainSubclassRuleOffset + delta + 2 + 4 * j + 2);
                this.harvester.harvest(gids, lookupIndex, this.lookups);
            }
            applies = true;
        }
        return applies;
    }

    public boolean keepGoing() {
        return true;
    }
}

