/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.io.stream.IO;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectRef;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.util.StringOps;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.List;

public final class CosObjectInfo {
    private static final int isFree = 0;
    private static final int isAssigned = 1;
    private static final int isAddressed = 2;
    private static final int isLoaded = 3;
    private static final int isDirty = 4;
    private int mState;
    private int mObjNum;
    private int mObjGen;
    private long mPos;
    private CosDocument mDoc;
    private Object mObj;
    private CosObjectRef mRef;
    private CosObjectInfo mObjStmInfo;
    private int mStreamNdx;
    private boolean mIsObjStm;
    private boolean mWriteCompressed;
    private long mNextObjPos = Long.MAX_VALUE;

    CosObjectInfo(CosDocument doc, int objNum, int objGen) {
        this.mDoc = doc;
        this.mState = 1;
        this.mObjNum = objNum;
        this.mObjGen = objGen;
        this.mPos = 0L;
    }

    CosObjectInfo() {
        this.mState = 0;
        this.mObjNum = 0;
        this.mObjGen = 65535;
        this.mPos = 0L;
    }

    public int getObjNum() {
        return this.mObjNum;
    }

    void setObjNum(int objNum) {
        this.mObjNum = objNum;
    }

    public int getObjGen() {
        return this.mObjGen;
    }

    void setIsObjStm(boolean isObjStm) {
        this.mIsObjStm = isObjStm;
    }

    boolean isObjStm() {
        return this.mIsObjStm;
    }

    void setWriteCompressed(boolean writeCompressed) {
        this.mWriteCompressed = writeCompressed;
    }

    boolean isWriteCompressed() {
        return this.mWriteCompressed;
    }

    void setObjGen(int objGen) {
        this.mObjGen = objGen;
    }

    boolean isCompressed() {
        return this.mObjStmInfo != null;
    }

    public CosObject getObject() throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        return this.getObject(true);
    }

    public CosObject getObject(boolean loadIfRequired) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        CosObject obj;
        CosObject cosObject = obj = this.mDoc != null ? this.mDoc.getRepairedValue(this.getObjNum()) : null;
        if (obj != null) {
            return obj;
        }
        if (this.mObj == null || this.mObj instanceof CosObject) {
            return (CosObject)this.mObj;
        }
        obj = (CosObject)((SoftReference)this.mObj).get();
        if (loadIfRequired && obj == null) {
            this.mState = 2;
            obj = this.mDoc.getXRef().getIndirectObject(this);
            this.mObj = new SoftReference<CosObject>(obj);
        }
        return obj;
    }

    void setObject(CosObject obj) {
        this.mDoc = obj.getDocument();
        this.mObj = this.mDoc.isCacheEnabled() ? new SoftReference<CosObject>(obj) : obj;
    }

    void clearObject() {
        this.mObj = null;
    }

    public long getPos() {
        return this.mPos;
    }

    void setPosInternal(long pos) {
        this.mPos = pos;
    }

    void setPos(long pos) {
        if (this.mPos != pos) {
            if (this.mPos != 0L) {
                Object obj = this.mObj;
                if (obj instanceof SoftReference) {
                    obj = ((SoftReference)this.mObj).get();
                }
                if (obj instanceof CosStream) {
                    ((CosStream)obj).adjustPos(pos - this.mPos);
                }
            }
            this.mPos = pos;
        }
    }

    void setNextObjPos(long pos) {
        this.mNextObjPos = pos;
    }

    long getNextObjPos() {
        return this.mNextObjPos;
    }

    public int getStreamNdx() {
        return this.mStreamNdx;
    }

    void setStreamNdx(int ndx) {
        this.mStreamNdx = ndx;
    }

    public CosObjectInfo getStreamInfo() {
        return this.mObjStmInfo;
    }

    void setStreamInfo(CosObjectInfo stm) {
        this.mObjStmInfo = stm;
        this.mWriteCompressed = false;
    }

    public CosObjectRef getRef() {
        return this.mRef;
    }

    void setRef(CosObjectRef ref) {
        this.mRef = ref;
    }

    boolean isFree() {
        return this.mState == 0;
    }

    void markFree() {
        this.mState = 0;
        this.mObj = null;
    }

    boolean isAssigned() {
        return this.mState == 1;
    }

    void markAssigned() {
        this.mState = 1;
    }

    boolean isAddressed() {
        return this.mState == 2;
    }

    void markAddressed() {
        this.mState = 2;
    }

    boolean isLoaded() {
        return this.mState == 3;
    }

    void markLoaded() {
        this.mState = 3;
    }

    boolean isDirty() {
        return this.mState == 4;
    }

    void markDirty() throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        this.mState = 4;
        if (this.mDoc != null) {
            this.mDoc.markDirty();
        }
        if (this.mObj == null || this.mObj instanceof SoftReference) {
            this.mObj = this.getObject();
        }
    }

    public int getState() {
        return this.mState;
    }

    void setState(int state) {
        this.mState = state;
    }

    boolean flushCachedObject() {
        if (this.isDirty()) {
            return false;
        }
        if (this.isLoaded()) {
            this.markAddressed();
            this.mObj = null;
        }
        return true;
    }

    boolean markNotDirty() {
        if (!this.isDirty()) {
            return false;
        }
        this.markLoaded();
        if (this.mObj instanceof CosObject) {
            this.mObj = new SoftReference<Object>(this.mObj);
        }
        return true;
    }

    long writeIndirectObject(OutputByteStream obs, long pos) throws PDFCosParseException, PDFIOException, IOException, PDFSecurityException {
        return this.writeIndirectObject(obs, pos, false);
    }

    long writeIndirectObject(OutputByteStream obs, long pos, boolean saveToCopy) throws PDFCosParseException, PDFIOException, IOException, PDFSecurityException {
        if (this.isFree()) {
            return pos;
        }
        obs.write(StringOps.toByteArray(Integer.toString(this.mObjNum)));
        obs.write(32);
        obs.write(StringOps.toByteArray(Integer.toString(this.mObjGen)));
        obs.write(StringOps.toByteArray(" obj\n"));
        CosObject obj = this.getObject();
        this.loadStrings(obj, null, null);
        this.mPos = pos;
        this.mObjStmInfo = null;
        this.mWriteCompressed = false;
        this.mStreamNdx = 0;
        this.mNextObjPos = Long.MAX_VALUE;
        if (obj instanceof CosStream) {
            ((CosStream)obj).writeOut(obs, false, false, saveToCopy);
        } else {
            obj.writeOut(obs);
        }
        obs.write(StringOps.toByteArray("\nendobj\n"));
        return obs.getPosition();
    }

    void loadStrings(CosObject obj, CosObject parent, ASName key2) throws PDFCosParseException, PDFIOException, IOException, PDFSecurityException {
        block7: {
            block8: {
                block6: {
                    if (!(obj instanceof CosString)) break block6;
                    if (parent != null && ((CosString)obj).getIsEncrypted() && this.mDoc.getOptions().skipCorruptObjects()) {
                        try {
                            ((CosString)obj).byteArrayValue();
                        }
                        catch (Exception e) {
                            CosString repairedString = new CosString(this.mDoc, new byte[0], 0, 0, false, null);
                            repairedString.setParentObj((CosDictionary)parent);
                            ((CosDictionary)parent).setRepairedValue(key2, repairedString);
                        }
                    } else {
                        ((CosString)obj).byteArrayValue();
                    }
                    break block7;
                }
                if (!(obj instanceof CosArray)) break block8;
                for (int i = 0; i < ((CosArray)obj).size(); ++i) {
                    CosObject child;
                    if (((CosArray)obj).getRef(i) != null || (child = ((CosArray)obj).get(i)).isIndirect()) continue;
                    this.loadStrings(child, null, null);
                }
                break block7;
            }
            if (!(obj instanceof CosDictionary)) break block7;
            List<ASName> keys = ((CosDictionary)obj).getKeys();
            for (ASName key2 : keys) {
                CosObject child;
                if (((CosDictionary)obj).getRef(key2) != null || (child = ((CosDictionary)obj).get(key2)).isIndirect()) continue;
                this.loadStrings(child, obj, key2);
            }
        }
    }

    void writeXRefTableEntry(OutputByteStream obs) throws IOException {
        if (this.isFree()) {
            this.writeInt(obs, 0L, 10);
            obs.write(32);
            this.writeInt(obs, 65535L, 5);
            obs.write(StringOps.toByteArray(" f\r\n"));
        } else {
            this.writeInt(obs, this.mPos, 10);
            obs.write(32);
            this.writeInt(obs, this.mObjGen, 5);
            obs.write(StringOps.toByteArray(" n\r\n"));
        }
    }

    void writeInt(OutputByteStream obs, long num, int size) throws IOException {
        int i;
        int maxDig = 10;
        if (size > maxDig) {
            size = maxDig;
        }
        char[] digits = new char[maxDig];
        int work = 1000000000;
        for (i = 0; i < maxDig - 1; ++i) {
            digits[i] = (char)(48L + num / (long)work);
            num %= (long)work;
            work /= 10;
        }
        digits[i] = (char)(48L + num);
        for (i = maxDig - size; i < maxDig; ++i) {
            obs.write(digits[i]);
        }
    }

    void writeXRefStreamEntry(OutputByteStream buf, int[] fieldsizes) throws PDFCosParseException, IOException, PDFSecurityException {
        if (this.isCompressed()) {
            buf.write(IO.longToByteArray(2L, fieldsizes[0]));
            buf.write(IO.longToByteArray(this.mObjStmInfo.getObjNum(), fieldsizes[1]));
            buf.write(IO.longToByteArray(this.mStreamNdx, fieldsizes[2]));
        } else if (this.isFree()) {
            buf.write(IO.longToByteArray(0L, fieldsizes[0]));
            buf.write(IO.longToByteArray(0L, fieldsizes[1]));
            buf.write(IO.longToByteArray(65535L, fieldsizes[2]));
        } else {
            buf.write(IO.longToByteArray(1L, fieldsizes[0]));
            buf.write(IO.longToByteArray(this.mPos, fieldsizes[1]));
            buf.write(IO.longToByteArray(this.mObjGen, fieldsizes[2]));
        }
    }

    public void copyValuesFrom(CosObjectInfo template) {
        this.mState = template.mState;
        this.mObjNum = template.mObjNum;
        this.mObjGen = template.mObjGen;
        this.mPos = template.mPos;
        this.mDoc = template.mDoc;
        this.mObj = template.mObj;
        this.mRef = template.mRef;
        this.mObjStmInfo = template.mObjStmInfo;
        this.mStreamNdx = template.mStreamNdx;
        this.mIsObjStm = template.mIsObjStm;
        this.mWriteCompressed = template.mWriteCompressed;
        this.mNextObjPos = template.mNextObjPos;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.mObjNum);
        builder.append(":");
        builder.append(this.mObjGen);
        builder.append("] = ");
        switch (this.mState) {
            case 2: {
                builder.append("addressed");
                break;
            }
            case 1: {
                builder.append("assigned");
                break;
            }
            case 4: {
                builder.append("dirty");
                break;
            }
            case 0: {
                builder.append("free");
                break;
            }
            case 3: {
                builder.append("loaded");
            }
        }
        builder.append(" at 0x");
        builder.append(Long.toHexString(this.mPos));
        return builder.toString();
    }
}

