/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.pdftoolkit.core.filter.LZWInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class LZWEngine {
    private static final int LZWMAXCODE = 4096;
    private static final int LZWMINCODELEN = 9;
    private static final int LZWMAXCODELEN = 12;
    private static final int HASHTABSIZE = 8191;
    private boolean reading;
    private LZWInputStream rdr;
    private OutputStream wtr;
    private long totalOut;
    private int earlyChange;
    private int codeSize;
    private int wordSize;
    private int clearCode;
    private int stopCode;
    private int nextCode;
    private int lastCode;
    private int sendCode;
    private int sendLength;
    private int residualBits;
    private int codeMask;
    private int codeMaskChange;
    private int codeWord;
    private int[] lzwEntry;
    private short[] hashTab;

    private LZWEngine(boolean reading) {
        this.reading = reading;
        this.earlyChange = 1;
        this.residualBits = 0;
        this.codeWord = 0;
        this.lzwEntry = new int[4097];
        this.hashTab = new short[8192];
        this.LZWInit(8);
    }

    public LZWEngine(InputStream r) {
        this(true);
        this.rdr = (LZWInputStream)r;
    }

    public LZWEngine(OutputStream w) {
        this(false);
        this.wtr = w;
    }

    protected void setEarlyChange(int value) {
        this.earlyChange = value;
    }

    private void LZWInit(int codeSize) {
        int entries;
        this.codeSize = codeSize;
        this.wordSize = codeSize + 1;
        this.codeMask = (1 << this.wordSize) - 1;
        this.codeMaskChange = this.codeMask + 1 - this.earlyChange;
        this.clearCode = entries = 1 << codeSize;
        this.stopCode = entries + 1;
        this.nextCode = entries + 2;
        this.lastCode = -1;
        this.sendCode = -1;
        for (int code = 0; code < this.nextCode; ++code) {
            this.lzwEntry[code] = -1048320 + code;
        }
        for (int i = 0; i < 32; ++i) {
            this.hashTab[i] = 0;
        }
        System.arraycopy(this.hashTab, 0, this.hashTab, 32, 32);
        System.arraycopy(this.hashTab, 0, this.hashTab, 64, 64);
        System.arraycopy(this.hashTab, 0, this.hashTab, 128, 128);
        System.arraycopy(this.hashTab, 0, this.hashTab, 256, 256);
        System.arraycopy(this.hashTab, 0, this.hashTab, 512, 512);
        System.arraycopy(this.hashTab, 0, this.hashTab, 1024, 1024);
        System.arraycopy(this.hashTab, 0, this.hashTab, 2048, 2048);
        System.arraycopy(this.hashTab, 0, this.hashTab, 4096, 4096);
    }

    private int LZWSearchTable(int newData) {
        short code;
        int k;
        int key = newData << 5;
        do {
            key += this.lastCode + 1;
            while (key >= 8191) {
                key -= 8191;
            }
            code = this.hashTab[key];
            if (code != 0) continue;
            this.hashTab[key] = (short)this.nextCode;
            return -1;
        } while (((k = this.lzwEntry[code]) & 0xFF) != newData || k >>> 20 != this.lastCode);
        return code;
    }

    private void LZWAddTable(int newData) {
        this.lzwEntry[this.nextCode] = (this.lastCode << 20) + (this.lzwEntry[this.lastCode] & 0xFFF00) + 256 + newData;
        if (this.reading) {
            ++this.nextCode;
        }
        if (this.nextCode == this.codeMaskChange) {
            if (++this.wordSize > 12) {
                this.wordSize = 12;
            }
            this.codeMask = (1 << this.wordSize) - 1;
            this.codeMaskChange = this.codeMask + 1 - this.earlyChange;
        }
        if (!this.reading) {
            ++this.nextCode;
        }
    }

    protected int get(byte[] buf, int offset, int length) {
        int count = 0;
        while (length > 0) {
            int k;
            if (this.sendCode < 0) {
                int stringLen;
                int thisCode;
                while (this.residualBits < this.wordSize) {
                    int p;
                    if (this.residualBits <= 8 && (p = this.rdr.read3()) >= 0) {
                        this.codeWord = (this.codeWord << 24) + p;
                        this.residualBits += 24;
                        continue;
                    }
                    p = this.rdr.read2();
                    if (p >= 0) {
                        this.codeWord = (this.codeWord << 16) + p;
                        this.residualBits += 16;
                        continue;
                    }
                    p = this.rdr.read1();
                    if (p >= 0) {
                        this.codeWord = (this.codeWord << 8) + p;
                        this.residualBits += 8;
                        continue;
                    }
                    this.codeWord = this.stopCode;
                    this.residualBits = this.wordSize;
                }
                this.residualBits -= this.wordSize;
                int newCode = this.codeWord >> this.residualBits & this.codeMask;
                if (newCode == this.stopCode) {
                    this.sendCode = this.stopCode;
                    break;
                }
                if (newCode == this.clearCode) {
                    this.LZWInit(this.codeSize);
                    continue;
                }
                if (newCode >= this.nextCode) {
                    thisCode = this.lastCode;
                    if (newCode > this.nextCode) {
                        this.sendCode = this.stopCode;
                        break;
                    }
                } else {
                    thisCode = newCode;
                }
                if (this.nextCode < 4096 && this.lastCode >= 0) {
                    int j;
                    int k2 = this.lzwEntry[thisCode];
                    while ((j = k2 >>> 20) != 4095) {
                        k2 = this.lzwEntry[j];
                    }
                    this.LZWAddTable(k2 & 0xFF);
                }
                if ((stringLen = this.lzwEntry[newCode] >> 8 & 0xFFF) <= length) {
                    this.lastCode = thisCode = newCode;
                    length -= stringLen;
                    count += stringLen;
                    this.sendCode = -1;
                    int s = offset += stringLen;
                    k = this.lzwEntry[thisCode];
                    while (stringLen-- > 1) {
                        buf[--s] = (byte)k;
                        k = this.lzwEntry[k >>> 20];
                    }
                    buf[--s] = (byte)k;
                } else {
                    this.lastCode = thisCode = newCode;
                    this.sendCode = thisCode;
                    this.sendLength = stringLen;
                }
            } else if (this.sendCode == this.stopCode) break;
            if (this.sendCode < 0) continue;
            int toSend = this.sendLength;
            if (toSend > length) {
                toSend = length;
            }
            int toSkip = this.sendLength -= toSend;
            length -= toSend;
            count += toSend;
            k = this.lzwEntry[this.sendCode];
            while (toSkip-- > 0) {
                k = this.lzwEntry[k >>> 20];
            }
            int s = offset += toSend;
            while (toSend-- > 1) {
                buf[--s] = (byte)k;
                k = this.lzwEntry[k >>> 20];
            }
            buf[--s] = (byte)k;
            if (this.sendLength != 0) continue;
            this.sendCode = -1;
        }
        return count;
    }

    private void LZWPutEOF() throws IOException {
        if (this.lastCode != -1) {
            this.codeWord = (this.codeWord << this.wordSize) + this.lastCode;
            this.residualBits += this.wordSize;
            while (this.residualBits >= 8) {
                this.residualBits -= 8;
                this.wtr.write((byte)(this.codeWord >> this.residualBits));
                ++this.totalOut;
            }
            this.LZWAddTable(0);
        }
        this.codeWord = (this.codeWord << this.wordSize) + this.stopCode;
        this.residualBits += this.wordSize;
        while (this.residualBits >= 8) {
            this.residualBits -= 8;
            this.wtr.write((byte)(this.codeWord >> this.residualBits));
            ++this.totalOut;
        }
        if (this.residualBits != 0) {
            this.wtr.write((byte)(this.codeWord << 8 - this.residualBits));
            ++this.totalOut;
        }
    }

    protected void put(int newData) throws IOException {
        if (newData == -1) {
            this.LZWPutEOF();
        } else if (this.lastCode == -1) {
            this.lastCode = newData;
        } else {
            int newCode = this.LZWSearchTable(newData);
            if (newCode == -1) {
                this.codeWord = (this.codeWord << this.wordSize) + this.lastCode;
                this.residualBits += this.wordSize;
                while (this.residualBits >= 8) {
                    this.residualBits -= 8;
                    this.wtr.write((byte)(this.codeWord >> this.residualBits));
                    ++this.totalOut;
                }
                if (this.nextCode < 4093) {
                    this.LZWAddTable(newData);
                } else {
                    this.codeWord = (this.codeWord << this.wordSize) + this.clearCode;
                    this.residualBits += this.wordSize;
                    while (this.residualBits >= 8) {
                        this.residualBits -= 8;
                        this.wtr.write((byte)(this.codeWord >> this.residualBits));
                        ++this.totalOut;
                    }
                    this.LZWInit(this.codeSize);
                }
                this.lastCode = newData;
            } else {
                this.lastCode = newCode;
            }
        }
    }

    protected long getTotalOut() {
        return this.totalOut;
    }

    protected int getResidualBits() {
        return this.residualBits;
    }
}

