/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.AppModelScript;
import com.adobe.xfa.AppSchema;
import com.adobe.xfa.Arg;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.DependencyTracker;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.EventManager;
import com.adobe.xfa.EventPseudoModel;
import com.adobe.xfa.HrefHandler;
import com.adobe.xfa.LogMessage;
import com.adobe.xfa.LogMessenger;
import com.adobe.xfa.LogPseudoModel;
import com.adobe.xfa.Model;
import com.adobe.xfa.ModelFactory;
import com.adobe.xfa.ModelPeer;
import com.adobe.xfa.Node;
import com.adobe.xfa.Obj;
import com.adobe.xfa.Packet;
import com.adobe.xfa.Schema;
import com.adobe.xfa.ScriptDynamicPropObj;
import com.adobe.xfa.ScriptHandler;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.XFA;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.service.storage.PacketHandler;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;

public final class AppModel
extends Model
implements Model.DualDomModel {
    public static final LegacyMask XFA_LEGACY_POSITIONING = new LegacyMask(1);
    public static final LegacyMask XFA_LEGACY_EVENTMODEL = new LegacyMask(2);
    public static final LegacyMask XFA_LEGACY_PLUSPRINT = new LegacyMask(4);
    public static final LegacyMask XFA_LEGACY_PERMISSIONS = new LegacyMask(8);
    public static final LegacyMask XFA_LEGACY_CALCOVERRIDE = new LegacyMask(16);
    public static final LegacyMask XFA_LEGACY_RENDERING = new LegacyMask(32);
    public static final LegacyMask XFA_LEGACY_V26_HIDDENPOSITIONED = new LegacyMask(64);
    public static final LegacyMask XFA_LEGACY_V27_MULTIRECORDCONTEXTCACHE = new LegacyMask(128);
    public static final LegacyMask XFA_LEGACY_V27_LAYOUT = new LegacyMask(256);
    public static final LegacyMask XFA_LEGACY_V27_SCRIPTING = new LegacyMask(512);
    public static final LegacyMask XFA_LEGACY_V27_EVENTMODEL = new LegacyMask(1024);
    public static final LegacyMask XFA_LEGACY_V27_TRAVERSALORDER = new LegacyMask(2048);
    public static final LegacyMask XFA_LEGACY_V27_XHTMLVERSIONPROCESSING = new LegacyMask(4096);
    public static final LegacyMask XFA_LEGACY_V27_ACCESSIBILITY = new LegacyMask(8192);
    public static final LegacyMask XFA_LEGACY_V28_LAYOUT = new LegacyMask(16384);
    public static final LegacyMask XFA_LEGACY_V28_SCRIPTING = new LegacyMask(32768);
    public static final LegacyMask XFA_LEGACY_V29_LAYOUT = new LegacyMask(65536);
    public static final LegacyMask XFA_LEGACY_V29_SCRIPTING = new LegacyMask(131072);
    public static final LegacyMask XFA_LEGACY_V30_LAYOUT = new LegacyMask(262144);
    public static final LegacyMask XFA_LEGACY_V30_SCRIPTING = new LegacyMask(524288);
    public static final LegacyMask XFA_LEGACY_V29_TRAVERSALORDER = new LegacyMask(0x100000);
    public static final LegacyMask XFA_PATCH_B_02518 = new LegacyMask(0x200000);
    public static final LegacyMask XFA_LEGACY_V29_FIELDPRESENCE = new LegacyMask(0x400000);
    public static final LegacyMask XFA_PATCH_W_2393121 = new LegacyMask(0x800000);
    public static final LegacyMask XFA_PATCH_W_2447677 = new LegacyMask(0x1000000);
    public static final LegacyMask XFA_LEGACY_V32_SCRIPTING = new LegacyMask(0x2000000);
    public static final LegacyMask XFA_LEGACY_V31_LAYOUT = new LegacyMask(0x4000000);
    public static final LegacyMask XFA_LEGACY_V32_LAYOUT = new LegacyMask(0x8000000);
    public static final LegacyMask XFA_LEGACY_V32_RENDERING = new LegacyMask(0x10000000);
    public static final LegacyMask XFA_LEGACY_V32_CANONICALIZATION = new LegacyMask(Integer.MIN_VALUE);
    public static final LegacyMask XFA_PATCH_W_2757988 = new LegacyMask(1, 1);
    public static final LegacyMask XFA_LEGACY_35_DEFAULT = new LegacyMask(0);
    public static final LegacyMask XFA_LEGACY_HEAD_DEFAULT = new LegacyMask(XFA_LEGACY_35_DEFAULT);
    public static final LegacyMask XFA_LEGACY_34_DEFAULT = new LegacyMask(XFA_LEGACY_35_DEFAULT);
    public static final LegacyMask XFA_LEGACY_33_DEFAULT = new LegacyMask(XFA_LEGACY_34_DEFAULT);
    public static final LegacyMask XFA_LEGACY_32_DEFAULT = LegacyMask.or(new LegacyMask[]{XFA_LEGACY_33_DEFAULT, XFA_LEGACY_V32_SCRIPTING, XFA_LEGACY_V32_LAYOUT, XFA_LEGACY_V32_RENDERING, XFA_LEGACY_V32_CANONICALIZATION});
    public static final LegacyMask XFA_LEGACY_31_DEFAULT = new LegacyMask(XFA_LEGACY_32_DEFAULT);
    public static final LegacyMask XFA_LEGACY_30_DEFAULT = LegacyMask.or(new LegacyMask[]{XFA_LEGACY_31_DEFAULT, XFA_LEGACY_V30_LAYOUT, XFA_LEGACY_V30_SCRIPTING});
    public static final LegacyMask XFA_LEGACY_29_DEFAULT = LegacyMask.or(new LegacyMask[]{XFA_LEGACY_30_DEFAULT, XFA_LEGACY_V29_LAYOUT, XFA_LEGACY_V29_SCRIPTING, XFA_LEGACY_V29_TRAVERSALORDER, XFA_LEGACY_V29_FIELDPRESENCE});
    public static final LegacyMask XFA_LEGACY_28_DEFAULT = LegacyMask.or(new LegacyMask[]{XFA_LEGACY_29_DEFAULT, XFA_LEGACY_V28_LAYOUT, XFA_LEGACY_V28_SCRIPTING});
    public static final LegacyMask XFA_LEGACY_27_DEFAULT = LegacyMask.or(new LegacyMask[]{XFA_LEGACY_28_DEFAULT, XFA_LEGACY_V27_LAYOUT, XFA_LEGACY_V27_SCRIPTING, XFA_LEGACY_V27_EVENTMODEL, XFA_LEGACY_V27_TRAVERSALORDER, XFA_LEGACY_V27_XHTMLVERSIONPROCESSING});
    public static final LegacyMask XFA_LEGACY_26_DEFAULT = LegacyMask.or(new LegacyMask[]{XFA_LEGACY_27_DEFAULT, XFA_LEGACY_V26_HIDDENPOSITIONED});
    public static final LegacyMask XFA_LEGACY_25_DEFAULT = LegacyMask.or(new LegacyMask[]{XFA_LEGACY_26_DEFAULT});
    public static final LegacyMask XFA_LEGACY_24_DEFAULT = LegacyMask.or(new LegacyMask[]{XFA_LEGACY_25_DEFAULT, XFA_LEGACY_PLUSPRINT, XFA_LEGACY_CALCOVERRIDE, XFA_LEGACY_PERMISSIONS});
    public static final LegacyMask XFA_LEGACY_23_DEFAULT = LegacyMask.or(new LegacyMask[]{XFA_LEGACY_24_DEFAULT, XFA_LEGACY_EVENTMODEL});
    public static final LegacyMask XFA_LEGACY_22_DEFAULT = LegacyMask.or(new LegacyMask[]{XFA_LEGACY_23_DEFAULT});
    public static final LegacyMask XFA_LEGACY_21_DEFAULT = LegacyMask.or(new LegacyMask[]{XFA_LEGACY_22_DEFAULT, XFA_LEGACY_POSITIONING});
    public static final LegacyMask XFA_LEGACY_21_DEPRECATED;
    public static final LegacyMask XFA_LEGACY_22_DEPRECATED;
    public static final LegacyMask XFA_LEGACY_23_DEPRECATED;
    public static final LegacyMask XFA_LEGACY_24_DEPRECATED;
    public static final LegacyMask XFA_LEGACY_25_DEPRECATED;
    public static final LegacyMask XFA_LEGACY_26_DEPRECATED;
    public static final LegacyMask XFA_LEGACY_27_DEPRECATED;
    public static final LegacyMask XFA_LEGACY_28_DEPRECATED;
    public static final LegacyMask XFA_LEGACY_29_DEPRECATED;
    public static final LegacyMask XFA_LEGACY_30_DEPRECATED;
    public static final LegacyMask XFA_LEGACY_31_DEPRECATED;
    public static final LegacyMask XFA_LEGACY_32_DEPRECATED;
    public static final LegacyMask XFA_LEGACY_33_DEPRECATED;
    public static final LegacyMask XFA_LEGACY_34_DEPRECATED;
    public static final LegacyMask XFA_LEGACY_35_DEPRECATED;
    public static final LegacyMask XFA_LEGACY_HEAD_DEPRECATED;
    private static final AppSchema gAppSchema;
    private boolean mbExternalProtosAreTransient;
    private boolean mbIsFragmentDoc;
    private boolean mbResolveAllExternalProtos = true;
    private boolean mbUpdateOriginalVersion = true;
    private DependencyTracker mDependencyTracker;
    private int meOutputBelow = 8323073;
    private int meSourceAbove = 0x7E0000;
    private int meSourceBelow = 0x7D0000;
    private EventManager mEventManager;
    private final Map<String, Obj> mExtraShortCuts = new HashMap<String, Obj>();
    private final List<ModelFactory> mFactories = new ArrayList<ModelFactory>();
    private final List<ScriptHandler> mScriptHandlers = new ArrayList<ScriptHandler>();
    private HrefHandler mHrefHandler;
    private PacketHandler mPacketHandler;
    private Object mHandlerData;
    private LogMessenger mMessenger;
    private int mnMaxVersionAllowed = 35;
    private boolean mbBumpVersionOnRichTextLoad;
    private List<String> moFragmentSearchPath;
    private String msPackets = "";
    private boolean mbAllowThirdPartyXml;
    private static final ScriptDynamicPropObj getPseudoModelPropObj;

    static Schema getModelSchema() {
        return gAppSchema;
    }

    public static boolean includePacket(String aPacketName, String sInList) {
        String sPackets = sInList;
        if (StringUtils.isEmpty(sInList)) {
            return false;
        }
        boolean bInclude = true;
        if (sPackets.startsWith("-")) {
            sPackets = sPackets.substring(1);
            bInclude = false;
        }
        if (sPackets.indexOf(42) != -1) {
            return bInclude;
        }
        String sPacketName = aPacketName;
        String[] sTokens = sPackets.split(" ");
        for (int i = 0; i < sTokens.length; ++i) {
            if (!sTokens[i].equals(sPacketName)) continue;
            return bInclude;
        }
        return !bInclude;
    }

    public AppModel(LogMessenger messenger) {
        super(null, null, "", "xfa", "xfa", "$xfa", 353, "xfa", AppModel.getModelSchema());
        this.setName("xfa");
        if (messenger == null) {
            messenger = new LogMessenger();
        }
        this.mMessenger = messenger;
        this.mEventManager = new EventManager(this);
        new Document(this);
        this.setAppModel(this);
        ModelPeer xmlPeer = new ModelPeer(null, null, "", "xfa", "xfa", null, this);
        xmlPeer.setModel(this);
        this.setXmlPeer(xmlPeer);
        this.addPseudoModel("$log", new LogPseudoModel(this));
        this.addPseudoModel("$event", new EventPseudoModel(this));
    }

    public void addFactory(ModelFactory factory) {
        int count = this.mFactories.size();
        for (int i = 0; i < count; ++i) {
            if (factory.rootName() != this.mFactories.get(i).rootName()) continue;
            this.mFactories.remove(i);
            break;
        }
        this.mFactories.add(factory);
    }

    public void addPseudoModel(String sShortCutName, Obj obj) {
        assert (sShortCutName.startsWith("$"));
        assert (this.mExtraShortCuts.get(sShortCutName) == null);
        assert (obj != null);
        this.mExtraShortCuts.put(sShortCutName, obj);
    }

    public void addScriptHandler(ScriptHandler handler) {
        for (int i = 0; i < this.mScriptHandlers.size(); ++i) {
            ScriptHandler oHandler = this.mScriptHandlers.get(i);
            if (!oHandler.languageName().equals(handler.languageName())) continue;
            this.mScriptHandlers.remove(i);
            --i;
        }
        this.mScriptHandlers.add(handler.clone());
    }

    public void clearScriptingContexts() {
        for (int i = 0; i < this.mScriptHandlers.size(); ++i) {
            this.mScriptHandlers.get(i).clearExecutionContexts();
        }
        while (this.mScriptHandlers.size() > 0) {
            this.mScriptHandlers.remove(0);
        }
    }

    public boolean bumpVersionOnRichTextLoad() {
        return this.mbBumpVersionOnRichTextLoad;
    }

    public void bumpVersionOnRichTextLoad(boolean bBumpVersion) {
        this.mbBumpVersionOnRichTextLoad = bBumpVersion;
    }

    @Override
    public void appendChild(Node newChild, boolean bValidate) {
        assert (newChild != null);
        if (newChild instanceof Model) {
            Model newModel = (Model)newChild;
            super.appendChild(newModel, bValidate);
            newModel.setAppModel(this);
        } else {
            super.appendChild(newChild, bValidate);
        }
    }

    @Override
    public void clearErrorList() {
        super.clearErrorList();
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!(child instanceof Model)) continue;
            ((Model)child).clearErrorList();
        }
    }

    @Override
    public Node createNode(int eTag, Element parent, String aName, String aNS, boolean bDoVersionCheck) {
        assert (aName != null);
        assert (aNS != null);
        if (eTag == 220) {
            Packet packet = new Packet(this, null);
            ModelPeer modelPeer = new ModelPeer((Element)this.getXmlPeer(), null, aNS, aName, aName, null, packet);
            packet.setXmlPeer(modelPeer);
            return packet;
        }
        throw new ExFull(new MsgFormat(ResId.InvalidNodeTypeException, this.getAtom(eTag)));
    }

    @Override
    public Element createElement(Element parent, Node prevSibling, String uri, String localName, String qName, Attributes attributes, int lineNumber, String fileName) {
        super.setLineNumber(lineNumber);
        if (parent == this || parent instanceof Document) {
            String sPackets = this.getPacketList();
            if (sPackets.length() > 0) {
                boolean bFilterOut;
                StringTokenizer sFilter = new StringTokenizer(sPackets);
                boolean bl = bFilterOut = sFilter.countTokens() > 0;
                while (sFilter.hasMoreTokens()) {
                    String sToken = sFilter.nextToken();
                    if (sToken.equals("*") || sToken.equals(localName)) {
                        bFilterOut = false;
                        continue;
                    }
                    if (sToken.charAt(0) != '-' || !sToken.endsWith(localName)) continue;
                    break;
                }
                if (bFilterOut) {
                    return null;
                }
            }
            for (int i = 0; i < this.mFactories.size(); ++i) {
                ModelFactory mf = this.mFactories.get(i);
                if (!mf.isRootNode(this, uri, localName)) continue;
                if (!mf.getAllowAdd()) {
                    for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                        if (child.getClassTag() != mf.meClassTag) continue;
                        throw new ExFull(ResId.DuplicateModelLoadException, XFA.getAtom(mf.meClassTag));
                    }
                }
                Model model = mf.newModel(this, prevSibling, uri, localName, qName, attributes);
                if (uri == "") {
                    model.setNeedsNSNormalize(true);
                }
                return model;
            }
            Packet packet = new Packet(this, prevSibling);
            packet.setXmlPeer(new ModelPeer(parent == this ? (Element)this.getXmlPeer() : parent, null, uri, localName, qName, attributes, packet));
            packet.setDOMProperties(uri, localName, qName, null);
            return packet;
        }
        if (parent == null) {
            return null;
        }
        return super.createElement(parent, prevSibling, uri, localName, qName, attributes, lineNumber, fileName);
    }

    public DependencyTracker dependencyTracker() {
        return this.mDependencyTracker;
    }

    public void dependencyTracker(DependencyTracker oDependencyTracker) {
        this.mDependencyTracker = oDependencyTracker;
    }

    public boolean getAllowThirdPartyXml() {
        return this.mbAllowThirdPartyXml;
    }

    public List<ModelFactory> factories() {
        return this.mFactories;
    }

    @Override
    public Attribute getAttribute(int eAttributeTag) {
        assert (eAttributeTag == 400 || eAttributeTag == 699);
        String aPropertyName = XFA.getAtom(eAttributeTag);
        int attr = this.findAttr(null, aPropertyName);
        String oAttrValue = "";
        if (attr != -1) {
            oAttrValue = this.getAttrVal(attr);
        }
        return new StringAttr(aPropertyName, oAttrValue);
    }

    @Override
    public String getBaseNS() {
        return "http://ns.adobe.com/xdp/";
    }

    @Override
    public ScriptDynamicPropObj getDynamicScriptProp(String sPropertyName, boolean bPropertyOverride, boolean bPeek) {
        if (!bPropertyOverride && AppModelScript.getPseudoModelFunc(this, null, sPropertyName)) {
            return getPseudoModelPropObj;
        }
        return super.getDynamicScriptProp(sPropertyName, bPropertyOverride, bPeek);
    }

    @Override
    public List<Element> getErrorContextList() {
        ArrayList<Element> errList = new ArrayList<Element>(super.getErrorContextList());
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!(child instanceof Model)) continue;
            Model model = (Model)child;
            errList.addAll(model.getErrorContextList());
        }
        return errList;
    }

    @Override
    public List<ExFull> getErrorList() {
        ArrayList<ExFull> errList = new ArrayList<ExFull>(super.getErrorList());
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!(child instanceof Model)) continue;
            Model model = (Model)child;
            errList.addAll(model.getErrorList());
        }
        return errList;
    }

    @Override
    public EventManager getEventManager() {
        return this.mEventManager;
    }

    public boolean getExternalProtosAreTransient() {
        return this.mbExternalProtosAreTransient;
    }

    public List<String> getFragmentSearchPath() {
        return this.moFragmentSearchPath;
    }

    @Override
    public String getHeadNS() {
        return "http://ns.adobe.com/xdp/";
    }

    public HrefHandler getHrefHandler() {
        return this.mHrefHandler;
    }

    public boolean getIsFragmentDoc() {
        return this.mbIsFragmentDoc;
    }

    @Override
    public boolean getLegacySetting(LegacyMask nLegacyFlag) {
        FormModel formModel;
        if (nLegacyFlag == XFA_LEGACY_V30_SCRIPTING && (formModel = (FormModel)Model.getNamedModel(this, "form")) != null && formModel.mergeMode() == 9175041) {
            return false;
        }
        TemplateModel oTemplateModel = (TemplateModel)Model.getNamedModel(this, "template");
        if (oTemplateModel == null) {
            return false;
        }
        return oTemplateModel.getLegacySetting(nLegacyFlag);
    }

    @Override
    public LogMessenger getLogMessenger() {
        return this.mMessenger;
    }

    @Override
    public String getNS() {
        return this.getBaseNS();
    }

    public int getOutputBelow() {
        return this.meOutputBelow;
    }

    public String getPacketList() {
        return this.msPackets;
    }

    @Override
    public Node getPreviousXMLSibling() {
        Document parent = this.getDocument();
        if (parent == null) {
            return null;
        }
        Node prev = null;
        for (Node child = ((Element)parent).getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            if (child == this) {
                return prev;
            }
            prev = child;
        }
        return null;
    }

    boolean getResolveAllExternalProtos() {
        return this.mbResolveAllExternalProtos;
    }

    @Override
    public int getSchemaType(int eTag) {
        for (Node oChild = this.getFirstXFAChild(); oChild != null; oChild = oChild.getNextXFASibling()) {
            if (oChild.getClassTag() != eTag) continue;
            return 4;
        }
        return super.getSchemaType(eTag);
    }

    public List<ScriptHandler> getScriptHandlers() {
        return this.mScriptHandlers;
    }

    @Override
    ScriptHandler getScriptHandler(String sLanguageName) {
        for (int i = 0; i < this.mScriptHandlers.size(); ++i) {
            ScriptHandler scriptHandler = this.mScriptHandlers.get(i);
            if (!scriptHandler.languageName().equals(sLanguageName)) continue;
            return scriptHandler;
        }
        return null;
    }

    @Override
    public ScriptTable getScriptTable() {
        return AppModelScript.getScriptTable();
    }

    int getSourceAbove() {
        return this.meSourceAbove;
    }

    @Override
    public int getSourceBelow() {
        return this.meSourceBelow;
    }

    Node getThis() {
        return this.getContext();
    }

    public int getVersionRestriction() {
        return this.mnMaxVersionAllowed;
    }

    @Override
    public boolean getWillDirty() {
        Document document = this.getDocument();
        if (document == null) {
            return false;
        }
        return document.getWillDirty();
    }

    @Override
    public void insertChild(Node newChild, Node refChild, boolean bValidate) {
        assert (null != newChild);
        if (newChild instanceof Model) {
            Model newModel = (Model)newChild;
            super.insertChild(newModel, refChild, bValidate);
            newModel.setAppModel(this);
        } else {
            super.insertChild(newChild, refChild, bValidate);
        }
    }

    @Override
    public boolean isValidAttr(int eTag, boolean bReport, String value) {
        return eTag == 400 || eTag == 699;
    }

    @Override
    public boolean isValidChild(int eTag, int nError, boolean bBeforeInsert, boolean bOccurrenceErrorOnly) {
        if (eTag == 220) {
            return true;
        }
        return super.isValidChild(eTag, nError, bBeforeInsert, bOccurrenceErrorOnly);
    }

    public boolean isXFANode(String uri, String localName, String qName) {
        return localName == "xfa" ? uri == "" || uri.startsWith("http://www.xfa.org/schema/") : localName == "xdp" && uri != "" && uri.startsWith("http://ns.adobe.com/xdp/");
    }

    public static boolean isXFANode(Element node) {
        String uri;
        String localName = node.getName();
        if (localName == "xfa") {
            String uri2 = node.getNS();
            if (uri2 == "" || uri2.startsWith("http://www.xfa.org/schema/")) {
                return true;
            }
            if (uri2 != "" && uri2.startsWith("http://ns.adobe.com/xdp/")) {
                return true;
            }
        } else if (localName == "xdp" && (uri = node.getNS()) != "" && uri.startsWith("http://ns.adobe.com/xdp/")) {
            return true;
        }
        return false;
    }

    public Obj lookupPseudoModel(String sShortCutName) {
        return this.mExtraShortCuts.get(sShortCutName);
    }

    public Element newDOM() {
        while (this.getFirstXFAChild() != null) {
            this.getFirstXFAChild().remove();
        }
        this.mEventManager.reset();
        Document doc = this.getDocument();
        while (doc.getFirstXMLChild() != null) {
            doc.getFirstXMLChild().remove();
        }
        doc.isDefaultDocument(false);
        ModelPeer xmlPeer = new ModelPeer(doc, null, "", "xfa", "xfa", null, this);
        xmlPeer.setModel(this);
        this.setXmlPeer(xmlPeer);
        this.createDOM((Element)this.getXmlPeer());
        return this;
    }

    @Override
    protected void postLoad() {
        if (this.mPacketHandler != null) {
            Node child = this.getFirstXMLChild();
            while (child != null) {
                Node nextChild = child.getNextXMLSibling();
                this.mPacketHandler.filterPackets(child, this.mHandlerData);
                child = nextChild;
            }
        }
    }

    @Override
    public void preSave(boolean bSaveXMLScript) {
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            child.preSave(bSaveXMLScript);
        }
    }

    @Override
    public boolean ready(boolean bForced) {
        boolean bRet = false;
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!(child instanceof Model)) continue;
            Model model = (Model)child;
            bRet |= model.ready(bForced);
        }
        return bRet;
    }

    void preSaveXML() {
    }

    @Override
    public boolean publish(Model.Publisher publisher) {
        boolean bRet = true;
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!(child instanceof Model)) continue;
            bRet &= ((Model)child).publish(publisher);
        }
        return bRet;
    }

    public void removePseudoModel(String sShortCutName) {
        this.mExtraShortCuts.remove(sShortCutName);
    }

    void resetPseudoModelEvents() {
        for (Obj obj : this.mExtraShortCuts.values()) {
            EventManager.resetEventTable(obj.getEventTable(false));
        }
    }

    void setAllowThirdPartyXml(boolean bAllowThirdPartyXml) {
        this.mbAllowThirdPartyXml = bAllowThirdPartyXml;
    }

    @Override
    public void setAttribute(Attribute oValue, int eAttributeTag) {
        if (eAttributeTag != 400 && eAttributeTag != 699) {
            MsgFormat oMessage = new MsgFormat(ResId.InvalidSetPropertyException);
            oMessage.format(this.getClassAtom());
            oMessage.format(oValue.getLocalName());
            throw new ExFull(oMessage);
        }
        this.updateAttribute(oValue);
    }

    public void setExternalProtosAreTransient(boolean bExternalProtosAreTransient) {
        this.mbExternalProtosAreTransient = bExternalProtosAreTransient;
    }

    public void setFragmentSearchPath(List<String> oSearchPath) {
        this.moFragmentSearchPath = oSearchPath;
    }

    public void setHrefHandler(HrefHandler handler) {
        this.mHrefHandler = handler;
    }

    public void setIsFragmentDoc(boolean bIsFragmentDoc) {
        this.mbIsFragmentDoc = bIsFragmentDoc;
    }

    @Override
    void setLogMessenger(LogMessenger oMessenger) {
        if (oMessenger == null) {
            return;
        }
        if (this.mMessenger == oMessenger) {
            return;
        }
        if (oMessenger != null) {
            List<LogMessage> oMessages = this.mMessenger.storedMsgArray();
            for (int i = 0; i < oMessages.size(); ++i) {
                LogMessage oMessage = oMessages.get(i);
                oMessenger.sendMessage(oMessage);
            }
        }
        this.mMessenger = oMessenger;
    }

    public void setPacketHandler(PacketHandler oPacketHandler, Object oHandlerData) {
        this.mPacketHandler = oPacketHandler;
        this.mHandlerData = oHandlerData;
    }

    public void setPacketList(String sPackets) {
        this.msPackets = sPackets;
    }

    public void setResolveAllExternalProtos(boolean bResolveAllExternalProtos) {
        this.mbResolveAllExternalProtos = bResolveAllExternalProtos;
    }

    public void setSourceAbove(int eSouceAbove) {
        this.meSourceAbove = eSouceAbove;
    }

    public void setSourceBelow(int eSouceBelow) {
        this.meSourceBelow = eSouceBelow;
    }

    public void setVersionRestriction(int nVersion, int eOutputBelow) {
        this.mnMaxVersionAllowed = nVersion;
        this.meOutputBelow = eOutputBelow;
    }

    @Override
    public void setWillDirty(boolean bWillDirty) {
        this.getDocument().setWillDirty(bWillDirty);
    }

    public boolean updateOriginalVersion() {
        return this.mbUpdateOriginalVersion;
    }

    public void updateOriginalVersion(boolean bUpdate) {
        this.mbUpdateOriginalVersion = bUpdate;
    }

    static {
        XFA_LEGACY_32_DEPRECATED = XFA_LEGACY_31_DEPRECATED = (XFA_LEGACY_30_DEPRECATED = (XFA_LEGACY_29_DEPRECATED = (XFA_LEGACY_28_DEPRECATED = (XFA_LEGACY_27_DEPRECATED = (XFA_LEGACY_26_DEPRECATED = (XFA_LEGACY_25_DEPRECATED = (XFA_LEGACY_24_DEPRECATED = (XFA_LEGACY_23_DEPRECATED = (XFA_LEGACY_22_DEPRECATED = (XFA_LEGACY_21_DEPRECATED = new LegacyMask(0)))))))))));
        XFA_LEGACY_HEAD_DEPRECATED = XFA_LEGACY_35_DEPRECATED = (XFA_LEGACY_34_DEPRECATED = (XFA_LEGACY_33_DEPRECATED = LegacyMask.or(new LegacyMask[]{XFA_LEGACY_32_DEPRECATED, XFA_LEGACY_RENDERING, XFA_LEGACY_POSITIONING})));
        gAppSchema = new AppSchema();
        getPseudoModelPropObj = new ScriptDynamicPropObj(10, 63){

            @Override
            public boolean invokeGetProp(Obj scriptThis, Arg retValue, String sPropertyName) {
                return AppModelScript.getPseudoModelFunc(scriptThis, retValue, sPropertyName);
            }
        };
    }

    public static class LegacyMask {
        private static final int LegacyMask_BitSize = 2;
        private int[] nBits;

        public LegacyMask(int nBitsIdx) {
            this(nBitsIdx, 0);
        }

        public LegacyMask(int nBitsIdx, int nIndex) {
            assert (nIndex < 2);
            this.nBits = new int[2];
            for (int i = 0; i < 2; ++i) {
                this.nBits[i] = 0;
            }
            if (nIndex >= 2) {
                return;
            }
            int n = nIndex;
            this.nBits[n] = this.nBits[n] | nBitsIdx;
        }

        public LegacyMask(LegacyMask inLegacyMask) {
            this.nBits = new int[2];
            for (int i = 0; i < 2; ++i) {
                this.nBits[i] = inLegacyMask.nBits[i];
            }
        }

        public boolean isNonZero() {
            for (int i = 0; i < 2; ++i) {
                if (this.nBits[i] == 0) continue;
                return true;
            }
            return false;
        }

        public LegacyMask and(LegacyMask lm) {
            LegacyMask lmRes = new LegacyMask(0);
            for (int i = 0; i < 2; ++i) {
                lmRes.nBits[i] = lm.nBits[i] & this.nBits[i];
            }
            return lmRes;
        }

        public LegacyMask or_n_set(LegacyMask lm) {
            for (int i = 0; i < 2; ++i) {
                int n = i;
                this.nBits[n] = this.nBits[n] | lm.nBits[i];
            }
            return this;
        }

        public void set(LegacyMask lm) {
            for (int i = 0; i < 2; ++i) {
                this.nBits[i] = lm.nBits[i];
            }
        }

        public LegacyMask not() {
            LegacyMask lmRes = new LegacyMask(0);
            for (int i = 0; i < 2; ++i) {
                lmRes.nBits[i] = ~this.nBits[i];
            }
            return lmRes;
        }

        public LegacyMask or(LegacyMask lmIn) {
            LegacyMask lmRes = new LegacyMask(0);
            for (int i = 0; i < 2; ++i) {
                lmRes.nBits[i] = lmIn.nBits[i] | this.nBits[i];
            }
            return lmRes;
        }

        public static LegacyMask or(LegacyMask[] lmArr) {
            LegacyMask lmRes = new LegacyMask(0);
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < lmArr.length; ++j) {
                    int n = i;
                    lmRes.nBits[n] = lmRes.nBits[n] | lmArr[j].nBits[i];
                }
            }
            return lmRes;
        }

        public boolean equals(Object objRight) {
            if (!(objRight instanceof LegacyMask)) {
                return false;
            }
            LegacyMask lmRight = (LegacyMask)objRight;
            for (int i = 0; i < 2; ++i) {
                if (this.nBits[i] == lmRight.nBits[i]) continue;
                return false;
            }
            return true;
        }
    }
}

