/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.font;

import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontDescription;

public class FontInfo
implements Comparable<FontInfo> {
    public static final int WEIGHT_UNKNOWN = 0;
    public static final int WEIGHT_NORMAL = 400;
    public static final int WEIGHT_BOLD = 700;
    public static final int STYLE_UNKNOWN = -1;
    public static final int STYLE_UPRIGHT = 0;
    public static final int STYLE_ITALIC = 1;
    private static final double LEGACY_SAMPLE_FONT_SIZE = 10.0;
    private final String mTypeface;
    private final int mWeight;
    private final boolean mItalic;
    private final double mLegacySizeDiff;
    private final int mStretchDiff;

    public FontInfo() {
        this("", 400, false, 0.0, 0);
    }

    public FontInfo(FontInfo source) {
        this(source.mTypeface, source.mWeight, source.mItalic, source.mLegacySizeDiff, source.mStretchDiff);
    }

    public FontInfo(String typeface, int weight, boolean italic) {
        this(typeface, weight, italic, 0.0, 0);
    }

    public FontInfo(String typeface, int weight, boolean italic, double legacySizeDiff, int stretchDiff) {
        this.mTypeface = typeface;
        this.mWeight = weight;
        this.mItalic = italic;
        this.mLegacySizeDiff = legacySizeDiff;
        this.mStretchDiff = stretchDiff;
    }

    public String getTypeface() {
        return this.mTypeface;
    }

    public int getWeight() {
        return this.mWeight;
    }

    public boolean getItalic() {
        return this.mItalic;
    }

    public double getLegacySizeDiff() {
        return this.mLegacySizeDiff;
    }

    public int getStretchDiff() {
        return this.mStretchDiff;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        FontInfo other = (FontInfo)object;
        if (this.mWeight != other.mWeight || this.mItalic != other.mItalic) {
            return false;
        }
        return this.mTypeface.equals(other.mTypeface);
    }

    public static FontInfo createFromAFEDescription(CSS20FontDescription desc) {
        boolean italic = desc.getStyle() != CSS20Attribute.CSSStyleValue.NORMAL;
        return new FontInfo(desc.getFamilyName(), desc.getWeight(), italic, FontInfo.getLegacySizeDiff(desc), FontInfo.getStretchDiff(desc));
    }

    public static boolean match(FontInfo o1, FontInfo o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public int hashCode() {
        int result = this.mWeight;
        result = result * 31 ^ Boolean.valueOf(this.mItalic).hashCode();
        return result * 31 ^ this.mTypeface.hashCode();
    }

    public String toString() {
        String result = "Typeface: " + this.mTypeface;
        result = result + ", Weight: " + (this.mWeight >= 700 ? "bold" : "normal");
        result = result + ", Italic: " + (this.mItalic ? "on" : "off");
        return result;
    }

    @Override
    public int compareTo(FontInfo other) {
        if (other == null) {
            throw new NullPointerException();
        }
        int result = this.mTypeface.compareTo(other.mTypeface);
        if (result != 0) {
            return result;
        }
        if (this.mItalic != other.mItalic) {
            return this.mItalic ? 1 : -1;
        }
        if (this.mWeight < other.mWeight) {
            return -1;
        }
        if (this.mWeight > other.mWeight) {
            return 1;
        }
        return 0;
    }

    static double getLegacySizeDiff(CSS20FontDescription desc) {
        double minSize = desc.getLowPointSize();
        double maxSize = desc.getHighPointSize();
        if (10.0 < minSize) {
            return minSize - 10.0;
        }
        if (10.0 > maxSize) {
            return 10.0 - maxSize;
        }
        return 0.0;
    }

    static int getStretchDiff(CSS20FontDescription desc) {
        CSS20Attribute.CSSStretchValue stretch = desc.getStretch();
        if (stretch == CSS20Attribute.CSSStretchValue.SEMICONDENSED || stretch == CSS20Attribute.CSSStretchValue.SEMIEXPANDED) {
            return 1;
        }
        if (stretch == CSS20Attribute.CSSStretchValue.CONDENSED || stretch == CSS20Attribute.CSSStretchValue.EXPANDED) {
            return 2;
        }
        if (stretch == CSS20Attribute.CSSStretchValue.EXTRACONDENSED || stretch == CSS20Attribute.CSSStretchValue.EXTRAEXPANDED) {
            return 3;
        }
        if (stretch == CSS20Attribute.CSSStretchValue.ULTRACONDENSED || stretch == CSS20Attribute.CSSStretchValue.ULTRAEXPANDED) {
            return 4;
        }
        return 0;
    }
}

