/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.formcalc;

import com.adobe.xfa.formcalc.BuiltinDate;
import com.adobe.xfa.formcalc.BuiltinEncode;
import com.adobe.xfa.formcalc.BuiltinFinancial;
import com.adobe.xfa.formcalc.BuiltinLogical;
import com.adobe.xfa.formcalc.BuiltinMath;
import com.adobe.xfa.formcalc.BuiltinMisc;
import com.adobe.xfa.formcalc.BuiltinScientific;
import com.adobe.xfa.formcalc.BuiltinString;
import com.adobe.xfa.formcalc.BuiltinUnit;
import com.adobe.xfa.formcalc.CalcException;
import com.adobe.xfa.formcalc.CalcParser;
import com.adobe.xfa.formcalc.CalcSymbol;
import com.adobe.xfa.formcalc.SymbolTable;
import java.lang.reflect.Method;
import java.util.Locale;

final class Builtins {
    private Builtins() {
    }

    static void init(SymbolTable oTable) {
        Builtins.add(oTable, "Abs", BuiltinMath.class);
        Builtins.add(oTable, "Avg", BuiltinMath.class);
        Builtins.add(oTable, "Ceil", BuiltinMath.class);
        Builtins.add(oTable, "Count", BuiltinMath.class);
        Builtins.add(oTable, "Floor", BuiltinMath.class);
        Builtins.add(oTable, "Max", BuiltinMath.class);
        Builtins.add(oTable, "Min", BuiltinMath.class);
        Builtins.add(oTable, "Mod", BuiltinMath.class);
        Builtins.add(oTable, "Round", BuiltinMath.class);
        Builtins.add(oTable, "Sum", BuiltinMath.class);
        Builtins.add(oTable, "Date", BuiltinDate.class);
        Builtins.add(oTable, "Date2Num", BuiltinDate.class);
        Builtins.add(oTable, "DateFmt", BuiltinDate.class);
        Builtins.add(oTable, "DateTimeFmt", BuiltinDate.class);
        Builtins.add(oTable, "IsoDate2Num", BuiltinDate.class);
        Builtins.add(oTable, "IsoTime2Num", BuiltinDate.class);
        Builtins.add(oTable, "LocalDateFmt", BuiltinDate.class);
        Builtins.add(oTable, "LocalTimeFmt", BuiltinDate.class);
        Builtins.add(oTable, "Num2Date", BuiltinDate.class);
        Builtins.add(oTable, "Num2GmTime", BuiltinDate.class);
        Builtins.add(oTable, "Num2Time", BuiltinDate.class);
        Builtins.add(oTable, "Time", BuiltinDate.class);
        Builtins.add(oTable, "Time2Num", BuiltinDate.class);
        Builtins.add(oTable, "TimeFmt", BuiltinDate.class);
        Builtins.add(oTable, "Apr", BuiltinFinancial.class);
        Builtins.add(oTable, "Cterm", BuiltinFinancial.class);
        Builtins.add(oTable, "Fv", BuiltinFinancial.class);
        Builtins.add(oTable, "Ipmt", BuiltinFinancial.class);
        Builtins.add(oTable, "Npv", BuiltinFinancial.class);
        Builtins.add(oTable, "Pmt", BuiltinFinancial.class);
        Builtins.add(oTable, "Ppmt", BuiltinFinancial.class);
        Builtins.add(oTable, "Pv", BuiltinFinancial.class);
        Builtins.add(oTable, "Rate", BuiltinFinancial.class);
        Builtins.add(oTable, "Term", BuiltinFinancial.class);
        Builtins.add(oTable, "Choose", BuiltinLogical.class);
        Builtins.add(oTable, "Exists", BuiltinLogical.class);
        Builtins.add(oTable, "HasValue", BuiltinLogical.class);
        Builtins.add(oTable, "If", BuiltinLogical.class);
        Builtins.add(oTable, "Oneof", BuiltinLogical.class);
        Builtins.add(oTable, "Throw", BuiltinLogical.class);
        Builtins.add(oTable, "Within", BuiltinLogical.class);
        Builtins.add(oTable, "Eval", BuiltinMisc.class);
        Builtins.add(oTable, "Ref", BuiltinMisc.class);
        Builtins.add(oTable, "Acos", BuiltinScientific.class);
        Builtins.add(oTable, "Asin", BuiltinScientific.class);
        Builtins.add(oTable, "Atan", BuiltinScientific.class);
        Builtins.add(oTable, "Atan2", BuiltinScientific.class);
        Builtins.add(oTable, "Cos", BuiltinScientific.class);
        Builtins.add(oTable, "Deg2Rad", BuiltinScientific.class);
        Builtins.add(oTable, "Exp", BuiltinScientific.class);
        Builtins.add(oTable, "Log", BuiltinScientific.class);
        Builtins.add(oTable, "Pi", BuiltinScientific.class);
        Builtins.add(oTable, "Pow", BuiltinScientific.class);
        Builtins.add(oTable, "Rad2Deg", BuiltinScientific.class);
        Builtins.add(oTable, "Sin", BuiltinScientific.class);
        Builtins.add(oTable, "Sqrt", BuiltinScientific.class);
        Builtins.add(oTable, "Tan", BuiltinScientific.class);
        Builtins.add(oTable, "At", BuiltinString.class);
        Builtins.add(oTable, "Concat", BuiltinString.class);
        Builtins.add(oTable, "Format", BuiltinString.class);
        Builtins.add(oTable, "Left", BuiltinString.class);
        Builtins.add(oTable, "Len", BuiltinString.class);
        Builtins.add(oTable, "Lower", BuiltinString.class);
        Builtins.add(oTable, "Ltrim", BuiltinString.class);
        Builtins.add(oTable, "NumFmt", BuiltinString.class);
        Builtins.add(oTable, "Parse", BuiltinString.class);
        Builtins.add(oTable, "Replace", BuiltinString.class);
        Builtins.add(oTable, "Right", BuiltinString.class);
        Builtins.add(oTable, "Rtrim", BuiltinString.class);
        Builtins.add(oTable, "Space", BuiltinString.class);
        Builtins.add(oTable, "Str", BuiltinString.class);
        Builtins.add(oTable, "Stuff", BuiltinString.class);
        Builtins.add(oTable, "Substr", BuiltinString.class);
        Builtins.add(oTable, "Uuid", BuiltinString.class);
        Builtins.add(oTable, "Upper", BuiltinString.class);
        Builtins.add(oTable, "WordNum", BuiltinString.class);
        Builtins.add(oTable, "Encode", BuiltinEncode.class);
        Builtins.add(oTable, "Decode", BuiltinEncode.class);
        Builtins.add(oTable, "UnitValue", BuiltinUnit.class);
        Builtins.add(oTable, "UnitType", BuiltinUnit.class);
    }

    static void add(SymbolTable oTable, String name, Class<?> c) {
        block2: {
            CalcSymbol oSym = oTable.install(name.toUpperCase(Locale.US));
            oSym.setType(4);
            try {
                Class[] parms = new Class[]{CalcParser.class, CalcSymbol[].class};
                Method func = c.getDeclaredMethod(name, parms);
                oSym.setFuncValue(func);
            }
            catch (NoSuchMethodException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    static void minArgs(int nCount, int nMin) {
        if (nCount < nMin) {
            throw new CalcException();
        }
    }

    static void maxArgs(int nCount, int nLimit) {
        if (nCount > nLimit) {
            throw new CalcException();
        }
    }

    static void limitNullArgs(CalcParser oParser, int nArgs, CalcSymbol[] oSymArray) {
        for (int i = 0; i < nArgs; ++i) {
            if (oSymArray[i].getType() == 9) {
                CalcSymbol[] oSym = oParser.moScriptHost.getItemValue(oSymArray[i].getName(), oSymArray[i].getObjValues());
                CalcSymbol.delete(oSymArray[i], oParser);
                oSymArray[i] = oSym[0];
                for (int j = oSym.length - 1; j > 0; --j) {
                    CalcSymbol.delete(oSym[j], oParser);
                }
            }
            if (oSymArray[i].getType() != 1) continue;
            throw new CalcException(oSymArray[i]);
        }
    }

    static void limitExceptionArgs(CalcSymbol[] oSymArray) {
        int i;
        for (i = 0; i < oSymArray.length; ++i) {
            if (oSymArray[i].getType() != 0) continue;
            throw new CalcException(oSymArray[i]);
        }
        for (i = 0; i < oSymArray.length; ++i) {
            if (oSymArray[i].getType() != 10) continue;
            throw new CalcException(oSymArray[i]);
        }
    }

    static CalcSymbol[] limitAllNullArgs(CalcParser oParser, CalcSymbol[] oSymArray) {
        for (int i = 0; i < oSymArray.length; ++i) {
            CalcSymbol symbol = oSymArray[i];
            if (symbol.getType() == 9) {
                try {
                    CalcSymbol[] oSym = oParser.moScriptHost.getItemValue(symbol.getName(), symbol.getObjValues());
                    int nSyms = oSym.length;
                    if (nSyms > 1) {
                        CalcSymbol[] oNewArray = new CalcSymbol[oSymArray.length + nSyms - 1];
                        System.arraycopy(oSymArray, 0, oNewArray, 0, i);
                        System.arraycopy(oSymArray, i + 1, oNewArray, nSyms + i, oSymArray.length - i - 1);
                        oSymArray = oNewArray;
                    }
                    CalcSymbol.delete(symbol, oParser);
                    System.arraycopy(oSym, 0, oSymArray, i, nSyms);
                }
                catch (CalcException e) {
                    CalcSymbol.delete(symbol, oParser);
                    oSymArray[i] = e.getSymbol();
                }
            }
            if (oSymArray[i].getType() == 1) continue;
            return oSymArray;
        }
        throw new CalcException();
    }
}

