/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.StrAttr;
import com.adobe.xfa.text.StrItem;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextGfxSource;
import com.adobe.xfa.text.TextPosn;
import com.adobe.xfa.text.TextRange;
import com.adobe.xfa.text.TextStream;

class LoadText {
    private TextStream mpoSource;
    private int mnStartMajor;
    private int mnStartMinor;
    private int mnEndMajor;
    private int mnEndMinor;
    private final TextGfxSource moGfxSource;
    private TextAttr mpoInitAttr;

    LoadText(TextStream oSource, TextGfxSource oGfxSource) {
        this.moGfxSource = oGfxSource;
        this.mpoInitAttr = null;
        TextRange oRangeAll = new TextRange(oSource, 0, Integer.MAX_VALUE);
        this.initialize(oRangeAll.position(2), oRangeAll.position(3));
    }

    LoadText(TextPosn oStart, TextPosn oEnd, TextGfxSource oGfxSource) {
        this.moGfxSource = oGfxSource;
        this.mpoInitAttr = oStart.attributePtr();
        this.initialize(oStart, oEnd);
    }

    int size() {
        int nSize = this.mnEndMajor - this.mnStartMajor;
        if (this.mnEndMinor > 0) {
            ++nSize;
        }
        if (this.mpoInitAttr != null) {
            ++nSize;
        }
        return nSize;
    }

    StrItem nextItem() {
        StrItem poCopy;
        if (this.mpoInitAttr != null) {
            poCopy = new StrAttr(this.mpoInitAttr, this.moGfxSource, 0);
            this.mpoInitAttr = null;
        } else {
            StrItem poSource = this.mpoSource.getItem(this.mnStartMajor);
            int nCloneSize = this.mnStartMajor == this.mnEndMajor ? this.mnEndMinor - this.mnStartMinor : poSource.count() - this.mnStartMinor;
            poCopy = poSource.clonePart(this.moGfxSource, this.mnStartMinor, nCloneSize);
            ++this.mnStartMajor;
            this.mnStartMinor = 0;
        }
        return poCopy;
    }

    int maxSize() {
        return this.mpoSource.maxSize();
    }

    boolean allowNewLines() {
        return this.mpoSource.allowNewLines();
    }

    private void initialize(TextPosn oStart, TextPosn oEnd) {
        this.mpoSource = oStart.stream();
        this.mnStartMajor = oStart.major();
        this.mnStartMinor = oStart.minor();
        this.mnEndMajor = oEnd.major();
        this.mnEndMinor = oEnd.minor();
    }
}

