/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.font.FontInstance;
import com.adobe.xfa.text.Units;
import com.adobe.xfa.ut.UnitSpan;

public class TextMeasurement {
    public static final int TYPE_LENGTH = 0;
    public static final int TYPE_EM = 1;
    public static final int TYPE_PERCENT = 2;
    public static final int DEFAULT_PRECISION = 6;
    public static final TextMeasurement ZERO = new TextMeasurement();
    private final int meType;
    private final UnitSpan moLength;
    private final double mdScale;

    public TextMeasurement() {
        this.meType = 0;
        this.moLength = UnitSpan.ZERO;
        this.mdScale = 0.0;
    }

    public TextMeasurement(UnitSpan oLength) {
        this.meType = 0;
        this.moLength = oLength == null ? UnitSpan.ZERO : oLength;
        this.mdScale = 0.0;
    }

    public TextMeasurement(int eType, double dScale) {
        this.meType = eType;
        this.moLength = null;
        this.mdScale = dScale;
    }

    public UnitSpan flatten(FontInstance oFontInstance) {
        double dWidth;
        if (this.meType == 0) {
            return this.moLength;
        }
        if (this.mdScale == 0.0) {
            return UnitSpan.ZERO;
        }
        assert (oFontInstance != null);
        UnitSpan oResult = oFontInstance.getSize();
        if (this.meType == 2 && (dWidth = oFontInstance.getDoubleCharWidth(32, true)) > 0.0) {
            oResult = new UnitSpan(dWidth, 19);
        }
        return oResult.multiply(this.mdScale);
    }

    public UnitSpan flatten(UnitSpan oBaseValue) {
        return this.meType == 0 ? this.moLength : oBaseValue.multiply(this.mdScale);
    }

    public int getType() {
        return this.meType;
    }

    public UnitSpan getLength() {
        return this.moLength;
    }

    public int getLengthValue() {
        return this.moLength.value();
    }

    public double getScale() {
        return this.mdScale;
    }

    public boolean isZero() {
        return this.meType == 0 ? this.moLength.value() == 0 : this.mdScale == 0.0;
    }

    public static TextMeasurement fromString(String sValue, int eDefaultUnits, boolean bValuePerUnit) {
        int eType;
        UnitSpan.ParseData oParseData = UnitSpan.validatingParse(sValue, eDefaultUnits, true, bValuePerUnit, true);
        if (oParseData == null) {
            return null;
        }
        if (oParseData.mbValuePerUnit) {
            return null;
        }
        if (oParseData.meUnits != 255) {
            return new TextMeasurement(new UnitSpan(oParseData.meUnits, oParseData.mnValue));
        }
        double dValue = oParseData.mnValue;
        if (oParseData.mnFraction != 0) {
            dValue += (double)oParseData.mnFraction / (double)oParseData.mnFractionScale;
        }
        if (oParseData.mbPercent) {
            eType = 2;
            dValue /= 100.0;
        } else {
            if (oParseData.mcUnit2 != '\u0000') {
                return null;
            }
            eType = 1;
            char c0 = oParseData.mcUnit0;
            char c1 = oParseData.mcUnit1;
            if (c0 != 'e' && c0 != 'E' || c1 != 'm' && c1 != 'M') {
                return null;
            }
        }
        return new TextMeasurement(eType, dValue);
    }

    public static TextMeasurement fromString(String sValue, int eDefaultUnits) {
        return TextMeasurement.fromString(sValue, eDefaultUnits, false);
    }

    public static TextMeasurement fromString(String sValue) {
        return TextMeasurement.fromString(sValue, 255, false);
    }

    public String toString(int nPrecision) {
        StringBuilder sResult = new StringBuilder();
        switch (this.meType) {
            case 1: {
                sResult.append(Units.doubleToString(this.mdScale, nPrecision));
                sResult.append('e');
                sResult.append('m');
                break;
            }
            case 2: {
                sResult.append(Units.doubleToString(this.mdScale * 100.0, nPrecision));
                sResult.append('%');
                break;
            }
            default: {
                sResult.append(this.moLength.text(nPrecision, true, false));
            }
        }
        return sResult.toString();
    }

    public static boolean match(TextMeasurement m1, TextMeasurement m2) {
        if (m1 == m2) {
            return true;
        }
        if (m1 == null || m2 == null) {
            return false;
        }
        return m1.equals(m2);
    }

    public String toString() {
        return this.toString(6);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        TextMeasurement compare = (TextMeasurement)object;
        if (this.meType != compare.meType) {
            return false;
        }
        if (this.meType == 0) {
            return UnitSpan.match(this.moLength, compare.moLength);
        }
        return this.mdScale == compare.mdScale;
    }

    public int hashCode() {
        int hash = Integer.valueOf(this.meType).hashCode();
        if (this.meType == 0) {
            hash = hash * 31 ^ this.moLength.hashCode();
        }
        long bits = Double.doubleToLongBits(this.mdScale);
        hash = hash * 31 ^ (int)(bits ^ bits >>> 32);
        return hash;
    }

    public static TextMeasurement zero() {
        return ZERO;
    }
}

