/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.Pkg;
import com.adobe.xfa.text.TextTab;
import com.adobe.xfa.ut.UnitSpan;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class TextTabList {
    public static final TextTabList DEFAULT_TAB_LIST = new TextTabList();
    private SortedMap<UnitSpan, TextTab> moTabs;
    private TextTab moUniform;

    public TextTabList() {
        this.moUniform = TextTab.DEFAULT_TAB;
    }

    public TextTabList(TextTabList oSource) {
        if (oSource.moTabs != null) {
            this.moTabs = new TreeMap<UnitSpan, TextTab>(oSource.moTabs);
        }
        this.moUniform = oSource.moUniform;
    }

    public TextTab uniform() {
        return this.noUniform() ? TextTab.DEFAULT_TAB : this.moUniform;
    }

    public void uniform(TextTab oNewUniform) {
        if (oNewUniform.value() <= 0) {
            return;
        }
        this.moUniform = oNewUniform;
    }

    public boolean noUniform() {
        return this.moUniform.value() == 0;
    }

    public void noUniform(boolean bNoUniform) {
        if (bNoUniform) {
            this.moUniform = TextTab.ZERO_TAB;
        } else if (this.moUniform.value() == 0) {
            this.moUniform = TextTab.DEFAULT_TAB;
        }
    }

    public void set(TextTab oSet) {
        if (this.moTabs == null) {
            this.moTabs = new TreeMap<UnitSpan, TextTab>();
        }
        this.moTabs.put(oSet.tabStop(), oSet);
    }

    public void clear(TextTab oClear) {
        if (this.moTabs != null) {
            this.moTabs.remove(oClear.tabStop());
        }
    }

    public void clearAll() {
        if (this.moTabs != null) {
            this.moTabs.clear();
        }
        this.moUniform = TextTab.DEFAULT_TAB;
    }

    public int size() {
        return this.moTabs == null ? 0 : this.moTabs.size();
    }

    public TextTab next(UnitSpan oPosition) {
        if (this.moTabs != null) {
            for (TextTab textTab : this.moTabs.values()) {
                if (textTab.tabStop().compareTo(oPosition) <= 0) continue;
                return textTab;
            }
        }
        if (this.noUniform()) {
            return TextTab.ZERO_TAB;
        }
        UnitSpan oValue = oPosition.grid(this.moUniform.tabStop());
        oValue = oValue.add(this.moUniform.tabStop());
        return new TextTab(oValue, this.moUniform.tabType());
    }

    public TextTab prev(UnitSpan oPosition) {
        if (oPosition.value() <= 0) {
            return TextTab.ZERO_TAB;
        }
        if (this.moTabs == null) {
            return TextTab.ZERO_TAB;
        }
        TextTab oLastTab = TextTab.ZERO_TAB;
        if (this.moTabs.size() > 0 && oPosition.lte((oLastTab = (TextTab)this.moTabs.get(this.moTabs.lastKey())).tabStop())) {
            UnitSpan previous = null;
            for (UnitSpan currentPosition : this.moTabs.keySet()) {
                if (oPosition.compareTo(currentPosition) >= 0) {
                    if (previous == null) {
                        return TextTab.ZERO_TAB;
                    }
                    return (TextTab)this.moTabs.get(previous);
                }
                previous = currentPosition;
            }
        }
        if (this.noUniform()) {
            return oLastTab;
        }
        UnitSpan oUniform = oPosition.grid(this.moUniform.tabStop());
        if (oUniform.equals(oPosition)) {
            oUniform = oUniform.subtract(this.moUniform.tabStop());
        }
        if (this.moTabs.size() > 0 && oLastTab.tabStop().gte(oUniform)) {
            return oLastTab;
        }
        return new TextTab(oUniform, this.moUniform.tabType());
    }

    public void copyFrom(TextTabList oSource) {
        this.moUniform = oSource.moUniform;
        this.moTabs = oSource.moTabs == null ? null : new TreeMap<UnitSpan, TextTab>(oSource.moTabs);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        TextTabList compare = (TextTabList)object;
        if (!this.moUniform.equals(compare.moUniform)) {
            return false;
        }
        if (this.size() != compare.size()) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        Iterator<TextTab> it1 = this.moTabs.values().iterator();
        Iterator<TextTab> it2 = compare.moTabs.values().iterator();
        while (it1.hasNext()) {
            if (it1.next().equals(it2.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 71;
        hash = hash * 31 ^ this.moUniform.hashCode();
        if (this.moTabs != null) {
            for (TextTab textTab : this.moTabs.values()) {
                hash = hash * 31 ^ textTab.hashCode();
            }
        }
        return hash;
    }

    public boolean notEqual(TextTabList oCompare) {
        return !this.equals(oCompare);
    }

    public TextTab tabAt(int nIndex) {
        if (nIndex == 0) {
            return TextTab.ZERO_TAB;
        }
        int nTabs = this.size();
        if (nIndex <= nTabs) {
            return this.getTab(nIndex - 1);
        }
        UnitSpan oValue = null;
        if (nTabs > 0) {
            oValue = this.moTabs.lastKey();
        }
        oValue = this.next(oValue).tabStop();
        int lOffset = nIndex - nTabs - 1;
        UnitSpan stop = this.moUniform.tabStop();
        stop = stop.multiply(lOffset);
        stop = stop.add(oValue);
        return new TextTab(stop, this.moUniform.tabType());
    }

    public void debug() {
        this.debug(0);
    }

    void debug(int indent) {
        String prefix = Pkg.doIndent(indent + 1);
        System.out.println(prefix + "Tab list:");
        prefix = prefix + ' ';
        indent += 2;
        if (this.size() > 0) {
            System.out.println(prefix + "Tab stops:");
            for (TextTab textTab : this.moTabs.values()) {
                textTab.debug(indent);
            }
        }
        if (!this.noUniform()) {
            System.out.println(prefix + "Uniform:");
            this.uniform().debug(indent);
        }
    }

    private final TextTab getTab(int index) {
        int i = 0;
        for (TextTab textTab : this.moTabs.values()) {
            if (i == index) {
                return textTab;
            }
            ++i;
        }
        return null;
    }
}

