/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PerformanceReportRequest {
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH");
    private long campaignId;
    private Date start;
    private Date end;
    private String successMetric;
    private String step;

    public static PerformanceReportRequest forCampaignId(long campaignId) {
        if (campaignId <= 0L) {
            throw new IllegalArgumentException("Expected campaignId > 0, but got  " + campaignId);
        }
        PerformanceReportRequest request = new PerformanceReportRequest();
        request.campaignId = campaignId;
        return request;
    }

    public PerformanceReportRequest setStart(Date start) {
        this.start = start;
        return this;
    }

    public PerformanceReportRequest setEnd(Date end) {
        this.end = end;
        return this;
    }

    public PerformanceReportRequest setSuccessMetric(String successMetric) {
        this.successMetric = successMetric;
        return this;
    }

    public PerformanceReportRequest setStep(String step) {
        this.step = step;
        return this;
    }

    public String getSuccessMetric() {
        return this.successMetric;
    }

    public String getStep() {
        return this.step;
    }

    public long getCampaignId() {
        return this.campaignId;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public Map<String, String> getParameters() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        this.addParameter(paramMap, "successMetric", this.successMetric);
        this.addParameter(paramMap, "step", this.step);
        return paramMap;
    }

    private void addParameter(Map<String, String> destMap, String key, Object value) {
        if (destMap != null && key != null && value != null) {
            String valueStr = null;
            valueStr = value instanceof Date ? this.sdf.format((Date)value) : value.toString();
            destMap.put(key, valueStr);
        }
    }
}

