/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.api;

import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.commons.lang.StringUtils;
import org.osgi.service.event.Event;

public class DamEvent {
    public static final String EVENT_TOPIC = "com/day/cq/dam";
    private static final String PROPERTY_TYPE = "type";
    private static final String PROPERTY_DATE = "date";
    public static final String PROPERTY_EXPIRATIONDATE = "expirationDate";
    public static final String PROPERTY_CREATEDBY = "createdBy";
    private static final String PROPERTY_ASSETPATH = "assetPath";
    private static final String PROPERTY_USER_ID = "userId";
    public static final String PROPERTY_VERSION_ID = "versionId";
    public static final String PROPERTY_LICENSE_INFO = "licenseInfo";
    public static final String PROPERTY_ADDITIONAL_INFO = "additionalInfo";
    private static final String PROPERTY_DISTRIBUTABLE = "event.distribute";
    private final Type type;
    private final String assetPath;
    private final String userId;
    private final String versionId;
    private final String licenseInfo;
    private final String additionalInfo;
    private final Date date;
    private final Date expirationDate;
    private final String createdBy;

    private DamEvent(Type type, String assetPath, String userId, String licenseInfo, String versionId, String additionalInfo, Date date, Date expirationDate, String createdBy) {
        this.type = type;
        this.assetPath = assetPath;
        this.userId = userId;
        this.versionId = versionId;
        this.licenseInfo = licenseInfo;
        this.additionalInfo = additionalInfo;
        this.date = null != date ? date : new Date();
        this.expirationDate = expirationDate;
        this.createdBy = createdBy;
    }

    private DamEvent(Event event) {
        this.type = (Type)((Object)event.getProperty(PROPERTY_TYPE));
        this.assetPath = (String)event.getProperty(PROPERTY_ASSETPATH);
        this.userId = (String)event.getProperty(PROPERTY_USER_ID);
        this.licenseInfo = (String)event.getProperty(PROPERTY_LICENSE_INFO);
        this.versionId = (String)event.getProperty(PROPERTY_VERSION_ID);
        this.additionalInfo = (String)event.getProperty(PROPERTY_ADDITIONAL_INFO);
        this.date = (Date)event.getProperty(PROPERTY_DATE);
        this.expirationDate = (Date)event.getProperty(PROPERTY_EXPIRATIONDATE);
        this.createdBy = (String)event.getProperty(PROPERTY_CREATEDBY);
    }

    public String getAssetPath() {
        return this.assetPath;
    }

    public Date getDate() {
        return this.date;
    }

    public String getLicenseInfo() {
        return this.licenseInfo;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Type getType() {
        return this.type;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public boolean isPublishedExternally() {
        return Type.PUBLISHED_EXTERNAL == this.type;
    }

    public static DamEvent fromEvent(Event event) {
        return EVENT_TOPIC.equals(event.getTopic()) ? new DamEvent(event) : null;
    }

    public Event toEvent() {
        return new Event(EVENT_TOPIC, this.getDistributableEventProperties());
    }

    public Event toNonDistributableEvent() {
        return new Event(EVENT_TOPIC, this.getEventProperties());
    }

    public static DamEvent accepted(String assetPath, String userId, String licenseInfo) {
        return new DamEvent(Type.ACCEPTED, assetPath, userId, licenseInfo, null, null, null, null, null);
    }

    public static DamEvent rejected(String assetPath, String userId, String licenseInfo) {
        return new DamEvent(Type.REJECTED, assetPath, userId, licenseInfo, null, null, null, null, null);
    }

    public static DamEvent downloaded(String assetPath, String userId) {
        return new DamEvent(Type.DOWNLOADED, assetPath, userId, null, null, null, null, null, null);
    }

    public static DamEvent downloaded(String assetPath, String userId, String additionalInfo) {
        return new DamEvent(Type.DOWNLOADED, assetPath, userId, null, null, additionalInfo, null, null, null);
    }

    public static DamEvent versioned(String assetPath, String userId, String versionId) {
        return new DamEvent(Type.VERSIONED, assetPath, userId, null, versionId, null, null, null, null);
    }

    public static DamEvent restored(String assetPath, String userId, String versionId) {
        return new DamEvent(Type.RESTORED, assetPath, userId, null, versionId, null, null, null, null);
    }

    public static DamEvent metadataUpdated(String assetPath, String userId) {
        return new DamEvent(Type.METADATA_UPDATED, assetPath, userId, null, null, null, null, null, null);
    }

    public static DamEvent metadataUpdated(String assetPath, String userId, String additionalInfo) {
        return new DamEvent(Type.METADATA_UPDATED, assetPath, userId, null, null, additionalInfo, null, null, null);
    }

    public static DamEvent publishedExternally(String assetPath, String userId, String additionalInfo) {
        return new DamEvent(Type.PUBLISHED_EXTERNAL, assetPath, userId, null, null, additionalInfo, null, null, null);
    }

    public static DamEvent originalUpdated(String assetPath, String userId) {
        return new DamEvent(Type.ORIGINAL_UPDATED, assetPath, userId, null, null, null, null, null, null);
    }

    public static DamEvent renditionUpdated(String assetPath, String userId, String renditionPath) {
        return new DamEvent(Type.RENDITION_UPDATED, assetPath, userId, null, null, renditionPath, null, null, null);
    }

    public static DamEvent renditionRemoved(String assetPath, String userId, String renditionPath) {
        return new DamEvent(Type.RENDITION_REMOVED, assetPath, userId, null, null, renditionPath, null, null, null);
    }

    public static DamEvent renditionDownloaded(String assetPath, String userId, String renditionPath) {
        return new DamEvent(Type.RENDITION_DOWNLOADED, assetPath, userId, null, null, renditionPath, null, null, null);
    }

    public static DamEvent subassetUpdated(String assetPath, String userId, String subassetPath) {
        return new DamEvent(Type.SUBASSET_UPDATED, assetPath, userId, null, null, subassetPath, null, null, null);
    }

    public static DamEvent subassetRemoved(String assetPath, String userId, String subassetPath) {
        return new DamEvent(Type.SUBASSET_REMOVED, assetPath, userId, null, null, subassetPath, null, null, null);
    }

    public static DamEvent assetCreated(String assetPath, String userId) {
        return new DamEvent(Type.ASSET_CREATED, assetPath, userId, null, null, null, null, null, null);
    }

    public static DamEvent assetMoved(String assetPath, String userId) {
        return new DamEvent(Type.ASSET_MOVED, assetPath, userId, null, null, null, null, null, null);
    }

    public static DamEvent assetRemoved(String assetPath, String userId) {
        return new DamEvent(Type.ASSET_REMOVED, assetPath, userId, null, null, null, null, null, null);
    }

    public static DamEvent assetExpired(String assetPath, String userId, Date expirationDate, String createdBy) {
        return new DamEvent(Type.ASSET_EXPIRED, assetPath, userId, null, null, null, null, expirationDate, createdBy);
    }

    public static DamEvent assetExpiring(String assetPath, String userId, Date expirationDate, String createdBy) {
        return new DamEvent(Type.ASSET_EXPIRING, assetPath, userId, null, null, null, null, expirationDate, createdBy);
    }

    public static DamEvent assetViewed(String assetPath, String userId) {
        return new DamEvent(Type.ASSET_VIEWED, assetPath, userId, null, null, null, null, null, null);
    }

    public static DamEvent assetShared(String assetPath, String userId, String additionalInfo) {
        return new DamEvent(Type.ASSET_SHARED, assetPath, userId, null, null, additionalInfo, null, null, null);
    }

    public static DamEvent assetPublished(String assetPath, String userId) {
        return new DamEvent(Type.ASSET_PUBLISHED, assetPath, userId, null, null, null, null, null, null);
    }

    public static DamEvent projectViewed(String assetPath, String userId) {
        return new DamEvent(Type.PROJECT_VIEWED, assetPath, userId, null, null, null, null, null, null);
    }

    public static DamEvent collectionViewed(String assetPath, String userId) {
        return new DamEvent(Type.COLLECTION_VIEWED, assetPath, userId, null, null, null, null, null, null);
    }

    public static DamEvent addedComment(String assetPath, String userId, String additionalInfo) {
        return new DamEvent(Type.ADDED_COMMENT, assetPath, userId, null, null, additionalInfo, null, null, null);
    }

    public static DamEvent assetUsage(String assetPath, String usageType, Date date) {
        return new DamEvent(Type.ASSET_USAGE, assetPath, null, null, null, usageType, date, null, null);
    }

    public static DamEvent damUpdateAssetWorkflowCompleted(String assetPath) {
        return new DamEvent(Type.DAM_UPDATE_ASSET_WORKFLOW_COMPLETED, assetPath, null, null, null, null, null, null, null);
    }

    public static DamEvent damMetadataWritebackWorkflowCompleted(String assetPath) {
        return new DamEvent(Type.DAM_METADATA_WRITEBACK_WORKFLOW_COMPLETED, assetPath, null, null, null, null, null, null, null);
    }

    private Dictionary<String, Object> getEventProperties() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put(PROPERTY_TYPE, (Object)((Object)this.type));
        ((Dictionary)properties).put(PROPERTY_DATE, this.date);
        DamEvent.putStringProperty(properties, PROPERTY_ASSETPATH, this.assetPath);
        DamEvent.putStringProperty(properties, PROPERTY_USER_ID, this.userId);
        DamEvent.putStringProperty(properties, PROPERTY_LICENSE_INFO, this.licenseInfo);
        DamEvent.putStringProperty(properties, PROPERTY_VERSION_ID, this.versionId);
        DamEvent.putStringProperty(properties, PROPERTY_ADDITIONAL_INFO, this.additionalInfo);
        DamEvent.putStringProperty(properties, PROPERTY_CREATEDBY, this.createdBy);
        if (this.expirationDate != null) {
            ((Dictionary)properties).put(PROPERTY_EXPIRATIONDATE, this.expirationDate);
        }
        return properties;
    }

    private Dictionary<String, Object> getDistributableEventProperties() {
        Dictionary<String, Object> properties = this.getEventProperties();
        properties.put(PROPERTY_DISTRIBUTABLE, Boolean.TRUE);
        return properties;
    }

    private static void putStringProperty(Dictionary<String, Object> map, String propertyName, String value) {
        if (StringUtils.isNotBlank(value)) {
            map.put(propertyName, value);
        }
    }

    public static enum Type {
        ACCEPTED,
        REJECTED,
        DOWNLOADED,
        VERSIONED,
        RESTORED,
        METADATA_UPDATED,
        PUBLISHED_EXTERNAL,
        ORIGINAL_UPDATED,
        RENDITION_UPDATED,
        RENDITION_REMOVED,
        RENDITION_DOWNLOADED,
        SUBASSET_UPDATED,
        SUBASSET_REMOVED,
        ASSET_CREATED,
        ASSET_MOVED,
        ASSET_REMOVED,
        ASSET_EXPIRED,
        ASSET_EXPIRING,
        ASSET_VIEWED,
        ASSET_SHARED,
        ASSET_PUBLISHED,
        ADDED_COMMENT,
        PROJECT_VIEWED,
        COLLECTION_VIEWED,
        ASSET_USAGE,
        DAM_UPDATE_ASSET_WORKFLOW_COMPLETED,
        DAM_METADATA_WRITEBACK_WORKFLOW_COMPLETED;

    }
}

