/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.metadata;

import com.adobe.granite.asset.api.AssetMetadata;
import com.adobe.xmp.XMPDateTime;
import com.adobe.xmp.XMPDateTimeFactory;
import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPIterator;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.core.XMPArray;
import com.adobe.xmp.core.XMPMetadata;
import com.adobe.xmp.core.parser.RDFXMLParser;
import com.adobe.xmp.core.parser.RDFXMLParserContext;
import com.adobe.xmp.options.PropertyOptions;
import com.adobe.xmp.path.XMPPath;
import com.adobe.xmp.properties.XMPProperty;
import com.adobe.xmp.properties.XMPPropertyInfo;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.api.metadata.xmp.XmpMappings;
import com.day.cq.dam.commons.metadata.XmpFilter;
import com.day.cq.dam.commons.util.DateParser;
import com.day.cq.tagging.JcrTagManagerFactory;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Binary;
import javax.jcr.Item;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@Component(metatype=false, label="SimpleXmpToJcrMetadataBuilder Handler", description="SimpleXmpToJcrMetadataBuilder Handler")
@Service(value={SimpleXmpToJcrMetadataBuilder.class})
public class SimpleXmpToJcrMetadataBuilder {
    private static final String METADATA_PROPERTY_NAME_ADOBE_KEYWORDS = "lr:hierarchicalSubject";
    private static final String XMP_ARRAY_TYPE = "xmpArrayType";
    private static final String IS_XMP_ARRAY = "isXMPArray";
    private static final Logger log = LoggerFactory.getLogger(SimpleXmpToJcrMetadataBuilder.class);
    public static final String NT_RDF_BAG = "rdf:Bag";
    public static final String NT_RDF_SEQ = "rdf:Seq";
    public static final String NT_RDF_ALT = "rdf:Alt";
    private static final String INGREDIENT_TAG = "xmpMM:Ingredients";
    private static final String SYNC_FLAG = "newRendition";
    private static final String DAM_NS_URI = "http://www.day.com/dam/1.0";
    private static final String CQ_NS_URI = "http://www.day.com/jcr/cq/1.0";
    private static final String NAMESPACE_UPDATE_HELPER = "namespaceupdatehelper";
    private String[] defaultFormats = new String[]{"application/octet-stream"};
    private static final List<String> altArrayProps = new ArrayList<String>(8);
    private static final int MAX_ITEM_SIZE = 1000;
    private static final List<String> ignoreHierarchy;
    public final Map<String, String> conflictPropMap = new HashMap<String, String>(5);
    @Reference
    private XmpFilter xmpFilter;
    @Reference
    private JcrTagManagerFactory tagManagerFactory;
    @Reference
    private SlingRepository repository;

    public SimpleXmpToJcrMetadataBuilder() {
        this.conflictPropMap.put("ImageLength", "Image Length");
        this.conflictPropMap.put("ImageWidth", "Image Width");
        this.conflictPropMap.put("tiff:ImageWidth", "Image Width");
        this.conflictPropMap.put("tiff:ImageLength", "Image Length");
        this.conflictPropMap.put("dc:description", "description");
        this.conflictPropMap.put("dc:description", "Caption/Abstract");
    }

    protected SimpleXmpToJcrMetadataBuilder(SlingRepository repository) {
        this();
        this.repository = repository;
    }

    @Deprecated
    public void storeXmp(Node metadataRoot, XMPMeta meta, boolean doSave) throws XMPException, RepositoryException {
        XMPIterator itr = meta.iterator();
        String rootPath = metadataRoot.getPath();
        HashMap<String, List<XMPPropertyInfo>> arrayMap = new HashMap<String, List<XMPPropertyInfo>>();
        while (itr.hasNext()) {
            String path;
            XMPPropertyInfo prop = (XMPPropertyInfo)itr.next();
            if (prop.getOptions().isSchemaNode()) continue;
            if (prop.getOptions().isQualifier() || prop.getOptions().isSimple()) {
                this.checkNamespace(prop, metadataRoot);
                String string = path = Text.getRelativeParent(prop.getPath(), 1).equals("") ? rootPath : rootPath + "/" + Text.getRelativeParent(prop.getPath(), 1);
                if (this.isArrayMember(arrayMap, prop.getPath())) {
                    if (prop.getOptions().isQualifier()) {
                        log.debug("Qualifier detected (noop): " + prop.toString());
                        continue;
                    }
                    if (prop.getOriValue() == null) continue;
                    String p = prop.getPath();
                    p = p.substring(0, p.lastIndexOf("["));
                    ((List)arrayMap.get(p)).add(prop);
                    continue;
                }
                if (prop.getOptions().isQualifier()) {
                    log.debug("Qualifier detected (noop): " + prop.toString());
                    continue;
                }
                if (prop.getOriValue() != null) {
                    Node node = this.getOrCreateNode(metadataRoot.getSession(), path, "nt:unstructured");
                    if (node != null) {
                        this.setProperty(node, prop);
                    }
                    log.debug("PATH: " + rootPath + "/" + prop.getPath() + ":" + prop.getValue());
                    continue;
                }
                log.debug(prop.getPath() + " is NULL");
                continue;
            }
            if (prop.getOptions().isArray()) {
                this.checkNamespace(prop, metadataRoot);
                ArrayList<XMPPropertyInfo> members = new ArrayList<XMPPropertyInfo>();
                members.add(prop);
                arrayMap.put(prop.getPath(), members);
                continue;
            }
            if (!prop.getOptions().isStruct()) continue;
            if (this.isArrayMember(arrayMap, prop.getPath())) {
                log.debug("Struct as member of array");
                if (prop.getOptions().isQualifier()) {
                    log.debug("Qualifier detected (noop): " + prop.toString());
                    continue;
                }
                if (prop.getOriValue() == null) continue;
                String p = prop.getPath();
                int arrayIndexStrt = p.lastIndexOf("[");
                if (arrayIndexStrt > -1) {
                    p = p.substring(0, arrayIndexStrt);
                }
                ((List)arrayMap.get(p)).add(prop);
                continue;
            }
            this.checkNamespace(prop, metadataRoot);
            path = rootPath + "/" + prop.getPath();
            this.getOrCreateNode(metadataRoot.getSession(), path, "nt:unstructured");
        }
        for (String path : arrayMap.keySet()) {
            Node node;
            String parentPath = Text.getRelativeParent(path, 1);
            List arrayMembers = (List)arrayMap.get(path);
            if (arrayMembers.size() <= 1 || (node = this.getOrCreateNode(metadataRoot.getSession(), rootPath + "/" + this.normalizeArrayPath(parentPath), "nt:unstructured")) == null) continue;
            XMPPropertyInfo arrayProp = (XMPPropertyInfo)arrayMembers.remove(0);
            String name = NT_RDF_BAG;
            if (arrayProp.getOptions().isArrayOrdered()) {
                name = NT_RDF_SEQ;
            } else if (arrayProp.getOptions().isArrayAlternate()) {
                name = NT_RDF_ALT;
            }
            XMPPropertyInfo firstMember = (XMPPropertyInfo)arrayMembers.get(0);
            if (firstMember.getOptions().isStruct() && !INGREDIENT_TAG.equalsIgnoreCase(Text.getName(path))) {
                Node arrayNode = this.getOrCreateNode(metadataRoot.getSession(), node.getPath() + "/" + Text.getName(path), "nt:unstructured");
                arrayNode.setProperty(XMP_ARRAY_TYPE, name);
                arrayNode.setProperty(IS_XMP_ARRAY, true);
                NodeIterator nodes = arrayNode.getNodes();
                while (nodes.hasNext()) {
                    Node childNode = (Node)nodes.next();
                    childNode.remove();
                }
                for (XMPPropertyInfo prop : arrayMembers) {
                    if (prop.getOptions().isStruct()) {
                        this.getOrCreateNode(metadataRoot.getSession(), rootPath + "/" + this.normalizeArrayPath(prop.getPath()), "nt:unstructured");
                        continue;
                    }
                    if (!prop.getOptions().isSimple()) continue;
                    String parentStructPath = Text.getRelativeParent(prop.getPath(), 1);
                    Node parentStructNode = this.getOrCreateNode(metadataRoot.getSession(), rootPath + "/" + this.normalizeArrayPath(parentStructPath), "nt:unstructured");
                    this.setProperty(parentStructNode, prop);
                }
                continue;
            }
            this.setMvProperty(node, arrayMembers, Text.getName(path));
        }
        if (doSave) {
            metadataRoot.getSession().save();
        }
    }

    private String normalizeArrayPath(String xmpPath) {
        xmpPath = xmpPath.replace("[", "/");
        return xmpPath.replace("]", "");
    }

    public void storeXmp(Node metadataRoot, XMPMeta meta) throws XMPException, RepositoryException {
        this.storeXmp(metadataRoot, meta, true);
    }

    private boolean isArrayMember(Map<String, List<XMPPropertyInfo>> arrayMap, String path) {
        if (path.lastIndexOf("[") > 0) {
            String parentPath = path.substring(0, path.lastIndexOf("["));
            return arrayMap.containsKey(parentPath);
        }
        return false;
    }

    @Deprecated
    public XMPMeta getXmpFromJcr(Node metadataRoot) throws RepositoryException, XMPException {
        XMPMeta meta = XMPMetaFactory.create();
        PropertyIterator props = metadataRoot.getProperties();
        while (props.hasNext()) {
            try {
                Property prop = props.nextProperty();
                String name = prop.getName();
                if (name.indexOf(":") < 0) {
                    log.debug("property [{}] doesn't have namespace prefix, skipping. metadata node: [{}].", (Object)name, (Object)metadataRoot.getPath());
                    continue;
                }
                Session session = metadataRoot.getSession();
                String nsPrefix = name.substring(0, name.indexOf(":"));
                String namespace = session.getNamespaceURI(nsPrefix);
                if ((name = this.getKeyFromXMPRegistry(name, session)).indexOf("jcr:") < 0 && !prop.isMultiple()) {
                    Object val = this.getValue(prop);
                    try {
                        if (altArrayProps.contains(name) && val instanceof String) {
                            meta.setLocalizedText(namespace, name, "x-default", "x-default", (String)val);
                            continue;
                        }
                        meta.setProperty(namespace, name, val);
                    }
                    catch (XMPException xmpe) {
                        if (log.isDebugEnabled()) {
                            log.debug("Cannot set xmp property: " + xmpe.getMessage(), xmpe);
                            continue;
                        }
                        log.warn("Cannot set xmp property: " + xmpe.getMessage());
                    }
                    continue;
                }
                if (name.indexOf("jcr:") >= 0 || !prop.isMultiple()) continue;
                Object[] vals = this.getMultiValues(prop);
                try {
                    if (altArrayProps.contains(name) && vals.length == 1) {
                        if (!(vals[0] instanceof String)) continue;
                        meta.setLocalizedText(namespace, name, "x-default", "x-default", (String)vals[0]);
                        continue;
                    }
                    for (Object v : vals) {
                        if (!(v instanceof String)) continue;
                        meta.appendArrayItem(namespace, name, new PropertyOptions().setArray(true), (String)v, null);
                    }
                }
                catch (XMPException xmpe) {
                    if (log.isDebugEnabled()) {
                        log.debug("Cannot set xmp property: " + xmpe.getMessage(), xmpe);
                        continue;
                    }
                    log.warn("Cannot set xmp property: " + xmpe.getMessage());
                }
            }
            catch (RepositoryException re) {
                log.error("Cannot set xmp property: " + re.getMessage(), re);
            }
        }
        try {
            this.checkForComplexMetadata(metadataRoot, meta, null, null, new HashMap<String, PropertyOptions>());
        }
        catch (PathNotFoundException e) {
            log.info("Complex Metadata extraction is not applicable for the binary");
        }
        catch (Exception e) {
            log.error("Unable to extract the complex metadata " + e.getMessage(), e);
        }
        return meta;
    }

    private void checkForComplexMetadata(Node metadataRoot, XMPMeta xmpMeta, String nodeName, String nsRootURI, Map<String, PropertyOptions> arrOfStructMap) throws XMPException, RepositoryException {
        String pNodeName = nodeName;
        NodeIterator iter = metadataRoot.getNodes();
        while (iter.hasNext()) {
            String childRootURI = nsRootURI;
            Node childMetadataNode = iter.nextNode();
            PropertyIterator dpi = childMetadataNode.getProperties();
            PropertyOptions dpropertyOption = new PropertyOptions();
            dpropertyOption.setArray(true);
            String string = nodeName = pNodeName == null ? childMetadataNode.getName() : pNodeName + "/" + childMetadataNode.getName();
            if (childRootURI == null) {
                if (childMetadataNode.getName().indexOf(":") < 0) {
                    log.warn("property [{}] doesn't have namespace prefix, skipping. metadata node: [{}].", (Object)childMetadataNode.getName(), (Object)childMetadataNode.getPath());
                    return;
                }
                childRootURI = this.registerPrefix(childMetadataNode);
            }
            if (childMetadataNode.hasProperty(IS_XMP_ARRAY) || childMetadataNode.hasProperty("xmpNodeType") && "xmpArray".equals(childMetadataNode.getProperty("xmpNodeType").getString())) {
                PropertyOptions arrayOptions = new PropertyOptions();
                if (childMetadataNode.hasProperty(XMP_ARRAY_TYPE)) {
                    String arrayType = childMetadataNode.getProperty(XMP_ARRAY_TYPE).getString();
                    if (NT_RDF_BAG.equals(arrayType)) {
                        arrayOptions.setArray(true);
                    } else if (NT_RDF_SEQ.equals(arrayType)) {
                        arrayOptions.setArrayOrdered(true);
                    } else if (NT_RDF_ALT.equals(arrayType)) {
                        arrayOptions.setArrayAlternate(true);
                    }
                } else {
                    arrayOptions.setArray(true);
                }
                arrOfStructMap.put(childMetadataNode.getPath(), arrayOptions);
            } else {
                if (arrOfStructMap.containsKey(metadataRoot.getPath())) {
                    xmpMeta.appendArrayItem(childRootURI, pNodeName, arrOfStructMap.get(metadataRoot.getPath()), null, new PropertyOptions().setStruct(true));
                    int index = xmpMeta.countArrayItems(childRootURI, pNodeName);
                    nodeName = pNodeName + "[" + index + "]";
                }
                while (dpi.hasNext()) {
                    Property p = dpi.nextProperty();
                    if (p.getName().indexOf(":") < 0) {
                        log.debug("property [{}] doesn't have namespace prefix, skipping. metadata node: [{}].", (Object)p.getName(), (Object)childMetadataNode.getPath());
                        continue;
                    }
                    this.registerPrefix(p);
                    if (childRootURI == null || p.getName() == null) continue;
                    if (p.getName().indexOf("jcr:") < 0 && p.isMultiple()) {
                        log.debug("Multiple value metadata property {}, creating String[] in XMP", (Object)p.getName());
                        try {
                            Value[] values;
                            for (Value value : values = p.getValues()) {
                                xmpMeta.appendArrayItem(childRootURI, nodeName + "/" + p.getName(), dpropertyOption, value.getString(), null);
                            }
                            continue;
                        }
                        catch (XMPException xmpe) {
                            if (log.isDebugEnabled()) {
                                log.debug("Cannot set xmp property: " + xmpe.getMessage(), xmpe);
                                continue;
                            }
                            log.warn("Cannot set xmp property: " + xmpe.getMessage());
                            continue;
                        }
                    }
                    if (p.getName().indexOf("jcr:") >= 0 || p.isMultiple()) continue;
                    log.debug("Writing {} with value: {}", (Object)p.getName(), (Object)p.getString());
                    try {
                        xmpMeta.setProperty(childRootURI, nodeName + "/" + p.getName(), p.getString());
                    }
                    catch (XMPException xmpe) {
                        if (log.isDebugEnabled()) {
                            log.debug("Cannot set xmp property: " + xmpe.getMessage(), xmpe);
                            continue;
                        }
                        log.warn("Cannot set xmp property: " + xmpe.getMessage());
                    }
                }
            }
            if (childMetadataNode.getNodes().getSize() <= 0L) continue;
            this.checkForComplexMetadata(childMetadataNode, xmpMeta, nodeName, childRootURI, arrOfStructMap);
        }
    }

    private String registerPrefix(Item jcrItem) throws RepositoryException {
        String childPrefix = jcrItem.getName().substring(0, jcrItem.getName().indexOf(":"));
        String nsUriChild = jcrItem.getSession().getWorkspace().getNamespaceRegistry().getURI(childPrefix);
        try {
            this.registerNs(childPrefix, nsUriChild);
        }
        catch (XMPException xmpe) {
            log.warn("Cannot process the xmp structure: " + xmpe.getMessage());
        }
        return nsUriChild;
    }

    @Deprecated
    public void storeAsXmp(ExtractedMetadata metadata, Node metadataRoot, boolean doSave) throws XMPException, RepositoryException {
        XMPMeta meta = XMPMetaFactory.create();
        this.convertToXmp(metadata, metadataRoot, meta, doSave);
        this.storeXmp(metadataRoot, meta, doSave);
    }

    public void storeAsXmp(ExtractedMetadata metadata, Asset asset, boolean doSave) throws XMPException, RepositoryException {
        Node assetNode = asset.adaptTo(Node.class);
        Node metadataRoot = assetNode.getNode("jcr:content/metadata");
        InputStream is = metadata.getXmp();
        XMPMeta xmpMeta = null;
        try {
            if (is != null) {
                if (this.xmpFilter != null) {
                    is = this.xmpFilter.filter(is);
                }
                xmpMeta = XMPMetaFactory.parse(is);
                this.resolvePropConflict(metadata, this.conflictPropMap);
                this.resolvePropConflict(metadata, xmpMeta, this.conflictPropMap);
                this.convertToXmp(metadata, metadataRoot, xmpMeta, doSave);
                if (metadataRoot.hasProperty("dc:format") && !this.isDefaultFormat(metadataRoot.getProperty("dc:format").getValue().getString()) && xmpMeta.getPropertyString("http://purl.org/dc/elements/1.1/", "dc:format") != null) {
                    xmpMeta.deleteProperty("http://purl.org/dc/elements/1.1/", "dc:format");
                }
            } else {
                xmpMeta = XMPMetaFactory.create();
                this.convertToXmp(metadata, metadataRoot, xmpMeta, doSave);
            }
            XMPMetadata xmpMetadata = null;
            byte[] xmpBytes = XMPMetaFactory.serializeToBuffer(xmpMeta, null);
            RDFXMLParserContext parserContext = new RDFXMLParserContext();
            xmpMetadata = new RDFXMLParser().parse(xmpBytes, (Map<String, Object>)parserContext);
            Set<String> nss = parserContext.getPrefixDefinitions().keySet();
            for (String ns : nss) {
                this.checkNamespace(parserContext.getPrefixDefinitions().get(ns), metadataRoot);
            }
            this.validateTags(xmpMetadata, asset);
            AssetMetadata assetMetadata = asset.adaptTo(Resource.class).adaptTo(com.adobe.granite.asset.api.Asset.class).getAssetMetadata();
            assetMetadata.setXMP(xmpMetadata, null, ignoreHierarchy);
            this.extractHierarchicalSubjects(asset, metadataRoot.getSession());
        }
        catch (com.adobe.xmp.core.XMPException e) {
            log.info("cannot convert extractedmetadata to XMPMetadata", e);
        }
        catch (IOException e) {
            log.info("cannot convert extractedmetadata to XMPMetadata", e);
        }
    }

    private void validateTags(XMPMetadata xmpMetadata, Asset asset) {
        XMPArray tagsArray = xmpMetadata.getArray(CQ_NS_URI, "tags");
        if (this.tagManagerFactory == null) {
            return;
        }
        ResourceResolver resolver = asset.adaptTo(Resource.class).getResourceResolver();
        TagManager tagManager = this.tagManagerFactory.getTagManager(resolver);
        ArrayList<XMPPath> listIndexRemoval = new ArrayList<XMPPath>();
        if (tagsArray != null) {
            for (int i = 0; i < tagsArray.size(); ++i) {
                Tag tag;
                String tagValue = tagsArray.getSimple(i).getValue();
                if (tagValue == null || null != (tag = tagManager.resolve(tagValue))) continue;
                listIndexRemoval.add(tagsArray.get(i).getXMPPath());
            }
            for (XMPPath path : listIndexRemoval) {
                try {
                    xmpMetadata.remove(path);
                }
                catch (com.adobe.xmp.core.XMPException e) {
                    log.debug("unable to delete the tag from path " + xmpMetadata.get(path).getName());
                }
            }
        }
    }

    private boolean isDefaultFormat(String format) {
        for (String defFormat : this.defaultFormats) {
            if (!defFormat.equals(format)) continue;
            return true;
        }
        return false;
    }

    private void convertToXmp(ExtractedMetadata metadata, Node metadataRoot, XMPMeta meta, boolean doSave) throws XMPException, RepositoryException {
        Set keys = metadata.getMetaDataProperties().keySet();
        for (String mkey : keys) {
            String[] xmpKeys;
            String key = mkey.replaceAll("\\(", "").replaceAll("\\)", "");
            if (XmpMappings.defaultSimpleXmpMappings.containsKey(key)) {
                for (String xmpKey : xmpKeys = this.getXmpKeys(XmpMappings.defaultSimpleXmpMappings.get(key))) {
                    try {
                        this.setXmpProperty(meta, xmpKey, metadata.getMetaDataProperties().get(key), metadataRoot.getSession());
                    }
                    catch (XMPException e) {
                        log.debug("Cannot create xmp property: " + e.getMessage(), e);
                    }
                }
                continue;
            }
            if (XmpMappings.defaultBagXmpMappings.containsKey(key) || XmpMappings.defaultSeqXmpMappings.containsKey(key) || XmpMappings.defaultAltXmpMappings.containsKey(key)) {
                xmpKeys = new String[]{};
                if (XmpMappings.defaultBagXmpMappings.containsKey(key)) {
                    if (!metadata.getMetaDataProperties().get("dc:format").equals("application/pdf") || !key.equalsIgnoreCase("subject")) {
                        xmpKeys = this.getXmpKeys(XmpMappings.defaultBagXmpMappings.get(key));
                    }
                } else if (XmpMappings.defaultSeqXmpMappings.containsKey(key)) {
                    xmpKeys = this.getXmpKeys(XmpMappings.defaultSeqXmpMappings.get(key));
                } else if (XmpMappings.defaultAltXmpMappings.containsKey(key)) {
                    xmpKeys = this.getXmpKeys(XmpMappings.defaultAltXmpMappings.get(key));
                }
                for (String xmpKey : xmpKeys) {
                    try {
                        List<Object> valList;
                        String namespace = this.getNamespace(xmpKey);
                        Object val = metadata.getMetaDataProperties().get(key);
                        if (val instanceof List) {
                            valList = (List<Object>)val;
                            this.insertIntoXMPMeta(meta, xmpKey, valList, namespace);
                            continue;
                        }
                        if (val instanceof Object[]) {
                            valList = Arrays.asList((Object[])val);
                            this.insertIntoXMPMeta(meta, xmpKey, valList, namespace);
                            continue;
                        }
                        if (val.getClass().isArray() && val.getClass().getComponentType().isPrimitive()) {
                            Class<?> componentType = val.getClass().getComponentType();
                            if (Boolean.TYPE.isAssignableFrom(componentType)) {
                                for (boolean bl : (boolean[])val) {
                                    meta.appendArrayItem(namespace, xmpKey, new PropertyOptions().setArray(true), bl + "", null);
                                }
                                continue;
                            }
                            if (Float.TYPE.isAssignableFrom(componentType)) {
                                for (float f : (float[])val) {
                                    meta.appendArrayItem(namespace, xmpKey, new PropertyOptions().setArray(true), f + "", null);
                                }
                                continue;
                            }
                            if (Double.TYPE.isAssignableFrom(componentType)) {
                                for (double d : (double[])val) {
                                    meta.appendArrayItem(namespace, xmpKey, new PropertyOptions().setArray(true), d + "", null);
                                }
                                continue;
                            }
                            if (Integer.TYPE.isAssignableFrom(componentType)) {
                                for (int n : (int[])val) {
                                    meta.appendArrayItem(namespace, xmpKey, new PropertyOptions().setArray(true), n + "", null);
                                }
                                continue;
                            }
                            if (Long.TYPE.isAssignableFrom(componentType)) {
                                for (long l : (long[])val) {
                                    meta.appendArrayItem(namespace, xmpKey, new PropertyOptions().setArray(true), l + "", null);
                                }
                                continue;
                            }
                            if (!Short.TYPE.isAssignableFrom(componentType)) continue;
                            for (short s : (short[])val) {
                                meta.appendArrayItem(namespace, xmpKey, new PropertyOptions().setArray(true), s + "", null);
                            }
                            continue;
                        }
                        String strVal = val instanceof String ? (String)val : String.valueOf(val);
                        this.insertIntoXMPMeta(meta, xmpKey, Arrays.asList(strVal), namespace);
                    }
                    catch (XMPException e) {
                        log.debug("Cannot create xmp property: " + e.getMessage());
                    }
                }
                continue;
            }
            if (key.indexOf(":") < 0) {
                try {
                    Object value = metadata.getMetaDataProperties().get(key);
                    Session session = metadataRoot.getSession();
                    String xmpKey = this.getKeyFromXMPRegistry("dam:" + key.replace(" ", ""), session);
                    if (value instanceof List) {
                        List valList = (List)value;
                        this.insertIntoXMPMeta(meta, xmpKey, valList, DAM_NS_URI);
                        continue;
                    }
                    if (value instanceof Object[]) {
                        List<Object> valList = Arrays.asList((Object[])value);
                        this.insertIntoXMPMeta(meta, xmpKey, valList, DAM_NS_URI);
                        continue;
                    }
                    if (value == null || value instanceof String && StringUtils.isEmpty((String)value)) continue;
                    meta.setProperty(DAM_NS_URI, xmpKey.trim(), value);
                }
                catch (XMPException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Cannot set xmp property:" + e.getMessage(), e);
                        continue;
                    }
                    log.warn("Cannot set xmp property:" + e.getMessage());
                }
                continue;
            }
            try {
                this.setXmpProperty(meta, key, metadata.getMetaDataProperties().get(key), metadataRoot.getSession());
            }
            catch (XMPException e) {
                log.debug("Cannot create xmp property: " + e.getMessage());
            }
        }
    }

    public void storeAsXmp(ExtractedMetadata metadata, Node metadataRoot) throws XMPException, RepositoryException {
        this.storeAsXmp(metadata, metadataRoot, true);
    }

    private void setXmpProperty(XMPMeta meta, String xmpKey, Object value, Session session) throws XMPException, RepositoryException {
        if (value != null) {
            try {
                String nsPrefix = xmpKey.substring(0, xmpKey.indexOf(":"));
                String nsUri = session.getNamespaceURI(nsPrefix);
                xmpKey = this.getKeyFromXMPRegistry(xmpKey, session);
                if (value instanceof Boolean) {
                    meta.setPropertyBoolean(nsUri, xmpKey, (Boolean)value);
                } else if (value instanceof Calendar) {
                    meta.setPropertyCalendar(nsUri, xmpKey, (Calendar)value);
                } else if (value instanceof Date) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime((Date)value);
                    meta.setPropertyDate(nsUri, xmpKey, XMPDateTimeFactory.createFromCalendar(cal));
                } else if (value instanceof Double) {
                    meta.setPropertyDouble(nsUri, xmpKey, (Double)value);
                } else if (value instanceof Integer) {
                    meta.setPropertyInteger(nsUri, xmpKey, (Integer)value);
                } else if (value instanceof Long) {
                    meta.setPropertyLong(nsUri, xmpKey, (Long)value);
                } else if (value instanceof String) {
                    if (!StringUtils.isEmpty((String)value)) {
                        meta.setProperty(nsUri, xmpKey, value);
                    }
                } else if (value instanceof List) {
                    List valList = (List)value;
                    this.insertIntoXMPMeta(meta, xmpKey, valList, nsUri);
                } else if (value instanceof Object[]) {
                    Object[] valArray = (Object[])value;
                    if (altArrayProps.contains(xmpKey) && valArray[0] != null && valArray[0] instanceof String) {
                        meta.setProperty(nsUri, xmpKey, valArray[0]);
                    } else {
                        List<Object> valList = Arrays.asList(valArray);
                        this.insertIntoXMPMeta(meta, xmpKey, valList, nsUri);
                    }
                } else {
                    meta.setProperty(nsUri, xmpKey, value);
                }
            }
            catch (NamespaceException nsEx) {
                if (log.isDebugEnabled()) {
                    log.debug("namespace exception in setting xmp property", nsEx);
                } else {
                    log.warn("namespace exception in setting xmp property", (Object)nsEx.getMessage());
                }
            }
            catch (ClassCastException ccEx) {
                if (log.isDebugEnabled()) {
                    log.debug("class cast exception in setting xmp property", ccEx);
                }
                log.warn("class cast exception in setting xmp property", (Object)ccEx.getMessage());
            }
        }
    }

    private String[] getXmpKeys(String keyString) {
        if (keyString.indexOf(",") > 0) {
            return keyString.split(",");
        }
        return new String[]{keyString};
    }

    private String getNamespace(String xmpKey) {
        if (xmpKey.indexOf(":") > 0) {
            String nsPrefix = xmpKey.substring(0, xmpKey.indexOf(":"));
            return XMPMetaFactory.getSchemaRegistry().getNamespaceURI(nsPrefix);
        }
        return null;
    }

    private Node getOrCreateNode(Session session, String path, String nodetype) {
        block5: {
            try {
                if (session.itemExists(path)) {
                    return (Node)session.getItem(path);
                }
                Node childMetaNode = session.getRootNode().addNode(path.substring(1), nodetype);
                childMetaNode.setProperty(SYNC_FLAG, true);
                return childMetaNode;
            }
            catch (RepositoryException e) {
                log.warn("Failed to get or create node {}", (Object)path, (Object)e.getMessage());
                if (log.isDebugEnabled()) {
                    log.debug("Failed to get or create node", e);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("Failed to get or create node", e);
            }
        }
        return null;
    }

    private String getPropertyName(Node node, XMPPropertyInfo prop) {
        String name;
        String path = prop.getPath();
        String string = name = path.lastIndexOf("/") > 0 ? path.substring(path.lastIndexOf("/") + 1) : path;
        if (name.indexOf(":") > 0) {
            String[] splits = name.split(":");
            String prefix = splits[0];
            String namespace = XMPMetaFactory.getSchemaRegistry().getNamespaceURI(prefix);
            if (namespace != null) {
                try {
                    String regPrefix = this.checkNamespace(namespace, node);
                    if (!regPrefix.equals(prefix)) {
                        prefix = regPrefix;
                    }
                }
                catch (RepositoryException e) {
                    log.warn("Failed to check the namespace {}", (Object)namespace);
                }
                if (splits.length > 1) {
                    name = prefix + ":" + Text.escapeIllegalJcrChars(splits[1]);
                }
            } else {
                name = Text.escapeIllegalJcrChars(name);
            }
        } else {
            name = Text.escapeIllegalJcrChars(name);
        }
        return name;
    }

    private <T> void insertIntoXMPMeta(XMPMeta meta, String xmpKey, List<T> valList, String schemaNameSpace) throws XMPException {
        LinkedHashSet<String> valArrayWithoutDuplicates = new LinkedHashSet<String>();
        if (meta.doesPropertyExist(schemaNameSpace, xmpKey)) {
            int propertySize = meta.countArrayItems(schemaNameSpace, xmpKey);
            for (int i = 1; i <= propertySize && valArrayWithoutDuplicates.size() < 1000; ++i) {
                valArrayWithoutDuplicates.add(meta.getArrayItem(schemaNameSpace, xmpKey, i).toString().trim());
            }
        }
        for (T val : valList) {
            if (valArrayWithoutDuplicates.size() >= 1000) break;
            String trimmedVal = val.toString().trim();
            if ("".equals(trimmedVal) || valArrayWithoutDuplicates.contains(trimmedVal)) continue;
            valArrayWithoutDuplicates.add(trimmedVal);
            meta.appendArrayItem(schemaNameSpace, xmpKey, new PropertyOptions().setArray(true), val.toString(), null);
        }
    }

    private void resolvePropConflict(ExtractedMetadata metadata, Map<String, String> conflictPropMap) {
        for (Map.Entry<String, String> entry : conflictPropMap.entrySet()) {
            if (!metadata.getMetaDataProperties().containsKey(entry.getKey()) || !metadata.getMetaDataProperties().containsKey(entry.getValue())) continue;
            metadata.getMetaDataProperties().remove(entry.getKey());
        }
    }

    private void resolvePropConflict(ExtractedMetadata metadata, XMPMeta meta, Map<String, String> conflictPropMap) {
        for (Map.Entry<String, String> entry : conflictPropMap.entrySet()) {
            try {
                String namespace = this.getNamespace(entry.getKey());
                if (namespace != null) {
                    XMPProperty property = meta.getProperty(namespace, entry.getKey());
                    if (property == null || !metadata.getMetaDataProperties().containsKey(entry.getValue())) continue;
                    meta.deleteProperty(namespace, entry.getKey());
                    continue;
                }
                log.debug("namespace is null {} ", (Object)entry.getKey());
            }
            catch (XMPException e) {
                log.debug("exception while getting the property", e);
            }
        }
    }

    private Property setProperty(Node node, XMPPropertyInfo prop) {
        Property p = null;
        try {
            Object val = prop.getOriValue();
            String name = this.getPropertyName(node, prop);
            val = this.checkForDate(val);
            val = this.checkExif(name, val);
            if (val instanceof Boolean) {
                p = node.setProperty(name, (Boolean)val);
            } else if (val instanceof Long || val instanceof Integer) {
                p = node.setProperty(name, val instanceof Long ? (Long)val : (long)((Integer)val).intValue());
            } else if (val instanceof Short) {
                p = node.setProperty(name, ((Short)val).shortValue());
            } else if (val instanceof Double) {
                Double value = (Double)val;
                p = node.setProperty(name, value.isInfinite() || value.isNaN() ? 0.0 : value);
            } else if (val instanceof XMPDateTime) {
                p = node.setProperty(name, ((XMPDateTime)val).getCalendar());
            } else if (val instanceof byte[]) {
                p = node.setProperty(name, node.getSession().getValueFactory().createBinary(new ByteArrayInputStream((byte[])val)));
            } else if (val instanceof Byte) {
                p = node.setProperty(name, ((Byte)val).intValue());
            } else if (val instanceof Date) {
                Calendar cal = Calendar.getInstance();
                cal.setTime((Date)val);
                p = node.setProperty(name, cal);
            } else if (val instanceof Calendar) {
                p = node.setProperty(name, (Calendar)val);
            } else if (val instanceof RationalNumber) {
                Double value = ((RationalNumber)val).doubleValue();
                p = node.setProperty(name, value.isInfinite() || value.isNaN() ? 0.0 : value);
            } else if (val instanceof RationalNumber[]) {
                ArrayList<Value> vals = new ArrayList<Value>();
                for (RationalNumber rv : (RationalNumber[])val) {
                    Double value = rv.doubleValue();
                    vals.add(node.getSession().getValueFactory().createValue(value.isInfinite() || value.isNaN() ? 0.0 : value));
                }
                p = node.setProperty(name, vals.toArray(new Value[vals.size()]));
            } else if (val instanceof int[]) {
                ArrayList<Value> vals = new ArrayList<Value>();
                int[] nArray = (int[])val;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer i2 = nArray[i];
                    vals.add(node.getSession().getValueFactory().createValue(i2.intValue()));
                }
                p = node.setProperty(name, vals.toArray(new Value[vals.size()]));
            } else if (val instanceof short[]) {
                ArrayList<Value> vals = new ArrayList<Value>();
                short[] sArray = (short[])val;
                int n = sArray.length;
                for (int i = 0; i < n; ++i) {
                    Short i3 = sArray[i];
                    vals.add(node.getSession().getValueFactory().createValue(i3.shortValue()));
                }
                p = node.setProperty(name, vals.toArray(new Value[vals.size()]));
            } else if (val instanceof String) {
                p = node.setProperty(name, (String)val);
            } else {
                log.warn("Cannot handle as the type is not supported for the xmp property(" + prop.getPath() + ")");
            }
        }
        catch (Throwable re) {
            if (log.isDebugEnabled()) {
                log.debug("Cannot set xmp property (" + prop.getPath() + "): " + re.getMessage(), re);
            }
            log.warn("Cannot set xmp property (" + prop.getPath() + "): " + re.getMessage());
        }
        return p;
    }

    private Object checkExif(String name, Object val) {
        if (name.startsWith("exif:") && val instanceof byte[]) {
            return new String((byte[])val);
        }
        return val;
    }

    private Property setMvProperty(Node node, List<XMPPropertyInfo> props, String name) {
        Property p = null;
        ArrayList<Value> vals = new ArrayList<Value>();
        try {
            Object val = this.checkForDate(props.get(0).getOriValue());
            if (node.hasProperty(name) && !INGREDIENT_TAG.equalsIgnoreCase(name)) {
                Property existingProp = node.getProperty(name);
                if (existingProp.isMultiple()) {
                    vals.addAll(Arrays.asList(existingProp.getValues()));
                } else {
                    vals.add(existingProp.getValue());
                    existingProp.remove();
                }
            }
            if (val instanceof Boolean) {
                for (XMPPropertyInfo prop : props) {
                    if (this.hasDuplicate(vals, prop.getOriValue())) continue;
                    vals.add(node.getSession().getValueFactory().createValue((Boolean)prop.getOriValue()));
                }
                p = node.setProperty(name, vals.toArray(new Value[props.size()]));
            } else if (val instanceof Long) {
                for (XMPPropertyInfo prop : props) {
                    if (this.hasDuplicate(vals, prop.getOriValue())) continue;
                    vals.add(node.getSession().getValueFactory().createValue((Long)prop.getOriValue()));
                }
                p = node.setProperty(name, vals.toArray(new Value[props.size()]));
            } else if (val instanceof Double) {
                for (XMPPropertyInfo prop : props) {
                    Double value = (Double)prop.getOriValue();
                    value = value.isInfinite() || value.isNaN() ? 0.0 : value;
                    if (this.hasDuplicate(vals, value)) continue;
                    vals.add(node.getSession().getValueFactory().createValue(value));
                }
                p = node.setProperty(name, vals.toArray(new Value[props.size()]));
            } else if (val instanceof XMPDateTime) {
                for (XMPPropertyInfo prop : props) {
                    Calendar cal = ((XMPDateTime)prop.getOriValue()).getCalendar();
                    if (this.hasDuplicate(vals, cal)) continue;
                    vals.add(node.getSession().getValueFactory().createValue(cal));
                }
                p = node.setProperty(name, vals.toArray(new Value[props.size()]));
            } else if (val instanceof byte[]) {
                for (XMPPropertyInfo prop : props) {
                    Binary binary = node.getSession().getValueFactory().createBinary(new ByteArrayInputStream((byte[])prop.getOriValue()));
                    vals.add(node.getSession().getValueFactory().createValue(binary));
                }
                p = node.setProperty(name, vals.toArray(new Value[props.size()]));
            } else if (val instanceof Date) {
                for (XMPPropertyInfo prop : props) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime((Date)this.checkForDate(prop.getOriValue()));
                    if (this.hasDuplicate(vals, cal)) continue;
                    vals.add(node.getSession().getValueFactory().createValue(cal));
                }
                p = node.setProperty(name, vals.toArray(new Value[props.size()]));
            } else {
                for (XMPPropertyInfo prop : props) {
                    if (this.hasDuplicate(vals, prop.getOriValue())) continue;
                    vals.add(node.getSession().getValueFactory().createValue((String)prop.getOriValue()));
                }
                p = node.setProperty(name, vals.toArray(new Value[props.size()]));
            }
        }
        catch (Throwable re) {
            log.warn("Cannot set xmp mv property (" + name + "): " + re.getMessage());
        }
        return p;
    }

    private boolean hasDuplicate(List<Value> values, Object value) {
        if (value instanceof Boolean) {
            for (Value val : values) {
                try {
                    if (val.getBoolean() != ((Boolean)value).booleanValue()) continue;
                    return true;
                }
                catch (RepositoryException repositoryException) {
                }
            }
        } else if (value instanceof Long) {
            for (Value val : values) {
                try {
                    if (val.getLong() != ((Long)value).longValue()) continue;
                    return true;
                }
                catch (RepositoryException repositoryException) {
                }
            }
        } else if (value instanceof Calendar) {
            for (Value val : values) {
                try {
                    if (!val.getDate().equals(value)) continue;
                    return true;
                }
                catch (RepositoryException repositoryException) {
                }
            }
        } else if (value instanceof Double) {
            for (Value val : values) {
                try {
                    if (val.getDouble() != ((Double)value).doubleValue()) continue;
                    return true;
                }
                catch (RepositoryException repositoryException) {
                }
            }
        } else {
            for (Value val : values) {
                try {
                    if (!val.getString().equals((String)value)) continue;
                    return true;
                }
                catch (RepositoryException repositoryException) {
                }
            }
        }
        return false;
    }

    private Object checkForDate(Object val) {
        if (val instanceof String) {
            Date date = DateParser.parseDate((String)val);
            return date == null ? val : date;
        }
        return val;
    }

    private Object getValue(Property prop) {
        Object val = null;
        try {
            switch (prop.getType()) {
                case 2: {
                    val = IOUtils.toByteArray(prop.getBinary().getStream());
                    break;
                }
                case 5: {
                    val = XMPDateTimeFactory.createFromCalendar(prop.getDate());
                    break;
                }
                case 6: {
                    val = prop.getBoolean();
                    break;
                }
                case 4: {
                    val = prop.getDouble();
                    break;
                }
                case 3: {
                    val = prop.getLong();
                    break;
                }
                default: {
                    val = prop.getString();
                    break;
                }
            }
        }
        catch (RepositoryException re) {
            log.warn("Problem while getting xmp value from jcr property: " + re.getMessage());
        }
        catch (IOException ioe) {
            log.warn("Problem while getting binary xmp value from jcr property: " + ioe.getMessage());
        }
        return val;
    }

    private Object[] getMultiValues(Property prop) {
        ArrayList<String> valueList = new ArrayList<String>();
        try {
            Value[] values;
            for (Value v : values = prop.getValues()) {
                valueList.add(v.getString());
            }
        }
        catch (RepositoryException re) {
            log.warn("Problem while getting xmp value from jcr property: " + re.getMessage());
        }
        return valueList.toArray(new Object[valueList.size()]);
    }

    private void checkNamespace(XMPPropertyInfo prop, Node metadataRoot) throws RepositoryException {
        this.checkNamespace(prop.getNamespace(), metadataRoot);
    }

    private String getKeyFromXMPRegistry(String jcrPropName, Session session) throws NamespaceException, RepositoryException, XMPException {
        String xmpKey = null;
        String[] splits = jcrPropName.split(":");
        String regPrefix = splits[0];
        String nsUri = session.getNamespaceURI(regPrefix);
        try {
            regPrefix = this.registerNs(regPrefix, nsUri);
        }
        catch (XMPException xmpe) {
            log.warn("Can't register NameSpace: {}", (Object)xmpe.getMessage());
            if (log.isDebugEnabled()) {
                log.debug("Stack Trace:", xmpe);
            }
            throw xmpe;
        }
        xmpKey = regPrefix + ":" + splits[1];
        return xmpKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkNamespace(String namespace, Node metadataRoot) throws RepositoryException {
        try {
            return metadataRoot.getSession().getWorkspace().getNamespaceRegistry().getPrefix(namespace);
        }
        catch (NamespaceException e) {
            String prefix = XMPMetaFactory.getSchemaRegistry().getNamespacePrefix(namespace);
            prefix = prefix.indexOf(":") > 0 ? prefix.substring(0, prefix.indexOf(":")) : prefix;
            Session serviceSession = null;
            try {
                Session session = metadataRoot.getSession();
                if (this.repository != null) {
                    session = serviceSession = this.repository.loginService(NAMESPACE_UPDATE_HELPER, session.getWorkspace().getName());
                }
                session.getWorkspace().getNamespaceRegistry().registerNamespace(prefix, namespace);
                session = metadataRoot.getSession();
                session.refresh(true);
                String string = session.getWorkspace().getNamespaceRegistry().getPrefix(namespace);
                return string;
            }
            catch (RepositoryException re) {
                log.warn("Registration of {} failed, due to {}, caused by {}", namespace, re.toString(), re.getCause().toString());
            }
            finally {
                if (null != serviceSession) {
                    serviceSession.logout();
                }
            }
            return prefix;
        }
    }

    private String registerNs(String nsPrefix, String namespace) throws XMPException {
        String regPrefix = XMPMetaFactory.getSchemaRegistry().getNamespacePrefix(namespace) == null ? XMPMetaFactory.getSchemaRegistry().registerNamespace(namespace, nsPrefix) : XMPMetaFactory.getSchemaRegistry().getNamespacePrefix(namespace);
        return regPrefix.indexOf(":") > 0 ? regPrefix.substring(0, regPrefix.indexOf(":")) : regPrefix;
    }

    private void extractHierarchicalSubjects(Asset asset, Session session) {
        Resource assetResource = asset.adaptTo(Resource.class);
        ResourceResolver resolver = assetResource.getResourceResolver();
        Resource metadataResource = resolver.getResource(assetResource, "jcr:content/metadata");
        if (null != metadataResource) {
            ValueMap props = metadataResource.adaptTo(ValueMap.class);
            Object[] subjects = props.get(METADATA_PROPERTY_NAME_ADOBE_KEYWORDS, new String[0]);
            log.debug("got hierarchical subjects [{}] with content [{}].", (Object)METADATA_PROPERTY_NAME_ADOBE_KEYWORDS, (Object)StringUtils.join(subjects, ", "));
            if (subjects.length > 0) {
                if (this.tagManagerFactory == null) {
                    log.warn("cannot save hierarchical subjects for asset [{}]", (Object)asset.getPath());
                    return;
                }
                TagManager tagManager = this.tagManagerFactory.getTagManager(session);
                ArrayList<Tag> tags = new ArrayList<Tag>();
                for (Object subject : subjects) {
                    String titlePath = StringUtils.replaceOnce((String)subject, ":|", ":");
                    Tag tag = tagManager.resolveByTitle(titlePath = StringUtils.replace(titlePath, "|", "/"));
                    if (null != tag) {
                        log.debug("got tag [{}] from title path [{}].", (Object)tag.getTagID(), (Object)titlePath);
                        tags.add(tag);
                        continue;
                    }
                    log.warn("could not find tag from title path [{}].", (Object)titlePath);
                }
                if (!tags.isEmpty()) {
                    try {
                        log.debug("tagging [{}] with [{}] tags.", (Object)asset.getPath(), (Object)tags.size());
                        tagManager.setTags(metadataResource, tags.toArray(new Tag[tags.size()]), !asset.isBatchMode());
                    }
                    catch (Exception e) {
                        log.error("cannot save hierarchical subjects for asset [{}]: ", (Object)asset.getPath(), (Object)e);
                    }
                }
            }
        } else {
            log.error("cannot save hierarchical subjects for asset [{}], doesn't have metdata node.", (Object)asset.getPath());
        }
    }

    static {
        altArrayProps.add("dc:description");
        altArrayProps.add("dc:title");
        altArrayProps.add("dc:rights");
        altArrayProps.add("xmpRights:UsageTerms");
        altArrayProps.add("exif:UserComment");
        altArrayProps.add("tiff:Copyright");
        altArrayProps.add("tiff:ImageDescription");
        ignoreHierarchy = new ArrayList<String>();
        ignoreHierarchy.add("dc:description");
        ignoreHierarchy.add("dc:title");
        ignoreHierarchy.add("dc:rights");
        ignoreHierarchy.add("xmpRights:UsageTerms");
        ignoreHierarchy.add("exif:UserComment");
        ignoreHierarchy.add("tiff:Copyright");
        ignoreHierarchy.add("tiff:ImageDescription");
        ignoreHierarchy.add("cq:tags");
        ignoreHierarchy.add("dc:creator");
        ignoreHierarchy.add("creator");
        ignoreHierarchy.add("dc:contributor");
        ignoreHierarchy.add("dc:language");
        ignoreHierarchy.add("dc:subject");
        ignoreHierarchy.add("photoshop:SupplementalCategories");
    }

    protected void bindXmpFilter(XmpFilter xmpFilter) {
        this.xmpFilter = xmpFilter;
    }

    protected void unbindXmpFilter(XmpFilter xmpFilter) {
        if (this.xmpFilter == xmpFilter) {
            this.xmpFilter = null;
        }
    }

    protected void bindTagManagerFactory(JcrTagManagerFactory jcrTagManagerFactory) {
        this.tagManagerFactory = jcrTagManagerFactory;
    }

    protected void unbindTagManagerFactory(JcrTagManagerFactory jcrTagManagerFactory) {
        if (this.tagManagerFactory == jcrTagManagerFactory) {
            this.tagManagerFactory = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    private class DBParserErrorHandler
    implements ErrorHandler {
        private DBParserErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            log.debug("DBParserErrorHandler error: " + exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            log.debug("DBParserErrorHandler fatalError: " + exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            log.debug("DBParserErrorHandler warning: " + exception);
        }
    }
}

