/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.adobe.cq.dam.cfm.ContentElement;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.ContentVariation;
import com.adobe.granite.asset.api.AssetRelation;
import com.adobe.granite.confmgr.Conf;
import com.adobe.granite.translation.core.MachineTranslationCloudConfig;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkflowData;
import com.adobe.granite.workflow.model.WorkflowModel;
import com.day.cq.commons.Language;
import com.day.cq.commons.LanguageUtil;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.dam.commons.util.UIHelper;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.PageManagerFactory;
import com.day.cq.wcm.api.WCMException;
import com.day.text.Text;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.resource.collection.ResourceCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DamLanguageUtil {
    private static final Logger log = LoggerFactory.getLogger(DamLanguageUtil.class);
    private static final String UPDATE_ASSET_WORKFLOW_MODEL = "/var/workflow/models/dam/update_asset";
    private static final String ATTRIBUTE_DESTINATION_LANGUAGE_COPY_PATH = "dam:destinationLanguageCopy";
    private static final String ATTRIBUTE_EXTRACT_METADATA = "dam:extractMetadata";
    private static final String ATTRIBUTE_SMART_ASSET_UPDATE_SOURCE = "dam:smartAssetUpdateSource";
    private static final String ATTRIBUTE_SMART_ASSET_UPDATE_REQUIRED = "dam:smartAssetUpdateRequired";
    private static final String ATTRIBUTE_CLOUD_CONFIG_PROPERTY = "cq:cloudserviceconfigs";
    private static final String ATTRIBUTE_CA_CONFIG_PROPERTY = "cq:conf";
    private static final String ATTRIBUTE_CQ_TRANSLATION_SOURCE_PATH = "cq:translationSourcePath";
    private static final String CACONFIG_ROOT = "/conf";
    private static final String CACONFIG_GLOBAL = "/conf/global";
    private static final String CACONFIG_TRANSLATIONCFG_PATH = "cloudconfigs/translation/translationcfg";
    private static final String DEFAULT_LANGUAGES_HOME = "wcm/core/resources/languages";
    private static final String ASSET_PERFORMANCE_NODE_RELATIVE_PATH = "/jcr:content/performance";
    private static final String ASSET_USAGE_NODE_RELATIVE_PATH = "/jcr:content/usages";
    private static final String ASSET_VERSION_MESSAGE = "Created by Asset Update Translation";
    private static final String ASSOCIATED_CONTENT_RELATIVE_PATH = "jcr:content/associated";
    private static final String ASSOCIATED_CONTENT_CHILD = "associated";
    private static final String CONTENT_FRAGMENT = "contentFragment";
    private static final String ATTRIBUTE_ASSET_DERIVED_RELATION = "derived";
    private static final String ATTRIBUTE_ASSET_OTHERS_RELATION = "others";
    private static final String MIME_TYPE_HTML = "text/html";
    private static final int MAX_DIFF_MILLISECOND_CHANGED = 2000;
    public static final String ATTRIBUTE_ASSET_LINKS_RELATION = "links";
    public static final String ATTRIBUTE_ASSET_SOURCE_RELATION = "sources";
    public static final String ATTRIBUTE_ASSET_UPDATE_REQUIRED = "dam:assetUpdateRequired";
    public static final String ATTRIBUTE_COLLECTION_SOURCE_LANGUAGE_COPY = "dam:collectionSourceLanguageCopy";
    public static final String CQ_LASTMODIFIED = "cq:lastModified";
    public static final String ATTRIBUTE_CQ_TRANSLATION_LAST_UPDATE = "cq:lastTranslationUpdate";

    public static boolean hasLanguageCopy(String assetPath, String languageCode, ResourceResolver resolver) {
        Asset asset = DamLanguageUtil.findLanguageCopy(assetPath, languageCode, resolver);
        return asset != null;
    }

    public static Asset getLanguageCopy(String assetPath, String languageCode, ResourceResolver resolver) {
        return DamLanguageUtil.findLanguageCopy(assetPath, languageCode, resolver);
    }

    public static List<String> createLanguageCopy(ResourceResolver resourceResolver, PageManagerFactory pageManagerFactory, String sourcePath, String[] targetLanguageCodes) {
        Session session = resourceResolver.adaptTo(Session.class);
        PageManager pageManager = pageManagerFactory.getPageManager(resourceResolver);
        Resource sourceResource = resourceResolver.getResource(sourcePath);
        ArrayList<String> createdCopies = new ArrayList<String>();
        String contentPath = "";
        if (targetLanguageCodes == null || targetLanguageCodes.length == 0 || targetLanguageCodes[0].trim().length() == 0) {
            log.error("Failed to load destination language from payload.");
            return createdCopies;
        }
        String root = LanguageUtil.getLanguageRoot(sourcePath);
        String parentOfRoot = null;
        boolean createNewLanguageRoot = false;
        Node sourceLanguageRootNode = null;
        Node sourceLRContentNode = null;
        if (root == null) {
            log.debug("Language root does not exist for asset at path: {} and would be created. ", (Object)sourcePath);
            if (Text.getRelativeParent(sourcePath, 1).equals("/content/dam")) {
                parentOfRoot = "/content/dam";
                root = "/content/dam";
            } else if (sourcePath.startsWith("/content/dam/")) {
                int parentOfRootPathLength = sourcePath.indexOf(47, "/content/dam".length() + 1);
                int oldRootPathLength = sourcePath.indexOf(47, parentOfRootPathLength);
                if (parentOfRootPathLength < 0 || sourcePath.length() <= parentOfRootPathLength) {
                    return createdCopies;
                }
                parentOfRoot = sourcePath.substring(0, parentOfRootPathLength);
                if (oldRootPathLength > 0 && sourcePath.length() > oldRootPathLength) {
                    root = sourcePath.substring(0, oldRootPathLength);
                }
            }
            createNewLanguageRoot = true;
            log.info("Parent of New Language root at path {} added for asset at path {}", (Object)parentOfRoot, (Object)sourcePath);
            contentPath = sourcePath.replaceFirst(parentOfRoot, "");
        } else {
            contentPath = sourcePath.replaceFirst(root, "");
            parentOfRoot = Text.getRelativeParent(root, 1);
        }
        for (int i = 0; i < targetLanguageCodes.length; ++i) {
            String targetPath = "";
            String languageRootPath = "";
            String strDestinationLanguage = DamLanguageUtil.getDestinationLanguageWithAllowedDelimiters(parentOfRoot, targetLanguageCodes[i], resourceResolver);
            languageRootPath = DamLanguageUtil.getDestinationLanguageRoot(parentOfRoot, strDestinationLanguage, resourceResolver);
            targetPath = languageRootPath + contentPath;
            try {
                if (contentPath.trim().length() > 0) {
                    String pathToCreate = Text.getRelativeParent(targetPath, 1);
                    String nodeType = "sling:Folder";
                    sourceLanguageRootNode = session.getNode(root);
                    sourceLRContentNode = sourceLanguageRootNode.getNode("jcr:content");
                    if (sourceLanguageRootNode.isNodeType("sling:OrderedFolder")) {
                        nodeType = "sling:OrderedFolder";
                    }
                    JcrUtil.createPath(pathToCreate, nodeType, nodeType, session, false);
                }
                if (!session.nodeExists(targetPath)) {
                    com.adobe.granite.asset.api.Asset destinationGraniteAsset;
                    Resource destinationResource = pageManager.copy(sourceResource, targetPath, null, false, false, false);
                    if (destinationResource != null && (destinationGraniteAsset = destinationResource.adaptTo(com.adobe.granite.asset.api.Asset.class)) != null) {
                        DamLanguageUtil.removeAssetRelation(destinationGraniteAsset, ATTRIBUTE_ASSET_DERIVED_RELATION);
                        DamLanguageUtil.removeAssetRelation(destinationGraniteAsset, ATTRIBUTE_ASSET_OTHERS_RELATION);
                    }
                    DamLanguageUtil.addTranslationSourcePath(destinationResource, sourceResource.getPath());
                    DamLanguageUtil.setLastTranslationUpdate(destinationResource);
                    DamLanguageUtil.deleteInsightData(destinationResource.getPath(), resourceResolver);
                    Node targetNode = session.getNode(languageRootPath);
                    if (targetNode != null) {
                        Node content;
                        if (!targetNode.hasNode("jcr:content")) {
                            targetNode.addNode("jcr:content", "nt:unstructured");
                        }
                        if (!(content = targetNode.getNode("jcr:content")).hasProperty("jcr:title")) {
                            String displayLanguage = DamLanguageUtil.getLanguageDisplayName(resourceResolver, strDestinationLanguage);
                            content.setProperty("jcr:title", displayLanguage);
                        }
                        if (sourceLRContentNode != null) {
                            if (!content.hasProperty(ATTRIBUTE_CA_CONFIG_PROPERTY) && sourceLRContentNode.hasProperty(ATTRIBUTE_CA_CONFIG_PROPERTY)) {
                                content.setProperty(ATTRIBUTE_CA_CONFIG_PROPERTY, sourceLRContentNode.getProperty(ATTRIBUTE_CA_CONFIG_PROPERTY).getString());
                            }
                            if (!content.hasProperty(ATTRIBUTE_CLOUD_CONFIG_PROPERTY) && sourceLRContentNode.hasProperty(ATTRIBUTE_CLOUD_CONFIG_PROPERTY)) {
                                content.setProperty(ATTRIBUTE_CLOUD_CONFIG_PROPERTY, sourceLRContentNode.getProperty(ATTRIBUTE_CLOUD_CONFIG_PROPERTY).getValues());
                            }
                        }
                        String tempAddTitlePath = contentPath.substring(0, contentPath.lastIndexOf(47));
                        while (tempAddTitlePath.length() > 0) {
                            Node tempNode = session.getNode(languageRootPath + tempAddTitlePath);
                            if (tempNode == null) continue;
                            if (!tempNode.hasNode("jcr:content")) {
                                tempNode.addNode("jcr:content", "nt:unstructured");
                            }
                            Node tempNodeContent = tempNode.getNode("jcr:content");
                            String sourceNodeForTitle = null;
                            sourceNodeForTitle = createNewLanguageRoot ? parentOfRoot + tempAddTitlePath : root + tempAddTitlePath;
                            if (!tempNodeContent.hasProperty("jcr:title")) {
                                Node sourceContentNode;
                                String tempNodeTitle = UIHelper.getTitle(resourceResolver.getResource(sourceNodeForTitle));
                                tempNodeContent.setProperty("jcr:title", tempNodeTitle);
                                Node sourceNode = session.getNode(sourceNodeForTitle);
                                if (sourceNode != null && (sourceContentNode = sourceNode.getNode("jcr:content")) != null) {
                                    if (!tempNodeContent.hasProperty(ATTRIBUTE_CA_CONFIG_PROPERTY) && sourceContentNode.hasProperty(ATTRIBUTE_CA_CONFIG_PROPERTY)) {
                                        tempNodeContent.setProperty(ATTRIBUTE_CA_CONFIG_PROPERTY, sourceContentNode.getProperty(ATTRIBUTE_CA_CONFIG_PROPERTY).getString());
                                    }
                                    if (!tempNodeContent.hasProperty(ATTRIBUTE_CLOUD_CONFIG_PROPERTY) && sourceContentNode.hasProperty(ATTRIBUTE_CLOUD_CONFIG_PROPERTY)) {
                                        tempNodeContent.setProperty(ATTRIBUTE_CLOUD_CONFIG_PROPERTY, sourceContentNode.getProperty(ATTRIBUTE_CLOUD_CONFIG_PROPERTY).getValues());
                                    }
                                }
                            }
                            tempAddTitlePath = tempAddTitlePath.substring(0, tempAddTitlePath.lastIndexOf(47));
                        }
                    }
                } else {
                    log.info("Could not create language copy for assets at path: " + targetPath + ", resource already exists. Updating language copy.");
                    Asset sourceAsset = resourceResolver.getResource(sourcePath).adaptTo(Asset.class);
                    Asset targetAsset = resourceResolver.getResource(targetPath).adaptTo(Asset.class);
                    if (sourceAsset != null && targetAsset != null) {
                        if (DamLanguageUtil.isSmartAssetUpdateRequired(sourceAsset, targetAsset)) {
                            DamLanguageUtil.addSmartAssetUpdateSource(targetAsset, sourcePath);
                            DamLanguageUtil.addSmartAssetUpdateProperty(targetAsset, true);
                        } else {
                            DamLanguageUtil.addSmartAssetUpdateProperty(targetAsset, false);
                        }
                    }
                }
                createdCopies.add(targetPath);
                continue;
            }
            catch (Exception e) {
                log.error("error while creating language copy for assets at path: " + targetPath + "{}", e);
            }
        }
        return createdCopies;
    }

    private static void addTranslationSourcePath(Resource destinationResource, String translationSourcePath) throws RepositoryException {
        Node destNode = destinationResource.adaptTo(Node.class);
        if (destinationResource != null) {
            Node contentNode = destNode.getNode("jcr:content");
            contentNode.setProperty(ATTRIBUTE_CQ_TRANSLATION_SOURCE_PATH, translationSourcePath);
        }
    }

    private static Asset findLanguageCopy(String assetPath, String languageCode, ResourceResolver resolver) {
        Resource assetResource = resolver.getResource(assetPath);
        if (assetResource == null || assetResource.adaptTo(Asset.class) == null) {
            return null;
        }
        Asset asset = null;
        String languageRootPath = LanguageUtil.getLanguageRoot(assetPath);
        if (languageRootPath == null) {
            return null;
        }
        String contentPath = assetPath.replaceFirst(languageRootPath, "");
        String languageRootParentPath = Text.getRelativeParent(languageRootPath, 1);
        String destinationLanguageRootPath = DamLanguageUtil.getDestinationLanguageRoot(languageRootParentPath, languageCode, resolver);
        String assetPathLC = destinationLanguageRootPath + contentPath;
        Resource assetResourceLC = resolver.getResource(assetPathLC);
        if (assetResourceLC != null) {
            asset = assetResourceLC.adaptTo(Asset.class);
        }
        return asset;
    }

    @Deprecated
    public static String getLanguageRoot(String path) {
        throw new UnsupportedOperationException("This API has been deprecated.Please use com.day.cq.commons.LanguageUtil instead.");
    }

    @Deprecated
    public static Language getLanguage(String path) {
        throw new UnsupportedOperationException("This API has been deprecated.Please use com.day.cq.commons.LanguageUtil instead.");
    }

    public static Collection<Resource> getLanguageRoots(ResourceResolver resolver, String path) {
        Iterator<Resource> resources = DamLanguageUtil.getLanguageRootSiblings(resolver, path);
        if (resources == null) {
            return Collections.emptySet();
        }
        ArrayList<Resource> roots = new ArrayList<Resource>();
        while (resources.hasNext()) {
            Resource res = resources.next();
            Locale locale = DamLanguageUtil.getLocaleFromResource(res);
            if (locale == null) continue;
            roots.add(res);
        }
        Resource currentResource = resolver.getResource(path);
        Resource langRoot = DamLanguageUtil.getLanguageRootResource(currentResource);
        if (null != langRoot) {
            Resource langRootParent = langRoot.getParent();
            boolean additionalLanguageRootsFound = false;
            Iterator<Resource> iter = langRootParent.listChildren();
            while (iter.hasNext()) {
                Resource sibling = iter.next();
                Locale locale = DamLanguageUtil.getLocaleFromResource(sibling);
                if (locale != null) continue;
                additionalLanguageRootsFound = DamLanguageUtil.addLanguageRootsFromChildren(roots, additionalLanguageRootsFound, sibling);
            }
            if (additionalLanguageRootsFound) {
                return roots;
            }
            Resource langRootGrandParent = langRootParent.getParent();
            ArrayList<Resource> nonLangRootUncles = new ArrayList<Resource>();
            if (langRootGrandParent != null) {
                Iterator<Resource> langRootUncles = langRootGrandParent.listChildren();
                while (langRootUncles.hasNext()) {
                    Resource langRootUncle = langRootUncles.next();
                    if (langRootUncle.getName().equals(langRootParent.getName())) continue;
                    Locale gcLocale = DamLanguageUtil.getLocaleFromResource(langRootUncle);
                    if (gcLocale != null && !DamLanguageUtil.isCountryNode(langRootUncle)) {
                        roots.add(langRootUncle);
                        additionalLanguageRootsFound = true;
                        continue;
                    }
                    nonLangRootUncles.add(langRootUncle);
                }
            }
            if (!additionalLanguageRootsFound) {
                return roots;
            }
            for (Resource nonLangRootUncle : nonLangRootUncles) {
                additionalLanguageRootsFound = DamLanguageUtil.addLanguageRootsFromChildren(roots, additionalLanguageRootsFound, nonLangRootUncle);
            }
        }
        return roots;
    }

    private static boolean addLanguageRootsFromChildren(List<Resource> roots, boolean additionalLanguageRootsFound, Resource resource) {
        Iterator<Resource> children = resource.listChildren();
        while (children.hasNext()) {
            Resource child = children.next();
            Locale childLocale = DamLanguageUtil.getLocaleFromResource(child);
            if (childLocale == null) continue;
            roots.add(child);
            additionalLanguageRootsFound = true;
        }
        return additionalLanguageRootsFound;
    }

    private static Iterator<Resource> getLanguageRootSiblings(ResourceResolver resolver, @Nonnull String path) {
        String root = LanguageUtil.getLanguageRoot(path);
        if (root == null) {
            return null;
        }
        String parent = Text.getRelativeParent(root, 1);
        Resource parentResource = resolver.getResource(parent);
        if (parentResource == null) {
            return null;
        }
        return resolver.listChildren(parentResource);
    }

    private static Resource getLanguageRootResource(@Nonnull Resource res) {
        String rootPath = LanguageUtil.getLanguageRoot(res.getPath());
        if (rootPath == null) {
            return null;
        }
        return res.getResourceResolver().getResource(rootPath);
    }

    public static String createUpdateLanguageCopy(ResourceResolver resourceResolver, PageManagerFactory pageManagerFactory, String sourcePath, String targetLanguageCode, String prefixPath) {
        Session session = resourceResolver.adaptTo(Session.class);
        PageManager pageManager = pageManagerFactory.getPageManager(resourceResolver);
        Resource sourceResource = resourceResolver.getResource(sourcePath);
        String createdCopy = "";
        String contentPath = "";
        if (targetLanguageCode == null || targetLanguageCode.trim().length() == 0) {
            log.error("Failed to load destination language from payload.");
            return null;
        }
        String root = LanguageUtil.getLanguageRoot(sourcePath);
        String parentOfRoot = null;
        boolean createNewLanguageRoot = false;
        if (root == null) {
            log.debug("Language root does not exist for asset at path: {} and would be created. ", (Object)sourcePath);
            if (Text.getRelativeParent(sourcePath, 1).equals("/content/dam")) {
                parentOfRoot = "/content/dam";
                root = "/content/dam";
            } else if (sourcePath.startsWith("/content/dam/")) {
                int parentOfRootPathLength = sourcePath.indexOf(47, "/content/dam".length() + 1);
                int oldRootPathLength = sourcePath.indexOf(47, parentOfRootPathLength);
                if (parentOfRootPathLength < 0 || sourcePath.length() <= parentOfRootPathLength) {
                    return createdCopy;
                }
                parentOfRoot = sourcePath.substring(0, parentOfRootPathLength);
                if (oldRootPathLength > 0 && sourcePath.length() > oldRootPathLength) {
                    root = sourcePath.substring(0, oldRootPathLength);
                }
            }
            createNewLanguageRoot = true;
            log.info("Parent of New Language root at path {} added for asset at path {}", (Object)parentOfRoot, (Object)sourcePath);
            contentPath = sourcePath.replaceFirst(parentOfRoot, "");
        } else {
            contentPath = sourcePath.replaceFirst(root, "");
            parentOfRoot = Text.getRelativeParent(root, 1);
        }
        String targetPath = "";
        String languageRootPath = "";
        String strDestinationLanguage = DamLanguageUtil.getDestinationLanguageWithAllowedDelimiters(prefixPath + parentOfRoot, targetLanguageCode, resourceResolver);
        languageRootPath = prefixPath + DamLanguageUtil.getDestinationLanguageRoot(parentOfRoot, strDestinationLanguage, resourceResolver);
        targetPath = languageRootPath + contentPath;
        try {
            String pathToCreate = Text.getRelativeParent(targetPath, 1);
            String nodeType = "sling:Folder";
            if (session.getNode(root).isNodeType("sling:OrderedFolder")) {
                nodeType = "sling:OrderedFolder";
            }
            JcrUtil.createPath(pathToCreate, nodeType, nodeType, session, false);
            if (null == resourceResolver.getResource(targetPath)) {
                Node targetNode;
                if (DamUtil.isAsset(sourceResource)) {
                    com.adobe.granite.asset.api.Asset destinationGraniteAsset;
                    Resource destinationResource = pageManager.copy(sourceResource, targetPath, null, false, true, false);
                    if (destinationResource != null && (destinationGraniteAsset = destinationResource.adaptTo(com.adobe.granite.asset.api.Asset.class)) != null) {
                        DamLanguageUtil.removeAssetRelation(destinationGraniteAsset, ATTRIBUTE_ASSET_DERIVED_RELATION);
                        DamLanguageUtil.removeAssetRelation(destinationGraniteAsset, ATTRIBUTE_ASSET_OTHERS_RELATION);
                    }
                    DamLanguageUtil.addTranslationSourcePath(destinationResource, sourceResource.getPath());
                    DamLanguageUtil.setLastTranslationUpdate(destinationResource);
                    DamLanguageUtil.deleteInsightData(destinationResource.getPath(), resourceResolver);
                    DamLanguageUtil.removeAllRenditionsInsideResource(destinationResource);
                    String destinationForTemporaryAsset = parentOfRoot + "/" + strDestinationLanguage + contentPath;
                    DamLanguageUtil.setDestinationLanguageCopyPath(destinationResource, destinationForTemporaryAsset);
                    createdCopy = destinationResource.getPath();
                }
                if ((targetNode = session.getNode(languageRootPath)) != null) {
                    Node content;
                    if (!targetNode.hasNode("jcr:content")) {
                        targetNode.addNode("jcr:content", "nt:unstructured");
                    }
                    if (!(content = targetNode.getNode("jcr:content")).hasProperty("jcr:title")) {
                        String displayLanguage = DamLanguageUtil.getLanguageDisplayName(resourceResolver, strDestinationLanguage);
                        content.setProperty("jcr:title", displayLanguage);
                    }
                    String tempAddTitlePath = contentPath.substring(0, contentPath.lastIndexOf(47));
                    while (tempAddTitlePath.length() > 0) {
                        Node tempNode = session.getNode(languageRootPath + tempAddTitlePath);
                        if (tempNode == null) continue;
                        if (!tempNode.hasNode("jcr:content")) {
                            tempNode.addNode("jcr:content", "nt:unstructured");
                        }
                        Node tempNodeContent = tempNode.getNode("jcr:content");
                        String sourceNodeForTitle = null;
                        sourceNodeForTitle = createNewLanguageRoot ? parentOfRoot + tempAddTitlePath : root + tempAddTitlePath;
                        if (!tempNodeContent.hasProperty("jcr:title")) {
                            String tempNodeTitle = UIHelper.getTitle(resourceResolver.getResource(sourceNodeForTitle));
                            tempNodeContent.setProperty("jcr:title", tempNodeTitle);
                        }
                        tempAddTitlePath = tempAddTitlePath.substring(0, tempAddTitlePath.lastIndexOf(47));
                    }
                }
                session.save();
            } else {
                createdCopy = targetPath;
            }
        }
        catch (Exception e) {
            log.error("error while creating language copy for assets at path: " + targetPath + "{}", e);
        }
        return createdCopy;
    }

    private static String getDestinationLanguageWithAllowedDelimiters(String contentPath, String strDestinationLanguage, ResourceResolver resourceResolver) {
        boolean langWithUnderscoreExist;
        String langWithHyphen = strDestinationLanguage.replace("_", "-");
        String langWithUnderscore = strDestinationLanguage.replace("-", "_");
        boolean langWithHyphenExist = null != resourceResolver.getResource(contentPath + "/" + langWithHyphen);
        boolean bl = langWithUnderscoreExist = null != resourceResolver.getResource(contentPath + "/" + langWithUnderscore);
        if (langWithHyphenExist && langWithUnderscoreExist) {
            return strDestinationLanguage;
        }
        if (langWithHyphenExist) {
            return langWithHyphen;
        }
        if (langWithUnderscoreExist) {
            return langWithUnderscore;
        }
        return strDestinationLanguage;
    }

    private static void deleteInsightData(String resourcePath, ResourceResolver resourceResolver) {
        Resource resource = resourceResolver.getResource(resourcePath);
        if (resource != null) {
            if (DamUtil.isAsset(resource)) {
                DamLanguageUtil.deleteResource(resourcePath + ASSET_PERFORMANCE_NODE_RELATIVE_PATH, resourceResolver);
                DamLanguageUtil.deleteResource(resourcePath + ASSET_USAGE_NODE_RELATIVE_PATH, resourceResolver);
            } else if (DamLanguageUtil.isFolder(resource)) {
                Iterator<Asset> assetIterator = DamUtil.getAssets(resource);
                while (assetIterator.hasNext()) {
                    String assetPath = assetIterator.next().getPath();
                    DamLanguageUtil.deleteResource(assetPath + ASSET_PERFORMANCE_NODE_RELATIVE_PATH, resourceResolver);
                    DamLanguageUtil.deleteResource(assetPath + ASSET_USAGE_NODE_RELATIVE_PATH, resourceResolver);
                }
            }
        }
    }

    private static void deleteResource(String path, ResourceResolver resourceResolver) {
        Resource resource = resourceResolver.getResource(path);
        if (resource != null) {
            try {
                resourceResolver.delete(resource);
            }
            catch (PersistenceException e) {
                log.error("Unable to delete resource from {} : {}", (Object)resource, (Object)e.getMessage());
            }
        }
    }

    private static void setDestinationLanguageCopyPath(Resource temporaryResource, String destinationPath) throws RepositoryException {
        Node temporaryNode = temporaryResource.adaptTo(Node.class);
        if (!temporaryNode.hasNode("jcr:content")) {
            temporaryNode.addNode("jcr:content", "nt:unstructured");
        }
        Node destinationContentNode = temporaryNode.getNode("jcr:content");
        destinationContentNode.setProperty(ATTRIBUTE_DESTINATION_LANGUAGE_COPY_PATH, destinationPath);
    }

    private static boolean isFolder(Resource resource) {
        Node n = resource.adaptTo(Node.class);
        try {
            return n.isNodeType("nt:folder");
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Deprecated
    public static void moveUpdatedAsset(String sourcePath, String destinationPath, Session userSession, PageManagerFactory pageManagerFactory, ResourceResolverFactory resolverFactory) {
        throw new UnsupportedOperationException("This API has been deprecated.Please use moveUpdatedAsset(String, String, Session, PageManagerFactory, ResourceResolver) instead.");
    }

    public static void moveUpdatedAsset(String sourcePath, String destinationPath, Session userSession, PageManagerFactory pageManagerFactory, ResourceResolver resourceResolver) {
        HashMap<String, Session> authInfo = new HashMap<String, Session>();
        authInfo.put("user.jcr.session", userSession);
        try {
            Resource sourceResource = resourceResolver.getResource(sourcePath);
            Resource destinationResource = resourceResolver.getResource(destinationPath);
            Asset sourceAsset = DamUtil.resolveToAsset(sourceResource);
            if (sourceAsset != null) {
                PageManager pageManager = pageManagerFactory.getPageManager(resourceResolver);
                if (destinationResource == null) {
                    String pathToCreate = Text.getRelativeParent(destinationPath, 1);
                    String nodeType = "sling:Folder";
                    JcrUtil.createPath(pathToCreate, nodeType, nodeType, userSession, false);
                    pageManager.copy(sourceResource, destinationPath, null, false, false, true);
                } else {
                    Asset destinationAsset = DamUtil.resolveToAsset(destinationResource);
                    if (destinationAsset != null) {
                        destinationAsset.addRendition("original", sourceAsset.getOriginal().getBinary(), sourceAsset.getMimeType());
                    } else {
                        log.error("Unable to move updated asset : Destination Asset not found");
                    }
                }
                userSession.save();
            } else {
                log.error("Unable to move updated asset : Source Asset not found");
            }
        }
        catch (Exception e) {
            log.error("Unable to move updated asset {}", (Object)e.getMessage());
        }
    }

    public static void replaceUpdatedAsset(String sourcePath, String destinationPath, Session userSession, PageManagerFactory pageManagerFactory, ResourceResolver resourceResolver) {
        try {
            Resource sourceResource = resourceResolver.getResource(sourcePath);
            Resource destinationResource = resourceResolver.getResource(destinationPath);
            Asset sourceAsset = sourceResource.adaptTo(Asset.class);
            if (sourceAsset != null && !DamLanguageUtil.isContentFragment(sourceAsset)) {
                DamLanguageUtil.addExtractMetadataPropertyForAsset(sourceAsset, false);
            }
            if (sourceResource != null) {
                PageManager pageManager = pageManagerFactory.getPageManager(resourceResolver);
                if (destinationResource == null) {
                    String pathToCreate = Text.getRelativeParent(destinationPath, 1);
                    String nodeType = "sling:Folder";
                    JcrUtil.createPath(pathToCreate, nodeType, nodeType, userSession, false);
                    pageManager.copy(sourceResource, destinationPath, null, false, false, true);
                } else {
                    Asset destinationAsset = resourceResolver.getResource(destinationPath).adaptTo(Asset.class);
                    if (destinationAsset != null) {
                        destinationAsset.createRevision("", ASSET_VERSION_MESSAGE);
                        DamLanguageUtil.copyInsightData(destinationResource.getPath(), sourceResource.getPath(), resourceResolver, pageManager);
                        DamLanguageUtil.deleteAllChildren(destinationResource, userSession);
                        DamLanguageUtil.copyAllChildren(sourceResource, destinationResource, pageManager, userSession);
                        WorkflowSession workflowSession = resourceResolver.adaptTo(WorkflowSession.class);
                        WorkflowModel modelToStart = workflowSession.getModel(UPDATE_ASSET_WORKFLOW_MODEL);
                        WorkflowData workflowData = workflowSession.newWorkflowData("JCR_PATH", destinationPath);
                        workflowSession.startWorkflow(modelToStart, workflowData);
                    } else {
                        log.error("Unable to move updated asset : Destination is not an Asset");
                    }
                }
                userSession.save();
            } else {
                log.error("Unable to move updated asset : Source Resource not found");
            }
        }
        catch (Exception e) {
            log.error("Unable to move updated asset {}", (Object)e.getMessage());
        }
    }

    private static void copyInsightData(String sourcePath, String destinationPath, ResourceResolver resourceResolver, PageManager pageManager) {
        DamLanguageUtil.copyResource(sourcePath + ASSET_PERFORMANCE_NODE_RELATIVE_PATH, destinationPath + ASSET_PERFORMANCE_NODE_RELATIVE_PATH, resourceResolver, pageManager);
        DamLanguageUtil.copyResource(sourcePath + ASSET_USAGE_NODE_RELATIVE_PATH, destinationPath + ASSET_USAGE_NODE_RELATIVE_PATH, resourceResolver, pageManager);
    }

    private static void copyResource(String sourcePath, String destinationPath, ResourceResolver resourceResolver, PageManager pageManager) {
        Resource sourceResource = resourceResolver.getResource(sourcePath);
        if (sourceResource != null) {
            try {
                pageManager.copy(sourceResource, destinationPath, null, false, false, false);
            }
            catch (WCMException e) {
                log.error("Unable to copy resource from " + sourcePath + " to " + destinationPath + " : {}", (Object)e.getMessage());
            }
        }
    }

    private static void copyAllChildren(Resource sourceResource, Resource destinationResource, PageManager pageManager, Session session) throws RepositoryException, WCMException {
        if (sourceResource != null && destinationResource != null) {
            Iterable<Resource> childList = sourceResource.getChildren();
            String destinationResourcePath = destinationResource.getPath();
            for (Resource child : childList) {
                String destinationChildPath = destinationResourcePath + "/" + child.getName();
                pageManager.copy(child, destinationChildPath, null, false, false, false);
            }
            session.save();
        }
    }

    private static void deleteAllChildren(Resource resource, Session session) throws RepositoryException {
        if (resource != null) {
            Iterable<Resource> childList = resource.getChildren();
            for (Resource child : childList) {
                Node childNode = child.adaptTo(Node.class);
                childNode.remove();
            }
        }
        session.save();
    }

    private static void removeAllRenditionsInsideResource(Resource resource) throws RepositoryException {
        Iterator<Asset> assets = DamUtil.getAssets(resource);
        while (assets.hasNext()) {
            Asset asset = assets.next();
            if (DamLanguageUtil.isContentFragment(asset)) continue;
            List<Rendition> renditions = asset.getRenditions();
            for (Rendition rendition : renditions) {
                String name = rendition.getName();
                if (name.equals("original")) continue;
                asset.removeRendition(name);
            }
        }
    }

    private static boolean isContentFragment(Asset asset) throws RepositoryException {
        Node assetNode = asset.adaptTo(Node.class);
        Node jcrNode = assetNode.getNode("jcr:content");
        if (jcrNode.hasProperty(CONTENT_FRAGMENT)) {
            return jcrNode.getProperty(CONTENT_FRAGMENT).getBoolean();
        }
        return false;
    }

    public static boolean isSmartAssetUpdateRequired(Asset sourceAsset, Asset destinationAsset) {
        if (sourceAsset == null || destinationAsset == null) {
            return false;
        }
        Resource sourceResource = sourceAsset.adaptTo(Resource.class);
        Resource destResource = destinationAsset.adaptTo(Resource.class);
        boolean bRetVal = false;
        if (sourceResource != null && destResource != null) {
            Resource sourceContentResource = sourceResource.getChild("jcr:content");
            Resource destContentResource = destResource.getChild("jcr:content");
            if (sourceContentResource == null) {
                sourceContentResource = sourceResource;
            }
            if (destContentResource == null) {
                destContentResource = destResource;
            }
            Calendar sourceLastModified = DamLanguageUtil.getNodeLastModifiedTime(sourceContentResource);
            Calendar lastTranslationUpdate = DamLanguageUtil.getCalendarAttribute(destContentResource, ATTRIBUTE_CQ_TRANSLATION_LAST_UPDATE);
            if (lastTranslationUpdate != null) {
                if (sourceLastModified != null) {
                    bRetVal = sourceLastModified.getTimeInMillis() - lastTranslationUpdate.getTimeInMillis() > 2000L;
                }
            } else {
                bRetVal = true;
            }
        }
        return bRetVal;
    }

    @Deprecated
    public static void addSmartAssetUpdateFlag(Asset destinationAsset) throws RepositoryException {
        throw new UnsupportedOperationException("This API has been deprecated.Please use addSmartAssetUpdateSource(Asset, String) instead.");
    }

    public static void addSmartAssetUpdateSource(Asset destinationAsset, String sourcePath) throws RepositoryException {
        if (destinationAsset == null || sourcePath == null) {
            return;
        }
        Node assetNode = destinationAsset.adaptTo(Node.class);
        if (!assetNode.hasNode("jcr:content")) {
            assetNode.addNode("jcr:content", "nt:unstructured");
        }
        Node assetContentNode = assetNode.getNode("jcr:content");
        assetContentNode.setProperty(ATTRIBUTE_SMART_ASSET_UPDATE_SOURCE, sourcePath);
    }

    private static void addSmartAssetUpdateProperty(Asset destinationAsset, boolean value) throws RepositoryException {
        if (destinationAsset == null) {
            return;
        }
        Node assetNode = destinationAsset.adaptTo(Node.class);
        if (!assetNode.hasNode("jcr:content")) {
            assetNode.addNode("jcr:content", "nt:unstructured");
        }
        Node assetContentNode = assetNode.getNode("jcr:content");
        assetContentNode.setProperty(ATTRIBUTE_SMART_ASSET_UPDATE_REQUIRED, value);
    }

    private static void addExtractMetadataPropertyForAsset(Asset asset, boolean bExtractMetadata) throws RepositoryException {
        Node assetNode = asset.adaptTo(Node.class);
        if (!assetNode.hasNode("jcr:content")) {
            assetNode.addNode("jcr:content", "nt:unstructured");
        }
        Node assetContentNode = assetNode.getNode("jcr:content");
        assetContentNode.setProperty(ATTRIBUTE_EXTRACT_METADATA, bExtractMetadata);
    }

    private static String createLanguageCopy(ResourceResolver resourceResolver, PageManagerFactory pageManagerFactory, String sourcePath, String targetLanguageCode) {
        String[] targetLanguageCodeArray = new String[]{targetLanguageCode};
        List<String> languageCopyPathArray = DamLanguageUtil.createLanguageCopy(resourceResolver, pageManagerFactory, sourcePath, targetLanguageCodeArray);
        if (null != languageCopyPathArray && languageCopyPathArray.size() == 1) {
            return languageCopyPathArray.get(0);
        }
        return null;
    }

    public static List<String> createLanguageCopyWithAssetRelations(ResourceResolver resourceResolver, PageManagerFactory pageManagerFactory, String sourcePath, String[] targetLanguageCodes) throws RepositoryException {
        Resource sourceResource = resourceResolver.getResource(sourcePath);
        if (null == sourceResource) {
            return new ArrayList<String>();
        }
        if (null != sourceResource.adaptTo(Asset.class)) {
            return DamLanguageUtil.createLanguageCopyWithAssetRelationsForAsset(resourceResolver, pageManagerFactory, sourcePath, targetLanguageCodes);
        }
        Node sourceNode = sourceResource.adaptTo(Node.class);
        if (null != sourceNode && sourceNode.isNodeType("nt:folder")) {
            return DamLanguageUtil.createLanguageCopyWithAssetRelationsForNTFolder(resourceResolver, pageManagerFactory, sourcePath, targetLanguageCodes);
        }
        return new ArrayList<String>();
    }

    private static String createLanguageCopyWithAssetRelations(String sourcePath, String targetLanguageCode, ResourceResolver resourceResolver, PageManagerFactory pageManagerFactory) throws RepositoryException {
        String[] languageArray = new String[]{targetLanguageCode};
        List<String> languageCopyList = DamLanguageUtil.createLanguageCopyWithAssetRelations(resourceResolver, pageManagerFactory, sourcePath, languageArray);
        if (languageCopyList != null && languageCopyList.size() == 1) {
            return languageCopyList.get(0);
        }
        return null;
    }

    private static void adjustDerivedAndRemoveOthersRelationsForSourceAssetsLC(List<Asset> relatedSourceAssets, String newDerivedAssetPath, String oldDerivedAssetPath, ResourceResolver resourceResolver) {
        String oldLanguageRoot = DamLanguageUtil.getLanguageRootLocale(oldDerivedAssetPath);
        for (Asset sourceDamAsset : relatedSourceAssets) {
            com.adobe.granite.asset.api.Asset sourceAssetLC;
            String targetLanguageCode = DamLanguageUtil.getLanguageRootLocale(newDerivedAssetPath);
            String sourceAssetLCPath = DamLanguageUtil.findLanguageCopyPathWithAutoCreatedRoots(sourceDamAsset.getPath(), targetLanguageCode, resourceResolver);
            Resource sourceAssetLCResource = resourceResolver.getResource(sourceAssetLCPath);
            if (sourceAssetLCResource == null || (sourceAssetLC = sourceAssetLCResource.adaptTo(com.adobe.granite.asset.api.Asset.class)) == null) continue;
            DamLanguageUtil.removeAssetRelationWithLanguageCode(sourceAssetLC, ATTRIBUTE_ASSET_DERIVED_RELATION, oldLanguageRoot);
            DamLanguageUtil.adjustAssetRelations(sourceAssetLC, ATTRIBUTE_ASSET_DERIVED_RELATION, oldDerivedAssetPath, newDerivedAssetPath);
            DamLanguageUtil.removeAssetRelation(sourceAssetLC, ATTRIBUTE_ASSET_OTHERS_RELATION);
        }
    }

    public static List<String> createLanguageCopyWithAssetRelationsForAsset(ResourceResolver resourceResolver, PageManagerFactory pageManagerFactory, String sourcePath, String[] targetLanguageCodes) throws RepositoryException {
        Resource sourceResource = resourceResolver.getResource(sourcePath);
        List<String> createdVariantCopies = new ArrayList<String>();
        String sourceResourcePath = sourceResource.getPath();
        if (null != sourceResource) {
            Asset sourceAsset;
            List<Asset> relatedSourceAssets = DamLanguageUtil.getRelatedAssets(sourceResource, ATTRIBUTE_ASSET_SOURCE_RELATION);
            List<Asset> relatedLinkedAssets = DamLanguageUtil.getRelatedAssets(sourceResource, ATTRIBUTE_ASSET_LINKS_RELATION);
            if (!relatedSourceAssets.isEmpty() || !relatedLinkedAssets.isEmpty()) {
                block9: for (int languageIndex = 0; languageIndex < targetLanguageCodes.length; ++languageIndex) {
                    TranslationCategory translationCategory = DamLanguageUtil.getTranslationCategoryForAssetAndItsRelations(sourcePath, targetLanguageCodes[languageIndex], resourceResolver);
                    switch (translationCategory) {
                        case TEMPORARY: {
                            DamLanguageUtil.createMissingDestinationLanguageCopies(resourceResolver, pageManagerFactory, sourcePath, targetLanguageCodes[languageIndex]);
                            String languageCopyPath = DamLanguageUtil.findLanguageCopyPathWithAutoCreatedRoots(sourcePath, targetLanguageCodes[languageIndex], resourceResolver);
                            Asset destinationAsset = resourceResolver.getResource(languageCopyPath).adaptTo(Asset.class);
                            DamLanguageUtil.addSmartAssetUpdateSource(destinationAsset, sourcePath);
                            DamLanguageUtil.addSmartAssetUpdateProperty(destinationAsset, true);
                            createdVariantCopies.add(languageCopyPath);
                            continue block9;
                        }
                        case DESTINATION: {
                            String variantLanguageCopyPath = DamLanguageUtil.createOrGetLanguageCopy(resourceResolver, pageManagerFactory, sourcePath, targetLanguageCodes[languageIndex]);
                            Resource variantLanguageCopyResource = resourceResolver.getResource(variantLanguageCopyPath);
                            com.adobe.granite.asset.api.Asset graniteDestinationAsset = variantLanguageCopyResource.adaptTo(com.adobe.granite.asset.api.Asset.class);
                            DamLanguageUtil.createRelationLanguageCopy(ATTRIBUTE_ASSET_SOURCE_RELATION, graniteDestinationAsset, relatedSourceAssets, targetLanguageCodes[languageIndex], resourceResolver, pageManagerFactory);
                            DamLanguageUtil.adjustDerivedAndRemoveOthersRelationsForSourceAssetsLC(relatedSourceAssets, variantLanguageCopyPath, sourceResourcePath, resourceResolver);
                            DamLanguageUtil.removeAssetRelation(graniteDestinationAsset, ATTRIBUTE_ASSET_OTHERS_RELATION);
                            DamLanguageUtil.createRelationLanguageCopy(ATTRIBUTE_ASSET_LINKS_RELATION, graniteDestinationAsset, relatedLinkedAssets, targetLanguageCodes[languageIndex], resourceResolver, pageManagerFactory);
                            DamLanguageUtil.createRelationLanguageCopyForSourceRelations(ATTRIBUTE_ASSET_LINKS_RELATION, relatedSourceAssets, targetLanguageCodes[languageIndex], resourceResolver, pageManagerFactory);
                            createdVariantCopies.add(variantLanguageCopyPath);
                            continue block9;
                        }
                        case NONE: {
                            String tempLanguageCopyPath = DamLanguageUtil.findLanguageCopyPathWithAutoCreatedRoots(sourcePath, targetLanguageCodes[languageIndex], resourceResolver);
                            Asset tempDestinationAsset = resourceResolver.getResource(tempLanguageCopyPath).adaptTo(Asset.class);
                            DamLanguageUtil.addSmartAssetUpdateProperty(tempDestinationAsset, false);
                            createdVariantCopies.add(tempLanguageCopyPath);
                        }
                    }
                }
            } else {
                createdVariantCopies = DamLanguageUtil.createLanguageCopy(resourceResolver, pageManagerFactory, sourcePath, targetLanguageCodes);
            }
            if (DamLanguageUtil.isContentFragment(sourceAsset = sourceResource.adaptTo(Asset.class))) {
                try {
                    DamLanguageUtil.createOrUpdateLanguageCopyForAssociatedContent(resourceResolver, pageManagerFactory, sourcePath, targetLanguageCodes);
                }
                catch (Exception e) {
                    log.error("Could not create language copy for associated content. {}", e);
                }
            }
            if (DamLanguageUtil.isContentFragment(sourceAsset)) {
                try {
                    resourceResolver.commit();
                    DamLanguageUtil.createAndReplaceLanguageCopyForEmbeddedAssets(resourceResolver, pageManagerFactory, sourcePath, targetLanguageCodes);
                }
                catch (Exception e) {
                    log.error("Could not create language copy for embedded assets. {}", e);
                }
            }
        }
        return createdVariantCopies;
    }

    private static void createAndReplaceLanguageCopyForEmbeddedAssets(ResourceResolver resourceResolver, PageManagerFactory pageManagerFactory, String sourcePath, String[] targetLanguageCodes) throws RepositoryException, IOException, WCMException, ContentFragmentException {
        String sourceLanguage = DamLanguageUtil.getLanguageRootLocale(sourcePath);
        for (String targetLanguageCode : targetLanguageCodes) {
            String languageCopyPath = DamLanguageUtil.findLanguageCopyPathWithAutoCreatedRoots(sourcePath, targetLanguageCode, resourceResolver);
            if (null == languageCopyPath || !DamLanguageUtil.isTranslateInlineMediaAssets(languageCopyPath, resourceResolver)) continue;
            if (!DamLanguageUtil.temporaryAssetSourcePropertyExist(languageCopyPath, resourceResolver)) {
                boolean bReplacementRequired = DamLanguageUtil.createLanguageCopyForEmbeddedAssets(languageCopyPath, sourceLanguage, targetLanguageCode, resourceResolver, pageManagerFactory);
                if (!bReplacementRequired) continue;
                DamLanguageUtil.replaceEmbeddedAssets(languageCopyPath, targetLanguageCode, resourceResolver);
                continue;
            }
            DamLanguageUtil.createLanguageCopyForEmbeddedAssets(sourcePath, sourceLanguage, targetLanguageCode, resourceResolver, pageManagerFactory);
        }
    }

    private static boolean temporaryAssetSourcePropertyExist(String assetpath, ResourceResolver resourceResolver) throws RepositoryException {
        Node node;
        boolean retVal = false;
        Resource resource = resourceResolver.getResource(assetpath);
        if (null != resource && DamLanguageUtil.getUpdateAssetNodeSourcePath(node = resource.adaptTo(Node.class)) != null) {
            retVal = true;
        }
        return retVal;
    }

    private static boolean createLanguageCopyForEmbeddedAssets(String contentFragmentPath, String sourceLanguageCode, String targetLanguageCode, ResourceResolver resourceResolver, PageManagerFactory pageManagerFactory) throws RepositoryException, IOException {
        HashSet<Asset> embeddedAssets = DamLanguageUtil.getEmbeddedAssets(contentFragmentPath, resourceResolver);
        boolean bReplacementRequired = false;
        DamLanguageUtil.getLanguageRootLocale(contentFragmentPath);
        for (Asset embeddedAsset : embeddedAssets) {
            String sourceEmbeddedAssetPath;
            String embeddedAssetPath = embeddedAsset.getPath();
            if (!DamLanguageUtil.getLanguageRootLocale(embeddedAssetPath).equals(targetLanguageCode)) {
                sourceEmbeddedAssetPath = embeddedAssetPath;
                bReplacementRequired = true;
            } else {
                sourceEmbeddedAssetPath = DamLanguageUtil.findLanguageCopyPathWithAutoCreatedRoots(embeddedAssetPath, sourceLanguageCode, resourceResolver);
            }
            DamLanguageUtil.createLanguageCopyWithAssetRelations(sourceEmbeddedAssetPath, targetLanguageCode, resourceResolver, pageManagerFactory);
        }
        return bReplacementRequired;
    }

    private static void createOrUpdateLanguageCopyForAssociatedContent(ResourceResolver resourceResolver, PageManagerFactory pageManagerFactory, String sourcePath, String[] targetLanguageCodes) throws RepositoryException, PersistenceException, WCMException {
        Resource sourceResource = resourceResolver.getResource(sourcePath);
        if (null != sourceResource) {
            Node sourceNode = sourceResource.adaptTo(Node.class);
            targetLanguageCodes = DamLanguageUtil.getAssociatedContentTranslationLanguages(sourceResource, targetLanguageCodes, resourceResolver);
            ArrayList<Asset> associatedAssets = DamLanguageUtil.getContentFragmentAssociatedAssets(sourceNode, resourceResolver);
            for (Asset asset : associatedAssets) {
                DamLanguageUtil.createLanguageCopyWithAssetRelations(resourceResolver, pageManagerFactory, asset.getPath(), targetLanguageCodes);
            }
            DamLanguageUtil.createOrUpdateLanguageCopyForAssociatedContentNode(resourceResolver, pageManagerFactory, sourcePath, targetLanguageCodes);
        } else {
            log.error("Could not create language copy for associated content. Resource nt found at path {}", (Object)sourcePath);
        }
    }

    private static String[] getAssociatedContentTranslationLanguages(Resource sourceResource, String[] targetLanguageCodes, ResourceResolver resourceResolver) {
        ArrayList<String> applicableLanguages = new ArrayList<String>();
        String sourcePath = sourceResource.getPath();
        for (String targetLanguageCode : targetLanguageCodes) {
            Resource lcResource;
            String lcPath = DamLanguageUtil.findLanguageCopyPathWithAutoCreatedRoots(sourcePath, targetLanguageCode, resourceResolver);
            if (null == lcPath || !DamLanguageUtil.isTranslateAssociatedContent(lcResource = resourceResolver.getResource(lcPath), resourceResolver)) continue;
            applicableLanguages.add(targetLanguageCode);
        }
        return applicableLanguages.toArray(new String[applicableLanguages.size()]);
    }

    private static void createOrUpdateLanguageCopyForAssociatedContentNode(ResourceResolver resourceResolver, PageManagerFactory pageManagerFactory, String sourcePath, String[] targetLanguageCodes) throws PersistenceException, WCMException, RepositoryException {
        DamLanguageUtil.createOrUpdateLanguageCopyForAssociatedContentNode(resourceResolver, pageManagerFactory, sourcePath, targetLanguageCodes, "");
    }

    private static void createOrUpdateLanguageCopyForAssociatedContentNode(ResourceResolver resourceResolver, PageManagerFactory pageManagerFactory, String sourcePath, String[] targetLanguageCodes, String prefixPath) throws PersistenceException, WCMException, RepositoryException {
        Resource sourceAssociatedContentResource = DamLanguageUtil.getAssociatedContentResource(sourcePath, resourceResolver);
        if (sourceAssociatedContentResource == null) {
            return;
        }
        PageManager pageManager = pageManagerFactory.getPageManager(resourceResolver);
        for (String targetLanguageCode : targetLanguageCodes) {
            Iterator<Resource> collectionResources;
            ResourceCollection destinationAssociatedContents = DamLanguageUtil.findAssociatedContentLanguageCopy(sourcePath, prefixPath, targetLanguageCode, resourceResolver);
            if (null == destinationAssociatedContents || null == (collectionResources = DamLanguageUtil.getResourcesFromCollection(sourceAssociatedContentResource))) continue;
            while (collectionResources.hasNext()) {
                Resource sourceCollectionResource = collectionResources.next();
                DamLanguageUtil.createOrUpdateCollectionLanguageCopy(sourceCollectionResource, targetLanguageCode, destinationAssociatedContents, resourceResolver, pageManager);
                DamLanguageUtil.createLCForNestedCollections(sourceCollectionResource, targetLanguageCode, resourceResolver, pageManager);
            }
        }
    }

    private static void createLCForNestedCollections(Resource sourceCollectionResource, String targetLanguageCode, ResourceResolver resourceResolver, PageManager pageManager) throws RepositoryException, WCMException, PersistenceException {
        HashSet<Resource> nestedCollections = new HashSet<Resource>();
        DamLanguageUtil.createLCForNestedCollections(sourceCollectionResource, targetLanguageCode, resourceResolver, pageManager, nestedCollections);
    }

    private static void createLCForNestedCollections(Resource sourceCollectionResource, String targetLanguageCode, ResourceResolver resourceResolver, PageManager pageManager, HashSet<Resource> updatedCollections) throws RepositoryException, WCMException, PersistenceException {
        ResourceCollection sourceCollection = sourceCollectionResource.adaptTo(ResourceCollection.class);
        Iterator<Resource> sourceResources = sourceCollection.getResources();
        while (sourceResources.hasNext()) {
            Resource sourceResource = sourceResources.next();
            if (!DamLanguageUtil.isDamCollection(sourceResource) || updatedCollections.contains(sourceResource)) continue;
            ResourceCollection destinationCollection = DamLanguageUtil.getDestinationCollection(sourceCollection.getPath(), targetLanguageCode, resourceResolver);
            DamLanguageUtil.createOrUpdateCollectionLanguageCopy(sourceResource, targetLanguageCode, destinationCollection, resourceResolver, pageManager);
            updatedCollections.add(sourceResource);
            DamLanguageUtil.createLCForNestedCollections(sourceResource, targetLanguageCode, resourceResolver, pageManager, updatedCollections);
        }
    }

    private static boolean isDamCollection(Resource sourceResource) {
        return sourceResource.isResourceType("dam/collection");
    }

    private static ResourceCollection getDestinationCollection(String sourceCollectionPath, String targetLanguageCode, ResourceResolver resourceResolver) {
        String destinationCollectionPath = DamLanguageUtil.getAssociatedContentLanguageCopyPathOrName(sourceCollectionPath, targetLanguageCode);
        Resource resource = resourceResolver.getResource(destinationCollectionPath);
        if (null == resource) {
            return null;
        }
        return resource.adaptTo(ResourceCollection.class);
    }

    private static ResourceCollection findAssociatedContentLanguageCopy(String sourceContentFragmentPath, String prefixPath, String targetLanguageCode, ResourceResolver resourceResolver) throws RepositoryException {
        String destinationContentFragmentPath = DamLanguageUtil.findLanguageCopyPathWithAutoCreatedRoots(sourceContentFragmentPath, targetLanguageCode, resourceResolver);
        Adaptable targetAssociatedContentResource = null;
        if (null != destinationContentFragmentPath) {
            destinationContentFragmentPath = prefixPath + destinationContentFragmentPath;
            targetAssociatedContentResource = DamLanguageUtil.getAssociatedContentResource(destinationContentFragmentPath, resourceResolver);
        }
        if (null != targetAssociatedContentResource) {
            return targetAssociatedContentResource.adaptTo(ResourceCollection.class);
        }
        return null;
    }

    private static Iterator<Resource> getResourcesFromCollection(Resource collectionResource) {
        ResourceCollection associatedContentCollection = collectionResource.adaptTo(ResourceCollection.class);
        if (associatedContentCollection != null) {
            return associatedContentCollection.getResources();
        }
        return null;
    }

    private static void createOrUpdateCollectionLanguageCopy(Resource sourceCollectionResource, String targetLanguageCode, ResourceCollection destinationAssociatedContents, ResourceResolver resourceResolver, PageManager pageManager) throws WCMException, PersistenceException, RepositoryException {
        String sourceCollectionPath = sourceCollectionResource.getPath();
        String targetPath = DamLanguageUtil.getAssociatedContentLanguageCopyPathOrName(sourceCollectionPath, targetLanguageCode);
        Resource targetCollectionResource = resourceResolver.getResource(targetPath);
        if (null == targetCollectionResource) {
            targetCollectionResource = pageManager.copy(sourceCollectionResource, targetPath, null, false, false, true);
            DamLanguageUtil.setProperty(targetCollectionResource, ATTRIBUTE_COLLECTION_SOURCE_LANGUAGE_COPY, sourceCollectionPath);
            if (null != sourceCollectionResource.adaptTo(Node.class) && sourceCollectionResource.adaptTo(Node.class).hasProperty("jcr:title")) {
                String sourceCollectionName = sourceCollectionResource.adaptTo(Node.class).getProperty("jcr:title").getString();
                String destinationCollectionName = DamLanguageUtil.getAssociatedContentLanguageCopyPathOrName(sourceCollectionName, targetLanguageCode);
                DamLanguageUtil.setProperty(targetCollectionResource, "jcr:title", destinationCollectionName);
            }
        } else {
            DamLanguageUtil.updateExistingCollectionResource(sourceCollectionResource, targetCollectionResource, targetLanguageCode, resourceResolver);
        }
        ResourceCollection collectionLanguageCopy = targetCollectionResource.adaptTo(ResourceCollection.class);
        DamLanguageUtil.replaceCollectionResource(destinationAssociatedContents, sourceCollectionResource, targetCollectionResource, resourceResolver);
        DamLanguageUtil.replaceCollectionAssetLanguageCopies(collectionLanguageCopy, targetLanguageCode, resourceResolver);
    }

    private static void setProperty(Resource resource, String property, String value) throws RepositoryException {
        Node node = resource.adaptTo(Node.class);
        node.setProperty(property, value);
    }

    private static String getAssociatedContentLanguageCopyPathOrName(String source, String targetLanguageCode) {
        String languageCode;
        Locale locale;
        String initial = source;
        if (initial.contains("-") && (locale = LanguageUtil.getLocale(languageCode = initial.substring(initial.lastIndexOf("-") + 1))) != null) {
            initial = initial.substring(0, initial.lastIndexOf("-"));
        }
        String languageCopyPostfix = "-" + targetLanguageCode;
        return initial + languageCopyPostfix;
    }

    private static void updateExistingCollectionResource(Resource sourceCollectionResource, Resource targetCollectionResource, String targetLanguageCode, ResourceResolver resourceResolver) throws PersistenceException, RepositoryException {
        if (null == sourceCollectionResource || null == targetCollectionResource) {
            return;
        }
        ResourceCollection sourceCollection = sourceCollectionResource.adaptTo(ResourceCollection.class);
        ResourceCollection targetCollection = targetCollectionResource.adaptTo(ResourceCollection.class);
        if (null == sourceCollection || null == targetCollection) {
            return;
        }
        Node targetNode = targetCollectionResource.adaptTo(Node.class);
        targetNode.setProperty(ATTRIBUTE_COLLECTION_SOURCE_LANGUAGE_COPY, sourceCollection.getPath());
        Iterator<Resource> sourceResources = sourceCollection.getResources();
        while (sourceResources.hasNext()) {
            Resource sourceResource = sourceResources.next();
            if (null == sourceResource.adaptTo(Asset.class) && !DamLanguageUtil.isFolder(sourceResource)) continue;
            Resource destinationResource = DamLanguageUtil.findLanguageCopyWithAutoCreatedRootsForAssetOrNTFolder(sourceResource, targetLanguageCode, resourceResolver);
            DamLanguageUtil.replaceCollectionResource(targetCollection, sourceResource, destinationResource, resourceResolver);
        }
    }

    private static void replaceCollectionAssetLanguageCopies(ResourceCollection collectionLanguageCopy, String targetLanguageCode, ResourceResolver resourceResolver) throws PersistenceException, RepositoryException {
        Iterator<Resource> resourceIterator = collectionLanguageCopy.getResources();
        while (resourceIterator.hasNext()) {
            Resource languageCopyResource;
            String currentLanguage;
            Resource resource = resourceIterator.next();
            if (null == resource.adaptTo(Asset.class) && !DamLanguageUtil.isFolder(resource) || null != (currentLanguage = DamLanguageUtil.getLanguageRootLocale(resource.getPath())) && currentLanguage.equals(targetLanguageCode) || null == (languageCopyResource = DamLanguageUtil.findLanguageCopyWithAutoCreatedRootsForAssetOrNTFolder(resource, targetLanguageCode, resourceResolver))) continue;
            DamLanguageUtil.replaceCollectionResource(collectionLanguageCopy, resource, languageCopyResource, resourceResolver);
        }
    }

    private static void replaceCollectionResource(ResourceCollection collectionLanguageCopy, Resource sourceLanguageResource, Resource destinationLanguageResource, ResourceResolver resourceResolver) throws PersistenceException {
        collectionLanguageCopy.remove(sourceLanguageResource);
        resourceResolver.commit();
        collectionLanguageCopy.add(destinationLanguageResource);
        resourceResolver.commit();
    }

    public static List<String> createLanguageCopyWithAssetRelationsForNTFolder(ResourceResolver resourceResolver, PageManagerFactory pageManagerFactory, String sourcePath, String[] targetLanguageCodes) throws RepositoryException {
        Resource sourceResource = resourceResolver.getResource(sourcePath);
        if (null != sourceResource) {
            Iterator<Asset> assetIterator = DamUtil.getAssets(sourceResource);
            while (assetIterator.hasNext()) {
                Asset nextAsset = assetIterator.next();
                DamLanguageUtil.createLanguageCopyWithAssetRelations(resourceResolver, pageManagerFactory, nextAsset.getPath(), targetLanguageCodes);
            }
        }
        ArrayList<String> createdLanguageCopies = new ArrayList<String>();
        for (String targetLanguageCode : targetLanguageCodes) {
            Node targetLanguageCopy = DamLanguageUtil.findLanguageCopyForNTFolderWithAutoCreatedRoots(sourcePath, targetLanguageCode, resourceResolver);
            if (null == targetLanguageCopy) continue;
            createdLanguageCopies.add(targetLanguageCopy.getPath());
        }
        return createdLanguageCopies;
    }

    private static void createRelationLanguageCopyForSourceRelations(String relationName, List<Asset> relatedSourceAssets, String targetLanguageCode, ResourceResolver resourceResolver, PageManagerFactory pageManagerFactory) {
        for (Asset relatedSourceAsset : relatedSourceAssets) {
            Resource relatedSourceResource = relatedSourceAsset.adaptTo(Resource.class);
            com.adobe.granite.asset.api.Asset graniteSourceAsset = relatedSourceAsset.adaptTo(com.adobe.granite.asset.api.Asset.class);
            List<Asset> relatedLinkedAssets = DamLanguageUtil.getRelatedAssets(relatedSourceResource, relationName);
            Asset destinationAsset = DamLanguageUtil.findLanguageCopyWithAutoCreatedRoots(graniteSourceAsset.getPath(), targetLanguageCode, resourceResolver);
            com.adobe.granite.asset.api.Asset graniteDestinationAsset = destinationAsset.adaptTo(com.adobe.granite.asset.api.Asset.class);
            DamLanguageUtil.createRelationLanguageCopy(relationName, graniteDestinationAsset, relatedLinkedAssets, targetLanguageCode, resourceResolver, pageManagerFactory);
        }
    }

    private static void createRelationLanguageCopy(String relationName, com.adobe.granite.asset.api.Asset graniteDestinationAsset, List<Asset> relatedAssets, String targetLanguageCode, ResourceResolver resourceResolver, PageManagerFactory pageManagerFactory) {
        ArrayList<String> resetRelationPaths = new ArrayList<String>();
        for (Asset relatedSourceAsset : relatedAssets) {
            String sourceRelationPath = relatedSourceAsset.getPath();
            String sourceRelationLanguageCopyPath = DamLanguageUtil.createOrGetLanguageCopy(resourceResolver, pageManagerFactory, sourceRelationPath, targetLanguageCode);
            resetRelationPaths.add(sourceRelationLanguageCopyPath);
        }
        DamLanguageUtil.resetAssetRelations(graniteDestinationAsset, relationName, resetRelationPaths);
    }

    private static String createOrGetLanguageCopy(ResourceResolver resourceResolver, PageManagerFactory pageManagerFactory, String sourcePath, String targetLanguageCode) {
        String languageCopyPath = DamLanguageUtil.createLanguageCopy(resourceResolver, pageManagerFactory, sourcePath, targetLanguageCode);
        if (languageCopyPath == null) {
            languageCopyPath = DamLanguageUtil.findLanguageCopyPathWithAutoCreatedRoots(sourcePath, targetLanguageCode, resourceResolver);
        }
        return languageCopyPath;
    }

    private static void createMissingDestinationLanguageCopies(ResourceResolver resourceResolver, PageManagerFactory pageManagerFactory, String assetPath, String targetLanguageCode) {
        if (null == DamLanguageUtil.findLanguageCopyPathWithAutoCreatedRoots(assetPath, targetLanguageCode, resourceResolver)) {
            DamLanguageUtil.createLanguageCopy(resourceResolver, pageManagerFactory, assetPath, targetLanguageCode);
        }
        Resource assetResource = resourceResolver.getResource(assetPath);
        DamLanguageUtil.createMissingDestinationLanguageCopiesForRelations(ATTRIBUTE_ASSET_SOURCE_RELATION, assetResource, targetLanguageCode, resourceResolver, pageManagerFactory);
        DamLanguageUtil.createMissingDestinationLanguageCopiesForRelations(ATTRIBUTE_ASSET_LINKS_RELATION, assetResource, targetLanguageCode, resourceResolver, pageManagerFactory);
        DamLanguageUtil.createMissingDestinationLanguageCopiesForRelationsOfSources(ATTRIBUTE_ASSET_LINKS_RELATION, assetResource, targetLanguageCode, resourceResolver, pageManagerFactory);
    }

    private static void createMissingDestinationLanguageCopiesForRelationsOfSources(String relationName, Resource assetResource, String targetLanguageCode, ResourceResolver resourceResolver, PageManagerFactory pageManagerFactory) {
        List<Asset> relatedSourceAssets = DamLanguageUtil.getRelatedAssets(assetResource, ATTRIBUTE_ASSET_SOURCE_RELATION);
        for (Asset relatedSourceAsset : relatedSourceAssets) {
            Resource relatedSourceResource = relatedSourceAsset.adaptTo(Resource.class);
            DamLanguageUtil.createMissingDestinationLanguageCopiesForRelations(relationName, relatedSourceResource, targetLanguageCode, resourceResolver, pageManagerFactory);
        }
    }

    private static void createMissingDestinationLanguageCopiesForRelations(String relationName, Resource assetResource, String targetLanguageCode, ResourceResolver resourceResolver, PageManagerFactory pageManagerFactory) {
        List<Asset> relatedAssets = DamLanguageUtil.getRelatedAssets(assetResource, relationName);
        if (!relatedAssets.isEmpty()) {
            for (Asset relatedAsset : relatedAssets) {
                String relatedAssetPath = relatedAsset.getPath();
                if (null != DamLanguageUtil.findLanguageCopyPathWithAutoCreatedRoots(relatedAssetPath, targetLanguageCode, resourceResolver)) continue;
                DamLanguageUtil.createLanguageCopy(resourceResolver, pageManagerFactory, relatedAssetPath, targetLanguageCode);
            }
        }
    }

    public static List<Asset> getRelatedAssets(Resource resource, String relationName) {
        com.adobe.granite.asset.api.Asset graniteSourceAsset;
        ArrayList<Asset> relatedAssets = new ArrayList<Asset>();
        if (null != resource && null != (graniteSourceAsset = resource.adaptTo(com.adobe.granite.asset.api.Asset.class))) {
            Iterator<? extends AssetRelation> assetRelationIterator = graniteSourceAsset.listRelations(relationName);
            while (assetRelationIterator.hasNext()) {
                AssetRelation assetRelation = assetRelationIterator.next();
                com.adobe.granite.asset.api.Asset graniteAsset = assetRelation.getAsset();
                relatedAssets.add(graniteAsset.adaptTo(Asset.class));
            }
        }
        return relatedAssets;
    }

    private static TranslationCategory getTranslationCategoryForAssetAndItsRelations(String assetPath, String targetLanguageCode, ResourceResolver resourceResolver) {
        if (DamLanguageUtil.getLanguageRootLocale(assetPath).equals(targetLanguageCode)) {
            return TranslationCategory.NONE;
        }
        TranslationCategory groupCategory = TranslationCategory.NONE;
        TranslationCategory currentCategory = null;
        Resource sourceResource = resourceResolver.getResource(assetPath);
        if (null != sourceResource) {
            Asset assetInSourceLanguage = sourceResource.adaptTo(Asset.class);
            Asset assetInDestinationLanguage = DamLanguageUtil.findLanguageCopyWithAutoCreatedRoots(assetPath, targetLanguageCode, resourceResolver);
            currentCategory = null != assetInDestinationLanguage ? (DamLanguageUtil.isSmartAssetUpdateRequired(assetInSourceLanguage, assetInDestinationLanguage) ? TranslationCategory.TEMPORARY : TranslationCategory.NONE) : TranslationCategory.DESTINATION;
            if ((groupCategory = DamLanguageUtil.combineCategory(groupCategory, currentCategory)) != TranslationCategory.TEMPORARY) {
                currentCategory = DamLanguageUtil.getTranslationCategoryForRelation(ATTRIBUTE_ASSET_SOURCE_RELATION, sourceResource, targetLanguageCode, resourceResolver);
                groupCategory = DamLanguageUtil.combineCategory(groupCategory, currentCategory);
            }
            if (groupCategory != TranslationCategory.TEMPORARY) {
                currentCategory = DamLanguageUtil.getTranslationCategoryForRelation(ATTRIBUTE_ASSET_LINKS_RELATION, sourceResource, targetLanguageCode, resourceResolver);
                groupCategory = DamLanguageUtil.combineCategory(groupCategory, currentCategory);
            }
            if (groupCategory != TranslationCategory.TEMPORARY) {
                currentCategory = DamLanguageUtil.getTranslationCategoryForRelationOfSources(ATTRIBUTE_ASSET_LINKS_RELATION, sourceResource, targetLanguageCode, resourceResolver);
                groupCategory = DamLanguageUtil.combineCategory(groupCategory, currentCategory);
            }
        }
        return groupCategory;
    }

    private static TranslationCategory combineCategory(TranslationCategory c1, TranslationCategory c2) {
        if (c1 == TranslationCategory.TEMPORARY || c2 == TranslationCategory.TEMPORARY) {
            return TranslationCategory.TEMPORARY;
        }
        if (c1 == TranslationCategory.NONE && c2 == TranslationCategory.NONE) {
            return TranslationCategory.NONE;
        }
        return TranslationCategory.DESTINATION;
    }

    private static TranslationCategory getTranslationCategoryForRelationOfSources(String relationName, Resource relaterResource, String targetLanguageCode, ResourceResolver resourceResolver) {
        TranslationCategory groupCategory = TranslationCategory.NONE;
        List<Asset> relatedSourceAssets = DamLanguageUtil.getRelatedAssets(relaterResource, ATTRIBUTE_ASSET_SOURCE_RELATION);
        for (Asset relatedSourceAsset : relatedSourceAssets) {
            Resource relatedSourceResource = relatedSourceAsset.adaptTo(Resource.class);
            TranslationCategory currentCategory = DamLanguageUtil.getTranslationCategoryForRelation(relationName, relatedSourceResource, targetLanguageCode, resourceResolver);
            groupCategory = DamLanguageUtil.combineCategory(groupCategory, currentCategory);
        }
        return groupCategory;
    }

    private static TranslationCategory getTranslationCategoryForRelation(String relationName, Resource sourceResource, String targetLanguageCode, ResourceResolver resourceResolver) {
        TranslationCategory translationCategory = TranslationCategory.NONE;
        List<Asset> relatedAssetsInSourceLanguage = DamLanguageUtil.getRelatedAssets(sourceResource, relationName);
        for (Asset relatedAssetInSourceLanguage : relatedAssetsInSourceLanguage) {
            String relatedAssetInSourceLanguagePath = relatedAssetInSourceLanguage.getPath();
            Asset relatedAssetInDestinationLanguage = DamLanguageUtil.findLanguageCopyWithAutoCreatedRoots(relatedAssetInSourceLanguagePath, targetLanguageCode, resourceResolver);
            if (null != relatedAssetInDestinationLanguage) {
                if (!DamLanguageUtil.isSmartAssetUpdateRequired(relatedAssetInSourceLanguage, relatedAssetInDestinationLanguage)) continue;
                translationCategory = TranslationCategory.TEMPORARY;
                break;
            }
            translationCategory = TranslationCategory.DESTINATION;
        }
        return translationCategory;
    }

    private static void removeAssetRelationWithLanguageCode(com.adobe.granite.asset.api.Asset graniteAsset, String relationName, String languageRoot) {
        List<String> relations = DamLanguageUtil.getRelationsPathList(graniteAsset, relationName);
        for (String relation : relations) {
            String relationLanguageRoot = DamLanguageUtil.getLanguageRootLocale(relation);
            if (!relationLanguageRoot.equals(languageRoot)) continue;
            graniteAsset.removeRelation(relationName, relation);
        }
    }

    private static void adjustAssetRelations(com.adobe.granite.asset.api.Asset graniteAsset, String relationName, String unlinkRelation, String linkRelation) {
        List<String> relations = DamLanguageUtil.getRelationsPathList(graniteAsset, relationName);
        if (relations.contains(unlinkRelation)) {
            graniteAsset.removeRelation(relationName, unlinkRelation);
        }
        if (!relations.contains(linkRelation)) {
            graniteAsset.addRelation(relationName, linkRelation);
        }
    }

    private static void removeAssetRelation(com.adobe.granite.asset.api.Asset graniteAsset, String relationName) {
        if (graniteAsset.listRelations(relationName).hasNext()) {
            graniteAsset.removeRelation(relationName);
        }
    }

    private static void resetAssetRelations(com.adobe.granite.asset.api.Asset graniteAsset, String relationName, ArrayList<String> linkRelations) {
        if (graniteAsset.listRelations(relationName).hasNext()) {
            graniteAsset.removeRelation(relationName);
        }
        for (String linkRelation : linkRelations) {
            graniteAsset.addRelation(relationName, linkRelation);
        }
    }

    private static List<String> getRelationsPathList(com.adobe.granite.asset.api.Asset graniteAsset, String relation) {
        Iterator<? extends AssetRelation> relationIterator = graniteAsset.listRelations(relation);
        ArrayList<String> relationsList = new ArrayList<String>();
        while (relationIterator.hasNext()) {
            AssetRelation assetRelation = relationIterator.next();
            com.adobe.granite.asset.api.Asset asset = assetRelation.getAsset();
            String relationPath = asset.getPath();
            relationsList.add(relationPath);
        }
        return relationsList;
    }

    private static String getUpdateAssetNodeSourcePath(Node node) throws RepositoryException {
        Node assetContentNode;
        if (node.isNodeType("dam:Asset") && node.hasNode("jcr:content") && (assetContentNode = node.getNode("jcr:content")).hasProperty(ATTRIBUTE_SMART_ASSET_UPDATE_SOURCE)) {
            return assetContentNode.getProperty(ATTRIBUTE_SMART_ASSET_UPDATE_SOURCE).getValue().getString();
        }
        return null;
    }

    private static Resource findTemporaryLanguageCopy(Asset asset, String prefixPath, ResourceResolver resourceResolver) {
        String tempLCPath = prefixPath + '/' + asset.getPath();
        Resource tempLCResource = resourceResolver.getResource(tempLCPath);
        if (tempLCResource != null) {
            return tempLCResource;
        }
        return null;
    }

    private static void adjustDerivedAndRemoveOthersForSourceAssetsTempLC(List<Asset> relatedSourceAssets, String destinationAssetPath, String prefixPath, String sourceLanguageRoot, ResourceResolver resourceResolver) {
        for (Asset sourceDamAsset : relatedSourceAssets) {
            com.adobe.granite.asset.api.Asset sourceGraniteAssetTempLC;
            Resource sourceDamAssetTempLC = DamLanguageUtil.findTemporaryLanguageCopy(sourceDamAsset, prefixPath, resourceResolver);
            if (sourceDamAssetTempLC == null || (sourceGraniteAssetTempLC = sourceDamAssetTempLC.adaptTo(com.adobe.granite.asset.api.Asset.class)) == null) continue;
            DamLanguageUtil.removeAssetRelationWithLanguageCode(sourceGraniteAssetTempLC, ATTRIBUTE_ASSET_DERIVED_RELATION, sourceLanguageRoot);
            sourceGraniteAssetTempLC.addRelation(ATTRIBUTE_ASSET_DERIVED_RELATION, destinationAssetPath);
            DamLanguageUtil.removeAssetRelation(sourceGraniteAssetTempLC, ATTRIBUTE_ASSET_OTHERS_RELATION);
        }
    }

    private static boolean createUpdateLanguageCopyWithAssetRelationsRequired(ResourceResolver resourceResolver, String destinationPath) throws RepositoryException {
        Node destinationNode;
        String updateAssetSourcePath;
        Resource destinationResource = resourceResolver.resolve(destinationPath);
        return null != destinationResource && null != (updateAssetSourcePath = DamLanguageUtil.getUpdateAssetNodeSourcePath(destinationNode = destinationResource.adaptTo(Node.class)));
    }

    public static String createUpdateLanguageCopyWithAssetRelations(ResourceResolver resourceResolver, PageManagerFactory pageManagerFactory, String destinationPath, String targetLanguageCode, String prefixPath) throws RepositoryException {
        boolean updateRequired = DamLanguageUtil.createUpdateLanguageCopyWithAssetRelationsRequired(resourceResolver, destinationPath);
        String variantPath = destinationPath;
        if (updateRequired) {
            Resource destinationResource = resourceResolver.resolve(destinationPath);
            List<Asset> relatedSourceAssets = DamLanguageUtil.getRelatedAssets(destinationResource, ATTRIBUTE_ASSET_SOURCE_RELATION);
            if (null != destinationResource) {
                Node destinationNode = destinationResource.adaptTo(Node.class);
                String updateAssetSourcePath = DamLanguageUtil.getUpdateAssetNodeSourcePath(destinationNode);
                String updateAssetLanguageLocale = DamLanguageUtil.getLanguageRootLocale(updateAssetSourcePath);
                variantPath = DamLanguageUtil.createUpdateLanguageCopy(resourceResolver, pageManagerFactory, updateAssetSourcePath, targetLanguageCode, prefixPath);
                DamLanguageUtil.createUpdateLanguageCopyForRelation(ATTRIBUTE_ASSET_SOURCE_RELATION, updateAssetSourcePath, variantPath, targetLanguageCode, prefixPath, resourceResolver, pageManagerFactory);
                DamLanguageUtil.adjustDerivedAndRemoveOthersForSourceAssetsTempLC(relatedSourceAssets, destinationPath, prefixPath, updateAssetLanguageLocale, resourceResolver);
                DamLanguageUtil.createUpdateLanguageCopyForRelation(ATTRIBUTE_ASSET_LINKS_RELATION, updateAssetSourcePath, variantPath, targetLanguageCode, prefixPath, resourceResolver, pageManagerFactory);
                DamLanguageUtil.createUpdateLanguageCopyForRelationOfSources(ATTRIBUTE_ASSET_LINKS_RELATION, updateAssetSourcePath, variantPath, targetLanguageCode, prefixPath, resourceResolver, pageManagerFactory);
                if (DamLanguageUtil.isContentFragment(destinationResource.adaptTo(Asset.class))) {
                    String[] targetLanguageCodeArray = new String[]{targetLanguageCode};
                    try {
                        DamLanguageUtil.createOrUpdateLanguageCopyForAssociatedContentNode(resourceResolver, pageManagerFactory, updateAssetSourcePath, targetLanguageCodeArray, prefixPath);
                    }
                    catch (Exception e) {
                        log.error("could not create or update langauge copy for associated content node for {}", (Object)(prefixPath + destinationPath), (Object)e);
                    }
                }
            }
        }
        return variantPath;
    }

    private static void createUpdateLanguageCopyForRelationOfSources(String relationName, String updateAssetSourcePath, String variantPath, String targetLanguageCode, String prefixPath, ResourceResolver resourceResolver, PageManagerFactory pageManagerFactory) {
        Resource updateAssetSourceResource = resourceResolver.getResource(updateAssetSourcePath);
        List<Asset> relatedSources = DamLanguageUtil.getRelatedAssets(updateAssetSourceResource, ATTRIBUTE_ASSET_SOURCE_RELATION);
        for (Asset relatedSource : relatedSources) {
            String relatedSourcePath = relatedSource.getPath();
            String LCofRelatedSource = DamLanguageUtil.findLanguageCopyPathWithAutoCreatedRoots(relatedSourcePath, targetLanguageCode, resourceResolver);
            String tempLCofRelatedSource = prefixPath + LCofRelatedSource;
            DamLanguageUtil.createUpdateLanguageCopyForRelation(relationName, relatedSourcePath, tempLCofRelatedSource, targetLanguageCode, prefixPath, resourceResolver, pageManagerFactory);
        }
    }

    private static void createUpdateLanguageCopyForRelation(String relationName, String updateAssetSourcePath, String variantPath, String targetLanguageCode, String prefixPath, ResourceResolver resourceResolver, PageManagerFactory pageManagerFactory) {
        DamLanguageUtil.adjustRelationsForAssetLanguageCopy(variantPath, relationName, targetLanguageCode, resourceResolver);
        Resource variantResource = resourceResolver.getResource(variantPath);
        Resource updateAssetSourceResource = resourceResolver.getResource(updateAssetSourcePath);
        List<Asset> relatedAssets = DamLanguageUtil.getRelatedAssets(updateAssetSourceResource, relationName);
        for (Asset relatedAsset : relatedAssets) {
            String relatedAssetPath = relatedAsset.getPath();
            if (!relatedAssetPath.startsWith("/content/dam")) continue;
            String tempLCOfRelatedAsset = DamLanguageUtil.createUpdateLanguageCopy(resourceResolver, pageManagerFactory, relatedAssetPath, targetLanguageCode, prefixPath);
            String LCofRelatedAsset = DamLanguageUtil.findLanguageCopyPathWithAutoCreatedRoots(relatedAssetPath, targetLanguageCode, resourceResolver);
            com.adobe.granite.asset.api.Asset graniteVariantAsset = variantResource.adaptTo(com.adobe.granite.asset.api.Asset.class);
            DamLanguageUtil.adjustAssetRelations(graniteVariantAsset, relationName, LCofRelatedAsset, tempLCOfRelatedAsset);
            DamLanguageUtil.removeAssetRelation(graniteVariantAsset, ATTRIBUTE_ASSET_OTHERS_RELATION);
        }
    }

    private static void adjustRelationsForAssetLanguageCopy(String assetPath, String relationName, String targetLanguageCode, ResourceResolver resourceResolver) {
        Resource assetResource = resourceResolver.resolve(assetPath);
        if (null != assetResource) {
            List<Asset> relatedAssets = DamLanguageUtil.getRelatedAssets(assetResource, relationName);
            for (Asset relatedAsset : relatedAssets) {
                String relatedAssetPath = relatedAsset.getPath();
                String sourceLanguageCode = DamLanguageUtil.getLanguageRootLocale(relatedAssetPath);
                if (null != sourceLanguageCode && sourceLanguageCode.equals(targetLanguageCode)) continue;
                String languageCopyPath = DamLanguageUtil.findLanguageCopyPathWithAutoCreatedRoots(relatedAssetPath, targetLanguageCode, resourceResolver);
                com.adobe.granite.asset.api.Asset graniteAsset = assetResource.adaptTo(com.adobe.granite.asset.api.Asset.class);
                DamLanguageUtil.adjustAssetRelations(graniteAsset, relationName, relatedAssetPath, languageCopyPath);
            }
        }
    }

    public static String findLanguageCopyPathWithAutoCreatedRoots(String assetPath, String languageCode, ResourceResolver resolver) {
        Asset languageCopy = DamLanguageUtil.findLanguageCopyWithAutoCreatedRoots(assetPath, languageCode, resolver);
        return null != languageCopy ? languageCopy.getPath() : null;
    }

    public static Resource findLanguageCopyWithAutoCreatedRootsForAssetOrNTFolder(Resource resource, String languageCode, ResourceResolver resolver) throws RepositoryException {
        Node folderNode;
        if (null != resource.adaptTo(Asset.class)) {
            Asset languageCopy = DamLanguageUtil.findLanguageCopyWithAutoCreatedRoots(resource.getPath(), languageCode, resolver);
            if (null != languageCopy) {
                return languageCopy.adaptTo(Resource.class);
            }
        } else if (DamLanguageUtil.isFolder(resource) && null != (folderNode = DamLanguageUtil.findLanguageCopyForNTFolderWithAutoCreatedRoots(resource.getPath(), languageCode, resolver))) {
            return resolver.getResource(folderNode.getPath());
        }
        return null;
    }

    public static Asset findLanguageCopyWithAutoCreatedRoots(String assetPath, String languageCode, ResourceResolver resolver) {
        Resource assetResource = resolver.getResource(assetPath);
        if (assetResource == null || assetResource.adaptTo(Asset.class) == null) {
            return null;
        }
        Asset asset = null;
        String languageRootPath = LanguageUtil.getLanguageRoot(assetPath);
        String languageRootParentPath = null;
        String contentPath = null;
        if (languageRootPath != null) {
            contentPath = assetPath.replaceFirst(languageRootPath, "");
            languageRootParentPath = Text.getRelativeParent(languageRootPath, 1);
        } else {
            if (Text.getRelativeParent(assetPath, 1).equals("/content/dam")) {
                languageRootParentPath = "/content/dam";
            } else if (assetPath.startsWith("/content/dam/")) {
                int parentOfRootPathLength = assetPath.indexOf(47, "/content/dam".length() + 1);
                if (parentOfRootPathLength < 0 || assetPath.length() <= parentOfRootPathLength) {
                    return null;
                }
                languageRootParentPath = assetPath.substring(0, parentOfRootPathLength);
            }
            contentPath = assetPath.replaceFirst(languageRootParentPath, "");
        }
        String destLanguageRootPath = DamLanguageUtil.getDestinationLanguageRoot(languageRootParentPath, languageCode, resolver);
        String assetPathLC = destLanguageRootPath + contentPath;
        Resource assetResourceLC = resolver.getResource(assetPathLC);
        if (assetResourceLC != null) {
            asset = assetResourceLC.adaptTo(Asset.class);
        }
        return asset;
    }

    private static Node findLanguageCopyForNTFolderWithAutoCreatedRoots(String folderPath, String languageCode, ResourceResolver resolver) throws RepositoryException {
        Resource folderResource = resolver.getResource(folderPath);
        if (folderResource == null) {
            return null;
        }
        Node folderNode = folderResource.adaptTo(Node.class);
        if (!folderNode.isNodeType("nt:folder")) {
            return null;
        }
        Node folderNodeLanguageCopy = null;
        String languageRootPath = LanguageUtil.getLanguageRoot(folderPath);
        String languageRootParentPath = null;
        String contentPath = null;
        if (languageRootPath != null) {
            contentPath = folderPath.replaceFirst(languageRootPath, "");
            languageRootParentPath = Text.getRelativeParent(languageRootPath, 1);
        } else {
            if (Text.getRelativeParent(folderPath, 1).equals("/content/dam")) {
                languageRootParentPath = "/content/dam";
            } else if (folderPath.startsWith("/content/dam/")) {
                int parentOfRootPathLength = folderPath.indexOf(47, "/content/dam".length() + 1);
                if (parentOfRootPathLength < 0 || folderPath.length() <= parentOfRootPathLength) {
                    return null;
                }
                languageRootParentPath = folderPath.substring(0, parentOfRootPathLength);
            }
            contentPath = folderPath.replaceFirst(languageRootParentPath, "");
        }
        String destLanguageRootPath = DamLanguageUtil.getDestinationLanguageRoot(languageRootParentPath, languageCode, resolver);
        String assetPathLC = destLanguageRootPath + contentPath;
        Resource folderResourceLC = resolver.getResource(assetPathLC);
        if (folderResourceLC != null) {
            folderNodeLanguageCopy = folderResourceLC.adaptTo(Node.class);
        }
        return folderNodeLanguageCopy;
    }

    public static void afterReplacingUpdatedAsset(String destinationPath, Session userSession, String prefixPath, ResourceResolver resourceResolver) throws RepositoryException {
        Resource resource = resourceResolver.getResource(destinationPath);
        if (null != resource) {
            com.adobe.granite.asset.api.Asset graniteAsset = resource.adaptTo(com.adobe.granite.asset.api.Asset.class);
            DamLanguageUtil.afterReplacingUpdatedAssetWithRelation(ATTRIBUTE_ASSET_SOURCE_RELATION, graniteAsset, prefixPath);
            DamLanguageUtil.afterReplacingUpdatedAssetWithRelation(ATTRIBUTE_ASSET_LINKS_RELATION, graniteAsset, prefixPath);
            DamLanguageUtil.afterReplacingUpdatedAssetForSources(ATTRIBUTE_ASSET_LINKS_RELATION, graniteAsset, prefixPath);
        }
        userSession.save();
    }

    private static void afterReplacingUpdatedAssetForSources(String relationName, com.adobe.granite.asset.api.Asset relaterAsset, String prefixPath) {
        Resource relaterResource = relaterAsset.adaptTo(Resource.class);
        List<Asset> relatedSources = DamLanguageUtil.getRelatedAssets(relaterResource, ATTRIBUTE_ASSET_SOURCE_RELATION);
        for (Asset relatedSource : relatedSources) {
            com.adobe.granite.asset.api.Asset graniteSource = relatedSource.adaptTo(com.adobe.granite.asset.api.Asset.class);
            DamLanguageUtil.afterReplacingUpdatedAssetWithRelation(relationName, graniteSource, prefixPath);
        }
    }

    private static void afterReplacingUpdatedAssetWithRelation(String relationName, com.adobe.granite.asset.api.Asset graniteAsset, String prefixPath) {
        List<String> relations = DamLanguageUtil.getRelationsPathList(graniteAsset, relationName);
        for (String relation : relations) {
            String replacedRelationPath = DamLanguageUtil.removePrefix(relation, prefixPath);
            if (null == replacedRelationPath) continue;
            DamLanguageUtil.adjustAssetRelations(graniteAsset, relationName, relation, replacedRelationPath);
        }
    }

    private static String removePrefix(String string, String prefix) {
        return string.startsWith(prefix) ? string.replaceFirst(prefix, "") : null;
    }

    public static String getLanguageRootLocale(String path) {
        String languageRootPath = LanguageUtil.getLanguageRoot(path);
        if (null != languageRootPath) {
            return languageRootPath.substring(languageRootPath.lastIndexOf("/") + 1);
        }
        return null;
    }

    public static String getLanguageDisplayName(ResourceResolver resolver, String langCode) {
        String langDisplayName = "";
        Resource languagesHome = resolver.getResource(DEFAULT_LANGUAGES_HOME);
        Resource language = DamLanguageUtil.getLanguage(languagesHome, langCode);
        if (language != null) {
            ValueMap langProperties = language.adaptTo(ValueMap.class);
            langDisplayName = (String)((Object)langProperties.get("language", String.class));
        }
        return langDisplayName != null && !langDisplayName.isEmpty() ? langDisplayName : langCode;
    }

    private static Resource getLanguage(Resource languagesHome, String languageCode) {
        if (languagesHome != null) {
            languageCode = languageCode.toLowerCase();
            String langWithUnderscore = languageCode.replace("-", "_");
            String langWithHyphen = languageCode.replace("_", "-");
            Resource languageRes = languagesHome.getChild(langWithUnderscore);
            if (languageRes == null) {
                languageRes = languagesHome.getChild(langWithHyphen);
            }
            return languageRes;
        }
        return null;
    }

    public static List<String> replaceWithExistingLanguageCopiesIfPossible(List<String> paths, String destinationLanguageCode, ResourceResolver resourceResolver) {
        ArrayList<String> resolveLanguageCopies = new ArrayList<String>();
        if (null == destinationLanguageCode) {
            return paths;
        }
        for (String path : paths) {
            String languageCopyPath = DamLanguageUtil.findLanguageCopyPathWithAutoCreatedRoots(path, destinationLanguageCode, resourceResolver);
            if (null != languageCopyPath) {
                path = languageCopyPath;
            }
            resolveLanguageCopies.add(path);
        }
        return resolveLanguageCopies;
    }

    private static ArrayList<Asset> getContentFragmentAssociatedAssets(Node currentNode, ResourceResolver resourceResolver) throws RepositoryException {
        Resource associatedContentResource = DamLanguageUtil.getAssociatedContentResource(currentNode.getPath(), resourceResolver);
        if (associatedContentResource != null) {
            ResourceCollection associatedContent = associatedContentResource.adaptTo(ResourceCollection.class);
            return DamLanguageUtil.getAssetsFromAssociatedContentNode(associatedContent);
        }
        return new ArrayList<Asset>();
    }

    public static ArrayList<Asset> getAssetsFromAssociatedContent(Node contentFragmentNode, String destinationLanguage, ResourceResolver resourceResolver) throws RepositoryException {
        ArrayList<Asset> returnList = new ArrayList<Asset>();
        Node associatedContentNode = DamLanguageUtil.getAssociatedContentNode(contentFragmentNode);
        if (null != associatedContentNode) {
            Resource associatedContentResource = resourceResolver.getResource(associatedContentNode.getPath());
            Iterator<Resource> collectionResourceIterator = DamLanguageUtil.getResourcesFromCollection(associatedContentResource);
            while (collectionResourceIterator.hasNext()) {
                Resource collectionResource = collectionResourceIterator.next();
                ResourceCollection damCollection = collectionResource.adaptTo(ResourceCollection.class);
                if (damCollection == null) continue;
                ArrayList<Asset> collectionAssets = new ArrayList<Asset>();
                DamLanguageUtil.addAssetsFromCollection(damCollection, collectionAssets);
                DamLanguageUtil.addAssetsFromNestedCollections(collectionResource, collectionAssets);
                ArrayList<String> sourceCollectionAssetLanguageCopies = DamLanguageUtil.getAssetLanguageCopiesFromSourceOfCollection(collectionResource, destinationLanguage, resourceResolver);
                if (null != sourceCollectionAssetLanguageCopies) {
                    DamLanguageUtil.removeLanguageCopiesWithoutSource(collectionAssets, sourceCollectionAssetLanguageCopies);
                }
                returnList.addAll(collectionAssets);
            }
        }
        return returnList;
    }

    private static void addAssetsFromNestedCollections(Resource collectionResource, ArrayList<Asset> collectionAssets) throws RepositoryException {
        HashSet<Resource> nestedCollections = new HashSet<Resource>();
        DamLanguageUtil.getNestedCollections(collectionResource, nestedCollections);
        for (Resource resource : nestedCollections) {
            ResourceCollection rc = resource.adaptTo(ResourceCollection.class);
            DamLanguageUtil.addAssetsFromCollection(rc, collectionAssets);
        }
    }

    private static Node getAssociatedContentNode(Node currentNode) throws RepositoryException {
        if (currentNode.hasNode(ASSOCIATED_CONTENT_RELATIVE_PATH)) {
            return currentNode.getNode(ASSOCIATED_CONTENT_RELATIVE_PATH);
        }
        if (currentNode.hasNode(ASSOCIATED_CONTENT_CHILD)) {
            return currentNode.getNode(ASSOCIATED_CONTENT_CHILD);
        }
        return null;
    }

    private static Resource getAssociatedContentResource(String cfPath, ResourceResolver resourceResolver) throws RepositoryException {
        Resource resource = resourceResolver.getResource(cfPath + "/" + ASSOCIATED_CONTENT_RELATIVE_PATH);
        if (null == resource) {
            resource = resourceResolver.getResource(cfPath + "/" + ASSOCIATED_CONTENT_CHILD);
        }
        return resource;
    }

    private static void removeLanguageCopiesWithoutSource(ArrayList<Asset> collectionAssets, ArrayList<String> sourceCollectionLanguageCopyPaths) {
        if (null != sourceCollectionLanguageCopyPaths) {
            for (int ndx = collectionAssets.size() - 1; ndx >= 0; --ndx) {
                Asset collectionAsset = collectionAssets.get(ndx);
                if (sourceCollectionLanguageCopyPaths.contains(collectionAsset.getPath())) continue;
                collectionAssets.remove(ndx);
            }
        }
    }

    private static ArrayList<String> getAssetLanguageCopiesFromSourceOfCollection(Resource collectionResource, String destinationLanguage, ResourceResolver resourceResolver) throws RepositoryException {
        ArrayList<Asset> sourceAssetList = DamLanguageUtil.getAssetsFromSourceOfCollection(collectionResource, resourceResolver);
        if (null != sourceAssetList) {
            ArrayList<String> destinationCollectionAssets = new ArrayList<String>();
            for (Asset asset : sourceAssetList) {
                Asset languageCopy = DamLanguageUtil.findLanguageCopyWithAutoCreatedRoots(asset.getPath(), destinationLanguage, resourceResolver);
                if (null == languageCopy) continue;
                destinationCollectionAssets.add(languageCopy.getPath());
            }
            return destinationCollectionAssets;
        }
        return null;
    }

    private static ArrayList<Asset> getAssetsFromSourceOfCollection(Resource collectionResource, ResourceResolver resourceResolver) throws RepositoryException {
        Resource sourceCollection = DamLanguageUtil.getSourceCollection(collectionResource, resourceResolver);
        if (null != sourceCollection) {
            ArrayList<Asset> sourceAssetList = DamLanguageUtil.getAssetsFromCollection(sourceCollection);
            DamLanguageUtil.deleteProperty(collectionResource, ATTRIBUTE_COLLECTION_SOURCE_LANGUAGE_COPY);
            return sourceAssetList;
        }
        return null;
    }

    private static void deleteProperty(Resource collectionResource, String property) throws RepositoryException {
        Node collectionNode = collectionResource.adaptTo(Node.class);
        if (collectionNode.hasProperty(property)) {
            Property sourceCollectionProperty = collectionNode.getProperty(property);
            sourceCollectionProperty.remove();
        }
    }

    private static Resource getSourceCollection(Resource collectionResource, ResourceResolver resourceResolver) throws RepositoryException {
        Node collectionNode = collectionResource.adaptTo(Node.class);
        if (collectionNode.hasProperty(ATTRIBUTE_COLLECTION_SOURCE_LANGUAGE_COPY)) {
            Property sourceCollectionProperty = collectionNode.getProperty(ATTRIBUTE_COLLECTION_SOURCE_LANGUAGE_COPY);
            String sourceCollectionPath = sourceCollectionProperty.getString();
            return resourceResolver.getResource(sourceCollectionPath);
        }
        return null;
    }

    private static ArrayList<Asset> getAssetsFromCollection(Resource collectionResource) throws RepositoryException {
        ArrayList<Asset> assetList = new ArrayList<Asset>();
        return DamLanguageUtil.addAssetsFromCollectionResource(collectionResource, assetList);
    }

    private static ArrayList<Asset> getAssetsFromAssociatedContentNode(ResourceCollection resourceCollection) throws RepositoryException {
        ArrayList<Asset> assetList = new ArrayList<Asset>();
        Iterator<Resource> resourceIterator = resourceCollection.getResources();
        while (resourceIterator.hasNext()) {
            Resource collectionResource = resourceIterator.next();
            DamLanguageUtil.addAssetsFromCollectionResource(collectionResource, assetList);
        }
        return assetList;
    }

    private static ArrayList<Asset> addAssetsFromCollectionResource(Resource collectionResource, ArrayList<Asset> assetList) throws RepositoryException {
        if (null == collectionResource) {
            return assetList;
        }
        ResourceCollection resourceCollection = collectionResource.adaptTo(ResourceCollection.class);
        if (null == resourceCollection) {
            return assetList;
        }
        DamLanguageUtil.addAssetsFromCollection(resourceCollection, assetList);
        DamLanguageUtil.addAssetsFromNestedCollections(collectionResource, assetList);
        return assetList;
    }

    private static void getNestedCollections(Resource sourceCollectionResource, HashSet<Resource> updatedCollections) throws RepositoryException {
        ResourceCollection sourceCollection = sourceCollectionResource.adaptTo(ResourceCollection.class);
        Iterator<Resource> sourceResources = sourceCollection.getResources();
        while (sourceResources.hasNext()) {
            Resource sourceResource = sourceResources.next();
            if (!DamLanguageUtil.isDamCollection(sourceResource) || updatedCollections.contains(sourceResource)) continue;
            updatedCollections.add(sourceResource);
            DamLanguageUtil.getNestedCollections(sourceResource, updatedCollections);
        }
    }

    private static void addAssetsFromCollection(ResourceCollection resourceCollection, ArrayList<Asset> assetList) throws RepositoryException {
        Iterator<Resource> resourceIterator = resourceCollection.getResources();
        while (resourceIterator.hasNext()) {
            Resource resource = resourceIterator.next();
            Asset asset = resource.adaptTo(Asset.class);
            if (asset != null && !DamLanguageUtil.isContentFragment(asset)) {
                assetList.add(asset);
                continue;
            }
            if (!DamLanguageUtil.isFolder(resource)) continue;
            Iterator<Asset> assetIterator = DamUtil.getAssets(resource);
            while (assetIterator.hasNext()) {
                Asset folderAsset = assetIterator.next();
                if (DamLanguageUtil.isContentFragment(folderAsset)) continue;
                assetList.add(folderAsset);
            }
        }
    }

    private static boolean isTranslateAssociatedContent(Resource contentFragmentResource, ResourceResolver resourceResolver) {
        MachineTranslationCloudConfig cloudConfig;
        boolean retVal = false;
        Resource cloudConfigResource = DamLanguageUtil.getCloudConfigResourceAppliedOnResource(contentFragmentResource, MachineTranslationCloudConfig.class, null, resourceResolver);
        if (null != cloudConfigResource && null != (cloudConfig = cloudConfigResource.adaptTo(MachineTranslationCloudConfig.class))) {
            retVal = cloudConfig.isTranslateAssociatedContentForAssets();
        }
        return retVal;
    }

    private static boolean isTranslateInlineMediaAssets(String contentFragmentPath, ResourceResolver resourceResolver) {
        MachineTranslationCloudConfig cloudConfig;
        Resource cloudConfigResource;
        boolean retVal = false;
        Resource contentFragmentResource = resourceResolver.getResource(contentFragmentPath);
        if (null != contentFragmentResource && null != (cloudConfigResource = DamLanguageUtil.getCloudConfigResourceAppliedOnResource(contentFragmentResource, MachineTranslationCloudConfig.class, null, resourceResolver)) && null != (cloudConfig = cloudConfigResource.adaptTo(MachineTranslationCloudConfig.class))) {
            retVal = cloudConfig.isTranslateInlineMediaAssets();
        }
        return retVal;
    }

    private static Resource getContentResource(Resource resource) {
        if (resource != null) {
            boolean isContentNode = resource.getPath().equals("jcr:content");
            Resource content = !isContentNode ? resource.getChild("jcr:content") : resource;
            return content;
        }
        return null;
    }

    private static Resource getCloudConfigResourceAppliedOnResource(Resource resource, Class<?> cloudConfigClass, String strCloudConfigResourceType, ResourceResolver resourceResolver) {
        String cloudConfigPath = DamLanguageUtil.getCloudConfigPathAppliedOnResourceFromClassOrResourceType(resource, cloudConfigClass, strCloudConfigResourceType, resourceResolver);
        if (null != cloudConfigPath) {
            return resourceResolver.getResource(cloudConfigPath);
        }
        return null;
    }

    private static String getCloudConfigPathAppliedOnResourceFromClassOrResourceType(Resource resource, Class<?> cloudConfigClass, String strCloudConfigResourceType, ResourceResolver resourceResolver) {
        if (resource == null || cloudConfigClass == null && strCloudConfigResourceType == null) {
            return null;
        }
        log.debug("In Function: getCloudConfigAppliedOnResource({})", (Object)resource.getPath());
        String strCloudConfigPath = null;
        String[] appliedCloudConfigs = null;
        if (resourceResolver != null) {
            Resource content = DamLanguageUtil.getContentResource(resource);
            if (content != null) {
                block17: {
                    if (log.isDebugEnabled()) {
                        log.debug("Resource: {}", (Object)resource.getPath());
                        log.debug("Content: {}", (Object)content.getPath());
                    }
                    boolean isContextAwareConfig = false;
                    if (ResourceUtil.getValueMap(content).get(ATTRIBUTE_CA_CONFIG_PROPERTY) != null) {
                        isContextAwareConfig = true;
                    }
                    if (isContextAwareConfig) {
                        try {
                            appliedCloudConfigs = DamLanguageUtil.getCAConfigs(resource);
                        }
                        catch (Exception e) {
                            log.error("Failed to get configs.", e);
                        }
                    }
                    if (appliedCloudConfigs == null || appliedCloudConfigs.length == 0) {
                        try {
                            appliedCloudConfigs = (String[])ResourceUtil.getValueMap(content).get(ATTRIBUTE_CLOUD_CONFIG_PROPERTY);
                        }
                        catch (ClassCastException cce) {
                            log.debug("Trying to cast as String as String[] failed");
                            String singleValue = (String)ResourceUtil.getValueMap(content).get(ATTRIBUTE_CLOUD_CONFIG_PROPERTY);
                            if (singleValue == null || "".equals(singleValue)) break block17;
                            appliedCloudConfigs = new String[]{singleValue};
                        }
                    }
                }
                if (appliedCloudConfigs != null) {
                    for (String appliedCloudConfig : appliedCloudConfigs) {
                        Resource appliedConfig = resourceResolver.getResource(appliedCloudConfig);
                        if (cloudConfigClass != null) {
                            if (appliedConfig != null && appliedConfig.adaptTo(cloudConfigClass) != null) {
                                strCloudConfigPath = appliedCloudConfig;
                                log.debug("Found ObjectCloudConfig {}", (Object)strCloudConfigPath);
                                return strCloudConfigPath;
                            }
                            log.debug("Applied Cloud Config {} is not of type {}.", (Object)appliedCloudConfig, (Object)cloudConfigClass.toString());
                            continue;
                        }
                        Resource appliedConfigContent = DamLanguageUtil.getContentResource(appliedConfig);
                        if (appliedConfigContent == null) continue;
                        String strCurrentResourceType = appliedConfigContent.getResourceType();
                        if (strCloudConfigResourceType.equals(strCurrentResourceType)) {
                            strCloudConfigPath = appliedCloudConfig;
                            log.debug("Found ObjectCloudConfig {}", (Object)strCloudConfigPath);
                            return strCloudConfigPath;
                        }
                        log.debug("Applied Cloud Config {} is not of type {}.", (Object)appliedCloudConfig, (Object)strCloudConfigResourceType);
                    }
                }
            }
            strCloudConfigPath = DamLanguageUtil.getCloudConfigPathAppliedOnResourceFromClassOrResourceType(resource.getParent(), cloudConfigClass, strCloudConfigResourceType, resourceResolver);
        } else {
            log.warn("Failed to get resourceResolver");
        }
        return strCloudConfigPath;
    }

    private static String[] getCAConfigs(Resource resource) throws Exception {
        ArrayList<String> caConfigs = new ArrayList<String>();
        Conf conf = resource.adaptTo(Conf.class);
        if (conf != null) {
            List<Resource> tifCollection = conf.getListResources(CACONFIG_TRANSLATIONCFG_PATH);
            if (null == tifCollection) {
                return new String[0];
            }
            Resource tif = DamLanguageUtil.getConfigFromCollection(tifCollection);
            caConfigs.add(tif.getPath());
        }
        String[] caConfigsArray = new String[caConfigs.size()];
        return caConfigs.toArray(caConfigsArray);
    }

    private static Resource getConfigFromCollection(Collection<Resource> tifCollection) {
        Iterator<Resource> tifIterator = tifCollection.iterator();
        ArrayList<Resource> tifList = new ArrayList<Resource>();
        while (tifIterator.hasNext()) {
            tifList.add(tifIterator.next());
        }
        if (tifList.size() == 1) {
            return (Resource)tifList.get(0);
        }
        if (tifList.size() > 1) {
            String[] fallbackPaths;
            for (int ndx = 0; ndx < tifList.size(); ++ndx) {
                Resource currTif = (Resource)tifList.get(ndx);
                if (!currTif.getPath().startsWith(CACONFIG_ROOT) || currTif.getPath().startsWith(CACONFIG_GLOBAL)) continue;
                return currTif;
            }
            for (String fallbackPath : fallbackPaths = new String[]{CACONFIG_GLOBAL, "/apps"}) {
                for (int ndx = 0; ndx < tifList.size(); ++ndx) {
                    Resource currTif = (Resource)tifList.get(ndx);
                    if (!currTif.getPath().startsWith(fallbackPath)) continue;
                    return currTif;
                }
            }
        }
        return null;
    }

    private static HashSet<Asset> getEmbeddedAssets(String contentFragmentNodePath, ResourceResolver resourceResolver) throws RepositoryException, IOException {
        log.debug("In Function: getEmbeddedAssets");
        HashSet<Asset> embeddedAssets = new HashSet<Asset>();
        ContentFragment cf = resourceResolver.getResource(contentFragmentNodePath).adaptTo(ContentFragment.class);
        if (cf != null) {
            Iterator<ContentElement> cfElemnemts = cf.getElements();
            while (cfElemnemts.hasNext()) {
                ContentElement currentElement = cfElemnemts.next();
                String elementContent = currentElement.getContent();
                embeddedAssets.addAll(DamLanguageUtil.getEmbeddedAssetsForVariation(elementContent, resourceResolver));
                Iterator<ContentVariation> elementVariations = currentElement.getVariations();
                while (elementVariations.hasNext()) {
                    ContentVariation currentVariation = elementVariations.next();
                    String variationData = currentVariation.getContent();
                    embeddedAssets.addAll(DamLanguageUtil.getEmbeddedAssetsForVariation(variationData, resourceResolver));
                }
            }
        }
        return embeddedAssets;
    }

    private static void replaceEmbeddedAssets(String contentFragmentNodePath, String targetLanguageCode, ResourceResolver resourceResolver) throws RepositoryException, IOException, ContentFragmentException {
        log.debug("In Function: replaceEmbeddedAssets");
        ContentFragment cf = resourceResolver.getResource(contentFragmentNodePath).adaptTo(ContentFragment.class);
        if (cf != null) {
            Iterator<ContentElement> cfElemnemts = cf.getElements();
            while (cfElemnemts.hasNext()) {
                ContentElement currentElement = cfElemnemts.next();
                String elementContent = currentElement.getContent();
                String replacementData = DamLanguageUtil.replaceEmbeddedAssetsForVariation(elementContent, targetLanguageCode, resourceResolver);
                currentElement.setContent(replacementData, currentElement.getContentType());
                Iterator<ContentVariation> elementVariations = currentElement.getVariations();
                while (elementVariations.hasNext()) {
                    ContentVariation currentVariation = elementVariations.next();
                    String variationData = currentVariation.getContent();
                    String variationReplacementData = DamLanguageUtil.replaceEmbeddedAssetsForVariation(variationData, targetLanguageCode, resourceResolver);
                    currentVariation.setContent(variationReplacementData, currentVariation.getContentType());
                }
            }
        }
    }

    private static String getMimeType(Node variation) throws RepositoryException {
        Node contentNode;
        String retVal = "";
        if (variation.hasNode("jcr:content") && (contentNode = variation.getNode("jcr:content")).hasProperty("jcr:mimeType")) {
            retVal = contentNode.getProperty("jcr:mimeType").getString();
        }
        return retVal;
    }

    private static HashSet<Asset> getEmbeddedAssetsForVariation(String variationData, ResourceResolver resourceResolver) {
        log.debug("In Function: getEmbeddedAssetsForVariation");
        HashSet<Asset> embeddedAssets = new HashSet<Asset>();
        HashSet<String> assetPaths = DamLanguageUtil.getEmbeddedAssetPaths(variationData);
        for (String assetPath : assetPaths) {
            Asset asset;
            Resource resource = resourceResolver.getResource(DamLanguageUtil.decodeURL(assetPath));
            if (null == resource || null == (asset = resource.adaptTo(Asset.class))) continue;
            embeddedAssets.add(asset);
        }
        return embeddedAssets;
    }

    private static String decodeURL(String url) {
        try {
            return URIUtil.decode(url);
        }
        catch (URIException e) {
            log.error("could not decode url : {}", (Object)url, (Object)e);
            return url;
        }
    }

    private static String encodeURL(String url) {
        try {
            return URIUtil.encodePath(url);
        }
        catch (URIException e) {
            log.error("could not encode url : {}", (Object)url, (Object)e);
            return url;
        }
    }

    private static String replaceEmbeddedAssetsForVariation(String variationData, String targetLanguageCode, ResourceResolver resourceResolver) {
        log.debug("In Function: replaceEmbeddedAssetsForVariation");
        String regEx = DamLanguageUtil.getRegexForInlineMediaAssets();
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(variationData);
        int lastEnd = 0;
        String updatedVariationData = "";
        while (matcher.find()) {
            String sourceCopyPath = matcher.group(DamLanguageUtil.getRegexGroupInlineMediaAssets());
            sourceCopyPath = DamLanguageUtil.decodeURL(sourceCopyPath);
            String languageCopyPath = DamLanguageUtil.findLanguageCopyPathWithAutoCreatedRoots(sourceCopyPath, targetLanguageCode, resourceResolver);
            languageCopyPath = DamLanguageUtil.encodeURL(languageCopyPath);
            int start = matcher.start(DamLanguageUtil.getRegexGroupInlineMediaAssets());
            int end = matcher.end(DamLanguageUtil.getRegexGroupInlineMediaAssets());
            updatedVariationData = updatedVariationData + variationData.substring(lastEnd, start) + languageCopyPath;
            lastEnd = end;
        }
        updatedVariationData = updatedVariationData + variationData.substring(lastEnd);
        return updatedVariationData;
    }

    private static HashSet<String> getEmbeddedAssetPaths(String variationData) {
        log.debug("In Function: getEmbeddedAssetPaths");
        HashSet<String> assetPaths = new HashSet<String>();
        String regEx = DamLanguageUtil.getRegexForInlineMediaAssets();
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(variationData);
        while (matcher.find()) {
            assetPaths.add(matcher.group(DamLanguageUtil.getRegexGroupInlineMediaAssets()));
        }
        return assetPaths;
    }

    private static String getRegexForInlineMediaAssets() {
        String TOKEN_UNLIMITED_SPACE = "[\\n ]*";
        String TOKEN_IMAGE_TAG = "img";
        String TOKEN_ATTRIBUTE_KEY = "[a-zA-Z-]+";
        String TOKEN_ATTRIBUTE_KEY_SOURCE = "src";
        String TOKEN_SOURCE_ATTRIBUTE_VALUE = "\"[\\n ]*([^>\" \\n]+)[\\n ]*\"";
        String TOKEN_ATTRIBUTE_VALUE = "\"[\\n ]*([^>\"\\n]+)[\\n ]*\"";
        String TOKEN_UNLIMITED_KEY_VALUE = "(([a-zA-Z-]+[\\n ]*=[\\n ]*\"[\\n ]*([^>\"\\n]+)[\\n ]*\")* *)*";
        String TOKEN_SOURCE_KEY_VALUE = "src[\\n ]*=[\\n ]*\"[\\n ]*([^>\" \\n]+)[\\n ]*\"";
        String regex = "<[\\n ]*img[\\n ]*(([a-zA-Z-]+[\\n ]*=[\\n ]*\"[\\n ]*([^>\"\\n]+)[\\n ]*\")* *)*[\\n ]*src[\\n ]*=[\\n ]*\"[\\n ]*([^>\" \\n]+)[\\n ]*\"[\\n ]*(([a-zA-Z-]+[\\n ]*=[\\n ]*\"[\\n ]*([^>\"\\n]+)[\\n ]*\")* *)*[\\n ]*\\/?[\\n ]*>";
        return "<[\\n ]*img[\\n ]*(([a-zA-Z-]+[\\n ]*=[\\n ]*\"[\\n ]*([^>\"\\n]+)[\\n ]*\")* *)*[\\n ]*src[\\n ]*=[\\n ]*\"[\\n ]*([^>\" \\n]+)[\\n ]*\"[\\n ]*(([a-zA-Z-]+[\\n ]*=[\\n ]*\"[\\n ]*([^>\"\\n]+)[\\n ]*\")* *)*[\\n ]*\\/?[\\n ]*>";
    }

    private static int getRegexGroupInlineMediaAssets() {
        return 4;
    }

    private static void setLastTranslationUpdate(Resource resource) throws RepositoryException {
        Resource contentResource;
        if (resource != null && (contentResource = resource.getChild("jcr:content")) != null) {
            Node sourceContentNode = contentResource.adaptTo(Node.class);
            Calendar lastModified = DamLanguageUtil.getNodeLastModifiedTime(contentResource);
            if (lastModified == null) {
                lastModified = Calendar.getInstance();
            }
            sourceContentNode.setProperty(ATTRIBUTE_CQ_TRANSLATION_LAST_UPDATE, lastModified);
        }
    }

    private static Calendar getNodeLastModifiedTime(Resource contentNode) {
        Calendar retVal = null;
        Calendar cqLastModified = DamLanguageUtil.getCalendarAttribute(contentNode, CQ_LASTMODIFIED);
        Calendar jcrLastModified = DamLanguageUtil.getCalendarAttribute(contentNode, "jcr:lastModified");
        if (cqLastModified != null && jcrLastModified != null) {
            retVal = cqLastModified.compareTo(jcrLastModified) > 0 ? cqLastModified : jcrLastModified;
        } else if (jcrLastModified != null) {
            retVal = jcrLastModified;
        } else if (cqLastModified != null) {
            retVal = cqLastModified;
        }
        return retVal;
    }

    private static Calendar getCalendarAttribute(Resource resource, String strAttributeName) {
        ValueMap contentVM = resource.adaptTo(ValueMap.class);
        return (Calendar)((Object)contentVM.get(strAttributeName, Calendar.class));
    }

    private static String getDestinationLanguageRoot(@Nonnull String srcLanguageRootParentPath, @Nonnull String destinationLanguage, @Nonnull ResourceResolver resourceResolver) {
        Resource langRootParent = resourceResolver.getResource(srcLanguageRootParentPath);
        if (null != langRootParent) {
            destinationLanguage = DamLanguageUtil.getDestinationLanguageWithAllowedDelimiters(srcLanguageRootParentPath, destinationLanguage, resourceResolver);
            String sameLevelDestinationRootPath = srcLanguageRootParentPath + "/" + destinationLanguage;
            if (null != resourceResolver.getResource(sameLevelDestinationRootPath)) {
                return sameLevelDestinationRootPath;
            }
            Iterator<Resource> iter = langRootParent.listChildren();
            while (iter.hasNext()) {
                String retVal;
                Resource sibling = iter.next();
                Locale locale = DamLanguageUtil.getLocaleFromResource(sibling);
                if (locale != null || null == (retVal = DamLanguageUtil.checkAndGetLanguageRootsFromChildren(sibling, destinationLanguage))) continue;
                return retVal;
            }
            Resource langRootGrandParent = langRootParent.getParent();
            ArrayList<Resource> nonLangRootUncles = new ArrayList<Resource>();
            boolean additionalLanguageRootsFound = false;
            if (langRootGrandParent != null) {
                Iterator<Resource> langRootUncles = langRootGrandParent.listChildren();
                while (langRootUncles.hasNext()) {
                    Resource langRootUncle = langRootUncles.next();
                    if (langRootUncle.getName().equals(langRootParent.getName())) continue;
                    Locale gcLocale = DamLanguageUtil.getLocaleFromResource(langRootUncle);
                    if (DamLanguageUtil.isCountryNode(langRootUncle)) continue;
                    additionalLanguageRootsFound = true;
                    if (null != gcLocale) {
                        String gcLanguage = gcLocale.getLanguage().toString();
                        if (!destinationLanguage.equals(gcLanguage)) continue;
                        return langRootUncle.getPath();
                    }
                    nonLangRootUncles.add(langRootUncle);
                }
            }
            if (additionalLanguageRootsFound) {
                for (Resource nonLangRootUncle : nonLangRootUncles) {
                    String retVal = DamLanguageUtil.checkAndGetLanguageRootsFromChildren(nonLangRootUncle, destinationLanguage);
                    if (null == retVal) continue;
                    return retVal;
                }
            }
            return sameLevelDestinationRootPath;
        }
        return null;
    }

    private static String checkAndGetLanguageRootsFromChildren(Resource resource, String destLanguage) {
        Iterator<Resource> children = resource.listChildren();
        while (children.hasNext()) {
            String childLanguage;
            Resource child = children.next();
            Locale childLocale = DamLanguageUtil.getLocaleFromResource(child);
            if (childLocale == null || !(childLanguage = childLocale.getLanguage().toString()).equals(destLanguage)) continue;
            return child.getPath();
        }
        return null;
    }

    private static Locale getLocaleFromResource(@Nonnull Resource res) {
        Language language = LanguageUtil.getLanguage(res.getName());
        if (language != null) {
            return language.getLocale();
        }
        return null;
    }

    private static boolean isCountryNode(Resource resource) {
        Iterator<Resource> children = resource.listChildren();
        while (children.hasNext()) {
            Resource child = children.next();
            Locale gcLocale = DamLanguageUtil.getLocaleFromResource(child);
            if (gcLocale == null) continue;
            return true;
        }
        return false;
    }

    public static ResourceResolver getUserResourceResolverFromUserId(SlingRepository slingRepository, ResourceResolverFactory resolverFactory, String userId, String serviceUser) throws LoginException, RepositoryException {
        Session initiatorSession = DamLanguageUtil.getUserSession(slingRepository, userId, serviceUser);
        return resolverFactory.getResourceResolver(Collections.singletonMap("user.jcr.session", initiatorSession));
    }

    private static Session getUserSession(SlingRepository slingRepository, String userId, String serviceUser) throws RepositoryException {
        SimpleCredentials credentials = new SimpleCredentials(userId, new char[0]);
        return slingRepository.impersonateFromService(serviceUser, credentials, null);
    }

    private static enum TranslationCategory {
        NONE,
        DESTINATION,
        TEMPORARY;

    }
}

