/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.adobe.granite.asset.api.Asset;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S73DHelper {
    private static final Logger log = LoggerFactory.getLogger(S73DHelper.class);
    static final String[] MimeTypes3D = new String[]{"application/x-v3d", "application/x-maya", "application/x-fbx", "application/x-obj", "application/x-max"};

    public static boolean isV3DInstalled(Session session) {
        try {
            Node rootNode = session.getRootNode();
            Node pathNode = null;
            pathNode = rootNode.getNode("apps/cq-scene7-v3D/config/settings");
            if (pathNode != null) {
                String propertyName = "isActive";
                if (pathNode.hasProperty(propertyName)) {
                    return pathNode.getProperty(propertyName).getBoolean();
                }
                return true;
            }
        }
        catch (RepositoryException e1) {
            log.error("3D-ERROR: sV3DInstalled Failed while looking for V3D App");
            e1.printStackTrace();
            return false;
        }
        return false;
    }

    public static String getS7Type(Resource resource) {
        if (resource == null) {
            return null;
        }
        Resource contentResource = resource.getChild("jcr:content");
        ValueMap vm = contentResource != null ? contentResource.adaptTo(ValueMap.class) : null;
        return vm != null ? (String)((Object)vm.get("dam:s7damType", String.class)) : null;
    }

    public static boolean isS73D(Resource resource) {
        if (resource == null) {
            return false;
        }
        String s7Type = S73DHelper.getS7Type(resource);
        return "3D Object".equals(s7Type) || "3D Scene".equals(s7Type) || "3D Stage".equals(s7Type);
    }

    public static boolean hasModel(Resource resource) {
        if (resource == null) {
            return false;
        }
        if (!S73DHelper.is3DMimeType(resource)) {
            return false;
        }
        Resource contentResource = resource.getChild("jcr:content");
        Node content = contentResource != null ? contentResource.adaptTo(Node.class) : null;
        try {
            return content != null && content.hasNode("model");
        }
        catch (RepositoryException e) {
            log.error("3D-ERROR: hasModel Failed ");
            e.printStackTrace();
            return false;
        }
    }

    public static boolean is3DMimeType(Resource resource) {
        assert (resource != null);
        Asset asset = resource.adaptTo(Asset.class);
        return S73DHelper.get3DMimeType(asset) != null;
    }

    public static String[] getDependencyPaths(Resource resource) {
        assert (resource != null);
        ArrayList<String> deps = new ArrayList<String>();
        if (S73DHelper.isS73D(resource)) {
            try {
                Asset asset = resource.adaptTo(Asset.class);
                Iterator<? extends Asset> ai = asset.listRelated("links");
                while (ai.hasNext()) {
                    Node ni = ai.next().adaptTo(Node.class);
                    deps.add(ni.getProperty("sling:resource").getString());
                }
            }
            catch (RepositoryException e) {
                log.error("3D-ERROR: getDependencyPaths Failed ");
                e.printStackTrace();
                return null;
            }
        }
        if (deps.isEmpty()) {
            return null;
        }
        String[] dependencies = new String[deps.size()];
        for (int i = 0; i < deps.size(); ++i) {
            dependencies[i] = (String)deps.get(i);
        }
        return dependencies;
    }

    public static boolean isUnResolved(Resource resource) {
        assert (resource != null);
        if (S73DHelper.isS73D(resource)) {
            Resource contentResource = resource.getChild("jcr:content");
            Node content = contentResource != null ? contentResource.adaptTo(Node.class) : null;
            try {
                if (content != null && content.hasNode("unresolved")) {
                    Node unresolved = content.getNode("unresolved");
                    return unresolved.hasNodes();
                }
                return false;
            }
            catch (RepositoryException e) {
                log.error("3D-ERROR: isUnResolved Failed");
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public static boolean isIncomplete(Resource resource) {
        assert (resource != null);
        if (S73DHelper.isS73D(resource)) {
            Resource contentResource = resource.getChild("jcr:content");
            Node content = contentResource != null ? contentResource.adaptTo(Node.class) : null;
            try {
                if (content != null && content.hasNode("unresolved")) {
                    Node unresolvedNode = content.getNode("unresolved");
                    int numMissing = 0;
                    NodeIterator ni = unresolvedNode.getNodes();
                    while (ni.hasNext()) {
                        Node unresolved = ni.nextNode();
                        if (unresolved.hasProperty("required") && !unresolved.getProperty("required").getString().equals("true")) continue;
                        ++numMissing;
                    }
                    return numMissing > 0;
                }
                return false;
            }
            catch (RepositoryException e) {
                log.error("3D-ERROR: isIncomplete Failed");
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public static String getProgressValue(Resource resource) {
        Resource contentResource;
        assert (resource != null);
        if (S73DHelper.isS73D(resource) && (contentResource = resource.getChild("jcr:content/progress")) != null) {
            ValueMap vm = contentResource.adaptTo(ValueMap.class);
            String value = vm.get("Progress", "");
            return value;
        }
        return "";
    }

    public static String getProgressOperation(Resource resource) {
        Resource contentResource;
        assert (resource != null);
        if (S73DHelper.isS73D(resource) && (contentResource = resource.getChild("jcr:content/progress")) != null) {
            ValueMap vm = contentResource.adaptTo(ValueMap.class);
            String value = vm.get("Operation", "");
            return value;
        }
        return "";
    }

    public static boolean has3DMimeTypeDC(Resource resource) {
        Resource contentResource = resource.getChild("jcr:content/metadata");
        if (contentResource != null) {
            ValueMap vm = contentResource.adaptTo(ValueMap.class);
            String value = vm.get("dc:format", "").toLowerCase();
            for (String type : MimeTypes3D) {
                if (!value.equals(type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean has3DMimeTypeJCR(Resource resource) {
        Resource contentResource = resource.getChild("jcr:content/metadata");
        if (contentResource != null) {
            ValueMap vm = contentResource.adaptTo(ValueMap.class);
            String value = vm.get("jcr:mimeType", "").toLowerCase();
            for (String type : MimeTypes3D) {
                if (!value.equals(type)) continue;
                return true;
            }
        }
        return false;
    }

    public static String get3DMimeType(Asset asset) {
        if (asset == null) {
            return null;
        }
        return S73DHelper.get3DMimeType(asset.getName());
    }

    public static String get3DMimeType(String fileName) {
        String mimeType = null;
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        if (extension.equalsIgnoreCase("v3d")) {
            mimeType = "application/x-v3d";
        } else if (extension.equalsIgnoreCase("ma") || extension.equalsIgnoreCase("mb")) {
            mimeType = "application/x-maya";
        } else if (extension.equalsIgnoreCase("fbx")) {
            mimeType = "application/x-fbx";
        } else if (extension.equalsIgnoreCase("obj")) {
            mimeType = "application/x-obj";
        } else if (extension.equalsIgnoreCase("max")) {
            mimeType = "application/x-max";
        }
        return mimeType;
    }
}

