/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.eval;

import com.day.cq.search.Predicate;
import com.day.cq.search.eval.AbstractPredicateEvaluator;
import com.day.cq.search.eval.EvaluationContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.Row;
import org.apache.felix.scr.annotations.Component;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.resource.collection.ResourceCollection;

@Component(metatype=false, factory="com.day.cq.search.eval.PredicateEvaluator/memberOf")
public class CollectionPredicateEvaluator
extends AbstractPredicateEvaluator {
    public static final String COLLECTION = "memberOf";
    private static final String COLLECTION_PATH_SET_KEY = "collectionPathSet";
    private static final String COLLECTION_FOLDER_SET_KEY = "collectionFolderSet";

    @Override
    public boolean includes(Predicate p, Row row, EvaluationContext context) {
        if (!p.hasNonEmptyValue(COLLECTION)) {
            return true;
        }
        Set collectionPathSet = (Set)context.get(COLLECTION_PATH_SET_KEY);
        Set<String> collectionFolderSet = (Set<String>)context.get(COLLECTION_FOLDER_SET_KEY);
        if (collectionPathSet == null) {
            Resource colRes = context.getResourceResolver().getResource(p.get(COLLECTION));
            collectionPathSet = Collections.emptySet();
            collectionFolderSet = Collections.emptySet();
            if (colRes != null) {
                ResourceCollection collection = colRes.adaptTo(ResourceCollection.class);
                Iterator<Resource> collectionItr = collection.getResources();
                collectionPathSet = new HashSet();
                collectionFolderSet = new HashSet<String>();
                while (collectionItr.hasNext()) {
                    Resource collectionMember = collectionItr.next();
                    collectionPathSet.add(collectionMember.getPath());
                    if (!this.isFolder(collectionMember)) continue;
                    collectionFolderSet.add(collectionMember.getPath() + "/");
                }
            }
            context.put(COLLECTION_PATH_SET_KEY, collectionPathSet);
            context.put(COLLECTION_FOLDER_SET_KEY, collectionFolderSet);
        }
        return collectionPathSet.contains(context.getPath(row)) || this.isFolderMember(collectionFolderSet, context.getPath(row));
    }

    @Override
    public boolean canXpath(Predicate predicate, EvaluationContext context) {
        return false;
    }

    @Override
    public boolean canFilter(Predicate predicate, EvaluationContext context) {
        return true;
    }

    private boolean isFolder(Resource resource) {
        Node n = resource.adaptTo(Node.class);
        try {
            return n.isNodeType("nt:folder");
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    private boolean isFolderMember(Set<String> collectionFolderSet, String path) {
        for (String folderPath : collectionFolderSet) {
            if (path.indexOf(folderPath) != 0) continue;
            return true;
        }
        return false;
    }
}

