/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.eval;

import com.day.cq.search.Predicate;
import com.day.cq.search.eval.EvaluationContext;
import com.day.cq.search.eval.JcrPropertyPredicateEvaluator;
import com.day.cq.search.eval.XPath;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.jcr.query.Row;
import org.apache.felix.scr.annotations.Component;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, factory="com.day.cq.search.eval.PredicateEvaluator/boolproperty")
public class JcrBoolPropertyPredicateEvaluator
extends JcrPropertyPredicateEvaluator {
    private static final Logger log = LoggerFactory.getLogger(JcrBoolPropertyPredicateEvaluator.class);
    public static final String BOOLPROPERTY = "boolproperty";

    @Override
    public String getXPathExpression(Predicate p, EvaluationContext context) {
        if (!p.hasNonEmptyValue(BOOLPROPERTY) || !p.hasNonEmptyValue("value")) {
            return null;
        }
        String property = p.get(BOOLPROPERTY);
        String value = p.get("value");
        if ("false".equals(value)) {
            return "(" + XPath.getEqualsExpression(property, value) + " or " + XPath.getNotExpression(property) + ")";
        }
        if ("true".equals(value)) {
            return XPath.getEqualsExpression(property, value);
        }
        return null;
    }

    @Override
    public boolean includes(Predicate p, Row row, EvaluationContext context) {
        if (!p.hasNonEmptyValue(BOOLPROPERTY) || !p.hasNonEmptyValue("value")) {
            return true;
        }
        String property = p.get(BOOLPROPERTY);
        String value = p.get("value");
        Node node = context.getNode(row);
        String path = context.getPath(row);
        try {
            String childNode = Text.getRelativeParent(property, 1);
            String propName = Text.getName(property);
            if (childNode.length() > 0) {
                if (node.hasNode(childNode)) {
                    node = node.getNode(childNode);
                } else {
                    return false;
                }
            }
            if (node.hasProperty(propName)) {
                String propValue = node.getProperty(propName).getString();
                if (propValue == null) {
                    return "false".equals(value);
                }
                return propValue.equals(value);
            }
            return "false".equals(value);
        }
        catch (ValueFormatException e) {
            log.warn("Could not evaluate property = '" + property + "', value = '" + value + "', node = '" + path + "'", e);
        }
        catch (RepositoryException e) {
            log.error("Could not evaluate property = '" + property + "', value = '" + value + "', node = '" + path + "'", e);
            throw new RuntimeException("", e);
        }
        return true;
    }
}

