/*
 * Decompiled with CFR 0.152.
 */
package com.day.util.diff;

import com.day.util.diff.Document;

public class Range {
    public final Document doc;
    public final int low;
    public final int high;

    public Range(Document doc, int low, int high) {
        assert (low >= 0);
        assert (high >= low);
        this.doc = doc;
        this.low = low;
        this.high = high;
    }

    public int len() {
        return this.high - this.low;
    }

    public String toString() {
        return this.low + "-" + this.high;
    }

    public String toRangeString() {
        if (this.len() == 1) {
            return String.valueOf(this.low + 1);
        }
        return this.low + 1 + "," + this.len();
    }
}

