/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.jackrabbit.oak.composite.MountedNodeStore;
import org.apache.jackrabbit.oak.spi.mount.Mount;

public class NodeMap<T> {
    private final Map<MountedNodeStore, CacheableSupplier<T>> suppliers;

    private NodeMap(Map<MountedNodeStore, CacheableSupplier<T>> suppliers) {
        this.suppliers = suppliers;
    }

    public static <T> NodeMap<T> create(Map<MountedNodeStore, T> nodes) {
        ImmutableMap.Builder suppliers = ImmutableMap.builder();
        nodes.forEach((mns, node) -> suppliers.put(mns, new CacheableSupplier<Object>(node)));
        return new NodeMap<T>(suppliers.build());
    }

    public T get(MountedNodeStore nodeStore) {
        if (!this.suppliers.containsKey(nodeStore)) {
            Mount mount = nodeStore.getMount();
            String mountName = mount.isDefault() ? "[default]" : mount.getName();
            throw new IllegalStateException("Node is not available for the node store " + mountName);
        }
        return this.suppliers.get(nodeStore).get();
    }

    public <R> NodeMap<R> getAndApply(BiFunction<MountedNodeStore, T, R> function) {
        ImmutableMap.Builder newSuppliers = ImmutableMap.builder();
        this.suppliers.forEach((mns, node) -> newSuppliers.put(mns, node.getAndApply(NodeMap.curry(function, mns))));
        return new NodeMap<T>(newSuppliers.build());
    }

    public <R> NodeMap<R> lazyApply(BiFunction<MountedNodeStore, T, R> function) {
        ImmutableMap.Builder newSuppliers = ImmutableMap.builder();
        this.suppliers.forEach((mns, node) -> newSuppliers.put(mns, node.lazyApply(NodeMap.curry(function, mns))));
        return new NodeMap<T>(newSuppliers.build());
    }

    private static <T, U, R> Function<U, R> curry(BiFunction<T, U, R> function, T value) {
        return u -> function.apply(value, u);
    }

    public NodeMap<T> replaceNode(MountedNodeStore nodeStore, T node) {
        ImmutableMap.Builder newSuppliers = ImmutableMap.builder();
        this.suppliers.forEach((mns, n) -> {
            if (mns != nodeStore) {
                newSuppliers.put((MountedNodeStore)mns, (CacheableSupplier)n);
            }
        });
        newSuppliers.put(nodeStore, new CacheableSupplier<T>(node));
        return new NodeMap<T>(newSuppliers.build());
    }

    private static class CacheableSupplier<T>
    implements Supplier<T> {
        private Supplier<T> supplier;
        private volatile T value;

        private CacheableSupplier(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        public CacheableSupplier(T value) {
            this.value = value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (this.value == null) {
                CacheableSupplier cacheableSupplier = this;
                synchronized (cacheableSupplier) {
                    if (this.value == null) {
                        this.value = this.supplier.get();
                        this.supplier = null;
                    }
                }
            }
            return this.value;
        }

        public <R> CacheableSupplier<R> getAndApply(Function<T, R> function) {
            return new CacheableSupplier<R>(function.apply(this.get()));
        }

        public <R> CacheableSupplier<R> lazyApply(Function<T, R> function) {
            return new CacheableSupplier<Supplier<Object>>(() -> function.apply(this.get()));
        }
    }
}

