/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.name;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.namespace.NamespaceConstants;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.util.Text;

public class Namespaces
implements NamespaceConstants {
    private static final Map<String, String> ENCODED_URIS = Maps.newConcurrentMap();
    private static final boolean allowOtherWhitespaceChars = Boolean.getBoolean("oak.allowOtherWhitespaceChars");
    private static final boolean allowOtherControlChars = Boolean.getBoolean("oak.allowOtherControlChars");
    private static final boolean disallowNonASCIIWhitespaceChars = Boolean.getBoolean("oak.disallowNonASCIIWhitespaceChars");

    private Namespaces() {
    }

    public static void setupNamespaces(NodeBuilder system) {
        if (!system.hasChildNode("rep:namespaces")) {
            NodeBuilder namespaces = Namespaces.createStandardMappings(system);
            Namespaces.buildIndexNode(namespaces);
        }
    }

    public static NodeBuilder createStandardMappings(NodeBuilder system) {
        Preconditions.checkState(!system.hasChildNode("rep:namespaces"));
        NodeBuilder namespaces = system.setChildNode("rep:namespaces");
        namespaces.setProperty("jcr:primaryType", "rep:Unstructured", Type.NAME);
        namespaces.setProperty("jcr", "http://www.jcp.org/jcr/1.0");
        namespaces.setProperty("nt", "http://www.jcp.org/jcr/nt/1.0");
        namespaces.setProperty("mix", "http://www.jcp.org/jcr/mix/1.0");
        namespaces.setProperty("xml", "http://www.w3.org/XML/1998/namespace");
        namespaces.setProperty("sv", "http://www.jcp.org/jcr/sv/1.0");
        namespaces.setProperty("rep", "internal");
        namespaces.setProperty("oak", "http://jackrabbit.apache.org/oak/ns/1.0");
        return namespaces;
    }

    /*
     * WARNING - void declaration
     */
    public static String addCustomMapping(NodeBuilder namespaces, String uri, String prefixHint) {
        for (PropertyState propertyState : namespaces.getProperties()) {
            String prefix;
            if (propertyState.getType() != Type.STRING || !Namespaces.isValidPrefix(prefix = propertyState.getName()) || !uri.equals(propertyState.getValue(Type.STRING))) continue;
            return prefix;
        }
        String prefix = prefixHint;
        boolean bl = true;
        while (namespaces.hasProperty(prefix)) {
            void var4_6;
            prefix = prefixHint + (int)(++var4_6);
        }
        namespaces.setProperty(prefix, uri);
        return prefix;
    }

    public static void buildIndexNode(NodeBuilder namespaces) {
        HashSet<String> prefixes = Sets.newHashSet("");
        HashSet<String> uris = Sets.newHashSet("");
        Map<String, String> nsmap = Namespaces.collectNamespaces(namespaces.getProperties());
        prefixes.addAll(nsmap.keySet());
        uris.addAll(nsmap.values());
        NodeBuilder data = namespaces.setChildNode("rep:nsdata");
        data.setProperty("jcr:primaryType", "rep:Unstructured", Type.NAME);
        data.setProperty("rep:prefixes", prefixes, Type.STRINGS);
        data.setProperty("rep:uris", uris, Type.STRINGS);
        for (Map.Entry<String, String> e : nsmap.entrySet()) {
            data.setProperty(Namespaces.encodeUri(e.getValue()), e.getKey());
        }
    }

    private static Tree getNamespaceTree(Tree root) {
        return root.getChild("jcr:system").getChild("rep:namespaces");
    }

    public static Map<String, String> getNamespaceMap(Tree root) {
        Map<String, String> map = Namespaces.collectNamespaces(Namespaces.getNamespaceTree(root).getProperties());
        map.put("", "");
        return map;
    }

    static Map<String, String> collectNamespaces(Iterable<? extends PropertyState> properties) {
        HashMap<String, String> map = Maps.newHashMap();
        for (PropertyState propertyState : properties) {
            String prefix = propertyState.getName();
            if (!Type.STRING.equals(propertyState.getType()) || !Namespaces.isValidPrefix(prefix)) continue;
            map.put(prefix, propertyState.getValue(Type.STRING));
        }
        return map;
    }

    public static String getNamespacePrefix(Tree root, String uri) {
        if (uri.isEmpty()) {
            return uri;
        }
        Tree nsdata = Namespaces.getNamespaceTree(root).getChild("rep:nsdata");
        PropertyState ps = nsdata.getProperty(Namespaces.encodeUri(uri));
        if (ps != null) {
            return ps.getValue(Type.STRING);
        }
        return null;
    }

    public static String getNamespaceURI(Tree root, String prefix) {
        PropertyState property;
        if (prefix.isEmpty()) {
            return prefix;
        }
        if (Namespaces.isValidPrefix(prefix) && (property = Namespaces.getNamespaceTree(root).getProperty(prefix)) != null && property.getType() == Type.STRING) {
            return property.getValue(Type.STRING);
        }
        return null;
    }

    public static String encodeUri(String uri) {
        String encoded = ENCODED_URIS.get(uri);
        if (encoded == null) {
            encoded = Text.escapeIllegalJcrChars(uri);
            if (ENCODED_URIS.size() > 1000) {
                ENCODED_URIS.clear();
            }
            ENCODED_URIS.put(uri, encoded);
        }
        return encoded;
    }

    public static boolean isValidPrefix(String prefix) {
        return prefix.indexOf(58) == -1;
    }

    public static boolean isValidLocalName(String local) {
        if (local.isEmpty() || ".".equals(local) || "..".equals(local)) {
            return false;
        }
        for (int i = 0; i < local.length(); ++i) {
            boolean spaceChar;
            char ch = local.charAt(i);
            if (disallowNonASCIIWhitespaceChars) {
                spaceChar = allowOtherWhitespaceChars ? Character.isSpaceChar(ch) : Character.isWhitespace(ch);
            } else {
                boolean bl = spaceChar = ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
            }
            if (spaceChar) {
                if (i == 0) {
                    return false;
                }
                if (i == local.length() - 1) {
                    return false;
                }
                if (ch == ' ') continue;
                return false;
            }
            if ("/:[]|*".indexOf(ch) != -1) {
                return false;
            }
            if (allowOtherControlChars || ch < '\u0000' || ch >= ' ' || ch == '\t' || ch == '\n' || ch == '\r') continue;
            return false;
        }
        return true;
    }
}

