/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.mount;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.oak.spi.mount.Mount;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;

final class SimpleMountInfoProvider
implements MountInfoProvider {
    private final Map<String, Mount> mounts;
    private final Mount defMount;
    private final boolean hasMounts;

    SimpleMountInfoProvider(List<Mount> mountInfos) {
        this.mounts = SimpleMountInfoProvider.getMounts(mountInfos);
        this.hasMounts = !this.mounts.isEmpty();
        this.defMount = SimpleMountInfoProvider.defaultMount(this.mounts);
    }

    @Override
    public Mount getMountByPath(String path) {
        for (Mount m : this.mounts.values()) {
            if (!m.isMounted(path)) continue;
            return m;
        }
        return this.defMount;
    }

    @Override
    public Collection<Mount> getNonDefaultMounts() {
        return this.mounts.values();
    }

    @Override
    public Mount getMountByName(String name) {
        return this.mounts.get(name);
    }

    @Override
    public boolean hasNonDefaultMounts() {
        return this.hasMounts;
    }

    @Override
    public Collection<Mount> getMountsPlacedUnder(String path) {
        ArrayList<Mount> mounts = Lists.newArrayList();
        for (Mount mount : this.mounts.values()) {
            if (!mount.isUnder(path)) continue;
            mounts.add(mount);
        }
        return mounts;
    }

    @Override
    public Collection<Mount> getMountsPlacedDirectlyUnder(String path) {
        ArrayList<Mount> mounts = Lists.newArrayList();
        for (Mount mount : this.mounts.values()) {
            if (!mount.isDirectlyUnder(path)) continue;
            mounts.add(mount);
        }
        return mounts;
    }

    @Override
    public Mount getDefaultMount() {
        return this.defMount;
    }

    private static Map<String, Mount> getMounts(List<Mount> mountInfos) {
        HashMap<String, Mount> mounts = Maps.newHashMap();
        for (Mount mi : mountInfos) {
            mounts.put(mi.getName(), mi);
        }
        return ImmutableMap.copyOf(mounts);
    }

    private static Mount defaultMount(Map<String, Mount> mounts) {
        return new Mounts.DefaultMount(mounts.values());
    }
}

