/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.state;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNodeState
implements NodeState {
    private static final int CHILDREN_CAP = Integer.getInteger("oak.children.cap", 100);

    public static boolean isValidName(String name) {
        return name != null && !name.isEmpty() && name.indexOf(47) == -1;
    }

    public static void checkValidName(String name) throws IllegalArgumentException {
        if (!AbstractNodeState.isValidName(name)) {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
    }

    public static boolean getBoolean(NodeState state, String name) {
        PropertyState property = state.getProperty(name);
        return property != null && property.getType() == Type.BOOLEAN && property.getValue(Type.BOOLEAN) != false;
    }

    public static long getLong(NodeState state, String name) {
        PropertyState property = state.getProperty(name);
        if (property != null && property.getType() == Type.LONG) {
            return property.getValue(Type.LONG);
        }
        return 0L;
    }

    public static String getString(NodeState state, String name) {
        PropertyState property = state.getProperty(name);
        if (property != null && property.getType() == Type.STRING) {
            return property.getValue(Type.STRING);
        }
        return null;
    }

    public static Iterable<String> getStrings(NodeState state, String name) {
        PropertyState property = state.getProperty(name);
        if (property != null && property.getType() == Type.STRINGS) {
            return property.getValue(Type.STRINGS);
        }
        return Collections.emptyList();
    }

    public static String getName(NodeState state, String name) {
        PropertyState property = state.getProperty(name);
        if (property != null && property.getType() == Type.NAME) {
            return property.getValue(Type.NAME);
        }
        return null;
    }

    public static Iterable<String> getNames(NodeState state, String name) {
        PropertyState property = state.getProperty(name);
        if (property != null && property.getType() == Type.NAMES) {
            return property.getValue(Type.NAMES);
        }
        return Collections.emptyList();
    }

    public static boolean compareAgainstBaseState(NodeState state, NodeState base, NodeStateDiff diff) {
        String name;
        if (!AbstractNodeState.comparePropertiesAgainstBaseState(state, base, diff)) {
            return false;
        }
        HashSet<String> baseChildNodes = new HashSet<String>();
        for (ChildNodeEntry childNodeEntry : base.getChildNodeEntries()) {
            name = childNodeEntry.getName();
            NodeState beforeChild = childNodeEntry.getNodeState();
            NodeState afterChild = state.getChildNode(name);
            if (!afterChild.exists()) {
                if (diff.childNodeDeleted(name, beforeChild)) continue;
                return false;
            }
            baseChildNodes.add(name);
            if (afterChild == beforeChild || diff.childNodeChanged(name, beforeChild, afterChild)) continue;
            return false;
        }
        for (ChildNodeEntry childNodeEntry : state.getChildNodeEntries()) {
            name = childNodeEntry.getName();
            if (baseChildNodes.contains(name) || diff.childNodeAdded(name, childNodeEntry.getNodeState())) continue;
            return false;
        }
        return true;
    }

    public static boolean comparePropertiesAgainstBaseState(NodeState state, NodeState base, NodeStateDiff diff) {
        HashSet<String> baseProperties = new HashSet<String>();
        for (PropertyState propertyState : base.getProperties()) {
            String name = propertyState.getName();
            PropertyState afterProperty = state.getProperty(name);
            if (afterProperty == null) {
                if (diff.propertyDeleted(propertyState)) continue;
                return false;
            }
            baseProperties.add(name);
            if (propertyState.equals(afterProperty) || diff.propertyChanged(propertyState, afterProperty)) continue;
            return false;
        }
        for (PropertyState propertyState : state.getProperties()) {
            if (baseProperties.contains(propertyState.getName()) || diff.propertyAdded(propertyState)) continue;
            return false;
        }
        return true;
    }

    public static String toString(NodeState state) {
        if (!state.exists()) {
            return "{N/A}";
        }
        StringBuilder builder = new StringBuilder("{");
        String separator = " ";
        for (PropertyState propertyState : state.getProperties()) {
            builder.append(separator);
            separator = ", ";
            builder.append(propertyState);
        }
        int count = CHILDREN_CAP;
        for (ChildNodeEntry childNodeEntry : state.getChildNodeEntries()) {
            if (count-- == 0) {
                builder.append("...");
                break;
            }
            builder.append(separator);
            separator = ", ";
            builder.append(childNodeEntry);
        }
        builder.append(" }");
        return builder.toString();
    }

    @Override
    public boolean hasProperty(@NotNull String name) {
        return this.getProperty(name) != null;
    }

    @Override
    public boolean getBoolean(@NotNull String name) {
        return AbstractNodeState.getBoolean(this, name);
    }

    @Override
    public long getLong(String name) {
        return AbstractNodeState.getLong(this, name);
    }

    @Override
    public String getString(String name) {
        return AbstractNodeState.getString(this, name);
    }

    @Override
    @NotNull
    public Iterable<String> getStrings(@NotNull String name) {
        return AbstractNodeState.getStrings(this, name);
    }

    @Override
    @Nullable
    public String getName(@NotNull String name) {
        return AbstractNodeState.getName(this, name);
    }

    @Override
    @NotNull
    public Iterable<String> getNames(@NotNull String name) {
        return AbstractNodeState.getNames(this, name);
    }

    @Override
    public PropertyState getProperty(@NotNull String name) {
        for (PropertyState propertyState : this.getProperties()) {
            if (!name.equals(propertyState.getName())) continue;
            return propertyState;
        }
        return null;
    }

    @Override
    public long getPropertyCount() {
        return AbstractNodeState.count(this.getProperties());
    }

    @Override
    public long getChildNodeCount(long max) {
        long n = 0L;
        Iterator<? extends ChildNodeEntry> iterator = this.getChildNodeEntries().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            if (++n < max) continue;
            return Long.MAX_VALUE;
        }
        return n;
    }

    @Override
    public Iterable<String> getChildNodeNames() {
        return Iterables.transform(this.getChildNodeEntries(), new Function<ChildNodeEntry, String>(){

            @Override
            public String apply(ChildNodeEntry input) {
                return input.getName();
            }
        });
    }

    @Override
    public boolean compareAgainstBaseState(NodeState base, NodeStateDiff diff) {
        return AbstractNodeState.compareAgainstBaseState(this, base, diff);
    }

    public String toString() {
        return AbstractNodeState.toString(this);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof NodeState) {
            return AbstractNodeState.equals(this, (NodeState)that);
        }
        return false;
    }

    public static boolean equals(NodeState a, NodeState b) {
        if (a.exists() != b.exists() || a.getPropertyCount() != b.getPropertyCount()) {
            return false;
        }
        long max = 20L;
        long c1 = a.getChildNodeCount(max);
        long c2 = b.getChildNodeCount(max);
        if (c1 <= max || c2 <= max ? c1 != c2 : c1 != Long.MAX_VALUE && c2 != Long.MAX_VALUE && c1 != c2) {
            return false;
        }
        for (PropertyState propertyState : a.getProperties()) {
            if (propertyState.equals(b.getProperty(propertyState.getName()))) continue;
            return false;
        }
        c1 = a.getChildNodeCount(Long.MAX_VALUE);
        if (c1 != (c2 = b.getChildNodeCount(Long.MAX_VALUE))) {
            return false;
        }
        for (ChildNodeEntry childNodeEntry : a.getChildNodeEntries()) {
            if (childNodeEntry.getNodeState().equals(b.getChildNode(childNodeEntry.getName()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    protected static long count(Iterable<?> iterable) {
        long n = 0L;
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        return n;
    }
}

