/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.config;

import java.io.File;
import java.io.IOException;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultMetaInf;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportRoot {
    private static final Logger log = LoggerFactory.getLogger(ExportRoot.class);
    private final File rootDir;
    private final File jcrRoot;
    private final File metaDir;
    private DefaultMetaInf metaInf;

    public ExportRoot(File rootDir) {
        this.rootDir = rootDir;
        this.jcrRoot = new File(rootDir, "jcr_root");
        this.metaDir = new File(rootDir, "META-INF/vault");
    }

    public boolean isValid() {
        return this.jcrRoot.isDirectory() && this.metaDir.isDirectory();
    }

    public void assertValid() throws IOException {
        if (!this.isValid()) {
            throw new IOException("META-INF/vault does not exist or is not valid.");
        }
    }

    public void create() throws IOException {
        if (!this.jcrRoot.isDirectory()) {
            this.jcrRoot.mkdirs();
            if (!this.jcrRoot.isDirectory()) {
                throw new IOException("Unable to create " + this.jcrRoot.getAbsolutePath());
            }
            log.info("Created {}", (Object)this.jcrRoot.getAbsolutePath());
        }
        if (!this.metaDir.isDirectory()) {
            this.metaDir.mkdirs();
            if (!this.metaDir.isDirectory()) {
                throw new IOException("Unable to create " + this.metaDir.getAbsolutePath());
            }
            log.info("Created {}", (Object)this.metaDir.getAbsolutePath());
        }
    }

    public MetaInf getMetaInf() {
        if (this.metaInf == null) {
            this.metaInf = new DefaultMetaInf();
            if (this.metaDir.exists()) {
                try {
                    this.metaInf.loadConfig(this.metaDir);
                    this.metaInf.loadFilter(this.metaDir, true);
                    this.metaInf.loadSettings(this.metaDir);
                    this.metaInf.loadProperties(this.metaDir);
                    this.metaInf.loadCNDs(this.metaDir);
                    this.metaInf.loadPrivileges(this.metaDir);
                    this.metaInf.setHasDefinition(new File(this.metaDir, "definition/.content.xml").canRead());
                }
                catch (ConfigurationException e) {
                    log.warn("Error while loading meta dir.", e);
                }
                catch (IOException e) {
                    log.warn("Error while loading meta dir.", e);
                }
            }
        }
        return this.metaInf;
    }

    public File getRoot() {
        return this.rootDir;
    }

    public File getJcrRoot() {
        return this.jcrRoot;
    }

    public File getMetaDir() {
        return this.metaDir;
    }

    public static ExportRoot findRoot(File cwd) {
        if (cwd == null) {
            return null;
        }
        File jcrRoot = new File(cwd, "jcr_root");
        if (!jcrRoot.exists() || !jcrRoot.isDirectory()) {
            jcrRoot = cwd;
            while (jcrRoot != null) {
                if (!jcrRoot.exists()) {
                    jcrRoot = null;
                    continue;
                }
                if (jcrRoot.getName().equals("jcr_root")) break;
                jcrRoot = jcrRoot.getParentFile();
            }
        }
        if (jcrRoot == null) {
            log.info("could not find jcr_root along the ancestors of {}", (Object)cwd.getPath());
            return null;
        }
        return new ExportRoot(jcrRoot.getParentFile());
    }
}

