/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers;

import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.TopologyView;

public abstract class BaseTopologyView
implements TopologyView {
    private volatile boolean current = true;

    @Override
    public boolean isCurrent() {
        return this.current;
    }

    public void setNotCurrent() {
        this.current = false;
    }

    public abstract String getLocalClusterSyncTokenId();

    public String toShortString() {
        StringBuffer sb = new StringBuffer();
        for (InstanceDescription instance : this.getInstances()) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(instance.getSlingId());
            sb.append("[");
            sb.append("local=");
            sb.append(instance.isLocal());
            sb.append(",leader=");
            sb.append(instance.isLeader());
            sb.append("]");
        }
        return "DefaultTopologyView[current=" + this.isCurrent() + ", num=" + this.getInstances().size() + ", instances=" + sb.toString() + "]";
    }

    public InstanceDescription getInstance(String slingId) {
        for (InstanceDescription instance : this.getInstances()) {
            if (!instance.getSlingId().equals(slingId)) continue;
            return instance;
        }
        return null;
    }
}

