/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.spi.base;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.sling.discovery.commons.providers.BaseTopologyView;
import org.apache.sling.discovery.commons.providers.spi.ClusterSyncService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSyncServiceChain
implements ClusterSyncService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<ClusterSyncService> chain;

    public ClusterSyncServiceChain(ClusterSyncService ... chain) {
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("chain must be 1 or more");
        }
        this.chain = Arrays.asList(chain);
    }

    @Override
    public void sync(BaseTopologyView view, Runnable callback) {
        Iterator<ClusterSyncService> chainIt = this.chain.iterator();
        this.chainedSync(view, callback, chainIt);
    }

    private void chainedSync(final BaseTopologyView view, final Runnable callback, final Iterator<ClusterSyncService> chainIt) {
        if (!chainIt.hasNext()) {
            this.logger.debug("doSync: done with sync chain, invoking callback");
            callback.run();
            return;
        }
        ClusterSyncService next = chainIt.next();
        next.sync(view, new Runnable(){

            @Override
            public void run() {
                ClusterSyncServiceChain.this.chainedSync(view, callback, chainIt);
            }
        });
    }

    @Override
    public void cancelSync() {
        for (ClusterSyncService consistencyService : this.chain) {
            consistencyService.cancelSync();
        }
    }
}

