/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.script.ScriptEngineFactory;

public abstract class AbstractScriptEngineFactory
implements ScriptEngineFactory {
    private String engineName;
    private String engineVersion;
    private List<String> extensions;
    private List<String> mimeTypes;
    private List<String> names;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractScriptEngineFactory() {
        String name = null;
        String version = null;
        Manifest manifest = null;
        InputStream ins = null;
        try {
            ins = this.getClass().getResourceAsStream("/META-INF/MANIFEST.MF");
            if (ins != null) {
                manifest = new Manifest(ins);
                Attributes attrs = manifest.getMainAttributes();
                name = attrs.getValue("ScriptEngine-Name");
                version = attrs.getValue("ScriptEngine-Version");
            }
        }
        catch (IOException attrs) {
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException attrs) {}
            }
        }
        if (name == null) {
            String className = this.getClass().getName();
            name = className.substring(className.lastIndexOf(46) + 1);
        }
        if (version == null) {
            version = "0";
        }
        this.setEngineName(name);
        this.setEngineVersion(version);
        this.setExtensions(null);
        this.setMimeTypes(null);
        this.setNames(null);
    }

    @Override
    public String getEngineName() {
        return this.engineName;
    }

    protected void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    @Override
    public String getEngineVersion() {
        return this.engineVersion;
    }

    protected void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    @Override
    public List<String> getExtensions() {
        return this.extensions;
    }

    protected void setExtensions(String ... extensions) {
        this.extensions = extensions == null ? Collections.emptyList() : Arrays.asList(extensions);
    }

    @Override
    public List<String> getMimeTypes() {
        return this.mimeTypes;
    }

    protected void setMimeTypes(String ... mimeTypes) {
        this.mimeTypes = mimeTypes == null ? Collections.emptyList() : Arrays.asList(mimeTypes);
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    protected void setNames(String ... names) {
        this.names = names == null ? Collections.emptyList() : Arrays.asList(names);
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        StringBuilder callSyntax = new StringBuilder();
        callSyntax.append(obj).append('.').append(m).append('(');
        for (int i = 0; args != null && i < args.length; ++i) {
            if (i > 0) {
                callSyntax.append(',');
            }
            callSyntax.append(args[i]);
        }
        callSyntax.append(')');
        return callSyntax.toString();
    }

    @Override
    public String getOutputStatement(String value) {
        return "out.print(" + value + ")";
    }

    @Override
    public Object getParameter(String name) {
        if ("javax.script.engine".equals(name)) {
            return this.getEngineName();
        }
        if ("javax.script.engine_version".equals(name)) {
            return this.getEngineVersion();
        }
        if ("javax.script.name".equals(name)) {
            return this.getNames();
        }
        if ("javax.script.language".equals(name)) {
            return this.getLanguageName();
        }
        if ("javax.script.language_version".equals(name)) {
            return this.getLanguageVersion();
        }
        return null;
    }

    @Override
    public String getProgram(String ... arg0) {
        return null;
    }
}

