/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.sites.ui.designfield.datasources;

import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.SearchResult;
import java.util.HashMap;
import javax.jcr.Session;
import javax.servlet.Servlet;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.iterators.TransformIterator;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=wcm/designer/gui/components/designfield/datasources/query", "sling.servlet.methods=GET"})
public class QueryDatasource
extends SlingSafeMethodsServlet {
    @Reference
    ExpressionResolver expressionResolver;
    @Reference
    QueryBuilder queryBuilder;

    @Override
    public void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        String LEGACY_DESIGNS_LOCATION = "/etc/designs";
        String DEFAULT_DESIGNS_LOCATION = "/libs/settings/wcm/designs";
        String USER_DESIGNS_LOCATION = "/apps/settings/wcm/designs";
        Resource currentResource = request.getResource();
        Config cfg = new Config(currentResource.getChild(Config.DATASOURCE));
        ExpressionHelper ex = new ExpressionHelper(this.expressionResolver, request);
        ResourceResolver resourceResolver = request.getResourceResolver();
        final String itemRT = cfg.get("itemResourceType", String.class);
        long offset = ex.get(cfg.get("offset", "0"), Long.TYPE);
        long limit = ex.get(cfg.get("limit", "20"), Long.TYPE);
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>(request.getParameterMap());
        parameterMap.put("type", new String[]{"cq:Page"});
        parameterMap.put("group.1_path", new String[]{"/libs/settings/wcm/designs"});
        parameterMap.put("group.2_path", new String[]{"/apps/settings/wcm/designs"});
        if (resourceResolver.getResource("/etc/designs") != null) {
            parameterMap.put("group.3_path", new String[]{"/etc/designs"});
        }
        parameterMap.put("group.p.or", new String[]{"true"});
        PredicateGroup predicates = PredicateGroup.create(parameterMap);
        Query query = this.queryBuilder.createQuery(predicates, resourceResolver.adaptTo(Session.class));
        query.setStart(offset);
        query.setHitsPerPage(limit);
        SearchResult result = query.getResult();
        SimpleDataSource ds = new SimpleDataSource(new TransformIterator(result.getResources(), new Transformer(){

            @Override
            public Object transform(Object input) {
                Resource r = (Resource)input;
                return new ResourceWrapper(r){

                    @Override
                    public String getResourceType() {
                        return itemRT;
                    }
                };
            }
        }));
        request.setAttribute(DataSource.class.getName(), ds);
    }
}

