/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Gdef;
import com.adobe.fontengine.font.opentype.GsubSubsetter;
import com.adobe.fontengine.font.opentype.LookupTable;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.OTSelector;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.ElementAttribute;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public final class Gsub
extends LookupTable {
    public static final ElementAttribute componentCountAttribute = new ElementAttribute("componentCount");
    public static final ElementAttribute ligatureComponentAttribute = new ElementAttribute("ligatureComponent");

    protected Gsub(FontByteArray buffer) throws IOException, InvalidFontException, UnsupportedFontException {
        super(buffer);
    }

    protected int getScriptListOffset() throws InvalidFontException {
        return this.data.getOffset(0, 4);
    }

    protected int getFeatureListOffset() throws InvalidFontException {
        return this.data.getOffset(0, 6);
    }

    protected int getLookupListOffset() throws InvalidFontException {
        return this.data.getOffset(0, 8);
    }

    protected LookupTable.LookupResult applyLookupSubtable(int lookupType, int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        switch (lookupType) {
            case 1: {
                return this.applySingleSubst(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
            case 2: {
                return this.applyMultipleSubst(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
            case 3: {
                return this.applyAlternateSubst(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
            case 4: {
                return this.applyLigatureSubst(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
            case 5: {
                return this.applyContextualSubtable(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
            case 6: {
                return this.applyChainingContextualSubtable(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
            case 7: {
                return this.applyExtensionSubtable(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
        }
        throw new InvalidFontException("Invalid GSUB lookup type (" + lookupType + ")");
    }

    protected LookupTable.LookupResult applySingleSubst(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int format = this.data.getuint16(stOffset);
        switch (format) {
            case 1: {
                return this.applySingleSubstFormat1(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
            case 2: {
                return this.applySingleSubstFormat2(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
        }
        throw new InvalidFontException("invalid GSUB single subst format (" + format + ")");
    }

    protected LookupTable.LookupResult applySingleSubstFormat1(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int coverageOffset = this.data.getOffset(stOffset, 2);
        if (this.getCoverageIndex(run.elementAt(curGlyph), coverageOffset) == -1) {
            return lookupNotApplied;
        }
        if (!selector.isApplied(run, curGlyph)) {
            return lookupNotApplied;
        }
        int deltaGlyphId = this.data.getint16(stOffset + 4);
        int newGlyphId = run.elementAt(curGlyph) + deltaGlyphId & 0xFFFF;
        run.replace(curGlyph, newGlyphId);
        return new LookupTable.LookupResult(true, curGlyph + 1, 0);
    }

    protected LookupTable.LookupResult applySingleSubstFormat2(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int coverageOffset = this.data.getOffset(stOffset, 2);
        int inPos = curGlyph;
        int ci = this.getCoverageIndex(run.elementAt(inPos), coverageOffset);
        if (ci == -1) {
            return lookupNotApplied;
        }
        if (!selector.isApplied(run, inPos)) {
            return lookupNotApplied;
        }
        int newGlyphId = this.data.getuint16(stOffset + 6 + 2 * ci);
        run.replace(inPos, newGlyphId);
        return new LookupTable.LookupResult(true, inPos + 1, 0);
    }

    protected LookupTable.LookupResult applyMultipleSubst(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int format = this.data.getuint16(stOffset);
        switch (format) {
            case 1: {
                return this.applyMultipleSubstFormat1(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
        }
        throw new InvalidFontException("invalid GSUB multiple subst format (" + format + ")");
    }

    protected LookupTable.LookupResult applyMultipleSubstFormat1(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int coverageOffset = this.data.getOffset(stOffset, 2);
        int inPos = curGlyph;
        int ci = this.getCoverageIndex(run.elementAt(inPos), coverageOffset);
        if (ci == -1) {
            return lookupNotApplied;
        }
        if (!selector.isApplied(run, inPos)) {
            return lookupNotApplied;
        }
        int sequenceOffset = this.data.getOffset(stOffset, 6 + 2 * ci);
        int glyphCount = this.data.getuint16(sequenceOffset);
        int[] newGlyphIds = new int[glyphCount];
        for (int g = 0; g < glyphCount; ++g) {
            newGlyphIds[g] = this.data.getuint16(sequenceOffset + 2 + 2 * g);
        }
        run.replace(inPos, newGlyphIds);
        return new LookupTable.LookupResult(true, inPos + glyphCount, glyphCount - 1);
    }

    protected LookupTable.LookupResult applyAlternateSubst(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int format = this.data.getuint16(stOffset);
        switch (format) {
            case 1: {
                return this.applyAlternateSubstFormat1(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
        }
        throw new InvalidFontException("invalid GSUB alternate subst format (" + format + ")");
    }

    protected LookupTable.LookupResult applyAlternateSubstFormat1(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int alternateVal;
        int coverageOffset = this.data.getOffset(stOffset, 2);
        int inPos = curGlyph;
        int ci = this.getCoverageIndex(run.elementAt(inPos), coverageOffset);
        if (ci == -1) {
            return lookupNotApplied;
        }
        if (!selector.isApplied(run, inPos)) {
            return lookupNotApplied;
        }
        int alternateSetOffset = this.data.getOffset(stOffset, 6 + 2 * ci);
        int alternateCount = this.data.getuint16(alternateSetOffset);
        Integer alternate = (Integer)run.getElementStyle(inPos, ElementAttribute.alternate);
        if (alternate != null && 0 < (alternateVal = alternate.intValue()) && alternateVal <= alternateCount) {
            int newGlyphId = this.data.getuint16(alternateSetOffset + 2 + 2 * (alternateVal - 1));
            run.replace(inPos, newGlyphId);
        }
        return new LookupTable.LookupResult(true, inPos + 1, 0);
    }

    protected LookupTable.LookupResult applyLigatureSubst(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int format = this.data.getuint16(stOffset);
        switch (format) {
            case 1: {
                return this.applyLigatureSubstFormat1(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
        }
        throw new InvalidFontException("invalid GSUB ligature subst format (" + format + ")");
    }

    protected LookupTable.LookupResult applyLigatureSubstFormat1(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int coverageOffset = this.data.getOffset(stOffset, 2);
        int inPos = curGlyph;
        int ci = this.getCoverageIndex(run.elementAt(inPos), coverageOffset);
        if (ci == -1) {
            return lookupNotApplied;
        }
        int ligatureSetOffset = this.data.getOffset(stOffset, 6 + 2 * ci);
        int ligatureCount = this.data.getuint16(ligatureSetOffset);
        for (int l = 0; l < ligatureCount; ++l) {
            int ligatureOffset = this.data.getOffset(ligatureSetOffset, 2 + 2 * l);
            int[] matchedPositions = this.matchOneLigature(lookupFlag, ligatureOffset, run, inPos, limit, selector, gdef);
            if (matchedPositions == noMatch || !selector.isApplied(run, matchedPositions)) continue;
            int componentCount = 0;
            for (int b = 0; b < matchedPositions.length; ++b) {
                int upTo;
                int n = upTo = b < matchedPositions.length - 1 ? matchedPositions[b + 1] : limit;
                for (int m = matchedPositions[b] + 1; m < upTo && gdef != null && gdef.getGlyphClass(run.elementAt(m)) == 3; ++m) {
                    Integer y = (Integer)run.getElementStyle(m, ligatureComponentAttribute);
                    int yy = componentCount + (y == null ? 0 : y);
                    run.setElementStyle(m, ligatureComponentAttribute, new Integer(yy));
                }
                Integer x = (Integer)run.getElementStyle(matchedPositions[b], componentCountAttribute);
                componentCount += x == null ? 1 : x;
            }
            int nextPosition = matchedPositions[matchedPositions.length - 1] + 1;
            int newGlyphId = this.data.getuint16(ligatureOffset);
            run.replace(matchedPositions, newGlyphId);
            run.setElementStyle(matchedPositions[0], componentCountAttribute, new Integer(componentCount));
            nextPosition = nextPosition - matchedPositions.length + 1;
            return new LookupTable.LookupResult(true, nextPosition, -(matchedPositions.length - 1));
        }
        return lookupNotApplied;
    }

    int[] matchOneLigature(int lookupFlag, int ligatureOffset, AttributedRun run, int inPos, int limit, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int compCount = this.data.getuint16(ligatureOffset + 2);
        int[] matchedPositions = new int[compCount];
        matchedPositions[0] = inPos++;
        for (int i = 1; i < compCount; ++i) {
            while (inPos < limit && this.lookupFlagCovers(lookupFlag, gdef, run.elementAt(inPos))) {
                ++inPos;
            }
            if (inPos >= limit || run.elementAt(inPos) != this.data.getuint16(ligatureOffset + 4 + 2 * (i - 1))) {
                return noMatch;
            }
            matchedPositions[i] = inPos++;
        }
        return matchedPositions;
    }

    void subsetAndStream(Subset subset, TreeMap lookups, Map tables, int numGlyphs) throws InvalidFontException, UnsupportedFontException {
        GsubSubsetter subsetter = new GsubSubsetter(this, numGlyphs);
        OTByteArray.OTByteArrayBuilder newData = subsetter.subsetAndStream(lookups, subset);
        tables.put(new Integer(1196643650), newData);
    }

    public void stream(Map tables) {
        OTByteArray.OTByteArrayBuilder newData = this.getDataAsByteArray();
        tables.put(new Integer(1196643650), newData);
    }
}

