/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.ExpressionResolver;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.iterators.FilterIterator;
import org.apache.commons.collections4.iterators.TransformIterator;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.ValueMap;

public class FilteringResourceWrapper
extends ResourceWrapper {
    @Nonnull
    private ExpressionResolver expressionResolver;
    @Nonnull
    private SlingHttpServletRequest request;

    public FilteringResourceWrapper(@Nonnull Resource resource, @Nonnull ExpressionResolver expressionResolver, @Nonnull SlingHttpServletRequest request) {
        super(resource);
        this.expressionResolver = expressionResolver;
        this.request = request;
    }

    @Override
    public Resource getChild(String relPath) {
        Resource child = super.getChild(relPath);
        if (child == null || !this.isVisible(child)) {
            return null;
        }
        return new FilteringResourceWrapper(child, this.expressionResolver, this.request);
    }

    @Override
    public Iterator<Resource> listChildren() {
        return new TransformIterator<Resource, Resource>(new FilterIterator<Resource>(super.listChildren(), new Predicate<Resource>(){

            @Override
            public boolean evaluate(Resource o) {
                return FilteringResourceWrapper.this.isVisible(o);
            }
        }), new Transformer<Resource, Resource>(){

            @Override
            public Resource transform(Resource o) {
                return new FilteringResourceWrapper(o, FilteringResourceWrapper.this.expressionResolver, FilteringResourceWrapper.this.request);
            }
        });
    }

    @Override
    public Iterable<Resource> getChildren() {
        return new Iterable<Resource>(){

            @Override
            public Iterator<Resource> iterator() {
                return FilteringResourceWrapper.this.listChildren();
            }
        };
    }

    @Override
    public boolean hasChildren() {
        if (!super.hasChildren()) {
            return false;
        }
        return this.listChildren().hasNext();
    }

    @Override
    public String getResourceType() {
        if (this.isResourceType("granite/ui/components/coral/foundation/include")) {
            return "granite/ui/components/coral/foundation/includewrapper";
        }
        return super.getResourceType();
    }

    private boolean isVisible(Resource r) {
        ExpressionHelper ex = new ExpressionHelper(this.expressionResolver, this.request);
        ValueMap vm = r.getValueMap();
        return !ex.getBoolean(vm.get("granite:hide", "false"));
    }
}

