/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import com.adobe.granite.ui.components.Config;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public class LayoutBuilder {
    private static final String NAME = "name";
    private JSONObject result;
    private String resourceType;
    @Nonnull
    private ValueMap vm;

    @Nonnull
    public static LayoutBuilder from(@Nonnull Config config) {
        return LayoutBuilder.from(config.getChild(Config.LAYOUT));
    }

    @Nonnull
    public static LayoutBuilder from(@Nonnull Config config, @Nonnull String defaultResourceType) {
        return LayoutBuilder.from(config.getChild(Config.LAYOUT), defaultResourceType);
    }

    @Nonnull
    public static LayoutBuilder from(@CheckForNull Resource resource) {
        return LayoutBuilder.from(resource, null);
    }

    @Nonnull
    public static LayoutBuilder from(@CheckForNull Resource resource, @CheckForNull String defaultResourceType) {
        LayoutBuilder b = new LayoutBuilder(resource);
        if (defaultResourceType == null) {
            b.setResourceType((String)((Object)b.vm.get("sling:resourceType", String.class)));
        } else {
            b.setResourceType(b.vm.get("sling:resourceType", defaultResourceType));
        }
        return b;
    }

    public LayoutBuilder() {
        this(null);
    }

    public LayoutBuilder(@CheckForNull Resource resource) {
        this.vm = resource != null ? resource.getValueMap() : ValueMap.EMPTY;
    }

    private void init() {
        if (this.result != null) {
            return;
        }
        this.result = new JSONObject();
        this.add(this.vm);
    }

    public boolean hasName() {
        this.init();
        return this.result.has(NAME);
    }

    @CheckForNull
    public String getName() {
        this.init();
        return this.result.optString(NAME, null);
    }

    public void setName(@CheckForNull String name) {
        try {
            this.init();
            this.result.put(NAME, name);
        }
        catch (JSONException impossible) {
            throw new RuntimeException(impossible);
        }
    }

    @CheckForNull
    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(@CheckForNull String resourceType) {
        this.resourceType = resourceType;
    }

    public void add(@Nonnull String key, @CheckForNull Object value) {
        try {
            this.init();
            this.result.accumulate(key, value);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public void add(@Nonnull Map<String, Object> data) {
        try {
            this.init();
            for (Map.Entry<String, Object> e : data.entrySet()) {
                String key = e.getKey();
                if (key.indexOf(":") >= 0) continue;
                this.result.accumulate(key, e.getValue());
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public JSONObject toJSON() {
        this.init();
        return this.result;
    }
}

