/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.versioncue.nativecomm.msg;

import com.adobe.versioncue.nativecomm.msg.NCType;
import java.nio.ByteBuffer;

public final class NCData
extends NCType {
    private final ByteBuffer value;

    public NCData(byte[] value) {
        this(ByteBuffer.wrap(value));
    }

    public NCData(byte[] value, int offset, int length) {
        this(ByteBuffer.wrap(value, offset, length));
    }

    public NCData(ByteBuffer value) {
        assert (value != null) : "value != null";
        this.value = value.duplicate();
    }

    public int count() {
        return this.value.remaining();
    }

    public ByteBuffer bytes() {
        return this.value.duplicate();
    }

    public byte[] byteArray() {
        if (this.value.hasArray() && this.value.arrayOffset() == 0) {
            byte[] array = this.value.array();
            if (this.value.position() == 0 && this.value.limit() == array.length) {
                return array;
            }
        }
        ByteBuffer temp = this.value.duplicate();
        byte[] result = new byte[temp.remaining()];
        temp.get(result);
        return result;
    }

    public int getType() {
        return 5;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof NCData) {
            NCData otherData = (NCData)other;
            return this.value.equals(otherData.value);
        }
        return false;
    }

    public String toString() {
        return "NCData <" + this.value + ">";
    }
}

