/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

public class TextCharProp {
    public static final int BREAK_MASK = 63;
    public static final int BREAK_SHIFT = 0;
    public static final int WIDTH_MASK = 448;
    public static final int WIDTH_SHIFT = 6;
    public static final int GRAPHEME_MASK = 7680;
    public static final int GRAPHEME_SHIFT = 9;
    public static final int WORD_MASK = 57344;
    public static final int WORD_SHIFT = 13;
    public static final int CASE_MASK = 196608;
    public static final int CASE_SHIFT = 16;
    public static final int BIDI_MASK = 0x7C0000;
    public static final int BIDI_SHIFT = 18;
    public static final int BM_MASK = 0x800000;
    public static final int BM_SHIFT = 23;
    public static final int BREAK_AI = 0;
    public static final int BREAK_AL = 1;
    public static final int BREAK_B2 = 2;
    public static final int BREAK_BA = 3;
    public static final int BREAK_BB = 4;
    public static final int BREAK_BK = 5;
    public static final int BREAK_CB = 6;
    public static final int BREAK_CL = 7;
    public static final int BREAK_CM = 8;
    public static final int BREAK_CR = 9;
    public static final int BREAK_EX = 10;
    public static final int BREAK_GL = 11;
    public static final int BREAK_H2 = 12;
    public static final int BREAK_H3 = 13;
    public static final int BREAK_HY = 14;
    public static final int BREAK_ID = 15;
    public static final int BREAK_IN = 16;
    public static final int BREAK_IS = 17;
    public static final int BREAK_JL = 18;
    public static final int BREAK_JT = 19;
    public static final int BREAK_JV = 20;
    public static final int BREAK_LF = 21;
    public static final int BREAK_NL = 22;
    public static final int BREAK_NS = 23;
    public static final int BREAK_NU = 24;
    public static final int BREAK_OP = 25;
    public static final int BREAK_PO = 26;
    public static final int BREAK_PR = 27;
    public static final int BREAK_QU = 28;
    public static final int BREAK_SA = 29;
    public static final int BREAK_SG = 30;
    public static final int BREAK_SP = 31;
    public static final int BREAK_SY = 32;
    public static final int BREAK_WJ = 33;
    public static final int BREAK_XX = 34;
    public static final int BREAK_ZW = 35;
    public static final int WIDTH_A = 0;
    public static final int WIDTH_F = 64;
    public static final int WIDTH_H = 128;
    public static final int WIDTH_N = 192;
    public static final int WIDTH_Na = 256;
    public static final int WIDTH_W = 320;
    public static final int GRAPHEME_Control = 0;
    public static final int GRAPHEME_CR = 512;
    public static final int GRAPHEME_Default = 1024;
    public static final int GRAPHEME_Extend = 1536;
    public static final int GRAPHEME_L = 2048;
    public static final int GRAPHEME_LF = 2560;
    public static final int GRAPHEME_LV = 3072;
    public static final int GRAPHEME_LVT = 3584;
    public static final int GRAPHEME_T = 4096;
    public static final int GRAPHEME_V = 4608;
    public static final int WORD_ALetter = 0;
    public static final int WORD_Default = 8192;
    public static final int WORD_ExtendNumLet = 16384;
    public static final int WORD_Format = 24576;
    public static final int WORD_Katakana = 32768;
    public static final int WORD_MidLetter = 40960;
    public static final int WORD_MidNum = 49152;
    public static final int WORD_Numeric = 57344;
    public static final int CASE_Default = 0;
    public static final int CASE_Lowercase = 65536;
    public static final int CASE_Titlecase = 131072;
    public static final int CASE_Uppercase = 196608;
    public static final int BIDI_AL = 0;
    public static final int BIDI_AN = 262144;
    public static final int BIDI_B = 524288;
    public static final int BIDI_BN = 786432;
    public static final int BIDI_CS = 0x100000;
    public static final int BIDI_EN = 0x140000;
    public static final int BIDI_ES = 0x180000;
    public static final int BIDI_ET = 0x1C0000;
    public static final int BIDI_L = 0x200000;
    public static final int BIDI_LRE = 0x240000;
    public static final int BIDI_LRO = 0x280000;
    public static final int BIDI_NSM = 0x2C0000;
    public static final int BIDI_ON = 0x300000;
    public static final int BIDI_PDF = 0x340000;
    public static final int BIDI_R = 0x380000;
    public static final int BIDI_RLE = 0x3C0000;
    public static final int BIDI_RLO = 0x400000;
    public static final int BIDI_S = 0x440000;
    public static final int BIDI_WS = 0x480000;
    public static final int BM_OFF = 0;
    public static final int BM_ON = 0x800000;
    public static final int defaultLetter = TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0);
    public static final int defaultSpace = TextCharProp.makeData(31, 0, 1024, 8192, 0, 0x480000, 0);
    public static final int defaultObject = TextCharProp.makeData(6, 192, 1024, 8192, 0, 0x300000, 0);
    public static final int INVALID = Integer.MAX_VALUE;
    public static final int BREAK_PROHIBIT = 0;
    public static final int BREAK_IF_SPACE = 1;
    public static final int BREAK_COMBINING_MARK = 2;
    public static final int BREAK_ALLOW = 3;
    private static final CharPropData mData = new CharPropData();
    private static int[] gnUAX14Map = new int[]{0, 12, 18, 16, 17, 0, 0, 2, 20, 0, 6, 4, 0, 0, 15, 13, 14, 8, 0, 0, 0, 0, 0, 5, 11, 1, 10, 9, 3, 0, 0, 0, 7, 21, 0, 19};
    static final int BNO = 0;
    static final int BSP = 1;
    static final int BCM = 2;
    static final int BOK = 3;
    static final int[][] geBreakRules = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {3, 0, 1, 1, 0, 0, 0, 0, 3, 1, 3, 3, 3, 3, 1, 1, 3, 3, 0, 2, 0}, {0, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0}, {1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0}, {3, 0, 1, 1, 1, 0, 0, 0, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 0, 2, 0}, {3, 0, 1, 1, 1, 0, 0, 0, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 0, 2, 0}, {3, 0, 1, 1, 1, 0, 0, 0, 3, 3, 1, 3, 3, 3, 1, 1, 3, 3, 0, 2, 0}, {3, 0, 1, 1, 1, 0, 0, 0, 3, 3, 1, 3, 3, 3, 1, 1, 3, 3, 0, 2, 0}, {1, 0, 1, 1, 1, 0, 0, 0, 3, 3, 1, 1, 1, 3, 1, 1, 3, 3, 0, 0, 0}, {3, 0, 1, 1, 1, 0, 0, 0, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 0, 2, 0}, {3, 0, 1, 1, 1, 0, 0, 0, 3, 1, 1, 1, 3, 1, 1, 1, 3, 3, 0, 2, 0}, {3, 0, 1, 1, 1, 0, 0, 0, 3, 3, 1, 1, 3, 1, 1, 1, 3, 3, 0, 2, 0}, {3, 0, 1, 1, 1, 0, 0, 0, 3, 1, 3, 3, 3, 1, 1, 1, 3, 3, 0, 2, 0}, {3, 0, 1, 1, 1, 0, 0, 0, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 0, 2, 0}, {3, 0, 1, 1, 1, 0, 0, 0, 3, 3, 1, 3, 3, 3, 1, 1, 3, 3, 0, 2, 0}, {3, 0, 1, 1, 1, 0, 0, 0, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 0, 2, 0}, {1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0}, {3, 0, 1, 1, 1, 0, 0, 0, 3, 3, 3, 3, 3, 3, 1, 1, 3, 0, 0, 2, 0}, {3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3}, {3, 0, 1, 1, 1, 0, 0, 0, 3, 3, 1, 1, 3, 1, 1, 1, 3, 3, 0, 2, 0}, {1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0}};
    private static final int[] mgpcKSDisallowStart = new int[]{125, 8217, 8221, 12289, 12290, 12293, 12297, 12299, 12301, 12303, 12305, 12309, 12353, 12355, 12357, 12359, 12361, 12387, 12419, 12421, 12423, 12430, 12449, 12451, 12453, 12455, 12457, 12483, 12515, 12517, 12519, 12526, 12533, 12534, 12540, 65281, 65289, 65292, 65294, 65306, 65307, 65311, 65341};
    private static final int[] mgpcKSDisallowEnd = new int[]{123, 167, 8216, 8220, 9839, 12296, 12298, 12300, 12302, 12304, 12306, 12308, 65284, 65288, 65312, 65339, 65504, 65505, 65509};

    public static final int makeData(int eBreak, int eWidth, int eGrapheme, int eWord, int eCase, int eBIDI, int eBM) {
        return eBreak | eWidth | eGrapheme | eWord | eCase | eBIDI | eBM;
    }

    public static int getCharProperty(int c) {
        if (c >= 57344 && c <= 63743) {
            return TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0);
        }
        int nLow = 0;
        int nHigh = TextCharProp.mData.mRanges.length;
        while (nLow < nHigh) {
            int nSplit = nLow + nHigh >>> 1;
            int cTest = TextCharProp.mData.mRanges[nSplit].mcStart;
            if (c < cTest) {
                nHigh = nSplit;
                continue;
            }
            if (c > cTest) {
                nLow = nSplit + 1;
                continue;
            }
            nLow = nHigh = nSplit;
        }
        if (TextCharProp.mData.mRanges[nLow].mcStart > c) {
            if (nLow == 0) {
                return 1;
            }
            --nLow;
        }
        if (nLow >= TextCharProp.mData.mRanges.length || c > TextCharProp.mData.mRanges[nLow].mcEnd) {
            return 1;
        }
        return TextCharProp.mData.mRanges[nLow].meBreak;
    }

    public static int getPairRule(int eBefore, int eAfter) {
        int nRow = gnUAX14Map[TextCharProp.getBreakClass(eBefore)];
        int nCol = gnUAX14Map[TextCharProp.getBreakClass(eAfter)];
        if (nRow == 0 || nCol == 0) {
            return 1;
        }
        return geBreakRules[nRow - 1][nCol - 1];
    }

    public static boolean kinsokuAllowStart(int c) {
        return TextCharProp.ksLookup(c, mgpcKSDisallowStart);
    }

    public static boolean kinsokuAllowEnd(int c) {
        return TextCharProp.ksLookup(c, mgpcKSDisallowEnd);
    }

    public static int getBreakClass(int nData) {
        return nData & 0x3F;
    }

    public static int setBreakClass(int nData, int eBreak) {
        return nData & 0xFFFFFFC0 | eBreak;
    }

    public static int breakToIndex(int nData) {
        return TextCharProp.getBreakClass(nData) >> 0;
    }

    public static int getWidthClass(int nData) {
        return nData & 0x1C0;
    }

    public static int setWidthClass(int nData, int eWidth) {
        return nData & 0xFFFFFE3F | eWidth;
    }

    public static int widthToIndex(int nData) {
        return TextCharProp.getWidthClass(nData) >> 6;
    }

    public static int getGraphemeClass(int nData) {
        return nData & 0x1E00;
    }

    public static int setGraphemeClass(int nData, int eGrapheme) {
        return nData & 0xFFFFE1FF | eGrapheme;
    }

    public static int graphemeToIndex(int nData) {
        return TextCharProp.getGraphemeClass(nData) >> 9;
    }

    public static int getWordClass(int nData) {
        return nData & 0xE000;
    }

    public static int setWordClass(int nData, int eWord) {
        return nData & 0xFFFF1FFF | eWord;
    }

    public static int wordToIndex(int nData) {
        return TextCharProp.getWordClass(nData) >> 13;
    }

    public static int getCaseClass(int nData) {
        return nData & 0x30000;
    }

    public static int setCaseClass(int nData, int eCase) {
        return nData & 0xFFFCFFFF | eCase;
    }

    public static int caseToIndex(int nData) {
        return TextCharProp.getCaseClass(nData) >> 16;
    }

    public static int getBIDIClass(int nData) {
        return nData & 0x7C0000;
    }

    public static int setBIDIClass(int nData, int eBIDI) {
        return nData & 0xFF83FFFF | eBIDI;
    }

    public static int BIDIToIndex(int nData) {
        return TextCharProp.getBIDIClass(nData) >> 18;
    }

    public static int getBIDIMirrorClass(int nData) {
        return nData & 0x800000;
    }

    public static int setBIDIMirrorClass(int nData, int eBIDIMirror) {
        return nData & 0xFF7FFFFF | eBIDIMirror;
    }

    public static int BIDIMirrorToIndex(int nData) {
        return TextCharProp.getBIDIMirrorClass(nData) >> 23;
    }

    public static boolean isBIDIMirrored(int nData) {
        return TextCharProp.getBIDIMirrorClass(nData) == 0x800000;
    }

    public static boolean isWordEdge(int eData) {
        switch (TextCharProp.getWordClass(eData)) {
            case 0: 
            case 16384: 
            case 24576: 
            case 32768: 
            case 57344: {
                return true;
            }
        }
        return false;
    }

    public static int resolveBreakWidth(int eBefore, int eAfter, int eDefault) {
        int nNarrow = 0;
        int nWide = 0;
        switch (eBefore) {
            case 128: 
            case 256: {
                ++nNarrow;
                break;
            }
            case 64: 
            case 320: {
                ++nWide;
            }
        }
        switch (eAfter) {
            case 128: 
            case 256: {
                ++nNarrow;
                break;
            }
            case 64: 
            case 320: {
                ++nWide;
            }
        }
        if (nNarrow > nWide) {
            return 1;
        }
        if (nWide > nNarrow) {
            return 15;
        }
        return eDefault;
    }

    public static int resolveBreakWidth(int eBefore, int eAfter) {
        return TextCharProp.resolveBreakWidth(eBefore, eAfter, 0);
    }

    public static boolean isAmbiguousWidth(int eWidth) {
        return eWidth == 0 || eWidth == 192;
    }

    public static int getBIDIMirrorChar(int c) {
        int nLow = 0;
        int nHigh = TextCharProp.mData.mBIDIMirrors.length;
        while (nLow < nHigh) {
            int nSplit = nLow + nHigh >>> 1;
            BIDIMirrorData data = TextCharProp.mData.mBIDIMirrors[nSplit];
            int cTest = data.mChar;
            if (c < cTest) {
                nHigh = nSplit;
                continue;
            }
            if (c > cTest) {
                nLow = nSplit + 1;
                continue;
            }
            return data.mMirror;
        }
        return c;
    }

    private static boolean ksLookup(int c, int[] pcTable) {
        int nLow = 0;
        int nHigh = pcTable.length;
        while (nLow < nHigh) {
            int nSplit = nLow + nHigh >>> 1;
            int cTest = pcTable[nSplit];
            if (c < cTest) {
                nHigh = nSplit;
                continue;
            }
            if (c > cTest) {
                nLow = nSplit + 1;
                continue;
            }
            return false;
        }
        return true;
    }

    private static class BIDIMirrorData {
        final int mChar;
        final int mMirror;

        BIDIMirrorData(int c, int mirror) {
            this.mChar = c;
            this.mMirror = mirror;
        }
    }

    private static class CharPropData {
        final CharPropRange[] mRanges;
        final BIDIMirrorData[] mBIDIMirrors = new BIDIMirrorData[]{new BIDIMirrorData(40, 41), new BIDIMirrorData(41, 40), new BIDIMirrorData(60, 62), new BIDIMirrorData(62, 60), new BIDIMirrorData(91, 93), new BIDIMirrorData(93, 91), new BIDIMirrorData(123, 125), new BIDIMirrorData(125, 123), new BIDIMirrorData(171, 187), new BIDIMirrorData(187, 171), new BIDIMirrorData(3898, 3899), new BIDIMirrorData(3899, 3898), new BIDIMirrorData(3900, 3901), new BIDIMirrorData(3901, 3900), new BIDIMirrorData(5787, 5788), new BIDIMirrorData(5788, 5787), new BIDIMirrorData(8216, 8217), new BIDIMirrorData(8217, 8216), new BIDIMirrorData(8220, 8221), new BIDIMirrorData(8221, 8220), new BIDIMirrorData(8249, 8250), new BIDIMirrorData(8250, 8249), new BIDIMirrorData(8261, 8262), new BIDIMirrorData(8262, 8261), new BIDIMirrorData(8317, 8318), new BIDIMirrorData(8318, 8317), new BIDIMirrorData(8333, 8334), new BIDIMirrorData(8334, 8333), new BIDIMirrorData(8712, 8715), new BIDIMirrorData(8713, 8716), new BIDIMirrorData(8714, 8717), new BIDIMirrorData(8715, 8712), new BIDIMirrorData(8716, 8713), new BIDIMirrorData(8717, 8714), new BIDIMirrorData(8725, 10741), new BIDIMirrorData(8764, 8765), new BIDIMirrorData(8765, 8764), new BIDIMirrorData(8771, 8909), new BIDIMirrorData(8786, 8787), new BIDIMirrorData(8787, 8786), new BIDIMirrorData(8788, 8789), new BIDIMirrorData(8789, 8788), new BIDIMirrorData(8804, 8805), new BIDIMirrorData(8805, 8804), new BIDIMirrorData(8806, 8807), new BIDIMirrorData(8807, 8806), new BIDIMirrorData(8808, 8809), new BIDIMirrorData(8809, 8808), new BIDIMirrorData(8810, 8811), new BIDIMirrorData(8811, 8810), new BIDIMirrorData(8814, 8815), new BIDIMirrorData(8815, 8814), new BIDIMirrorData(8816, 8817), new BIDIMirrorData(8817, 8816), new BIDIMirrorData(8818, 8819), new BIDIMirrorData(8819, 8818), new BIDIMirrorData(8820, 8821), new BIDIMirrorData(8821, 8820), new BIDIMirrorData(8822, 8823), new BIDIMirrorData(8823, 8822), new BIDIMirrorData(8824, 8825), new BIDIMirrorData(8825, 8824), new BIDIMirrorData(8826, 8827), new BIDIMirrorData(8827, 8826), new BIDIMirrorData(8828, 8829), new BIDIMirrorData(8829, 8828), new BIDIMirrorData(8830, 8831), new BIDIMirrorData(8831, 8830), new BIDIMirrorData(8832, 8833), new BIDIMirrorData(8833, 8832), new BIDIMirrorData(8834, 8835), new BIDIMirrorData(8835, 8834), new BIDIMirrorData(8836, 8837), new BIDIMirrorData(8837, 8836), new BIDIMirrorData(8838, 8839), new BIDIMirrorData(8839, 8838), new BIDIMirrorData(8840, 8841), new BIDIMirrorData(8841, 8840), new BIDIMirrorData(8842, 8843), new BIDIMirrorData(8843, 8842), new BIDIMirrorData(8847, 8848), new BIDIMirrorData(8848, 8847), new BIDIMirrorData(8849, 8850), new BIDIMirrorData(8850, 8849), new BIDIMirrorData(8856, 10680), new BIDIMirrorData(8866, 8867), new BIDIMirrorData(8867, 8866), new BIDIMirrorData(8870, 10974), new BIDIMirrorData(8872, 10980), new BIDIMirrorData(8873, 10979), new BIDIMirrorData(8875, 10981), new BIDIMirrorData(8880, 8881), new BIDIMirrorData(8881, 8880), new BIDIMirrorData(8882, 8883), new BIDIMirrorData(8883, 8882), new BIDIMirrorData(8884, 8885), new BIDIMirrorData(8885, 8884), new BIDIMirrorData(8886, 8887), new BIDIMirrorData(8887, 8886), new BIDIMirrorData(8905, 8906), new BIDIMirrorData(8906, 8905), new BIDIMirrorData(8907, 8908), new BIDIMirrorData(8908, 8907), new BIDIMirrorData(8909, 8771), new BIDIMirrorData(8912, 8913), new BIDIMirrorData(8913, 8912), new BIDIMirrorData(8918, 8919), new BIDIMirrorData(8919, 8918), new BIDIMirrorData(8920, 8921), new BIDIMirrorData(8921, 8920), new BIDIMirrorData(8922, 8923), new BIDIMirrorData(8923, 8922), new BIDIMirrorData(8924, 8925), new BIDIMirrorData(8925, 8924), new BIDIMirrorData(8926, 8927), new BIDIMirrorData(8927, 8926), new BIDIMirrorData(8928, 8929), new BIDIMirrorData(8929, 8928), new BIDIMirrorData(8930, 8931), new BIDIMirrorData(8931, 8930), new BIDIMirrorData(8932, 8933), new BIDIMirrorData(8933, 8932), new BIDIMirrorData(8934, 8935), new BIDIMirrorData(8935, 8934), new BIDIMirrorData(8936, 8937), new BIDIMirrorData(8937, 8936), new BIDIMirrorData(8938, 8939), new BIDIMirrorData(8939, 8938), new BIDIMirrorData(8940, 8941), new BIDIMirrorData(8941, 8940), new BIDIMirrorData(8944, 8945), new BIDIMirrorData(8945, 8944), new BIDIMirrorData(8946, 8954), new BIDIMirrorData(8947, 8955), new BIDIMirrorData(8948, 8956), new BIDIMirrorData(8950, 8957), new BIDIMirrorData(8951, 8958), new BIDIMirrorData(8954, 8946), new BIDIMirrorData(8955, 8947), new BIDIMirrorData(8956, 8948), new BIDIMirrorData(8957, 8950), new BIDIMirrorData(8958, 8951), new BIDIMirrorData(8968, 8969), new BIDIMirrorData(8969, 8968), new BIDIMirrorData(8970, 8971), new BIDIMirrorData(8971, 8970), new BIDIMirrorData(9001, 9002), new BIDIMirrorData(9002, 9001), new BIDIMirrorData(10088, 10089), new BIDIMirrorData(10089, 10088), new BIDIMirrorData(10090, 10091), new BIDIMirrorData(10091, 10090), new BIDIMirrorData(10092, 10093), new BIDIMirrorData(10093, 10092), new BIDIMirrorData(10094, 10095), new BIDIMirrorData(10095, 10094), new BIDIMirrorData(10096, 10097), new BIDIMirrorData(10097, 10096), new BIDIMirrorData(10098, 10099), new BIDIMirrorData(10099, 10098), new BIDIMirrorData(10100, 10101), new BIDIMirrorData(10101, 10100), new BIDIMirrorData(10179, 10180), new BIDIMirrorData(10180, 10179), new BIDIMirrorData(10181, 10182), new BIDIMirrorData(10182, 10181), new BIDIMirrorData(10197, 10198), new BIDIMirrorData(10198, 10197), new BIDIMirrorData(10205, 10206), new BIDIMirrorData(10206, 10205), new BIDIMirrorData(10210, 10211), new BIDIMirrorData(10211, 10210), new BIDIMirrorData(10212, 10213), new BIDIMirrorData(10213, 10212), new BIDIMirrorData(10214, 10215), new BIDIMirrorData(10215, 10214), new BIDIMirrorData(10216, 10217), new BIDIMirrorData(10217, 10216), new BIDIMirrorData(10218, 10219), new BIDIMirrorData(10219, 10218), new BIDIMirrorData(10627, 10628), new BIDIMirrorData(10628, 10627), new BIDIMirrorData(10629, 10630), new BIDIMirrorData(10630, 10629), new BIDIMirrorData(10631, 10632), new BIDIMirrorData(10632, 10631), new BIDIMirrorData(10633, 10634), new BIDIMirrorData(10634, 10633), new BIDIMirrorData(10635, 10636), new BIDIMirrorData(10636, 10635), new BIDIMirrorData(10637, 10640), new BIDIMirrorData(10638, 10639), new BIDIMirrorData(10639, 10638), new BIDIMirrorData(10640, 10637), new BIDIMirrorData(10641, 10642), new BIDIMirrorData(10642, 10641), new BIDIMirrorData(10643, 10644), new BIDIMirrorData(10644, 10643), new BIDIMirrorData(10645, 10646), new BIDIMirrorData(10646, 10645), new BIDIMirrorData(10647, 10648), new BIDIMirrorData(10648, 10647), new BIDIMirrorData(10680, 8856), new BIDIMirrorData(10688, 10689), new BIDIMirrorData(10689, 10688), new BIDIMirrorData(10692, 10693), new BIDIMirrorData(10693, 10692), new BIDIMirrorData(10703, 10704), new BIDIMirrorData(10704, 10703), new BIDIMirrorData(10705, 10706), new BIDIMirrorData(10706, 10705), new BIDIMirrorData(10708, 10709), new BIDIMirrorData(10709, 10708), new BIDIMirrorData(10712, 10713), new BIDIMirrorData(10713, 10712), new BIDIMirrorData(10714, 10715), new BIDIMirrorData(10715, 10714), new BIDIMirrorData(10741, 8725), new BIDIMirrorData(10744, 10745), new BIDIMirrorData(10745, 10744), new BIDIMirrorData(10748, 10749), new BIDIMirrorData(10749, 10748), new BIDIMirrorData(10795, 10796), new BIDIMirrorData(10796, 10795), new BIDIMirrorData(10797, 10798), new BIDIMirrorData(10798, 10797), new BIDIMirrorData(10804, 10805), new BIDIMirrorData(10805, 10804), new BIDIMirrorData(10812, 10813), new BIDIMirrorData(10813, 10812), new BIDIMirrorData(10852, 10853), new BIDIMirrorData(10853, 10852), new BIDIMirrorData(10873, 10874), new BIDIMirrorData(10874, 10873), new BIDIMirrorData(10877, 10878), new BIDIMirrorData(10878, 10877), new BIDIMirrorData(10879, 10880), new BIDIMirrorData(10880, 10879), new BIDIMirrorData(10881, 10882), new BIDIMirrorData(10882, 10881), new BIDIMirrorData(10883, 10884), new BIDIMirrorData(10884, 10883), new BIDIMirrorData(10891, 10892), new BIDIMirrorData(10892, 10891), new BIDIMirrorData(10897, 10898), new BIDIMirrorData(10898, 10897), new BIDIMirrorData(10899, 10900), new BIDIMirrorData(10900, 10899), new BIDIMirrorData(10901, 10902), new BIDIMirrorData(10902, 10901), new BIDIMirrorData(10903, 10904), new BIDIMirrorData(10904, 10903), new BIDIMirrorData(10905, 10906), new BIDIMirrorData(10906, 10905), new BIDIMirrorData(10907, 10908), new BIDIMirrorData(10908, 10907), new BIDIMirrorData(10913, 10914), new BIDIMirrorData(10914, 10913), new BIDIMirrorData(10918, 10919), new BIDIMirrorData(10919, 10918), new BIDIMirrorData(10920, 10921), new BIDIMirrorData(10921, 10920), new BIDIMirrorData(10922, 10923), new BIDIMirrorData(10923, 10922), new BIDIMirrorData(10924, 10925), new BIDIMirrorData(10925, 10924), new BIDIMirrorData(10927, 10928), new BIDIMirrorData(10928, 10927), new BIDIMirrorData(10931, 10932), new BIDIMirrorData(10932, 10931), new BIDIMirrorData(10939, 10940), new BIDIMirrorData(10940, 10939), new BIDIMirrorData(10941, 10942), new BIDIMirrorData(10942, 10941), new BIDIMirrorData(10943, 10944), new BIDIMirrorData(10944, 10943), new BIDIMirrorData(10945, 10946), new BIDIMirrorData(10946, 10945), new BIDIMirrorData(10947, 10948), new BIDIMirrorData(10948, 10947), new BIDIMirrorData(10949, 10950), new BIDIMirrorData(10950, 10949), new BIDIMirrorData(10957, 10958), new BIDIMirrorData(10958, 10957), new BIDIMirrorData(10959, 10960), new BIDIMirrorData(10960, 10959), new BIDIMirrorData(10961, 10962), new BIDIMirrorData(10962, 10961), new BIDIMirrorData(10963, 10964), new BIDIMirrorData(10964, 10963), new BIDIMirrorData(10965, 10966), new BIDIMirrorData(10966, 10965), new BIDIMirrorData(10974, 8870), new BIDIMirrorData(10979, 8873), new BIDIMirrorData(10980, 8872), new BIDIMirrorData(10981, 8875), new BIDIMirrorData(10988, 10989), new BIDIMirrorData(10989, 10988), new BIDIMirrorData(10999, 11000), new BIDIMirrorData(11000, 10999), new BIDIMirrorData(11001, 11002), new BIDIMirrorData(11002, 11001), new BIDIMirrorData(11778, 11779), new BIDIMirrorData(11779, 11778), new BIDIMirrorData(11780, 11781), new BIDIMirrorData(11781, 11780), new BIDIMirrorData(11785, 11786), new BIDIMirrorData(11786, 11785), new BIDIMirrorData(11788, 11789), new BIDIMirrorData(11789, 11788), new BIDIMirrorData(11804, 11805), new BIDIMirrorData(11805, 11804), new BIDIMirrorData(12296, 12297), new BIDIMirrorData(12297, 12296), new BIDIMirrorData(12298, 12299), new BIDIMirrorData(12299, 12298), new BIDIMirrorData(12300, 12301), new BIDIMirrorData(12301, 12300), new BIDIMirrorData(12302, 12303), new BIDIMirrorData(12303, 12302), new BIDIMirrorData(12304, 12305), new BIDIMirrorData(12305, 12304), new BIDIMirrorData(12308, 12309), new BIDIMirrorData(12309, 12308), new BIDIMirrorData(12310, 12311), new BIDIMirrorData(12311, 12310), new BIDIMirrorData(12312, 12313), new BIDIMirrorData(12313, 12312), new BIDIMirrorData(12314, 12315), new BIDIMirrorData(12315, 12314), new BIDIMirrorData(12317, 12318), new BIDIMirrorData(12318, 12317), new BIDIMirrorData(65113, 65114), new BIDIMirrorData(65114, 65113), new BIDIMirrorData(65115, 65116), new BIDIMirrorData(65116, 65115), new BIDIMirrorData(65117, 65118), new BIDIMirrorData(65118, 65117), new BIDIMirrorData(65124, 65125), new BIDIMirrorData(65125, 65124), new BIDIMirrorData(65288, 65289), new BIDIMirrorData(65289, 65288), new BIDIMirrorData(65308, 65310), new BIDIMirrorData(65310, 65308), new BIDIMirrorData(65339, 65341), new BIDIMirrorData(65341, 65339), new BIDIMirrorData(65371, 65373), new BIDIMirrorData(65373, 65371), new BIDIMirrorData(65375, 65376), new BIDIMirrorData(65376, 65375), new BIDIMirrorData(65378, 65379), new BIDIMirrorData(65379, 65378)};

        CharPropData() {
            this.mRanges = new CharPropRange[3336];
            int i = 0;
            i = this.initialize1(i);
            i = this.initialize2(i);
            i = this.initialize3(i);
            i = this.initialize4(i);
            i = this.initialize5(i);
            i = this.initialize6(i);
            i = this.initialize7(i);
        }

        private int initialize1(int i) {
            this.mRanges[i++] = new CharPropRange(0, 8, TextCharProp.makeData(8, 192, 0, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(9, 9, TextCharProp.makeData(3, 192, 0, 8192, 0, 0x440000, 0));
            this.mRanges[i++] = new CharPropRange(10, 10, TextCharProp.makeData(21, 192, 2560, 8192, 0, 524288, 0));
            this.mRanges[i++] = new CharPropRange(11, 11, TextCharProp.makeData(8, 192, 0, 8192, 0, 0x440000, 0));
            this.mRanges[i++] = new CharPropRange(12, 12, TextCharProp.makeData(5, 192, 0, 8192, 0, 0x480000, 0));
            this.mRanges[i++] = new CharPropRange(13, 13, TextCharProp.makeData(9, 192, 512, 8192, 0, 524288, 0));
            this.mRanges[i++] = new CharPropRange(14, 27, TextCharProp.makeData(8, 192, 0, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(28, 30, TextCharProp.makeData(8, 192, 0, 8192, 0, 524288, 0));
            this.mRanges[i++] = new CharPropRange(31, 31, TextCharProp.makeData(8, 192, 0, 8192, 0, 0x440000, 0));
            this.mRanges[i++] = new CharPropRange(32, 32, TextCharProp.makeData(31, 256, 1024, 8192, 0, 0x480000, 0));
            this.mRanges[i++] = new CharPropRange(33, 33, TextCharProp.makeData(10, 256, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(34, 34, TextCharProp.makeData(28, 256, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(35, 35, TextCharProp.makeData(1, 256, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(36, 36, TextCharProp.makeData(27, 256, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(37, 37, TextCharProp.makeData(26, 256, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(38, 38, TextCharProp.makeData(1, 256, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(39, 39, TextCharProp.makeData(28, 256, 1024, 40960, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(40, 40, TextCharProp.makeData(25, 256, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(41, 41, TextCharProp.makeData(7, 256, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(42, 42, TextCharProp.makeData(1, 256, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(43, 43, TextCharProp.makeData(27, 256, 1024, 8192, 0, 0x180000, 0));
            this.mRanges[i++] = new CharPropRange(44, 44, TextCharProp.makeData(17, 256, 1024, 49152, 0, 0x100000, 0));
            this.mRanges[i++] = new CharPropRange(45, 45, TextCharProp.makeData(14, 256, 1024, 8192, 0, 0x180000, 0));
            this.mRanges[i++] = new CharPropRange(46, 46, TextCharProp.makeData(17, 256, 1024, 49152, 0, 0x100000, 0));
            this.mRanges[i++] = new CharPropRange(47, 47, TextCharProp.makeData(32, 256, 1024, 8192, 0, 0x100000, 0));
            this.mRanges[i++] = new CharPropRange(48, 57, TextCharProp.makeData(24, 256, 1024, 57344, 0, 0x140000, 0));
            this.mRanges[i++] = new CharPropRange(58, 58, TextCharProp.makeData(17, 256, 1024, 40960, 0, 0x100000, 0));
            this.mRanges[i++] = new CharPropRange(59, 59, TextCharProp.makeData(17, 256, 1024, 49152, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(60, 60, TextCharProp.makeData(1, 256, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(61, 61, TextCharProp.makeData(1, 256, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(62, 62, TextCharProp.makeData(1, 256, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(63, 63, TextCharProp.makeData(10, 256, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(64, 64, TextCharProp.makeData(1, 256, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65, 90, TextCharProp.makeData(1, 256, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(91, 91, TextCharProp.makeData(25, 256, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(92, 92, TextCharProp.makeData(27, 256, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(93, 93, TextCharProp.makeData(7, 256, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(94, 94, TextCharProp.makeData(1, 256, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(95, 95, TextCharProp.makeData(1, 256, 1024, 16384, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(96, 96, TextCharProp.makeData(1, 256, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(97, 122, TextCharProp.makeData(1, 256, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(123, 123, TextCharProp.makeData(25, 256, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(124, 124, TextCharProp.makeData(3, 256, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(125, 125, TextCharProp.makeData(7, 256, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(126, 126, TextCharProp.makeData(1, 256, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(127, 132, TextCharProp.makeData(8, 192, 0, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(133, 133, TextCharProp.makeData(22, 192, 0, 8192, 0, 524288, 0));
            this.mRanges[i++] = new CharPropRange(134, 159, TextCharProp.makeData(8, 192, 0, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(160, 160, TextCharProp.makeData(11, 192, 1024, 0, 0, 0x100000, 0));
            this.mRanges[i++] = new CharPropRange(161, 161, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(162, 162, TextCharProp.makeData(26, 256, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(163, 163, TextCharProp.makeData(27, 256, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(164, 164, TextCharProp.makeData(27, 0, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(165, 165, TextCharProp.makeData(27, 256, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(166, 166, TextCharProp.makeData(1, 256, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(167, 168, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(169, 169, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(170, 170, TextCharProp.makeData(0, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(171, 171, TextCharProp.makeData(28, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(172, 172, TextCharProp.makeData(1, 256, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(173, 173, TextCharProp.makeData(3, 0, 0, 24576, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(174, 174, TextCharProp.makeData(1, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(175, 175, TextCharProp.makeData(1, 256, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(176, 176, TextCharProp.makeData(26, 0, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(177, 177, TextCharProp.makeData(27, 0, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(178, 179, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x140000, 0));
            this.mRanges[i++] = new CharPropRange(180, 180, TextCharProp.makeData(4, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(181, 181, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(182, 182, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(183, 183, TextCharProp.makeData(0, 0, 1024, 40960, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(184, 184, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(185, 185, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x140000, 0));
            this.mRanges[i++] = new CharPropRange(186, 186, TextCharProp.makeData(0, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(187, 187, TextCharProp.makeData(28, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(188, 191, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(192, 197, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(198, 198, TextCharProp.makeData(1, 0, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(199, 207, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(208, 208, TextCharProp.makeData(1, 0, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(209, 214, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(215, 215, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(216, 216, TextCharProp.makeData(1, 0, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(217, 221, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(222, 222, TextCharProp.makeData(1, 0, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(223, 225, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(226, 229, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(230, 230, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(231, 231, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(232, 234, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(235, 235, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(236, 237, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(238, 239, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(240, 240, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(241, 241, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(242, 243, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(244, 246, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(247, 247, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(248, 250, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(251, 251, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(252, 252, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(253, 253, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(254, 254, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(255, 255, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(256, 256, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(257, 257, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(258, 258, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(259, 259, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(260, 260, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(261, 261, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(262, 262, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(263, 263, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(264, 264, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(265, 265, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(266, 266, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(267, 267, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(268, 268, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(269, 269, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(270, 270, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(271, 271, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(272, 272, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(273, 273, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(274, 274, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(275, 275, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(276, 276, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(277, 277, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(278, 278, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(279, 279, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(280, 280, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(281, 281, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(282, 282, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(283, 283, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(284, 284, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(285, 285, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(286, 286, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(287, 287, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(288, 288, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(289, 289, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(290, 290, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(291, 291, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(292, 292, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(293, 293, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(294, 294, TextCharProp.makeData(1, 0, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(295, 295, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(296, 296, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(297, 297, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(298, 298, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(299, 299, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(300, 300, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(301, 301, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(302, 302, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(303, 303, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(304, 304, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(305, 305, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(306, 306, TextCharProp.makeData(1, 0, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(307, 307, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(308, 308, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(309, 309, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(310, 310, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(311, 311, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(312, 312, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(313, 313, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(314, 314, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(315, 315, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(316, 316, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(317, 317, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(318, 318, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(319, 319, TextCharProp.makeData(1, 0, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(320, 320, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(321, 321, TextCharProp.makeData(1, 0, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(322, 322, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(323, 323, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(324, 324, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(325, 325, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(326, 326, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(327, 327, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(328, 329, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(330, 330, TextCharProp.makeData(1, 0, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(331, 331, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(332, 332, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(333, 333, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(334, 334, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(335, 335, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(336, 336, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(337, 337, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(338, 338, TextCharProp.makeData(1, 0, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(339, 339, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(340, 340, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(341, 341, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(342, 342, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(343, 343, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(344, 344, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(345, 345, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(346, 346, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(347, 347, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(348, 348, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(349, 349, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(350, 350, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(351, 351, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(352, 352, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(353, 353, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(354, 354, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(355, 355, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(356, 356, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(357, 357, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(358, 358, TextCharProp.makeData(1, 0, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(359, 359, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(360, 360, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(361, 361, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(362, 362, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(363, 363, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(364, 364, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(365, 365, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(366, 366, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(367, 367, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(368, 368, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(369, 369, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(370, 370, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(371, 371, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(372, 372, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(373, 373, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(374, 374, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(375, 375, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(376, 377, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(378, 378, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(379, 379, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(380, 380, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(381, 381, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(382, 384, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(385, 386, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(387, 387, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(388, 388, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(389, 389, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(390, 391, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(392, 392, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(393, 395, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(396, 397, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(398, 401, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(402, 402, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(403, 404, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(405, 405, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(406, 408, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(409, 411, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(412, 413, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(414, 414, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(415, 416, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(417, 417, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(418, 418, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(419, 419, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(420, 420, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(421, 421, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(422, 423, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(424, 424, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(425, 425, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(426, 427, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(428, 428, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(429, 429, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(430, 431, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(432, 432, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(433, 435, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(436, 436, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(437, 437, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(438, 438, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(439, 440, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(441, 442, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(443, 443, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(444, 444, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(445, 447, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(448, 451, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(452, 452, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(453, 453, TextCharProp.makeData(1, 192, 1024, 0, 131072, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(454, 454, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(455, 455, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(456, 456, TextCharProp.makeData(1, 192, 1024, 0, 131072, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(457, 457, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(458, 458, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(459, 459, TextCharProp.makeData(1, 192, 1024, 0, 131072, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(460, 460, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(461, 461, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(462, 462, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(463, 463, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(464, 464, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(465, 465, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(466, 466, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(467, 467, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(468, 468, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(469, 469, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(470, 470, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(471, 471, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(472, 472, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(473, 473, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(474, 474, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(475, 475, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(476, 476, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(477, 477, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(478, 478, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(479, 479, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(480, 480, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(481, 481, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(482, 482, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(483, 483, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(484, 484, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(485, 485, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(486, 486, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(487, 487, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(488, 488, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(489, 489, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(490, 490, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(491, 491, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(492, 492, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(493, 493, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(494, 494, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(495, 496, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(497, 497, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(498, 498, TextCharProp.makeData(1, 192, 1024, 0, 131072, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(499, 499, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(500, 500, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(501, 501, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(502, 504, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(505, 505, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(506, 506, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(507, 507, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(508, 508, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(509, 509, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(510, 510, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(511, 511, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(512, 512, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(513, 513, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(514, 514, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(515, 515, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(516, 516, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(517, 517, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(518, 518, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(519, 519, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(520, 520, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(521, 521, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(522, 522, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(523, 523, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(524, 524, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(525, 525, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(526, 526, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(527, 527, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(528, 528, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(529, 529, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(530, 530, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(531, 531, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(532, 532, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(533, 533, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(534, 534, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(535, 535, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(536, 536, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(537, 537, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(538, 538, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(539, 539, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(540, 540, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(541, 541, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(542, 542, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(543, 543, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(544, 544, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(545, 545, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(546, 546, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(547, 547, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(548, 548, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(549, 549, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(550, 550, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(551, 551, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(552, 552, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(553, 553, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(554, 554, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(555, 555, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(556, 556, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(557, 557, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(558, 558, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(559, 559, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(560, 560, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(561, 561, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(562, 562, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(563, 569, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(570, 571, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(572, 572, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(573, 574, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(575, 576, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(577, 577, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(578, 578, TextCharProp.makeData(1, 192, 1024, 8192, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(579, 582, TextCharProp.makeData(1, 192, 1024, 8192, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(583, 583, TextCharProp.makeData(1, 192, 1024, 8192, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(584, 584, TextCharProp.makeData(1, 192, 1024, 8192, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(585, 585, TextCharProp.makeData(1, 192, 1024, 8192, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(586, 586, TextCharProp.makeData(1, 192, 1024, 8192, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(587, 587, TextCharProp.makeData(1, 192, 1024, 8192, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(588, 588, TextCharProp.makeData(1, 192, 1024, 8192, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(589, 589, TextCharProp.makeData(1, 192, 1024, 8192, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(590, 590, TextCharProp.makeData(1, 192, 1024, 8192, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(591, 591, TextCharProp.makeData(1, 192, 1024, 8192, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(592, 592, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(593, 593, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(594, 608, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(609, 609, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(610, 659, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(660, 660, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(661, 696, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(697, 698, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(699, 703, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(704, 705, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(706, 707, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(708, 708, TextCharProp.makeData(1, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(709, 709, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(710, 710, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(711, 711, TextCharProp.makeData(0, 0, 1024, 0, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(712, 712, TextCharProp.makeData(4, 192, 1024, 0, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(713, 715, TextCharProp.makeData(0, 0, 1024, 0, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(716, 716, TextCharProp.makeData(4, 192, 1024, 0, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(717, 717, TextCharProp.makeData(0, 0, 1024, 0, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(718, 719, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(720, 720, TextCharProp.makeData(0, 0, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(721, 721, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(722, 727, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(728, 731, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(732, 732, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(733, 733, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(734, 734, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(735, 735, TextCharProp.makeData(1, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(736, 740, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(741, 749, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(750, 750, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(751, 767, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(768, 836, TextCharProp.makeData(8, 0, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(837, 837, TextCharProp.makeData(8, 0, 1536, 8192, 65536, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(838, 846, TextCharProp.makeData(8, 0, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(847, 847, TextCharProp.makeData(11, 0, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(848, 860, TextCharProp.makeData(8, 0, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(861, 866, TextCharProp.makeData(11, 0, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(867, 879, TextCharProp.makeData(8, 0, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(884, 885, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(890, 890, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(891, 893, TextCharProp.makeData(1, 192, 1024, 8192, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(894, 894, TextCharProp.makeData(17, 192, 1024, 49152, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(900, 901, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(902, 902, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(903, 903, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(904, 906, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(908, 908, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(910, 911, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(912, 912, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(913, 929, TextCharProp.makeData(1, 0, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(931, 937, TextCharProp.makeData(1, 0, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(938, 939, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(940, 944, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(945, 961, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(962, 962, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(963, 969, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(970, 974, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(976, 977, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(978, 980, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(981, 983, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(984, 984, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(985, 985, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(986, 986, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(987, 987, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(988, 988, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(989, 989, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(990, 990, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(991, 991, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(992, 992, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(993, 993, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(994, 994, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(995, 995, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(996, 996, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(997, 997, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(998, 998, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(999, 999, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1000, 1000, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1001, 1001, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1002, 1002, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1003, 1003, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1004, 1004, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1005, 1005, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1006, 1006, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1007, 1011, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1012, 1012, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1013, 1013, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1014, 1014, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(1015, 1015, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1016, 1016, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1017, 1018, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1019, 1020, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1021, 1024, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1025, 1025, TextCharProp.makeData(1, 0, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1026, 1039, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1040, 1071, TextCharProp.makeData(1, 0, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1072, 1103, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1104, 1104, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1105, 1105, TextCharProp.makeData(1, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1106, 1119, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1120, 1120, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1121, 1121, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1122, 1122, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1123, 1123, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1124, 1124, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1125, 1125, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1126, 1126, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1127, 1127, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            return i;
        }

        private int initialize2(int i) {
            this.mRanges[i++] = new CharPropRange(1128, 1128, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1129, 1129, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1130, 1130, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1131, 1131, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1132, 1132, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1133, 1133, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1134, 1134, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1135, 1135, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1136, 1136, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1137, 1137, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1138, 1138, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1139, 1139, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1140, 1140, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1141, 1141, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1142, 1142, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1143, 1143, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1144, 1144, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1145, 1145, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1146, 1146, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1147, 1147, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1148, 1148, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1149, 1149, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1150, 1150, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1151, 1151, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1152, 1152, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1153, 1153, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1154, 1154, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1155, 1158, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(1160, 1161, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(1162, 1162, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1163, 1163, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1164, 1164, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1165, 1165, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1166, 1166, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1167, 1167, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1168, 1168, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1169, 1169, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1170, 1170, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1171, 1171, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1172, 1172, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1173, 1173, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1174, 1174, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1175, 1175, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1176, 1176, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1177, 1177, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1178, 1178, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1179, 1179, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1180, 1180, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1181, 1181, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1182, 1182, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1183, 1183, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1184, 1184, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1185, 1185, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1186, 1186, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1187, 1187, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1188, 1188, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1189, 1189, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1190, 1190, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1191, 1191, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1192, 1192, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1193, 1193, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1194, 1194, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1195, 1195, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1196, 1196, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1197, 1197, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1198, 1198, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1199, 1199, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1200, 1200, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1201, 1201, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1202, 1202, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1203, 1203, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1204, 1204, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1205, 1205, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1206, 1206, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1207, 1207, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1208, 1208, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1209, 1209, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1210, 1210, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1211, 1211, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1212, 1212, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1213, 1213, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1214, 1214, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1215, 1215, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1216, 1217, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1218, 1218, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1219, 1219, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1220, 1220, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1221, 1221, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1222, 1222, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1223, 1223, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1224, 1224, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1225, 1225, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1226, 1226, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1227, 1227, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1228, 1228, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1229, 1229, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1230, 1230, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1231, 1231, TextCharProp.makeData(1, 192, 1024, 8192, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1232, 1232, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1233, 1233, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1234, 1234, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1235, 1235, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1236, 1236, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1237, 1237, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1238, 1238, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1239, 1239, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1240, 1240, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1241, 1241, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1242, 1242, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1243, 1243, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1244, 1244, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1245, 1245, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1246, 1246, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1247, 1247, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1248, 1248, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1249, 1249, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1250, 1250, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1251, 1251, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1252, 1252, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1253, 1253, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1254, 1254, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1255, 1255, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1256, 1256, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1257, 1257, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1258, 1258, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1259, 1259, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1260, 1260, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1261, 1261, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1262, 1262, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1263, 1263, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1264, 1264, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1265, 1265, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1266, 1266, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1267, 1267, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1268, 1268, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1269, 1269, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1270, 1270, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1271, 1271, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1272, 1272, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1273, 1273, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1274, 1274, TextCharProp.makeData(1, 192, 1024, 8192, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1275, 1275, TextCharProp.makeData(1, 192, 1024, 8192, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1276, 1276, TextCharProp.makeData(1, 192, 1024, 8192, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1277, 1277, TextCharProp.makeData(1, 192, 1024, 8192, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1278, 1278, TextCharProp.makeData(1, 192, 1024, 8192, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1279, 1279, TextCharProp.makeData(1, 192, 1024, 8192, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1280, 1280, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1281, 1281, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1282, 1282, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1283, 1283, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1284, 1284, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1285, 1285, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1286, 1286, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1287, 1287, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1288, 1288, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1289, 1289, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1290, 1290, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1291, 1291, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1292, 1292, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1293, 1293, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1294, 1294, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1295, 1295, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1296, 1296, TextCharProp.makeData(1, 192, 1024, 8192, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1297, 1297, TextCharProp.makeData(1, 192, 1024, 8192, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1298, 1298, TextCharProp.makeData(1, 192, 1024, 8192, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1299, 1299, TextCharProp.makeData(1, 192, 1024, 8192, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1329, 1366, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1369, 1369, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1370, 1375, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1377, 1415, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1417, 1417, TextCharProp.makeData(17, 192, 1024, 49152, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1418, 1418, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(1424, 1424, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(1425, 1465, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(1466, 1466, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(1467, 1469, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(1470, 1470, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(1471, 1471, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(1472, 1472, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(1473, 1474, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(1475, 1475, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(1476, 1477, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(1478, 1478, TextCharProp.makeData(10, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(1479, 1479, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(1480, 1487, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(1488, 1514, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(1515, 1519, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(1520, 1523, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(1524, 1524, TextCharProp.makeData(1, 192, 1024, 40960, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(1525, 1535, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(1536, 1539, TextCharProp.makeData(1, 192, 0, 24576, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1540, 1546, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1547, 1547, TextCharProp.makeData(26, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1548, 1548, TextCharProp.makeData(10, 192, 1024, 8192, 0, 0x100000, 0));
            this.mRanges[i++] = new CharPropRange(1549, 1549, TextCharProp.makeData(17, 192, 1024, 49152, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1550, 1551, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(1552, 1557, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(1558, 1562, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1563, 1563, TextCharProp.makeData(10, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1564, 1565, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1566, 1567, TextCharProp.makeData(10, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1568, 1568, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1569, 1594, TextCharProp.makeData(1, 192, 1024, 0, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1595, 1599, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1600, 1610, TextCharProp.makeData(1, 192, 1024, 0, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1611, 1630, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(1631, 1631, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1632, 1641, TextCharProp.makeData(24, 192, 1024, 57344, 0, 262144, 0));
            this.mRanges[i++] = new CharPropRange(1642, 1642, TextCharProp.makeData(10, 192, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(1643, 1644, TextCharProp.makeData(24, 192, 1024, 57344, 0, 262144, 0));
            this.mRanges[i++] = new CharPropRange(1645, 1645, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1646, 1647, TextCharProp.makeData(1, 192, 1024, 0, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1648, 1648, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(1649, 1747, TextCharProp.makeData(1, 192, 1024, 0, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1748, 1748, TextCharProp.makeData(10, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1749, 1749, TextCharProp.makeData(1, 192, 1024, 0, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1750, 1756, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(1757, 1757, TextCharProp.makeData(1, 192, 0, 24576, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1758, 1764, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(1765, 1766, TextCharProp.makeData(1, 192, 1024, 0, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1767, 1768, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(1769, 1769, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(1770, 1773, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(1774, 1775, TextCharProp.makeData(1, 192, 1024, 0, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1776, 1785, TextCharProp.makeData(24, 192, 1024, 57344, 0, 0x140000, 0));
            this.mRanges[i++] = new CharPropRange(1786, 1788, TextCharProp.makeData(1, 192, 1024, 0, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1789, 1790, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1791, 1791, TextCharProp.makeData(1, 192, 1024, 0, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1792, 1806, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1807, 1807, TextCharProp.makeData(1, 192, 0, 24576, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(1808, 1808, TextCharProp.makeData(1, 192, 1024, 0, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1809, 1809, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(1810, 1839, TextCharProp.makeData(1, 192, 1024, 0, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1840, 1866, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(1867, 1868, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1869, 1901, TextCharProp.makeData(1, 192, 1024, 0, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1902, 1919, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1920, 1957, TextCharProp.makeData(1, 192, 1024, 0, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1958, 1968, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(1969, 1969, TextCharProp.makeData(1, 192, 1024, 0, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1970, 1983, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(1984, 2026, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(2027, 2035, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2036, 2037, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(2038, 2041, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(2042, 2303, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(2305, 2306, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2307, 2307, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2308, 2361, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2364, 2364, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2365, 2365, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2366, 2368, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2369, 2376, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2377, 2380, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2381, 2381, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2384, 2384, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2385, 2388, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2392, 2401, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2402, 2403, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2404, 2405, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2406, 2415, TextCharProp.makeData(24, 192, 1024, 57344, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2416, 2416, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2427, 2428, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2429, 2429, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2430, 2431, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2433, 2433, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2434, 2435, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2437, 2444, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2447, 2448, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2451, 2472, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2474, 2480, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2482, 2482, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2486, 2489, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2492, 2492, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2493, 2493, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2494, 2494, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2495, 2496, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2497, 2500, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2503, 2504, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2507, 2508, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2509, 2509, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2510, 2510, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2519, 2519, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2524, 2525, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2527, 2529, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2530, 2531, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2534, 2543, TextCharProp.makeData(24, 192, 1024, 57344, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2544, 2545, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2546, 2547, TextCharProp.makeData(27, 192, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(2548, 2554, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2561, 2562, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2563, 2563, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2565, 2570, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2575, 2576, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2579, 2600, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2602, 2608, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2610, 2611, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2613, 2614, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2616, 2617, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2620, 2620, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2622, 2624, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2625, 2626, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2631, 2632, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2635, 2637, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2649, 2652, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2654, 2654, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2662, 2671, TextCharProp.makeData(24, 192, 1024, 57344, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2672, 2673, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2674, 2676, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2689, 2690, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2691, 2691, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2693, 2701, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2703, 2705, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2707, 2728, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2730, 2736, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2738, 2739, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2741, 2745, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2748, 2748, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2749, 2749, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2750, 2752, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2753, 2757, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2759, 2760, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2761, 2761, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2763, 2764, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2765, 2765, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2768, 2768, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2784, 2785, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2786, 2787, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2790, 2799, TextCharProp.makeData(24, 192, 1024, 57344, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2801, 2801, TextCharProp.makeData(27, 192, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(2817, 2817, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2818, 2819, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2821, 2828, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2831, 2832, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2835, 2856, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2858, 2864, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2866, 2867, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2869, 2873, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2876, 2876, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2877, 2877, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2878, 2878, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2879, 2879, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2880, 2880, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2881, 2883, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2887, 2888, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2891, 2892, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2893, 2893, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2902, 2902, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2903, 2903, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2908, 2909, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2911, 2913, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2918, 2927, TextCharProp.makeData(24, 192, 1024, 57344, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2928, 2928, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2929, 2929, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2946, 2946, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(2947, 2947, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2949, 2954, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2958, 2960, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2962, 2965, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2969, 2970, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2972, 2972, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2974, 2975, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2979, 2980, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2984, 2986, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(2990, 3001, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3006, 3006, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3007, 3007, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3008, 3008, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3009, 3010, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3014, 3016, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3018, 3020, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3021, 3021, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3031, 3031, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3046, 3055, TextCharProp.makeData(24, 192, 1024, 57344, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3056, 3058, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3059, 3064, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(3065, 3065, TextCharProp.makeData(27, 192, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(3066, 3066, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(3073, 3075, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3077, 3084, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3086, 3088, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3090, 3112, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3114, 3123, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3125, 3129, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3134, 3136, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3137, 3140, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3142, 3144, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3146, 3149, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3157, 3158, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3168, 3169, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3174, 3183, TextCharProp.makeData(24, 192, 1024, 57344, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3202, 3203, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3205, 3212, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3214, 3216, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3218, 3240, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3242, 3251, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3253, 3257, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3260, 3260, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3261, 3261, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3262, 3262, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3263, 3263, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3264, 3265, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3266, 3266, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3267, 3268, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3270, 3270, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3271, 3272, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3274, 3275, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3276, 3277, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3285, 3286, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3294, 3294, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3296, 3297, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3298, 3299, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3302, 3311, TextCharProp.makeData(24, 192, 1024, 57344, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3313, 3314, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(3330, 3331, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3333, 3340, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3342, 3344, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3346, 3368, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3370, 3385, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3390, 3390, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3391, 3392, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3393, 3395, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3398, 3400, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3402, 3404, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3405, 3405, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3415, 3415, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3424, 3425, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3430, 3439, TextCharProp.makeData(24, 192, 1024, 57344, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3458, 3459, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3461, 3478, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3482, 3505, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3507, 3515, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3517, 3517, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3520, 3526, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3530, 3530, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3535, 3535, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3536, 3537, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3538, 3540, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3542, 3542, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3544, 3550, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3551, 3551, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3570, 3571, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3572, 3572, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3585, 3632, TextCharProp.makeData(29, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3633, 3633, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3634, 3635, TextCharProp.makeData(29, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3636, 3642, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3647, 3647, TextCharProp.makeData(27, 192, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(3648, 3654, TextCharProp.makeData(29, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3655, 3662, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3663, 3663, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3664, 3673, TextCharProp.makeData(24, 192, 1024, 57344, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3674, 3675, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3713, 3714, TextCharProp.makeData(29, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3716, 3716, TextCharProp.makeData(29, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3719, 3720, TextCharProp.makeData(29, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3722, 3722, TextCharProp.makeData(29, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3725, 3725, TextCharProp.makeData(29, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3732, 3735, TextCharProp.makeData(29, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3737, 3743, TextCharProp.makeData(29, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3745, 3747, TextCharProp.makeData(29, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3749, 3749, TextCharProp.makeData(29, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3751, 3751, TextCharProp.makeData(29, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3754, 3755, TextCharProp.makeData(29, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3757, 3760, TextCharProp.makeData(29, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3761, 3761, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3762, 3763, TextCharProp.makeData(29, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3764, 3769, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3771, 3772, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3773, 3773, TextCharProp.makeData(29, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3776, 3780, TextCharProp.makeData(29, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3782, 3782, TextCharProp.makeData(29, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3784, 3789, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3792, 3801, TextCharProp.makeData(24, 192, 1024, 57344, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3804, 3805, TextCharProp.makeData(29, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3840, 3840, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3841, 3844, TextCharProp.makeData(4, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3845, 3845, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3846, 3847, TextCharProp.makeData(4, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3848, 3848, TextCharProp.makeData(11, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3849, 3850, TextCharProp.makeData(4, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3851, 3851, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3852, 3852, TextCharProp.makeData(11, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3853, 3857, TextCharProp.makeData(10, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3858, 3858, TextCharProp.makeData(11, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3859, 3859, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3860, 3860, TextCharProp.makeData(10, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3861, 3863, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3864, 3865, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3866, 3871, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3872, 3881, TextCharProp.makeData(24, 192, 1024, 57344, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3882, 3891, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3892, 3892, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3893, 3893, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3894, 3894, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3895, 3895, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3896, 3896, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3897, 3897, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3898, 3898, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(3899, 3899, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(3900, 3900, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            return i;
        }

        private int initialize3(int i) {
            this.mRanges[i++] = new CharPropRange(3901, 3901, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(3902, 3903, TextCharProp.makeData(8, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3904, 3911, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3913, 3946, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3953, 3966, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3967, 3967, TextCharProp.makeData(3, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3968, 3972, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3973, 3973, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3974, 3975, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3976, 3979, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(3984, 3991, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(3993, 4028, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(4030, 4031, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4032, 4037, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4038, 4038, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(4039, 4044, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4047, 4047, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4048, 4049, TextCharProp.makeData(4, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4096, 4129, TextCharProp.makeData(29, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4131, 4135, TextCharProp.makeData(29, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4137, 4138, TextCharProp.makeData(29, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4140, 4140, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4141, 4144, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(4145, 4145, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4146, 4146, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(4150, 4151, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(4152, 4152, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4153, 4153, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(4160, 4169, TextCharProp.makeData(24, 192, 1024, 57344, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4170, 4171, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4172, 4175, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4176, 4181, TextCharProp.makeData(29, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4182, 4183, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4184, 4185, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(4256, 4293, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4304, 4346, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4347, 4347, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4348, 4348, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4352, 4441, TextCharProp.makeData(18, 320, 2048, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4447, 4447, TextCharProp.makeData(18, 320, 2048, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4448, 4514, TextCharProp.makeData(20, 192, 4608, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4520, 4601, TextCharProp.makeData(19, 192, 4096, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4608, 4680, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4682, 4685, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4688, 4694, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4696, 4696, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4698, 4701, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4704, 4744, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4746, 4749, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4752, 4784, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4786, 4789, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4792, 4798, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4800, 4800, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4802, 4805, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4808, 4822, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4824, 4880, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4882, 4885, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4888, 4954, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4959, 4959, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(4960, 4960, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4961, 4961, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4962, 4988, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(4992, 5007, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(5008, 5017, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(5024, 5108, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(5121, 5740, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(5741, 5742, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(5743, 5750, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(5760, 5760, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x480000, 0));
            this.mRanges[i++] = new CharPropRange(5761, 5786, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(5787, 5787, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(5788, 5788, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(5792, 5866, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(5867, 5869, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(5870, 5872, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(5888, 5900, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(5902, 5905, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(5906, 5908, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(5920, 5937, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(5938, 5940, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(5941, 5942, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(5952, 5969, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(5970, 5971, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(5984, 5996, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(5998, 6000, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6002, 6003, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(6016, 6067, TextCharProp.makeData(29, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6068, 6069, TextCharProp.makeData(29, 192, 0, 24576, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6070, 6070, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6071, 6077, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(6078, 6085, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6086, 6086, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(6087, 6088, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6089, 6099, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(6100, 6101, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6102, 6102, TextCharProp.makeData(23, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6103, 6103, TextCharProp.makeData(23, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6104, 6104, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6105, 6105, TextCharProp.makeData(23, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6106, 6106, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6107, 6107, TextCharProp.makeData(27, 192, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(6108, 6108, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6109, 6109, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(6112, 6121, TextCharProp.makeData(24, 192, 1024, 57344, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6128, 6137, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(6144, 6145, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(6146, 6149, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(6150, 6150, TextCharProp.makeData(4, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(6151, 6151, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(6152, 6153, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(6154, 6154, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(6155, 6157, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(6158, 6158, TextCharProp.makeData(11, 192, 1024, 8192, 0, 0x480000, 0));
            this.mRanges[i++] = new CharPropRange(6160, 6169, TextCharProp.makeData(24, 192, 1024, 57344, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6176, 6263, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6272, 6312, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6313, 6313, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(6400, 6428, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6432, 6434, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(6435, 6438, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6439, 6440, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(6441, 6443, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(6448, 6449, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6450, 6450, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(6451, 6456, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6457, 6459, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(6464, 6464, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(6468, 6469, TextCharProp.makeData(10, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(6470, 6479, TextCharProp.makeData(24, 192, 1024, 57344, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6480, 6509, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6512, 6516, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6528, 6569, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6576, 6592, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6593, 6599, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6600, 6601, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6608, 6617, TextCharProp.makeData(24, 192, 1024, 57344, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6622, 6655, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(6656, 6678, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6679, 6680, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(6681, 6683, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6686, 6686, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6687, 6687, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6912, 6915, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(6916, 6963, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6964, 6964, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(6965, 6965, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6966, 6970, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(6971, 6971, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6972, 6972, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(6973, 6977, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6978, 6978, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(6979, 6987, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(6992, 7018, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7019, 7027, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(7028, 7036, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7424, 7615, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7616, 7619, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(7620, 7626, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(7678, 7679, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(7680, 7680, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7681, 7681, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7682, 7682, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7683, 7683, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7684, 7684, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7685, 7685, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7686, 7686, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7687, 7687, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7688, 7688, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7689, 7689, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7690, 7690, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7691, 7691, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7692, 7692, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7693, 7693, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7694, 7694, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7695, 7695, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7696, 7696, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7697, 7697, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7698, 7698, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7699, 7699, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7700, 7700, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7701, 7701, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7702, 7702, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7703, 7703, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7704, 7704, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7705, 7705, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7706, 7706, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7707, 7707, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7708, 7708, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7709, 7709, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7710, 7710, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7711, 7711, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7712, 7712, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7713, 7713, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7714, 7714, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7715, 7715, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7716, 7716, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7717, 7717, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7718, 7718, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7719, 7719, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7720, 7720, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7721, 7721, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7722, 7722, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7723, 7723, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7724, 7724, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7725, 7725, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7726, 7726, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7727, 7727, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7728, 7728, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7729, 7729, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7730, 7730, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7731, 7731, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7732, 7732, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7733, 7733, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7734, 7734, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7735, 7735, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7736, 7736, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7737, 7737, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7738, 7738, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7739, 7739, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7740, 7740, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7741, 7741, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7742, 7742, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7743, 7743, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7744, 7744, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7745, 7745, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7746, 7746, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7747, 7747, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7748, 7748, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7749, 7749, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7750, 7750, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7751, 7751, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7752, 7752, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7753, 7753, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7754, 7754, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7755, 7755, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7756, 7756, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7757, 7757, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7758, 7758, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7759, 7759, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7760, 7760, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7761, 7761, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7762, 7762, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7763, 7763, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7764, 7764, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7765, 7765, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7766, 7766, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7767, 7767, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7768, 7768, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7769, 7769, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7770, 7770, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7771, 7771, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7772, 7772, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7773, 7773, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7774, 7774, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7775, 7775, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7776, 7776, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7777, 7777, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7778, 7778, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7779, 7779, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7780, 7780, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7781, 7781, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7782, 7782, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7783, 7783, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7784, 7784, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7785, 7785, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7786, 7786, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7787, 7787, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7788, 7788, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7789, 7789, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7790, 7790, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7791, 7791, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7792, 7792, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7793, 7793, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7794, 7794, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7795, 7795, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7796, 7796, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7797, 7797, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7798, 7798, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7799, 7799, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7800, 7800, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7801, 7801, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7802, 7802, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7803, 7803, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7804, 7804, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7805, 7805, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7806, 7806, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7807, 7807, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7808, 7808, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7809, 7809, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7810, 7810, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7811, 7811, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7812, 7812, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7813, 7813, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7814, 7814, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7815, 7815, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7816, 7816, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7817, 7817, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7818, 7818, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7819, 7819, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7820, 7820, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7821, 7821, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7822, 7822, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7823, 7823, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7824, 7824, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7825, 7825, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7826, 7826, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7827, 7827, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7828, 7828, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7829, 7835, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7840, 7840, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7841, 7841, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7842, 7842, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7843, 7843, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7844, 7844, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7845, 7845, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7846, 7846, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7847, 7847, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7848, 7848, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7849, 7849, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7850, 7850, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7851, 7851, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7852, 7852, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7853, 7853, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7854, 7854, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7855, 7855, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7856, 7856, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7857, 7857, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7858, 7858, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7859, 7859, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7860, 7860, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7861, 7861, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7862, 7862, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7863, 7863, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7864, 7864, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7865, 7865, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7866, 7866, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7867, 7867, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7868, 7868, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7869, 7869, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7870, 7870, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7871, 7871, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7872, 7872, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7873, 7873, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7874, 7874, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7875, 7875, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7876, 7876, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7877, 7877, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7878, 7878, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7879, 7879, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7880, 7880, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7881, 7881, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7882, 7882, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7883, 7883, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7884, 7884, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7885, 7885, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7886, 7886, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7887, 7887, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7888, 7888, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7889, 7889, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7890, 7890, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7891, 7891, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7892, 7892, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7893, 7893, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7894, 7894, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7895, 7895, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7896, 7896, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7897, 7897, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7898, 7898, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7899, 7899, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7900, 7900, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7901, 7901, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7902, 7902, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7903, 7903, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7904, 7904, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7905, 7905, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7906, 7906, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7907, 7907, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7908, 7908, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7909, 7909, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7910, 7910, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7911, 7911, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7912, 7912, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7913, 7913, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7914, 7914, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7915, 7915, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7916, 7916, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7917, 7917, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7918, 7918, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7919, 7919, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7920, 7920, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7921, 7921, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7922, 7922, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7923, 7923, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7924, 7924, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7925, 7925, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7926, 7926, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7927, 7927, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7928, 7928, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7929, 7929, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7936, 7943, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7944, 7951, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7952, 7957, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7960, 7965, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7968, 7975, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7976, 7983, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7984, 7991, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(7992, 7999, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8000, 8005, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8008, 8013, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8016, 8023, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8025, 8025, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8027, 8027, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8029, 8029, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8031, 8031, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8032, 8039, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8040, 8047, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8048, 8061, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8064, 8071, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8072, 8079, TextCharProp.makeData(1, 192, 1024, 0, 131072, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8080, 8087, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8088, 8095, TextCharProp.makeData(1, 192, 1024, 0, 131072, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8096, 8103, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8104, 8111, TextCharProp.makeData(1, 192, 1024, 0, 131072, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8112, 8116, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8118, 8119, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8120, 8123, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8124, 8124, TextCharProp.makeData(1, 192, 1024, 0, 131072, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8125, 8125, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8126, 8126, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8127, 8129, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8130, 8132, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8134, 8135, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8136, 8139, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8140, 8140, TextCharProp.makeData(1, 192, 1024, 0, 131072, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8141, 8143, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8144, 8147, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8150, 8151, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8152, 8155, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8157, 8159, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8160, 8167, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8168, 8172, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8173, 8175, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8178, 8180, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8182, 8183, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8184, 8187, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8188, 8188, TextCharProp.makeData(1, 192, 1024, 0, 131072, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8189, 8190, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8192, 8198, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x480000, 0));
            this.mRanges[i++] = new CharPropRange(8199, 8199, TextCharProp.makeData(11, 192, 1024, 8192, 0, 0x480000, 0));
            this.mRanges[i++] = new CharPropRange(8200, 8202, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x480000, 0));
            this.mRanges[i++] = new CharPropRange(8203, 8203, TextCharProp.makeData(35, 192, 0, 24576, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(8204, 8205, TextCharProp.makeData(8, 192, 1536, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(8206, 8206, TextCharProp.makeData(8, 192, 0, 24576, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8207, 8207, TextCharProp.makeData(8, 192, 0, 24576, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(8208, 8208, TextCharProp.makeData(3, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8209, 8209, TextCharProp.makeData(11, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8210, 8210, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8211, 8211, TextCharProp.makeData(3, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8212, 8212, TextCharProp.makeData(2, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8213, 8214, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8215, 8215, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8216, 8216, TextCharProp.makeData(28, 0, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8217, 8217, TextCharProp.makeData(28, 0, 1024, 40960, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8218, 8218, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8219, 8219, TextCharProp.makeData(28, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8220, 8221, TextCharProp.makeData(28, 0, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8222, 8222, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8223, 8223, TextCharProp.makeData(28, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8224, 8225, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8226, 8226, TextCharProp.makeData(1, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8227, 8227, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8228, 8230, TextCharProp.makeData(16, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8231, 8231, TextCharProp.makeData(3, 0, 1024, 40960, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8232, 8232, TextCharProp.makeData(5, 192, 0, 8192, 0, 0x480000, 0));
            this.mRanges[i++] = new CharPropRange(8233, 8233, TextCharProp.makeData(5, 192, 0, 8192, 0, 524288, 0));
            this.mRanges[i++] = new CharPropRange(8234, 8234, TextCharProp.makeData(8, 192, 0, 24576, 0, 0x240000, 0));
            this.mRanges[i++] = new CharPropRange(8235, 8235, TextCharProp.makeData(8, 192, 0, 24576, 0, 0x3C0000, 0));
            this.mRanges[i++] = new CharPropRange(8236, 8236, TextCharProp.makeData(8, 192, 0, 24576, 0, 0x340000, 0));
            this.mRanges[i++] = new CharPropRange(8237, 8237, TextCharProp.makeData(8, 192, 0, 24576, 0, 0x280000, 0));
            this.mRanges[i++] = new CharPropRange(8238, 8238, TextCharProp.makeData(8, 192, 0, 24576, 0, 0x400000, 0));
            this.mRanges[i++] = new CharPropRange(8239, 8239, TextCharProp.makeData(11, 192, 1024, 8192, 0, 0x100000, 0));
            this.mRanges[i++] = new CharPropRange(8240, 8240, TextCharProp.makeData(26, 0, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(8241, 8241, TextCharProp.makeData(26, 192, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(8242, 8243, TextCharProp.makeData(26, 0, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(8244, 8244, TextCharProp.makeData(26, 192, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(8245, 8245, TextCharProp.makeData(26, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8246, 8247, TextCharProp.makeData(26, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8248, 8248, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8249, 8250, TextCharProp.makeData(28, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8251, 8251, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8252, 8252, TextCharProp.makeData(23, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8253, 8253, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8254, 8254, TextCharProp.makeData(1, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8255, 8256, TextCharProp.makeData(1, 192, 1024, 16384, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8257, 8259, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8260, 8260, TextCharProp.makeData(17, 192, 1024, 49152, 0, 0x100000, 0));
            this.mRanges[i++] = new CharPropRange(8261, 8261, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8262, 8262, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8263, 8275, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8276, 8276, TextCharProp.makeData(1, 192, 1024, 16384, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8277, 8277, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            return i;
        }

        private int initialize4(int i) {
            this.mRanges[i++] = new CharPropRange(8278, 8278, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8279, 8279, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8280, 8283, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8284, 8284, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8285, 8286, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8287, 8287, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x480000, 0));
            this.mRanges[i++] = new CharPropRange(8288, 8288, TextCharProp.makeData(33, 192, 0, 24576, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(8289, 8291, TextCharProp.makeData(1, 192, 0, 24576, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(8292, 8297, TextCharProp.makeData(1, 192, 1024, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(8298, 8303, TextCharProp.makeData(8, 192, 0, 24576, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(8304, 8304, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x140000, 0));
            this.mRanges[i++] = new CharPropRange(8305, 8305, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8308, 8308, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x140000, 0));
            this.mRanges[i++] = new CharPropRange(8309, 8313, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x140000, 0));
            this.mRanges[i++] = new CharPropRange(8314, 8315, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x180000, 0));
            this.mRanges[i++] = new CharPropRange(8316, 8316, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8317, 8317, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8318, 8318, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8319, 8319, TextCharProp.makeData(0, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8320, 8320, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x140000, 0));
            this.mRanges[i++] = new CharPropRange(8321, 8324, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x140000, 0));
            this.mRanges[i++] = new CharPropRange(8325, 8329, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x140000, 0));
            this.mRanges[i++] = new CharPropRange(8330, 8331, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x180000, 0));
            this.mRanges[i++] = new CharPropRange(8332, 8332, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8333, 8333, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8334, 8334, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8336, 8340, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8352, 8358, TextCharProp.makeData(27, 192, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(8359, 8359, TextCharProp.makeData(26, 192, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(8360, 8360, TextCharProp.makeData(27, 192, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(8361, 8361, TextCharProp.makeData(27, 128, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(8362, 8363, TextCharProp.makeData(27, 192, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(8364, 8364, TextCharProp.makeData(27, 0, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(8365, 8373, TextCharProp.makeData(27, 192, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(8400, 8427, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(8428, 8431, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(8448, 8449, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8450, 8450, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8451, 8451, TextCharProp.makeData(26, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8452, 8452, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8453, 8453, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8454, 8454, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8455, 8455, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8456, 8456, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8457, 8457, TextCharProp.makeData(26, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8458, 8458, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8459, 8461, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8462, 8463, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8464, 8466, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8467, 8467, TextCharProp.makeData(0, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8468, 8468, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8469, 8469, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8470, 8470, TextCharProp.makeData(27, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8471, 8472, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8473, 8477, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8478, 8480, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8481, 8482, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8483, 8483, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8484, 8484, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8485, 8485, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8486, 8486, TextCharProp.makeData(1, 0, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8487, 8487, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8488, 8488, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8489, 8489, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8490, 8490, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8491, 8491, TextCharProp.makeData(0, 0, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8492, 8493, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8494, 8494, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(8495, 8495, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8496, 8497, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8498, 8498, TextCharProp.makeData(1, 192, 1024, 8192, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8499, 8499, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8500, 8500, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8501, 8504, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8505, 8505, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8506, 8507, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8508, 8509, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8510, 8511, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8512, 8516, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8517, 8517, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8518, 8521, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8522, 8525, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8526, 8526, TextCharProp.makeData(1, 192, 1024, 8192, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8531, 8531, TextCharProp.makeData(1, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8532, 8532, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8533, 8533, TextCharProp.makeData(0, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8534, 8538, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8539, 8539, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8540, 8541, TextCharProp.makeData(1, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8542, 8542, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8543, 8543, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8544, 8555, TextCharProp.makeData(0, 0, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8556, 8559, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8560, 8569, TextCharProp.makeData(0, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8570, 8575, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8576, 8578, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8579, 8579, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8580, 8580, TextCharProp.makeData(1, 192, 1024, 8192, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(8592, 8601, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8602, 8631, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8632, 8633, TextCharProp.makeData(1, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8634, 8657, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8658, 8658, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8659, 8659, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8660, 8660, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8661, 8678, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8679, 8679, TextCharProp.makeData(1, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8680, 8703, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8704, 8704, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8705, 8705, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8706, 8707, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8708, 8710, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8711, 8711, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8712, 8712, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8713, 8714, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8715, 8715, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8716, 8717, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8718, 8718, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8719, 8719, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8720, 8720, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8721, 8721, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8722, 8722, TextCharProp.makeData(27, 192, 1024, 8192, 0, 0x180000, 0));
            this.mRanges[i++] = new CharPropRange(8723, 8723, TextCharProp.makeData(27, 192, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(8724, 8724, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8725, 8725, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8726, 8729, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8730, 8730, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8731, 8732, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8733, 8736, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8737, 8738, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8739, 8739, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8740, 8740, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8741, 8741, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8742, 8742, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8743, 8748, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8749, 8749, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8750, 8750, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8751, 8755, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8756, 8759, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8760, 8763, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8764, 8765, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8766, 8770, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8771, 8771, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8772, 8775, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8776, 8776, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8777, 8779, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8780, 8780, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8781, 8785, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8786, 8786, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8787, 8789, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8790, 8799, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8800, 8801, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8802, 8803, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8804, 8807, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8808, 8809, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8810, 8811, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8812, 8813, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8814, 8815, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8816, 8833, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8834, 8835, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8836, 8837, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8838, 8839, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8840, 8843, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8844, 8846, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8847, 8850, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8851, 8852, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8853, 8853, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8854, 8855, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8856, 8856, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8857, 8857, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8858, 8865, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8866, 8867, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8868, 8868, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8869, 8869, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8870, 8870, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8871, 8871, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8872, 8873, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8874, 8874, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8875, 8875, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8876, 8879, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8880, 8887, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8888, 8894, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8895, 8895, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8896, 8904, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8905, 8909, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8910, 8911, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8912, 8913, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8914, 8917, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8918, 8941, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8942, 8943, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8944, 8948, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8949, 8949, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8950, 8951, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8952, 8953, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8954, 8958, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8959, 8967, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8968, 8971, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(8972, 8977, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8978, 8978, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(8979, 9000, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9001, 9001, TextCharProp.makeData(25, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(9002, 9002, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(9003, 9013, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9014, 9082, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(9083, 9108, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9109, 9109, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(9110, 9139, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9140, 9140, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9141, 9141, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9142, 9142, TextCharProp.makeData(28, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9143, 9191, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9216, 9254, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9280, 9290, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9312, 9351, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9352, 9371, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x140000, 0));
            this.mRanges[i++] = new CharPropRange(9372, 9397, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(9398, 9423, TextCharProp.makeData(0, 0, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(9424, 9449, TextCharProp.makeData(0, 0, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(9450, 9450, TextCharProp.makeData(0, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9451, 9470, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9471, 9471, TextCharProp.makeData(1, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9472, 9547, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9548, 9551, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9552, 9587, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9588, 9588, TextCharProp.makeData(0, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9589, 9599, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9600, 9615, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9616, 9617, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9618, 9621, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9622, 9631, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9632, 9633, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9634, 9634, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9635, 9641, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9642, 9649, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9650, 9651, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9652, 9653, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9654, 9655, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9656, 9659, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9660, 9661, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9662, 9663, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9664, 9665, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9666, 9669, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9670, 9672, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9673, 9674, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9675, 9675, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9676, 9677, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9678, 9681, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9682, 9697, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9698, 9701, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9702, 9710, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9711, 9711, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9712, 9732, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9733, 9734, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9735, 9736, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9737, 9737, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9738, 9741, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9742, 9743, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9744, 9747, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9748, 9749, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9750, 9751, TextCharProp.makeData(0, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9752, 9755, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9756, 9756, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9757, 9757, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9758, 9758, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9759, 9791, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9792, 9792, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9793, 9793, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9794, 9794, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9795, 9823, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9824, 9825, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9826, 9826, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9827, 9829, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9830, 9830, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9831, 9834, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9835, 9835, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9836, 9837, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9838, 9838, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9839, 9839, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9840, 9884, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9888, 9899, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9900, 9900, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(9901, 9906, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9985, 9988, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9990, 9993, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(9996, 10023, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10025, 10044, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10045, 10045, TextCharProp.makeData(1, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10046, 10059, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10061, 10061, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10063, 10066, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10070, 10070, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10072, 10074, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10075, 10078, TextCharProp.makeData(28, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10081, 10081, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10082, 10083, TextCharProp.makeData(10, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10084, 10087, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10088, 10088, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10089, 10089, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10090, 10090, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10091, 10091, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10092, 10092, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10093, 10093, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10094, 10094, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10095, 10095, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10096, 10096, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10097, 10097, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10098, 10098, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10099, 10099, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10100, 10100, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10101, 10101, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10102, 10111, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10112, 10131, TextCharProp.makeData(0, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10132, 10132, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10136, 10159, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10161, 10174, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10176, 10178, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10179, 10180, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10181, 10181, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10182, 10182, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10183, 10186, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10192, 10196, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10197, 10198, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10199, 10204, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10205, 10206, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10207, 10209, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10210, 10213, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10214, 10214, TextCharProp.makeData(25, 256, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10215, 10215, TextCharProp.makeData(7, 256, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10216, 10216, TextCharProp.makeData(25, 256, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10217, 10217, TextCharProp.makeData(7, 256, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10218, 10218, TextCharProp.makeData(25, 256, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10219, 10219, TextCharProp.makeData(7, 256, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10224, 10239, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10240, 10495, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(10496, 10626, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10627, 10627, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10628, 10628, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10629, 10629, TextCharProp.makeData(25, 256, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10630, 10630, TextCharProp.makeData(7, 256, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10631, 10631, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10632, 10632, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10633, 10633, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10634, 10634, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10635, 10635, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10636, 10636, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10637, 10637, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10638, 10638, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10639, 10639, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10640, 10640, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10641, 10641, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10642, 10642, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10643, 10643, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10644, 10644, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10645, 10645, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10646, 10646, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10647, 10647, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10648, 10648, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10649, 10679, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10680, 10680, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10681, 10687, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10688, 10689, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10690, 10691, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10692, 10693, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10694, 10702, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10703, 10706, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10707, 10707, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10708, 10709, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10710, 10711, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10712, 10712, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10713, 10713, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10714, 10714, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10715, 10715, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10716, 10740, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10741, 10741, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10742, 10743, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10744, 10745, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10746, 10747, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10748, 10748, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10749, 10749, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10750, 10794, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10795, 10798, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10799, 10803, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10804, 10805, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10806, 10811, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10812, 10813, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10814, 10851, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10852, 10853, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10854, 10872, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10873, 10874, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10875, 10876, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10877, 10884, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10885, 10890, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10891, 10892, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10893, 10896, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10897, 10908, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10909, 10912, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10913, 10914, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10915, 10917, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10918, 10925, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10926, 10926, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10927, 10928, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10929, 10930, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10931, 10932, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10933, 10938, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10939, 10950, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10951, 10956, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10957, 10966, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10967, 10973, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10974, 10974, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10975, 10978, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10979, 10981, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10982, 10987, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10988, 10989, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(10990, 10998, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(10999, 11002, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(11003, 11034, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(11040, 11043, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(11264, 11310, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11312, 11358, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11360, 11360, TextCharProp.makeData(1, 192, 1024, 8192, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11361, 11361, TextCharProp.makeData(1, 192, 1024, 8192, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11362, 11364, TextCharProp.makeData(1, 192, 1024, 8192, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11365, 11366, TextCharProp.makeData(1, 192, 1024, 8192, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11367, 11367, TextCharProp.makeData(1, 192, 1024, 8192, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11368, 11368, TextCharProp.makeData(1, 192, 1024, 8192, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11369, 11369, TextCharProp.makeData(1, 192, 1024, 8192, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11370, 11370, TextCharProp.makeData(1, 192, 1024, 8192, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11371, 11371, TextCharProp.makeData(1, 192, 1024, 8192, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11372, 11372, TextCharProp.makeData(1, 192, 1024, 8192, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11380, 11380, TextCharProp.makeData(1, 192, 1024, 8192, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11381, 11381, TextCharProp.makeData(1, 192, 1024, 8192, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11382, 11383, TextCharProp.makeData(1, 192, 1024, 8192, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11392, 11392, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11393, 11393, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11394, 11394, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11395, 11395, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11396, 11396, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11397, 11397, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11398, 11398, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11399, 11399, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11400, 11400, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11401, 11401, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11402, 11402, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11403, 11403, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11404, 11404, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11405, 11405, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11406, 11406, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11407, 11407, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11408, 11408, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11409, 11409, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11410, 11410, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11411, 11411, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11412, 11412, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11413, 11413, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11414, 11414, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11415, 11415, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11416, 11416, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11417, 11417, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11418, 11418, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11419, 11419, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11420, 11420, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11421, 11421, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11422, 11422, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11423, 11423, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11424, 11424, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11425, 11425, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11426, 11426, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11427, 11427, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11428, 11428, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11429, 11429, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11430, 11430, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11431, 11431, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11432, 11432, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11433, 11433, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11434, 11434, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11435, 11435, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11436, 11436, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11437, 11437, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11438, 11438, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11439, 11439, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11440, 11440, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11441, 11441, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11442, 11442, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11443, 11443, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11444, 11444, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11445, 11445, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11446, 11446, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11447, 11447, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11448, 11448, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11449, 11449, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11450, 11450, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11451, 11451, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11452, 11452, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11453, 11453, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11454, 11454, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11455, 11455, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11456, 11456, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11457, 11457, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11458, 11458, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11459, 11459, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11460, 11460, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            return i;
        }

        private int initialize5(int i) {
            this.mRanges[i++] = new CharPropRange(11461, 11461, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11462, 11462, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11463, 11463, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11464, 11464, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11465, 11465, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11466, 11466, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11467, 11467, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11468, 11468, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11469, 11469, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11470, 11470, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11471, 11471, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11472, 11472, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11473, 11473, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11474, 11474, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11475, 11475, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11476, 11476, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11477, 11477, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11478, 11478, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11479, 11479, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11480, 11480, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11481, 11481, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11482, 11482, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11483, 11483, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11484, 11484, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11485, 11485, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11486, 11486, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11487, 11487, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11488, 11488, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11489, 11489, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11490, 11490, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11491, 11492, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11493, 11498, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(11513, 11516, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(11517, 11517, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(11518, 11519, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(11520, 11557, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11568, 11621, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11631, 11631, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11648, 11670, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11680, 11686, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11688, 11694, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11696, 11702, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11704, 11710, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11712, 11718, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11720, 11726, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11728, 11734, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11736, 11742, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(11776, 11777, TextCharProp.makeData(28, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(11778, 11781, TextCharProp.makeData(28, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(11782, 11784, TextCharProp.makeData(28, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(11785, 11786, TextCharProp.makeData(28, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(11787, 11787, TextCharProp.makeData(28, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(11788, 11789, TextCharProp.makeData(28, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(11790, 11797, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(11798, 11798, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(11799, 11799, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(11804, 11805, TextCharProp.makeData(28, 192, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(11904, 11929, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(11931, 12019, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(12032, 12245, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(12272, 12283, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(12288, 12288, TextCharProp.makeData(15, 64, 1024, 8192, 0, 0x480000, 0));
            this.mRanges[i++] = new CharPropRange(12289, 12290, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(12291, 12292, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(12293, 12293, TextCharProp.makeData(23, 320, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12294, 12295, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12296, 12296, TextCharProp.makeData(25, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(12297, 12297, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(12298, 12298, TextCharProp.makeData(25, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(12299, 12299, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(12300, 12300, TextCharProp.makeData(25, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(12301, 12301, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(12302, 12302, TextCharProp.makeData(25, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(12303, 12303, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(12304, 12304, TextCharProp.makeData(25, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(12305, 12305, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(12306, 12307, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(12308, 12308, TextCharProp.makeData(25, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(12309, 12309, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(12310, 12310, TextCharProp.makeData(25, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(12311, 12311, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(12312, 12312, TextCharProp.makeData(25, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(12313, 12313, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(12314, 12314, TextCharProp.makeData(25, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(12315, 12315, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(12316, 12316, TextCharProp.makeData(23, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(12317, 12317, TextCharProp.makeData(25, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(12318, 12318, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(12319, 12319, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(12320, 12320, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(12321, 12329, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12330, 12335, TextCharProp.makeData(8, 320, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(12336, 12336, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(12337, 12341, TextCharProp.makeData(15, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12342, 12343, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(12344, 12346, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12347, 12348, TextCharProp.makeData(23, 320, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12349, 12350, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(12351, 12351, TextCharProp.makeData(15, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(12353, 12353, TextCharProp.makeData(23, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12354, 12354, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12355, 12355, TextCharProp.makeData(23, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12356, 12356, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12357, 12357, TextCharProp.makeData(23, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12358, 12358, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12359, 12359, TextCharProp.makeData(23, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12360, 12360, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12361, 12361, TextCharProp.makeData(23, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12362, 12386, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12387, 12387, TextCharProp.makeData(23, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12388, 12418, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12419, 12419, TextCharProp.makeData(23, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12420, 12420, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12421, 12421, TextCharProp.makeData(23, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12422, 12422, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12423, 12423, TextCharProp.makeData(23, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12424, 12429, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12430, 12430, TextCharProp.makeData(23, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12431, 12436, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12437, 12438, TextCharProp.makeData(23, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12441, 12442, TextCharProp.makeData(8, 320, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(12443, 12444, TextCharProp.makeData(23, 320, 1024, 32768, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(12445, 12446, TextCharProp.makeData(23, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12447, 12447, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12448, 12448, TextCharProp.makeData(23, 320, 1024, 32768, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(12449, 12449, TextCharProp.makeData(23, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12450, 12450, TextCharProp.makeData(15, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12451, 12451, TextCharProp.makeData(23, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12452, 12452, TextCharProp.makeData(15, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12453, 12453, TextCharProp.makeData(23, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12454, 12454, TextCharProp.makeData(15, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12455, 12455, TextCharProp.makeData(23, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12456, 12456, TextCharProp.makeData(15, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12457, 12457, TextCharProp.makeData(23, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12458, 12482, TextCharProp.makeData(15, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12483, 12483, TextCharProp.makeData(23, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12484, 12514, TextCharProp.makeData(15, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12515, 12515, TextCharProp.makeData(23, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12516, 12516, TextCharProp.makeData(15, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12517, 12517, TextCharProp.makeData(23, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12518, 12518, TextCharProp.makeData(15, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12519, 12519, TextCharProp.makeData(23, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12520, 12525, TextCharProp.makeData(15, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12526, 12526, TextCharProp.makeData(23, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12527, 12532, TextCharProp.makeData(15, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12533, 12534, TextCharProp.makeData(23, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12535, 12538, TextCharProp.makeData(15, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12539, 12539, TextCharProp.makeData(23, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(12540, 12542, TextCharProp.makeData(23, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12543, 12543, TextCharProp.makeData(15, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12549, 12588, TextCharProp.makeData(15, 320, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12593, 12686, TextCharProp.makeData(15, 320, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12688, 12703, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12704, 12727, TextCharProp.makeData(15, 320, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12736, 12751, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(12784, 12799, TextCharProp.makeData(23, 320, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12800, 12828, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12829, 12830, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(12832, 12867, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12880, 12895, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(12896, 12923, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12924, 12926, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(12927, 12976, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(12977, 12991, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(12992, 13003, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(13004, 13007, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(13008, 13054, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(13056, 13174, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(13175, 13178, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(13179, 13277, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(13278, 13279, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(13280, 13310, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(13311, 13311, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(13312, 19893, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(19904, 19967, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(19968, 40891, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(40960, 40980, TextCharProp.makeData(15, 320, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(40981, 40981, TextCharProp.makeData(23, 320, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(40982, 42124, TextCharProp.makeData(15, 320, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(42128, 42182, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(42752, 42778, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(42784, 42785, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(43008, 43009, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(43010, 43010, TextCharProp.makeData(8, 192, 1024, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(43011, 43013, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(43014, 43014, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(43015, 43018, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(43019, 43019, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(43020, 43042, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(43043, 43044, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(43045, 43046, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(43047, 43047, TextCharProp.makeData(8, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(43048, 43051, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(43072, 43123, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(43124, 43127, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(44032, 44032, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44033, 44059, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44060, 44060, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44061, 44087, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44088, 44088, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44089, 44115, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44116, 44116, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44117, 44143, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44144, 44144, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44145, 44171, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44172, 44172, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44173, 44199, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44200, 44200, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44201, 44227, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44228, 44228, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44229, 44255, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44256, 44256, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44257, 44283, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44284, 44284, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44285, 44311, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44312, 44312, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44313, 44339, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44340, 44340, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44341, 44367, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44368, 44368, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44369, 44395, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44396, 44396, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44397, 44423, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44424, 44424, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44425, 44451, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44452, 44452, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44453, 44479, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44480, 44480, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44481, 44507, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44508, 44508, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44509, 44535, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44536, 44536, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44537, 44563, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44564, 44564, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44565, 44591, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44592, 44592, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44593, 44619, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44620, 44620, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44621, 44647, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44648, 44648, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44649, 44675, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44676, 44676, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44677, 44703, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44704, 44704, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44705, 44731, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44732, 44732, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44733, 44759, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44760, 44760, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44761, 44787, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44788, 44788, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44789, 44815, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44816, 44816, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44817, 44843, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44844, 44844, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44845, 44871, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44872, 44872, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44873, 44899, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44900, 44900, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44901, 44927, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44928, 44928, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44929, 44955, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44956, 44956, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44957, 44983, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44984, 44984, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(44985, 45011, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45012, 45012, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45013, 45039, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45040, 45040, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45041, 45067, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45068, 45068, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45069, 45095, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45096, 45096, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45097, 45123, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45124, 45124, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45125, 45151, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45152, 45152, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45153, 45179, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45180, 45180, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45181, 45207, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45208, 45208, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45209, 45235, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45236, 45236, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45237, 45263, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45264, 45264, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45265, 45291, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45292, 45292, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45293, 45319, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45320, 45320, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45321, 45347, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45348, 45348, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45349, 45375, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45376, 45376, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45377, 45403, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45404, 45404, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45405, 45431, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45432, 45432, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45433, 45459, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45460, 45460, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45461, 45487, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45488, 45488, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45489, 45515, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45516, 45516, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45517, 45543, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45544, 45544, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45545, 45571, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45572, 45572, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45573, 45599, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45600, 45600, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45601, 45627, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45628, 45628, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45629, 45655, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45656, 45656, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45657, 45683, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45684, 45684, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45685, 45711, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45712, 45712, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45713, 45739, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45740, 45740, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45741, 45767, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45768, 45768, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45769, 45795, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45796, 45796, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45797, 45823, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45824, 45824, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45825, 45851, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45852, 45852, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45853, 45879, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45880, 45880, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45881, 45907, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45908, 45908, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45909, 45935, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45936, 45936, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45937, 45963, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45964, 45964, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45965, 45991, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45992, 45992, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(45993, 46019, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46020, 46020, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46021, 46047, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46048, 46048, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46049, 46075, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46076, 46076, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46077, 46103, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46104, 46104, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46105, 46131, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46132, 46132, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46133, 46159, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46160, 46160, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46161, 46187, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46188, 46188, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46189, 46215, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46216, 46216, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46217, 46243, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46244, 46244, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46245, 46271, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46272, 46272, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46273, 46299, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46300, 46300, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46301, 46327, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46328, 46328, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46329, 46355, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46356, 46356, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46357, 46383, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46384, 46384, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46385, 46411, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46412, 46412, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46413, 46439, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46440, 46440, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46441, 46467, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46468, 46468, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46469, 46495, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46496, 46496, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46497, 46523, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46524, 46524, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46525, 46551, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46552, 46552, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46553, 46579, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46580, 46580, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46581, 46607, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46608, 46608, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46609, 46635, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46636, 46636, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46637, 46663, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46664, 46664, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46665, 46691, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46692, 46692, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46693, 46719, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46720, 46720, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46721, 46747, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46748, 46748, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46749, 46775, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46776, 46776, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46777, 46803, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46804, 46804, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46805, 46831, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46832, 46832, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46833, 46859, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46860, 46860, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46861, 46887, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46888, 46888, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46889, 46915, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46916, 46916, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46917, 46943, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46944, 46944, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46945, 46971, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46972, 46972, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(46973, 46999, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47000, 47000, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47001, 47027, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47028, 47028, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47029, 47055, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47056, 47056, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47057, 47083, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47084, 47084, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47085, 47111, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47112, 47112, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47113, 47139, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47140, 47140, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47141, 47167, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47168, 47168, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47169, 47195, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47196, 47196, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47197, 47223, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47224, 47224, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47225, 47251, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47252, 47252, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47253, 47279, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47280, 47280, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47281, 47307, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47308, 47308, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47309, 47335, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47336, 47336, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47337, 47363, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47364, 47364, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47365, 47391, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47392, 47392, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47393, 47419, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47420, 47420, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47421, 47447, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47448, 47448, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47449, 47475, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47476, 47476, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47477, 47503, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47504, 47504, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47505, 47531, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47532, 47532, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47533, 47559, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47560, 47560, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47561, 47587, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47588, 47588, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47589, 47615, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47616, 47616, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47617, 47643, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47644, 47644, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47645, 47671, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47672, 47672, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47673, 47699, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47700, 47700, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47701, 47727, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47728, 47728, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47729, 47755, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47756, 47756, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47757, 47783, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47784, 47784, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47785, 47811, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47812, 47812, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47813, 47839, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47840, 47840, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47841, 47867, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47868, 47868, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47869, 47895, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47896, 47896, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47897, 47923, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47924, 47924, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47925, 47951, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47952, 47952, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47953, 47979, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47980, 47980, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(47981, 48007, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48008, 48008, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48009, 48035, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48036, 48036, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48037, 48063, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48064, 48064, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48065, 48091, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48092, 48092, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48093, 48119, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48120, 48120, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48121, 48147, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48148, 48148, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48149, 48175, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48176, 48176, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48177, 48203, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48204, 48204, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48205, 48231, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48232, 48232, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48233, 48259, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48260, 48260, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48261, 48287, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48288, 48288, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48289, 48315, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            return i;
        }

        private int initialize6(int i) {
            this.mRanges[i++] = new CharPropRange(48316, 48316, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48317, 48343, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48344, 48344, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48345, 48371, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48372, 48372, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48373, 48399, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48400, 48400, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48401, 48427, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48428, 48428, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48429, 48455, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48456, 48456, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48457, 48483, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48484, 48484, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48485, 48511, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48512, 48512, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48513, 48539, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48540, 48540, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48541, 48567, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48568, 48568, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48569, 48595, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48596, 48596, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48597, 48623, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48624, 48624, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48625, 48651, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48652, 48652, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48653, 48679, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48680, 48680, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48681, 48707, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48708, 48708, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48709, 48735, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48736, 48736, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48737, 48763, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48764, 48764, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48765, 48791, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48792, 48792, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48793, 48819, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48820, 48820, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48821, 48847, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48848, 48848, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48849, 48875, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48876, 48876, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48877, 48903, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48904, 48904, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48905, 48931, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48932, 48932, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48933, 48959, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48960, 48960, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48961, 48987, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48988, 48988, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(48989, 49015, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49016, 49016, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49017, 49043, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49044, 49044, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49045, 49071, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49072, 49072, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49073, 49099, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49100, 49100, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49101, 49127, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49128, 49128, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49129, 49155, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49156, 49156, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49157, 49183, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49184, 49184, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49185, 49211, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49212, 49212, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49213, 49239, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49240, 49240, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49241, 49267, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49268, 49268, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49269, 49295, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49296, 49296, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49297, 49323, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49324, 49324, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49325, 49351, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49352, 49352, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49353, 49379, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49380, 49380, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49381, 49407, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49408, 49408, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49409, 49435, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49436, 49436, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49437, 49463, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49464, 49464, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49465, 49491, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49492, 49492, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49493, 49519, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49520, 49520, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49521, 49547, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49548, 49548, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49549, 49575, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49576, 49576, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49577, 49603, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49604, 49604, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49605, 49631, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49632, 49632, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49633, 49659, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49660, 49660, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49661, 49687, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49688, 49688, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49689, 49715, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49716, 49716, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49717, 49743, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49744, 49744, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49745, 49771, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49772, 49772, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49773, 49799, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49800, 49800, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49801, 49827, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49828, 49828, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49829, 49855, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49856, 49856, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49857, 49883, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49884, 49884, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49885, 49911, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49912, 49912, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49913, 49939, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49940, 49940, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49941, 49967, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49968, 49968, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49969, 49995, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49996, 49996, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(49997, 50023, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50024, 50024, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50025, 50051, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50052, 50052, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50053, 50079, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50080, 50080, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50081, 50107, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50108, 50108, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50109, 50135, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50136, 50136, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50137, 50163, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50164, 50164, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50165, 50191, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50192, 50192, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50193, 50219, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50220, 50220, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50221, 50247, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50248, 50248, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50249, 50275, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50276, 50276, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50277, 50303, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50304, 50304, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50305, 50331, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50332, 50332, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50333, 50359, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50360, 50360, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50361, 50387, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50388, 50388, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50389, 50415, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50416, 50416, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50417, 50443, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50444, 50444, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50445, 50471, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50472, 50472, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50473, 50499, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50500, 50500, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50501, 50527, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50528, 50528, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50529, 50555, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50556, 50556, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50557, 50583, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50584, 50584, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50585, 50611, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50612, 50612, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50613, 50639, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50640, 50640, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50641, 50667, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50668, 50668, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50669, 50695, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50696, 50696, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50697, 50723, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50724, 50724, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50725, 50751, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50752, 50752, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50753, 50779, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50780, 50780, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50781, 50807, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50808, 50808, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50809, 50835, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50836, 50836, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50837, 50863, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50864, 50864, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50865, 50891, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50892, 50892, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50893, 50919, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50920, 50920, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50921, 50947, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50948, 50948, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50949, 50975, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50976, 50976, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(50977, 51003, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51004, 51004, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51005, 51031, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51032, 51032, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51033, 51059, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51060, 51060, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51061, 51087, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51088, 51088, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51089, 51115, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51116, 51116, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51117, 51143, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51144, 51144, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51145, 51171, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51172, 51172, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51173, 51199, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51200, 51200, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51201, 51227, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51228, 51228, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51229, 51255, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51256, 51256, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51257, 51283, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51284, 51284, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51285, 51311, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51312, 51312, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51313, 51339, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51340, 51340, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51341, 51367, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51368, 51368, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51369, 51395, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51396, 51396, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51397, 51423, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51424, 51424, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51425, 51451, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51452, 51452, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51453, 51479, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51480, 51480, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51481, 51507, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51508, 51508, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51509, 51535, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51536, 51536, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51537, 51563, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51564, 51564, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51565, 51591, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51592, 51592, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51593, 51619, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51620, 51620, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51621, 51647, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51648, 51648, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51649, 51675, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51676, 51676, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51677, 51703, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51704, 51704, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51705, 51731, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51732, 51732, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51733, 51759, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51760, 51760, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51761, 51787, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51788, 51788, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51789, 51815, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51816, 51816, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51817, 51843, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51844, 51844, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51845, 51871, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51872, 51872, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51873, 51899, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51900, 51900, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51901, 51927, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51928, 51928, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51929, 51955, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51956, 51956, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51957, 51983, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51984, 51984, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(51985, 52011, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52012, 52012, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52013, 52039, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52040, 52040, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52041, 52067, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52068, 52068, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52069, 52095, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52096, 52096, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52097, 52123, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52124, 52124, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52125, 52151, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52152, 52152, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52153, 52179, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52180, 52180, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52181, 52207, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52208, 52208, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52209, 52235, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52236, 52236, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52237, 52263, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52264, 52264, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52265, 52291, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52292, 52292, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52293, 52319, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52320, 52320, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52321, 52347, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52348, 52348, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52349, 52375, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52376, 52376, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52377, 52403, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52404, 52404, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52405, 52431, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52432, 52432, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52433, 52459, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52460, 52460, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52461, 52487, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52488, 52488, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52489, 52515, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52516, 52516, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52517, 52543, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52544, 52544, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52545, 52571, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52572, 52572, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52573, 52599, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52600, 52600, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52601, 52627, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52628, 52628, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52629, 52655, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52656, 52656, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52657, 52683, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52684, 52684, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52685, 52711, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52712, 52712, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52713, 52739, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52740, 52740, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52741, 52767, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52768, 52768, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52769, 52795, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52796, 52796, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52797, 52823, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52824, 52824, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52825, 52851, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52852, 52852, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52853, 52879, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52880, 52880, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52881, 52907, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52908, 52908, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52909, 52935, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52936, 52936, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52937, 52963, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52964, 52964, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52965, 52991, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52992, 52992, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(52993, 53019, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53020, 53020, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53021, 53047, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53048, 53048, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53049, 53075, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53076, 53076, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53077, 53103, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53104, 53104, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53105, 53131, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53132, 53132, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53133, 53159, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53160, 53160, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53161, 53187, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53188, 53188, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53189, 53215, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53216, 53216, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53217, 53243, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53244, 53244, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53245, 53271, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53272, 53272, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53273, 53299, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53300, 53300, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53301, 53327, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53328, 53328, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53329, 53355, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53356, 53356, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53357, 53383, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53384, 53384, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53385, 53411, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53412, 53412, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53413, 53439, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53440, 53440, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53441, 53467, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53468, 53468, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53469, 53495, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53496, 53496, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53497, 53523, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53524, 53524, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53525, 53551, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53552, 53552, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53553, 53579, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53580, 53580, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53581, 53607, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53608, 53608, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53609, 53635, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53636, 53636, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53637, 53663, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53664, 53664, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53665, 53691, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53692, 53692, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53693, 53719, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53720, 53720, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53721, 53747, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53748, 53748, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53749, 53775, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53776, 53776, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53777, 53803, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53804, 53804, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53805, 53831, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53832, 53832, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53833, 53859, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53860, 53860, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53861, 53887, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53888, 53888, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53889, 53915, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53916, 53916, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53917, 53943, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53944, 53944, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53945, 53971, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53972, 53972, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(53973, 53999, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54000, 54000, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54001, 54027, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54028, 54028, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54029, 54055, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54056, 54056, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54057, 54083, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54084, 54084, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54085, 54111, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54112, 54112, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54113, 54139, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54140, 54140, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54141, 54167, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54168, 54168, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54169, 54195, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54196, 54196, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54197, 54223, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54224, 54224, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54225, 54251, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54252, 54252, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54253, 54279, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54280, 54280, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54281, 54307, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54308, 54308, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54309, 54335, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54336, 54336, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54337, 54363, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54364, 54364, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54365, 54391, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54392, 54392, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54393, 54419, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54420, 54420, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54421, 54447, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54448, 54448, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54449, 54475, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54476, 54476, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54477, 54503, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54504, 54504, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54505, 54531, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54532, 54532, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54533, 54559, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54560, 54560, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54561, 54587, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54588, 54588, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54589, 54615, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54616, 54616, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54617, 54643, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54644, 54644, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54645, 54671, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54672, 54672, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54673, 54699, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54700, 54700, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54701, 54727, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54728, 54728, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54729, 54755, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54756, 54756, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54757, 54783, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54784, 54784, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54785, 54811, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54812, 54812, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54813, 54839, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54840, 54840, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54841, 54867, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54868, 54868, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54869, 54895, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54896, 54896, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54897, 54923, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54924, 54924, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54925, 54951, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54952, 54952, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54953, 54979, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54980, 54980, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(54981, 55007, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(55008, 55008, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(55009, 55035, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(55036, 55036, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(55037, 55063, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(55064, 55064, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(55065, 55091, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(55092, 55092, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(55093, 55119, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(55120, 55120, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(55121, 55147, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(55148, 55148, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(55149, 55175, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(55176, 55176, TextCharProp.makeData(12, 320, 3072, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(55177, 55203, TextCharProp.makeData(13, 320, 3584, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(55296, 57343, TextCharProp.makeData(30, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(57344, 63743, TextCharProp.makeData(34, 0, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(63744, 64045, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(64048, 64106, TextCharProp.makeData(15, 320, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(64112, 64217, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(64256, 64262, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(64275, 64279, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(64285, 64285, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(64286, 64286, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            return i;
        }

        private int initialize7(int i) {
            this.mRanges[i++] = new CharPropRange(64287, 64296, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(64297, 64297, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x180000, 0));
            this.mRanges[i++] = new CharPropRange(64298, 64310, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(64311, 64311, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(64312, 64316, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(64317, 64317, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(64318, 64318, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(64319, 64319, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(64320, 64321, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(64322, 64322, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(64323, 64324, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(64325, 64325, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(64326, 64335, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(64336, 64433, TextCharProp.makeData(1, 192, 1024, 0, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(64434, 64466, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(64467, 64829, TextCharProp.makeData(1, 192, 1024, 0, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(64830, 64830, TextCharProp.makeData(25, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(64831, 64831, TextCharProp.makeData(7, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(64832, 64847, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(64848, 64911, TextCharProp.makeData(1, 192, 1024, 0, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(64912, 64913, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(64914, 64967, TextCharProp.makeData(1, 192, 1024, 0, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(64968, 64975, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(64976, 65007, TextCharProp.makeData(1, 192, 1024, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(65008, 65019, TextCharProp.makeData(1, 192, 1024, 0, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(65020, 65020, TextCharProp.makeData(26, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(65021, 65021, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65022, 65023, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(65024, 65039, TextCharProp.makeData(8, 0, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(65040, 65040, TextCharProp.makeData(17, 320, 1024, 49152, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65041, 65042, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65043, 65044, TextCharProp.makeData(17, 320, 1024, 49152, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65045, 65046, TextCharProp.makeData(10, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65047, 65047, TextCharProp.makeData(25, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65048, 65048, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65049, 65049, TextCharProp.makeData(16, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65056, 65059, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(65072, 65074, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65075, 65076, TextCharProp.makeData(15, 320, 1024, 16384, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65077, 65077, TextCharProp.makeData(25, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65078, 65078, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65079, 65079, TextCharProp.makeData(25, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65080, 65080, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65081, 65081, TextCharProp.makeData(25, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65082, 65082, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65083, 65083, TextCharProp.makeData(25, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65084, 65084, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65085, 65085, TextCharProp.makeData(25, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65086, 65086, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65087, 65087, TextCharProp.makeData(25, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65088, 65088, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65089, 65089, TextCharProp.makeData(25, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65090, 65090, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65091, 65091, TextCharProp.makeData(25, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65092, 65092, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65093, 65094, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65095, 65095, TextCharProp.makeData(25, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65096, 65096, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65097, 65100, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65101, 65103, TextCharProp.makeData(15, 320, 1024, 16384, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65104, 65104, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x100000, 0));
            this.mRanges[i++] = new CharPropRange(65105, 65105, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65106, 65106, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x100000, 0));
            this.mRanges[i++] = new CharPropRange(65108, 65108, TextCharProp.makeData(23, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65109, 65109, TextCharProp.makeData(23, 320, 1024, 8192, 0, 0x100000, 0));
            this.mRanges[i++] = new CharPropRange(65110, 65111, TextCharProp.makeData(10, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65112, 65112, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65113, 65113, TextCharProp.makeData(25, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(65114, 65114, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(65115, 65115, TextCharProp.makeData(25, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(65116, 65116, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(65117, 65117, TextCharProp.makeData(25, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(65118, 65118, TextCharProp.makeData(7, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(65119, 65119, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(65120, 65121, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65122, 65123, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x180000, 0));
            this.mRanges[i++] = new CharPropRange(65124, 65125, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(65126, 65126, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65128, 65128, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65129, 65129, TextCharProp.makeData(27, 320, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(65130, 65130, TextCharProp.makeData(26, 320, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(65131, 65131, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65136, 65140, TextCharProp.makeData(1, 192, 1024, 0, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(65141, 65141, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(65142, 65276, TextCharProp.makeData(1, 192, 1024, 0, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(65277, 65278, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(65279, 65279, TextCharProp.makeData(33, 192, 0, 24576, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(65281, 65281, TextCharProp.makeData(10, 64, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65282, 65282, TextCharProp.makeData(15, 64, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65283, 65283, TextCharProp.makeData(15, 64, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(65284, 65284, TextCharProp.makeData(27, 64, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(65285, 65285, TextCharProp.makeData(26, 64, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(65286, 65287, TextCharProp.makeData(15, 64, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65288, 65288, TextCharProp.makeData(25, 64, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(65289, 65289, TextCharProp.makeData(7, 64, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(65290, 65290, TextCharProp.makeData(15, 64, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65291, 65291, TextCharProp.makeData(15, 64, 1024, 8192, 0, 0x180000, 0));
            this.mRanges[i++] = new CharPropRange(65292, 65292, TextCharProp.makeData(7, 64, 1024, 8192, 0, 0x100000, 0));
            this.mRanges[i++] = new CharPropRange(65293, 65293, TextCharProp.makeData(15, 64, 1024, 8192, 0, 0x180000, 0));
            this.mRanges[i++] = new CharPropRange(65294, 65294, TextCharProp.makeData(7, 64, 1024, 8192, 0, 0x100000, 0));
            this.mRanges[i++] = new CharPropRange(65295, 65295, TextCharProp.makeData(15, 64, 1024, 8192, 0, 0x100000, 0));
            this.mRanges[i++] = new CharPropRange(65296, 65305, TextCharProp.makeData(15, 64, 1024, 8192, 0, 0x140000, 0));
            this.mRanges[i++] = new CharPropRange(65306, 65306, TextCharProp.makeData(23, 64, 1024, 8192, 0, 0x100000, 0));
            this.mRanges[i++] = new CharPropRange(65307, 65307, TextCharProp.makeData(23, 64, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65308, 65308, TextCharProp.makeData(15, 64, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(65309, 65309, TextCharProp.makeData(15, 64, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65310, 65310, TextCharProp.makeData(15, 64, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(65311, 65311, TextCharProp.makeData(10, 64, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65312, 65312, TextCharProp.makeData(15, 64, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65313, 65338, TextCharProp.makeData(15, 64, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(65339, 65339, TextCharProp.makeData(25, 64, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(65340, 65340, TextCharProp.makeData(15, 64, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65341, 65341, TextCharProp.makeData(7, 64, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(65342, 65342, TextCharProp.makeData(15, 64, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65343, 65343, TextCharProp.makeData(15, 64, 1024, 16384, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65344, 65344, TextCharProp.makeData(15, 64, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65345, 65370, TextCharProp.makeData(15, 64, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(65371, 65371, TextCharProp.makeData(25, 64, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(65372, 65372, TextCharProp.makeData(15, 64, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65373, 65373, TextCharProp.makeData(7, 64, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(65374, 65374, TextCharProp.makeData(15, 64, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65375, 65375, TextCharProp.makeData(25, 64, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(65376, 65376, TextCharProp.makeData(7, 64, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(65377, 65377, TextCharProp.makeData(7, 128, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65378, 65378, TextCharProp.makeData(25, 128, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(65379, 65379, TextCharProp.makeData(7, 128, 1024, 8192, 0, 0x300000, 0x800000));
            this.mRanges[i++] = new CharPropRange(65380, 65380, TextCharProp.makeData(7, 128, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65381, 65381, TextCharProp.makeData(23, 128, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65382, 65382, TextCharProp.makeData(1, 128, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(65383, 65392, TextCharProp.makeData(23, 128, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(65393, 65437, TextCharProp.makeData(1, 128, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(65438, 65439, TextCharProp.makeData(23, 128, 1024, 32768, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(65440, 65470, TextCharProp.makeData(1, 128, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(65474, 65479, TextCharProp.makeData(1, 128, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(65482, 65487, TextCharProp.makeData(1, 128, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(65490, 65495, TextCharProp.makeData(1, 128, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(65498, 65500, TextCharProp.makeData(1, 128, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(65504, 65504, TextCharProp.makeData(26, 64, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(65505, 65505, TextCharProp.makeData(27, 64, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(65506, 65508, TextCharProp.makeData(15, 64, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65509, 65510, TextCharProp.makeData(27, 64, 1024, 8192, 0, 0x1C0000, 0));
            this.mRanges[i++] = new CharPropRange(65512, 65518, TextCharProp.makeData(1, 128, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65520, 65528, TextCharProp.makeData(1, 192, 1024, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(65529, 65531, TextCharProp.makeData(8, 192, 0, 24576, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65532, 65532, TextCharProp.makeData(6, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65533, 65533, TextCharProp.makeData(0, 0, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65534, 65535, TextCharProp.makeData(1, 192, 1024, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(65536, 65547, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(65549, 65574, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(65576, 65594, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(65596, 65597, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(65599, 65613, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(65616, 65629, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(65664, 65786, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(65792, 65792, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(65793, 65793, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65794, 65794, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(65799, 65843, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(65847, 65855, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(65856, 65908, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(65909, 65930, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(66304, 66334, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(66336, 66339, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(66352, 66378, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(66432, 66461, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(66462, 66462, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0, 0));
            this.mRanges[i++] = new CharPropRange(66463, 66463, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(66464, 66499, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(66504, 66511, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(66512, 66512, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(66513, 66517, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(66560, 66599, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(66600, 66639, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(66640, 66717, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(66720, 66729, TextCharProp.makeData(24, 192, 1024, 57344, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(67584, 67589, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(67590, 67591, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(67592, 67592, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(67593, 67593, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(67594, 67637, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(67638, 67638, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(67639, 67640, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(67641, 67643, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(67644, 67644, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(67645, 67646, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(67647, 67647, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(67648, 67870, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(67871, 67871, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(67872, 68095, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(68096, 68096, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(68097, 68099, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(68100, 68100, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(68101, 68102, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(68103, 68107, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(68108, 68111, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(68112, 68115, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(68116, 68116, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(68117, 68119, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(68120, 68120, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(68121, 68147, TextCharProp.makeData(1, 192, 1024, 0, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(68148, 68151, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(68152, 68154, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(68155, 68158, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(68159, 68159, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(68160, 68175, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(68176, 68183, TextCharProp.makeData(3, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(68184, 69631, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x380000, 0));
            this.mRanges[i++] = new CharPropRange(73728, 74606, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(74752, 74850, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(74864, 74867, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(118784, 119029, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119040, 119078, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119082, 119140, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119141, 119141, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119142, 119142, TextCharProp.makeData(8, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119143, 119145, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(119146, 119148, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119149, 119149, TextCharProp.makeData(8, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119150, 119154, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119155, 119162, TextCharProp.makeData(8, 192, 0, 24576, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(119163, 119170, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(119171, 119172, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119173, 119179, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(119180, 119209, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119210, 119213, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(119214, 119261, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119296, 119361, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(119362, 119364, TextCharProp.makeData(8, 192, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(119365, 119365, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(119552, 119638, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x300000, 0));
            this.mRanges[i++] = new CharPropRange(119648, 119665, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119808, 119833, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119834, 119859, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119860, 119885, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119886, 119892, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119894, 119911, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119912, 119937, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119938, 119963, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119964, 119964, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119966, 119967, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119970, 119970, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119973, 119974, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119977, 119980, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119982, 119989, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119990, 119993, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119995, 119995, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(119997, 120003, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120005, 120015, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120016, 120041, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120042, 120067, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120068, 120069, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120071, 120074, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120077, 120084, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120086, 120092, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120094, 120119, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120120, 120121, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120123, 120126, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120128, 120132, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120134, 120134, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120138, 120144, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120146, 120171, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120172, 120197, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120198, 120223, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120224, 120249, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120250, 120275, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120276, 120301, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120302, 120327, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120328, 120353, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120354, 120379, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120380, 120405, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120406, 120431, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120432, 120457, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120458, 120485, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120488, 120512, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120513, 120513, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120514, 120538, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120539, 120539, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120540, 120545, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120546, 120570, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120571, 120571, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120572, 120596, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120597, 120597, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120598, 120603, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120604, 120628, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120629, 120629, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120630, 120654, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120655, 120655, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120656, 120661, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120662, 120686, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120687, 120687, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120688, 120712, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120713, 120713, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120714, 120719, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120720, 120744, TextCharProp.makeData(1, 192, 1024, 0, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120745, 120745, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120746, 120770, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120771, 120771, TextCharProp.makeData(1, 192, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120772, 120777, TextCharProp.makeData(1, 192, 1024, 0, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120778, 120778, TextCharProp.makeData(1, 192, 1024, 8192, 196608, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120779, 120779, TextCharProp.makeData(1, 192, 1024, 8192, 65536, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(120782, 120831, TextCharProp.makeData(24, 192, 1024, 57344, 0, 0x140000, 0));
            this.mRanges[i++] = new CharPropRange(131070, 131071, TextCharProp.makeData(1, 192, 1024, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(131072, 173782, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(173783, 194559, TextCharProp.makeData(1, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(194560, 195101, TextCharProp.makeData(15, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(195102, 196605, TextCharProp.makeData(1, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(196606, 196607, TextCharProp.makeData(1, 192, 1024, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(196608, 262141, TextCharProp.makeData(1, 320, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(262142, 262143, TextCharProp.makeData(1, 192, 1024, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(327678, 327679, TextCharProp.makeData(1, 192, 1024, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(393214, 393215, TextCharProp.makeData(1, 192, 1024, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(458750, 458751, TextCharProp.makeData(1, 192, 1024, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(524286, 524287, TextCharProp.makeData(1, 192, 1024, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(589822, 589823, TextCharProp.makeData(1, 192, 1024, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(655358, 655359, TextCharProp.makeData(1, 192, 1024, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(720894, 720895, TextCharProp.makeData(1, 192, 1024, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(786430, 786431, TextCharProp.makeData(1, 192, 1024, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(851966, 851967, TextCharProp.makeData(1, 192, 1024, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(917502, 917504, TextCharProp.makeData(1, 192, 1024, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(917505, 917505, TextCharProp.makeData(8, 192, 0, 24576, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(917506, 917535, TextCharProp.makeData(1, 192, 1024, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(917536, 917631, TextCharProp.makeData(8, 192, 0, 24576, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(917632, 917759, TextCharProp.makeData(1, 192, 1024, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(917760, 917999, TextCharProp.makeData(8, 0, 1536, 8192, 0, 0x2C0000, 0));
            this.mRanges[i++] = new CharPropRange(918000, 921599, TextCharProp.makeData(1, 192, 1024, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(983038, 983039, TextCharProp.makeData(1, 192, 1024, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(983040, 1048573, TextCharProp.makeData(34, 0, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1048574, 1048575, TextCharProp.makeData(1, 192, 1024, 8192, 0, 786432, 0));
            this.mRanges[i++] = new CharPropRange(0x100000, 1114109, TextCharProp.makeData(34, 0, 1024, 8192, 0, 0x200000, 0));
            this.mRanges[i++] = new CharPropRange(1114110, 0x10FFFF, TextCharProp.makeData(1, 192, 1024, 8192, 0, 786432, 0));
            return i;
        }
    }

    static class CharPropRange {
        final int mcStart;
        final int mcEnd;
        final int meBreak;

        CharPropRange(int cStart, int cEnd, int eBreak) {
            this.mcStart = cStart;
            this.mcEnd = cEnd;
            this.meBreak = eBreak;
        }
    }
}

