/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.mac;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class MacMetadata {
    private final Map<String, Object> metadata = new HashMap<String, Object>();

    @Nonnull
    public MacMetadata addAttribute(@Nonnull String attributeName, @Nonnull String attributeValue) {
        if (this.metadata.size() == 15) {
            throw new RuntimeException("The maximum number of Marketing Cloud Metadata items has been exceeded (15)");
        }
        if (attributeName.length() > 250 || attributeValue.length() > 250) {
            throw new RuntimeException("The attribute name or value exceeds the maximum length of 250");
        }
        this.metadata.put(attributeName, attributeValue);
        return this;
    }

    public MacMetadata addAttribute(@Nonnull String attributeName, @Nonnull String[] attributeValues) {
        if (this.metadata.size() == 15) {
            throw new RuntimeException("The maximum number of Marketing Cloud Metadata items has been exceeded (15)");
        }
        String value = StringUtils.join((Object[])attributeValues, ",");
        if (attributeName.length() > 250 || value.length() > 250) {
            throw new RuntimeException("The attribute name or value exceeds the maximum length of 250");
        }
        this.metadata.put(attributeName, attributeValues);
        return this;
    }

    public void removeAttribute(@Nonnull String attributeName) {
        this.metadata.remove(attributeName);
    }

    public Map<String, String> getMarketingCloudMetadata() {
        HashMap<String, String> internalMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : this.metadata.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String[]) {
                Object[] values = (String[])value;
                internalMap.put(entry.getKey(), StringUtils.join(values, ","));
                continue;
            }
            internalMap.put(entry.getKey(), (String)value);
        }
        return internalMap;
    }

    @Nullable
    public String getValue(@Nonnull String attributeName) {
        if (StringUtils.isEmpty(attributeName)) {
            return null;
        }
        Object value = this.metadata.get(attributeName);
        if (value instanceof String[]) {
            return null;
        }
        return (String)this.metadata.get(attributeName);
    }

    @Nullable
    public String[] getValues(@Nonnull String attributeName) {
        if (StringUtils.isEmpty(attributeName)) {
            return null;
        }
        Object value = this.metadata.get(attributeName);
        if (value instanceof String[]) {
            return (String[])value;
        }
        return new String[]{(String)value};
    }

    @Nonnull
    public static MacMetadata generateMandatoryMetadata(@Nonnull String editUrl, @Nonnull String remoteModifiedBy) {
        return new MacMetadata().addAttribute("editURL", editUrl).addAttribute("sourceProductName", "Adobe Experience Manager").addAttribute("remoteModifiedBy", remoteModifiedBy);
    }
}

