/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.security.util;

import com.day.cq.security.util.AclPolicy;
import java.security.Principal;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.sling.api.SlingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CRXPolicyManager {
    private final JackrabbitSession session;
    private final AccessControlManager acManager;
    private final PrincipalManager principalManager;
    private static final Logger log = LoggerFactory.getLogger(CRXPolicyManager.class);

    public CRXPolicyManager(Session session) throws RepositoryException {
        if (!(session instanceof JackrabbitSession)) {
            throw new RepositoryException("CRXPolicyManager only usable with a jackrabbit session.");
        }
        this.session = (JackrabbitSession)session;
        this.acManager = session.getAccessControlManager();
        this.principalManager = this.session.getPrincipalManager();
    }

    public boolean applyPolicy(String path, AclPolicy policy) throws AccessDeniedException {
        boolean success = false;
        try {
            boolean modified = false;
            if (this.session.itemExists(path)) {
                JackrabbitAccessControlList acl = AccessControlUtils.getAccessControlList(this.session, path);
                if (acl != null) {
                    for (AclPolicy.Entry entry : policy.getEntries()) {
                        if (this.principalManager.hasPrincipal(entry.getPrincipal())) {
                            Principal principal = this.principalManager.getPrincipal(entry.getPrincipal());
                            if (principal != null && acl.addEntry(principal, AccessControlUtils.privilegesFromNames(this.session, entry.getPrivileges()), entry.isAllow())) {
                                modified = true;
                            }
                            log.debug("Allow not contained in ACL on {}: added for {}", (Object)path, (Object)principal.getName());
                            continue;
                        }
                        log.debug("Allow for {} contained in ACL on {}: no changes", (Object)entry.getPrincipal(), (Object)path);
                    }
                }
                if (modified) {
                    this.acManager.setPolicy(path, acl);
                    this.session.save();
                }
            }
            success = true;
            boolean bl = modified;
            return bl;
        }
        catch (AccessDeniedException e) {
            throw e;
        }
        catch (RepositoryException e) {
            throw new SlingException(e.getMessage(), e);
        }
        finally {
            if (!success) {
                try {
                    this.session.refresh(false);
                }
                catch (RepositoryException e) {
                    log.error("Failed to revert pending changes.", e);
                    throw new SlingException(e.getMessage(), e);
                }
            }
        }
    }

    public AclPolicy privatePolicy() {
        return new AclPolicy(this.principalManager.getEveryone().getName(), new String[]{"{http://www.jcp.org/jcr/1.0}all"}, false);
    }
}

